/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.LinkedInteger;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.table.TAlertDefinition;
import org.eclipse.aperi.server.guireq.ResourceAttribute;
import org.eclipse.aperi.xmsg.MessageLog;

public class TResAttr
extends RepositoryAccessor {
    private static final String QUERY_BY_RES = "select resource_id, resource_type, attribute_id, attribute_type,  exclude from t_res_attribute where resource_id = ? and resource_type = ? and attribute_type = ?";
    private static final String QUERY_BY_ATTR = "select resource_id, resource_type, attribute_id, attribute_type, exclude from t_res_attribute where attribute_type = ? and attribute_id = ? and resource_type = ?";
    private static final String QUERY_BY_ATTRS_PREFIX = "select resource_id, resource_type, attribute_id, attribute_type, exclude from t_res_attribute where attribute_type = ? and attribute_id in(";
    private static final String QUERY_BY_ATTRS_SUFFIX = ")";
    private static final String QUERY_BY_ATTR_TYPE = "select resource_id, resource_type, attribute_id, attribute_type, exclude from t_res_attribute where attribute_type = ?";
    private static final String DELETE_BY_RES = "delete from t_res_attribute where resource_id = ? and resource_type = ?";
    private static final String DELETE_BY_RESOURCE_ONLY = "delete from t_res_attribute where resource_id = ?";
    private static final String DELETE_BY_ATTR = "delete from t_res_attribute where attribute_id = ? and resource_id = ? and exclude = ?";
    private static final String DELETE_BY_ATTR_RES = "delete from t_res_attribute where attribute_id = ? and resource_id = ?";
    private static final String DELETE_BY_ATTR_ID_TYPE = "delete from t_res_attribute where attribute_id = ? and attribute_type = ?";
    private static final String JOIN_1 = "select d.creator, d.name, r.resource_id from t_res_attribute r, ";
    private static final String INSERT = "insert into t_res_attribute (attribute_id, attribute_type, resource_id, resource_type, exclude) values (?,?,?,?,?)";
    private static final String UPDATE = "update t_res_attribute set attribute_id = ?, exclude = ? where attribute_type = ? and resource_id = ?";
    private static final String QUERY_BY_ATTR_ID = "select resource_id from t_res_attribute where attribute_id = ";
    private static final String DELETE_BY_ATTR_ID = "delete from t_res_attribute where attribute_id = ";
    private static final String SELECT_AFFECTED_HOSTS_WITH_AGENT = "select distinct h.host_name from t_res_attribute r, t_res_host h where r.attribute_id = ? and r.attribute_type = 140 and (resource_type = 1 and r.resource_id = h.computer_id)";
    private static final String SELECT_AFFECTED_SMIS_ALIAS = "select distinct m.host_element_name from t_res_attribute r, t_res_masking_info m where r.attribute_id = ? and r.attribute_type = 140 and (resource_type = 1 and r.resource_id = m.masking_info_id)";

    public TResAttr(Connection dbc) {
        super(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResAttr.class.getName(), (String)"TResAttr", (String)"dbc");
        }
        this.tableName = "t_res_attribute";
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResAttr.class.getName(), (String)"TResAttr");
        }
    }

    public void prepQueryByRes(boolean sort) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResAttr.class.getName(), (String)"prepQueryByRes", (String)"sort");
        }
        String sqlText = QUERY_BY_RES;
        if (sort) {
            sqlText = sqlText + " ORDER BY attribute_id, exclude DESC";
        }
        this.selectStmt = this.prepareStmt(sqlText);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResAttr.class.getName(), (String)"prepQueryByRes");
        }
    }

    public void prepQueryByRes() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResAttr.class.getName(), (String)"prepQueryByRes", (String)"");
        }
        this.prepQueryByRes(false);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResAttr.class.getName(), (String)"prepQueryByRes");
        }
    }

    public void setQueryByRes(ResourceAttribute resAttr) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResAttr.class.getName(), (String)"setQueryByRes", (String)"resAttr");
        }
        try {
            this.colIndex = 1;
            this.setInt(this.selectStmt, resAttr.raResourceID);
            this.setShort(this.selectStmt, resAttr.raResourceType);
            this.setShort(this.selectStmt, resAttr.raAttributeType);
            this.resultSet = this.selectStmt.executeQuery();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResAttr.class.getName(), (String)"setQueryByRes", (Throwable)e);
            }
            this.cleanup();
            Object[] args = new Object[]{"execute"};
            String errorMsg = SQLUtil.getSQLExceptionMsg("STS0010E", e, args);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TResAttr.class.getName(), (String)"setQueryByRes");
            }
            throw new GeneralException(errorMsg);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResAttr.class.getName(), (String)"setQueryByRes");
        }
    }

    public void prepAttrTypeQuery(short attrType) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResAttr.class.getName(), (String)"prepAttrTypeQuery", (String)"attrType");
        }
        this.selectStmt = this.prepareStmt(QUERY_BY_ATTR_TYPE);
        try {
            this.colIndex = 1;
            this.stmtPhase = 0;
            this.setShort(this.selectStmt, attrType);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResAttr.class.getName(), (String)"prepAttrTypeQuery", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResAttr.class.getName(), (String)"prepAttrTypeQuery");
        }
    }

    public void prepQueryByAttr() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResAttr.class.getName(), (String)"prepQueryByAttr", (String)"");
        }
        this.selectStmt = this.prepareStmt(QUERY_BY_ATTR);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResAttr.class.getName(), (String)"prepQueryByAttr");
        }
    }

    public void setQueryByAttr(ResourceAttribute resAttr) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResAttr.class.getName(), (String)"setQueryByAttr", (String)"resAttr");
        }
        try {
            this.colIndex = 1;
            this.setShort(this.selectStmt, resAttr.raAttributeType);
            this.setInt(this.selectStmt, resAttr.raAttributeID);
            this.setShort(this.selectStmt, resAttr.raResourceType);
            this.resultSet = this.selectStmt.executeQuery();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResAttr.class.getName(), (String)"setQueryByAttr", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResAttr.class.getName(), (String)"setQueryByAttr");
        }
    }

    public void prepQueryByAttrs(int numAttributes) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)this.getClass().getName(), (String)"prepQueryByAttrs", (String)"");
        }
        if (numAttributes <= 0) {
            throw new GeneralException("SRV0605E", null);
        }
        StringBuffer statement = new StringBuffer(QUERY_BY_ATTRS_PREFIX);
        statement.append("?");
        for (int i = 1; i < numAttributes; ++i) {
            statement.append(",?");
        }
        statement.append(QUERY_BY_ATTRS_SUFFIX);
        this.selectStmt = this.prepareStmt(statement.toString());
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)this.getClass().getName(), (String)"prepQueryByAttrs");
        }
    }

    public void setQueryByAttrs(LinkedInteger attributeIDs, short attributeType) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)this.getClass().getName(), (String)"setQueryByAttrs", (String)"attributeIDs attributeType resourceType");
        }
        try {
            this.colIndex = 1;
            this.setShort(this.selectStmt, attributeType);
            LinkedInteger attributeID = attributeIDs;
            while (attributeID != null) {
                this.setInt(this.selectStmt, attributeID.value);
                attributeID = attributeID.next;
            }
            this.resultSet = this.selectStmt.executeQuery();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)this.getClass().getName(), (String)"setQueryByAttrs", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)this.getClass().getName(), (String)"setQueryByAttrs");
        }
    }

    public boolean fetch(ResourceAttribute resAttr) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResAttr.class.getName(), (String)"fetch", (String)"resAttr");
        }
        try {
            if (!this.nextResult()) {
                this.closeResultSet();
                boolean traceResult = false;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)TResAttr.class.getName(), (String)"fetch", (boolean)traceResult);
                }
                return traceResult;
            }
            this.colIndex = 1;
            resAttr.raResourceID = this.getInt(this.resultSet);
            resAttr.raResourceType = this.getShort(this.resultSet);
            resAttr.raAttributeID = this.getInt(this.resultSet);
            resAttr.raAttributeType = this.getShort(this.resultSet);
            resAttr.raExclude = this.getBoolean(this.resultSet);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResAttr.class.getName(), (String)"fetch", (Throwable)e);
            }
            this.stmtType = 0;
            this.stmtPhase = 1;
            this.sqlError(e);
        }
        boolean traceResult = true;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResAttr.class.getName(), (String)"fetch", (boolean)traceResult);
        }
        return traceResult;
    }

    public void prepDelete() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResAttr.class.getName(), (String)"prepDelete", (String)"");
        }
        this.deleteStmt = this.prepareStmt(DELETE_BY_RES);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResAttr.class.getName(), (String)"prepDelete");
        }
    }

    public void delete(ResourceAttribute resAttr) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResAttr.class.getName(), (String)"delete", (String)"resAttr");
        }
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.deleteStmt, resAttr.raResourceID);
            this.setInt(this.deleteStmt, resAttr.raResourceType);
            this.executeUpdate(this.deleteStmt);
            this.dbc.commit();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResAttr.class.getName(), (String)"delete", (Throwable)e);
            }
            this.stmtType = 3;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResAttr.class.getName(), (String)"delete");
        }
    }

    public void deleteByID(int resourceID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResAttr.class.getName(), (String)"deleteByID", (String)"resourceID");
        }
        this.deleteStmt = this.prepareStmt(DELETE_BY_RESOURCE_ONLY);
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.deleteStmt, resourceID);
            this.executeUpdate(this.deleteStmt);
            this.dbc.commit();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResAttr.class.getName(), (String)"deleteByID", (Throwable)e);
            }
            this.stmtType = 3;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResAttr.class.getName(), (String)"deleteByID");
        }
    }

    public void deleteByTypes(int resourceID, int[] attrs) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResAttr.class.getName(), (String)"deleteByTypes", (String)"resourceID, attrs");
        }
        StringBuffer buffer = new StringBuffer(1024);
        buffer.append(DELETE_BY_RESOURCE_ONLY);
        SQLUtil.appendInClause(buffer, "attribute_type", attrs, true, true);
        this.deleteStmt = this.prepareStmt(buffer.toString());
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.deleteStmt, resourceID);
            this.executeUpdate(this.deleteStmt);
            this.dbc.commit();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResAttr.class.getName(), (String)"deleteByTypes", (Throwable)e);
            }
            this.stmtType = 3;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResAttr.class.getName(), (String)"deleteByTypes");
        }
    }

    public void deleteByAttribute(int attributeID, short attributeType) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)this.getClass().getName(), (String)"deleteByAttribute", (String)"attributeID, attributeType");
        }
        this.deleteStmt = this.prepareStmt(DELETE_BY_ATTR_ID_TYPE);
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.deleteStmt, attributeID);
            this.setShort(this.deleteStmt, attributeType);
            this.executeUpdate(this.deleteStmt);
            this.dbc.commit();
            this.closeDelete();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)this.getClass().getName(), (String)"deleteByAttribute", (Throwable)e);
            }
            this.stmtType = 3;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)this.getClass().getName(), (String)"deleteByAttribute");
        }
    }

    public void prepDeleteByResAttr() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResAttr.class.getName(), (String)"prepDeleteByResAttr", (String)"");
        }
        this.deleteStmt = this.prepareStmt(DELETE_BY_ATTR);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResAttr.class.getName(), (String)"prepDeleteByResAttr");
        }
    }

    public void delete(int attributeID, int resourceID, boolean exclude) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResAttr.class.getName(), (String)"delete", (String)"attributeID, resourceID, exclude");
        }
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setInt(this.deleteStmt, attributeID);
            this.setInt(this.deleteStmt, resourceID);
            SQLUtil.setBoolean(this.deleteStmt, this.colIndex++, exclude);
            this.executeUpdate(this.deleteStmt);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResAttr.class.getName(), (String)"delete", (Throwable)e);
            }
            this.stmtType = 3;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResAttr.class.getName(), (String)"delete");
        }
    }

    public void delete(int attributeID, int resourceID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResAttr.class.getName(), (String)"delete", (String)"attributeID, resourceID");
        }
        this.deleteStmt = this.prepareStmt(DELETE_BY_ATTR_RES);
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setInt(this.deleteStmt, attributeID);
            this.setInt(this.deleteStmt, resourceID);
            this.executeUpdate(this.deleteStmt);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResAttr.class.getName(), (String)"delete", (Throwable)e);
            }
            this.stmtType = 3;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResAttr.class.getName(), (String)"delete");
        }
    }

    public void prepInsert(int attributeID, short attributeType) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResAttr.class.getName(), (String)"prepInsert", (String)"attributeID, attributeType");
        }
        this.insertStmt = this.prepareStmt(INSERT);
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setInt(this.insertStmt, attributeID);
            this.setShort(this.insertStmt, attributeType);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResAttr.class.getName(), (String)"prepInsert", (Throwable)e);
            }
            this.stmtType = 1;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResAttr.class.getName(), (String)"prepInsert");
        }
    }

    public void insert(int resourceID, short resourceType, boolean exclude) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResAttr.class.getName(), (String)"insert", (String)"resourceID, resourceType, exclude");
        }
        this.stmtPhase = 0;
        this.colIndex = 3;
        try {
            this.setInt(this.insertStmt, resourceID);
            this.setShort(this.insertStmt, resourceType);
            this.setBoolean(this.insertStmt, exclude);
            this.executeUpdate(this.insertStmt);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResAttr.class.getName(), (String)"insert", (Throwable)e);
            }
            this.stmtType = 1;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResAttr.class.getName(), (String)"insert");
        }
    }

    public void prepUpdate() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResAttr.class.getName(), (String)"prepUpdate", (String)"");
        }
        this.updateStmt = this.prepareStmt(UPDATE);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResAttr.class.getName(), (String)"prepUpdate");
        }
    }

    public int update(int resourceID, int attributeID, short attributeType, boolean exclude) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResAttr.class.getName(), (String)"update", (String)"resourceID, attributeID, attributeType, exclude");
        }
        int updatedRows = 0;
        try {
            this.setPhase();
            this.setInt(this.updateStmt, attributeID);
            this.setBoolean(this.updateStmt, exclude);
            this.setShort(this.updateStmt, attributeType);
            this.setInt(this.updateStmt, resourceID);
            updatedRows = this.executeUpdate(this.updateStmt);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResAttr.class.getName(), (String)"update", (Throwable)e);
            }
            this.stmtType = 2;
            this.sqlError(e);
        }
        int traceResult = updatedRows;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResAttr.class.getName(), (String)"update", (int)traceResult);
        }
        return traceResult;
    }

    private boolean nextDependent() throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResAttr.class.getName(), (String)"nextDependent", (String)"");
        }
        this.stmtPhase = 2;
        boolean traceResult = this.resultSet.next();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResAttr.class.getName(), (String)"nextDependent", (boolean)traceResult);
        }
        return traceResult;
    }

    public NameList queryDependents(String dependentTable, String idColumnName, int parentID, short resourceType) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResAttr.class.getName(), (String)"queryDependents", (String)"dependentTable, idColumnName, parentID, resourceType");
        }
        NameList head = null;
        NameList prev = null;
        StringBuffer buf = new StringBuffer(240);
        buf.append(JOIN_1);
        buf.append(dependentTable);
        buf.append(" d WHERE r.attribute_id = ");
        buf.append(parentID);
        buf.append(" AND d.");
        buf.append(idColumnName);
        buf.append(" = r.resource_id AND r.resource_type = ");
        buf.append(resourceType);
        buf.append(" ORDER BY d.creator, d.name");
        this.selectStmt = this.prepareStmt(buf.toString());
        this.stmtPhase = 3;
        try {
            this.resultSet = this.selectStmt.executeQuery();
            while (this.nextDependent()) {
                this.stmtPhase = 1;
                this.colIndex = 1;
                buf.setLength(0);
                if (resourceType == 99) {
                    this.getString(this.resultSet);
                } else {
                    buf.append(this.getString(this.resultSet));
                    buf.append('.');
                }
                buf.append(this.getString(this.resultSet));
                NameList element = new NameList();
                element.nlName = buf.toString();
                element.nlID = this.getInt(this.resultSet);
                element.nlInfo = resourceType;
                if (prev == null) {
                    head = element;
                } else {
                    prev.nlNext = element;
                }
                prev = element;
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResAttr.class.getName(), (String)"queryDependents", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        this.closeSelect();
        NameList traceResult = head;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResAttr.class.getName(), (String)"queryDependents", traceResult);
        }
        return traceResult;
    }

    public NameList getResAttr(ResourceAttribute row) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResAttr.class.getName(), (String)"getResAttr", (String)"row");
        }
        NameList head = null;
        this.setQueryByAttr(row);
        while (this.fetch(row)) {
            NameList element = new NameList();
            element.nlID = row.raResourceID;
            if (row.raExclude) {
                element.nlState = (byte)(element.nlState | 1);
            }
            element.nlInfo = row.raResourceType;
            element.nlNext = head;
            head = element;
        }
        NameList traceResult = head;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResAttr.class.getName(), (String)"getResAttr", traceResult);
        }
        return traceResult;
    }

    public int[] getResourceIDs(int attributeID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResAttr.class.getName(), (String)"getResourceIDs", (String)"attributeID");
        }
        LinkedInteger head = null;
        int count = 0;
        try {
            this.staticStmt = this.createStatement();
            this.resultSet = this.staticStmt.executeQuery(QUERY_BY_ATTR_ID + attributeID);
            while (this.nextResult()) {
                this.getPhase();
                LinkedInteger node = new LinkedInteger();
                node.value = this.getInt(this.resultSet);
                node.next = head;
                head = node;
                ++count;
            }
            this.closeStaticStmt();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResAttr.class.getName(), (String)"getResourceIDs", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        int[] stuff = new int[count];
        while (head != null) {
            stuff[--count] = head.value;
            head = head.next;
        }
        int[] traceResult = stuff;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResAttr.class.getName(), (String)"getResourceIDs", (Object)traceResult);
        }
        return traceResult;
    }

    public void deleteResourceIDs(int attributeID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResAttr.class.getName(), (String)"deleteResourceIDs", (String)"attributeID");
        }
        try {
            this.staticStmt = this.createStatement();
            this.staticStmt.executeUpdate(DELETE_BY_ATTR_ID + attributeID);
            this.closeStaticStmt();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResAttr.class.getName(), (String)"deleteResourceIDs", (Throwable)e);
            }
            this.stmtType = 2;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResAttr.class.getName(), (String)"deleteResourceIDs");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAffectedResources(int alertLogID, int[] affectedRes, short resourceType, short attributeType) throws GeneralException {
        try {
            TResAttr tresattr = new TResAttr(this.dbc);
            tresattr.prepInsert(alertLogID, attributeType);
            for (int i = 0; i < affectedRes.length; ++i) {
                tresattr.insert(affectedRes[i], resourceType, false);
            }
            this.commit();
        }
        finally {
            this.closeInsert();
        }
    }

    public String getAffectedHosts(int alertLogID) throws GeneralException {
        boolean hostWithoutAgentExist;
        boolean hostWithAgentExist;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertDefinition.class.getName(), (String)"getAffectedHosts", (String)"alertID");
        }
        String result = "";
        StringBuffer listOfHosts = new StringBuffer(100);
        String hostsWithAgent = this.getAffectedHosts(alertLogID, true);
        String hostsWithoutAnAgent = this.getAffectedHosts(alertLogID, false);
        boolean bl = hostWithAgentExist = !"".equals(hostsWithAgent);
        if (hostWithAgentExist) {
            String agentKey = "ALR0074W";
            String agents = MessageLog.getMessageNoTS((String)agentKey, (Object[])new Object[]{hostsWithAgent});
            agents = agents.substring(agentKey.length() + 1);
            listOfHosts.append("\n" + agents);
        }
        boolean bl2 = hostWithoutAgentExist = !"".equals(hostsWithoutAnAgent);
        if (hostWithoutAgentExist) {
            String SMISAliasKey = "ALR0075W";
            String SMISalias = MessageLog.getMessageNoTS((String)SMISAliasKey, (Object[])new Object[]{hostsWithoutAnAgent});
            SMISalias = SMISalias.substring(SMISAliasKey.length() + 1);
            listOfHosts.append("\n" + SMISalias);
        }
        if (hostWithAgentExist || hostWithoutAgentExist) {
            result = listOfHosts.toString();
            String msgKey = "ALR0073W";
            String affectedHostMsg = MessageLog.getMessageNoTS((String)msgKey, (Object[])new Object[]{result});
            result = affectedHostMsg = "\n" + affectedHostMsg.substring(msgKey.length() + 1);
        }
        TraceLogger.exit((String)TAlertDefinition.class.getName(), (String)"getAffectedHosts", (Object)result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAffectedHosts(int alertLogID, boolean agent) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertDefinition.class.getName(), (String)"getAffectedHosts", (String)"alertID agent");
        }
        StringBuffer listOfHosts = new StringBuffer(100);
        try {
            this.selectStmt = agent ? this.prepareStmt(SELECT_AFFECTED_HOSTS_WITH_AGENT) : this.prepareStmt(SELECT_AFFECTED_SMIS_ALIAS);
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, alertLogID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            String host = null;
            while (this.resultSet.next()) {
                host = this.resultSet.getString(1);
                listOfHosts.append(host);
                listOfHosts.append(" ");
            }
        }
        catch (SQLException sqle) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TAlertDefinition.class.getName(), (String)"getAffectedHosts", (Throwable)sqle);
            }
            this.stmtType = 0;
            this.sqlError(sqle);
        }
        finally {
            this.closeSelect();
            this.closeResultSet();
        }
        String hosts = null;
        if (!"".equals(listOfHosts)) {
            hosts = listOfHosts.toString();
        }
        TraceLogger.exit((String)TAlertDefinition.class.getName(), (String)"getAffectedHosts", (Object)hosts);
        return hosts;
    }
}

