/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.eclipse.aperi.TStorm.common.Cluster;
import org.eclipse.aperi.TStorm.common.Domain;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.backend.LockManager;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.NameListQueryable;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.table.TGroup;
import org.eclipse.aperi.repository.table.TGroup2Res;
import org.eclipse.aperi.repository.table.TResAttr;
import org.eclipse.aperi.repository.table.TResDomain;
import org.eclipse.aperi.repository.table.TStatComputer;
import org.eclipse.aperi.server.guireq.GComputer;
import org.eclipse.aperi.xmsg.MessageLog;

public class TResCluster
extends RepositoryAccessor
implements NameListQueryable {
    private static final String SELECT_CLUSTER = "select cluster_id, cluster_name, domain_name from t_res_cluster";
    private static final String SELECT_CLUSTER_ID = "select cluster_id from t_res_cluster where cluster_name = ? and domain_name = ?";
    private static final String SELECT_BY_ID = "select cluster_id, cluster_name, domain_name, ip_address, domain_id, cluster_type, discovered_time from t_res_cluster where cluster_id = ?";
    private static final String SELECT_CLUSTER_BY_NAME_AND_DOMAIN = "select cluster_id, cluster_name, domain_name, ip_address, domain_id, cluster_type, discovered_time from t_res_cluster where cluster_name = ? and domain_name = ?";
    private static final String SELECT_CLUSTER_DETAILS = "select r.cluster_name, r.domain_name, c.host_name, s.os_type from t_res_cluster r,  t_res_host c, t_stat_computer s where s.computer_id = ? and  r.cluster_id = s.cluster_id and  (c.computer_id = s.node_hosted_id or  c.computer_id = s.computer_id ) ";
    private static final String SELECT_CLUSTER_DETAILS_GC = "select r.cluster_id, r.cluster_name, r.domain_name, c.host_name from t_res_cluster r,  t_res_host c, t_stat_computer s where s.computer_id = ? and  r.cluster_id = s.cluster_id and  (c.computer_id = s.node_hosted_id or  c.computer_id = s.computer_id ) ";
    private static final String INSERT = "insert into t_res_cluster (cluster_id, cluster_name, domain_name, ip_address, domain_id, cluster_type, discovered_time) values (?,?,?,?,?,?,?)";
    private static final String UPDATE = "update t_res_cluster set ip_address = ?, domain_id = ?, cluster_type = ? where cluster_id = ?";
    private static final String DELETE_BY_ID = "delete from t_res_cluster where cluster_id = ?";
    public static final String CLUSTER_LOCK = "CLUSTER";

    public TResCluster(Connection dbc) {
        super(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResCluster.class.getName(), (String)"TResCluster", (String)"dbc");
        }
        this.tableName = "t_res_cluster";
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResCluster.class.getName(), (String)"TResCluster");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cluster insert(Cluster c) throws GeneralException {
        Cluster traceResult;
        block11: {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)TResCluster.class.getName(), (String)"insert", (String)"c");
            }
            Cluster result = null;
            int updateCount = 0;
            String cluster_and_domain = c.clusterName + "-" + c.domain_name;
            try {
                this.lockCluster(cluster_and_domain);
                Cluster cluster = this.getClusterByName(c.clusterName, c.domain_name);
                if (cluster != null) {
                    c.clusterID = cluster.clusterID;
                    this.update(c, true);
                } else {
                    c.clusterID = SQLUtil.getIdentifier(1, 1, this.dbc);
                    this.insertStmt = this.prepareStmt(INSERT);
                    this.setCluster(c, this.insertStmt);
                    updateCount = this.insertStmt.executeUpdate();
                    this.dbc.commit();
                }
                if (updateCount > 0) {
                    result = c;
                }
                this.closeInsert();
                this.unlockCluster(cluster_and_domain);
                traceResult = result;
                if (!TraceLogger.enableTrace) break block11;
            }
            catch (SQLException e) {
                try {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)TResCluster.class.getName(), (String)"insert", (Throwable)e);
                    }
                    this.stmtType = 1;
                    this.sqlError(e);
                }
                catch (Throwable throwable) {}
            }
            finally {
                this.closeInsert();
                this.unlockCluster(cluster_and_domain);
                Cluster traceResult2 = result;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)TResCluster.class.getName(), (String)"insert", traceResult2);
                }
                return traceResult2;
            }
            TraceLogger.exit((String)TResCluster.class.getName(), (String)"insert", (Object)traceResult);
        }
        return traceResult;
    }

    private boolean setCluster(Cluster c, PreparedStatement stmt) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResCluster.class.getName(), (String)"setCluster", (String)"c, stmt");
        }
        try {
            this.setPhase();
            this.setInt(stmt, c.clusterID);
            this.setString(stmt, c.clusterName);
            if (c.domain_name == null) {
                c.domain_name = c.windows_domain;
            }
            this.setString(stmt, c.domain_name);
            this.setString(stmt, c.IPAddress);
            TResDomain domAccessor = new TResDomain(this.dbc);
            Domain domain = new Domain();
            domain.domName = c.windows_domain;
            domain.domNext = null;
            if (c.windows_domain != null) {
                domAccessor.getIDs(domain);
                this.setInt(stmt, domain.domID);
            } else {
                this.setInt(stmt, -1);
            }
            this.setInt(stmt, c.cluster_type);
            c.discovered_time = SQLUtil.getTimestamp(this.dbc).getTime();
            this.setTimestamp(stmt, c.discovered_time);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResCluster.class.getName(), (String)"setCluster", (Throwable)e);
            }
            this.stmtType = 2;
            this.sqlError(e);
        }
        boolean traceResult = true;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResCluster.class.getName(), (String)"setCluster", (boolean)traceResult);
        }
        return traceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update(Cluster c, boolean locked) throws GeneralException {
        boolean traceResult;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResCluster.class.getName(), (String)"update", (String)"c, locked");
        }
        int updateCount = 0;
        this.updateStmt = this.prepareStmt(UPDATE);
        String cluster_and_domain = c.clusterName + "-" + c.domain_name;
        try {
            if (!locked) {
                this.lockCluster(cluster_and_domain);
            }
            this.setPhase();
            this.setString(this.updateStmt, c.IPAddress);
            TResDomain domAccessor = new TResDomain(this.dbc);
            Domain domain = new Domain();
            domain.domName = c.windows_domain;
            domain.domNext = null;
            if (c.windows_domain != null) {
                domAccessor.getIDs(domain);
                this.setInt(this.updateStmt, domain.domID);
            } else {
                this.setInt(this.updateStmt, -1);
            }
            this.setInt(this.updateStmt, c.cluster_type);
            this.setInt(this.updateStmt, c.clusterID);
            updateCount = this.executeUpdate(this.updateStmt);
            this.dbc.commit();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResCluster.class.getName(), (String)"update", (Throwable)e);
            }
            this.stmtType = 2;
            this.sqlError(e);
        }
        finally {
            this.closeUpdate();
            if (!locked) {
                this.unlockCluster(cluster_and_domain);
            }
        }
        boolean bl = traceResult = updateCount > 0;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResCluster.class.getName(), (String)"update", (boolean)traceResult);
        }
        return traceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteByID(int cluster_id) throws GeneralException {
        boolean traceResult;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResCluster.class.getName(), (String)"deleteByID", (String)"cluster_id");
        }
        int updateCount = 0;
        try {
            this.lockCluster(Integer.toString(cluster_id));
            this.deleteStmt = this.prepareStmt(DELETE_BY_ID);
            this.setPhase();
            this.setInt(this.deleteStmt, cluster_id);
            updateCount = this.executeUpdate(this.deleteStmt);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResCluster.class.getName(), (String)"deleteByID", (Throwable)e);
            }
            this.stmtType = 3;
            this.sqlError(e);
        }
        finally {
            this.closeDelete();
            this.unlockCluster(Integer.toString(cluster_id));
        }
        boolean bl = traceResult = updateCount > 0;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResCluster.class.getName(), (String)"deleteByID", (boolean)traceResult);
        }
        return traceResult;
    }

    private Cluster getCluster() throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResCluster.class.getName(), (String)"getCluster", (String)"");
        }
        Cluster c = new Cluster();
        this.getPhase();
        if (!this.nextResult()) {
            Cluster traceResult = null;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TResCluster.class.getName(), (String)"getCluster", traceResult);
            }
            return traceResult;
        }
        c.clusterID = this.getInt(this.resultSet);
        c.clusterName = this.getString(this.resultSet);
        c.domain_name = this.getString(this.resultSet);
        c.IPAddress = this.getString(this.resultSet);
        c.domain_id = this.getInt(this.resultSet);
        Domain d = new Domain();
        d.domID = c.domain_id;
        TResDomain tresdom = new TResDomain(this.dbc);
        tresdom.getName(d);
        c.windows_domain = d.domName;
        c.cluster_type = this.getShort(this.resultSet);
        c.discovered_time = this.getTimestamp(this.resultSet);
        Cluster traceResult = c;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResCluster.class.getName(), (String)"getCluster", (Object)traceResult);
        }
        return traceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cluster getClusterByID(int cluster_id) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResCluster.class.getName(), (String)"getClusterByID", (String)"cluster_id");
        }
        Cluster c = null;
        try {
            this.selectStmt = this.prepareStmt(SELECT_BY_ID);
            this.setPhase();
            this.setInt(this.selectStmt, cluster_id);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            c = this.getCluster();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResCluster.class.getName(), (String)"getClusterByID", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        finally {
            this.closeResultSet();
            this.closeSelect();
        }
        Cluster traceResult = c;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResCluster.class.getName(), (String)"getClusterByID", (Object)traceResult);
        }
        return traceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cluster getClusterByName(String name, String domain) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResCluster.class.getName(), (String)"getClusterByName", (String)"name, domain");
        }
        Cluster c = null;
        try {
            this.selectStmt = this.prepareStmt(SELECT_CLUSTER_BY_NAME_AND_DOMAIN);
            this.setPhase();
            this.setString(this.selectStmt, name);
            this.setString(this.selectStmt, domain);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            c = this.getCluster();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResCluster.class.getName(), (String)"getClusterByName", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        finally {
            this.closeResultSet();
            this.closeSelect();
        }
        Cluster traceResult = c;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResCluster.class.getName(), (String)"getClusterByName", traceResult);
        }
        return traceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getClusterID(String name, String domain) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResCluster.class.getName(), (String)"getClusterID", (String)"name, domain");
        }
        int cluster_id = -1;
        try {
            this.selectStmt = this.prepareStmt(SELECT_CLUSTER_ID);
            this.setPhase();
            this.setString(this.selectStmt, name);
            this.setString(this.selectStmt, domain);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.getPhase();
            if (this.nextResult()) {
                cluster_id = this.getInt(this.resultSet);
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResCluster.class.getName(), (String)"getClusterID", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        finally {
            this.closeResultSet();
            this.closeSelect();
        }
        int traceResult = cluster_id;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResCluster.class.getName(), (String)"getClusterID", (int)traceResult);
        }
        return traceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NameList selectNames(GuiListReq requestData) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResCluster.class.getName(), (String)"selectNames", (String)"requestData");
        }
        NameList head = null;
        NameList prev = null;
        try {
            this.selectStmt = this.prepareStmt("select cluster_id, cluster_name, domain_name from t_res_cluster order by cluster_name");
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            while (this.nextResult()) {
                this.getPhase();
                NameList element = new NameList();
                element.nlID = element.nlClusterID = this.getInt(this.resultSet);
                element.nlName = this.getString(this.resultSet);
                element.nlInfo = (short)99;
                element.nlID2 = 22;
                element.nlClusterName = element.nlName;
                element.nlClusterDomain = this.getString(this.resultSet);
                element.nlName = element.nlName + "-" + element.nlClusterDomain;
                if (prev == null) {
                    head = element;
                } else {
                    prev.nlNext = element;
                }
                prev = element;
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResCluster.class.getName(), (String)"selectNames", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        finally {
            this.closeResultSet();
            this.closeSelect();
        }
        NameList traceResult = head;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResCluster.class.getName(), (String)"selectNames", traceResult);
        }
        return traceResult;
    }

    public void prepGetClusterDetailsGC() throws GeneralException {
        this.selectStmt = this.prepareStmt(SELECT_CLUSTER_DETAILS_GC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getClusterDetailsGC(GComputer gc) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResCluster.class.getName(), (String)"getClusterDetailsGC", (String)"gc");
        }
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, gc.gcComputerID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            this.colIndex = 1;
            if (this.nextResult()) {
                gc.gcClusterID = this.getInt(this.resultSet);
                gc.gcClusterName = this.getString(this.resultSet);
                gc.gcDomainName = this.getString(this.resultSet);
                gc.gcHostedNodeName = this.getString(this.resultSet);
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResCluster.class.getName(), (String)"getClusterDetailsGC", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        finally {
            this.closeResultSet();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResCluster.class.getName(), (String)"getClusterDetailsGC");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillInClusterDetails(NameList nlComp) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResCluster.class.getName(), (String)"fillInClusterDetails", (String)"nlComp");
        }
        String sqltxt = SELECT_CLUSTER_DETAILS;
        try {
            this.selectStmt = this.prepareStmt(sqltxt);
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, nlComp.nlID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            this.colIndex = 1;
            if (this.nextResult()) {
                nlComp.nlClusterName = this.getString(this.resultSet);
                nlComp.nlClusterDomain = this.getString(this.resultSet);
                nlComp.nlHostName = this.getString(this.resultSet);
                nlComp.nlID2 = this.getShort(this.resultSet);
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResCluster.class.getName(), (String)"fillInClusterDetails", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        finally {
            this.closeResultSet();
            this.closeSelect();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResCluster.class.getName(), (String)"fillInClusterDetails");
        }
    }

    public boolean cleanupCluster(int cluster_id) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResCluster.class.getName(), (String)"cleanupCluster", (String)"cluster_id");
        }
        boolean status = false;
        TStatComputer tstat = new TStatComputer(this.dbc);
        NameList nl = tstat.getClusterMembers(cluster_id);
        if (nl == null) {
            try {
                status = this.deleteByID(cluster_id);
                TResAttr attrDeleter = new TResAttr(this.dbc);
                attrDeleter.deleteByID(cluster_id);
                LockManager.lock((short)0, (String)"GLOBAL", (String)"DELETE", (byte)2, (boolean)true);
                TGroup2Res g2r_accessor = new TGroup2Res(this.dbc);
                g2r_accessor.deleteResources(cluster_id, (short)99, true);
                TGroup accessor = new TGroup(this.dbc);
                String objectType = MessageLog.getMessageNoID((String)"STS0812L");
                accessor.deleteByID(cluster_id, objectType);
                accessor.commit();
            }
            catch (GeneralException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)TResCluster.class.getName(), (String)"cleanupCluster", (Throwable)e);
                }
                Object[] args = new Object[]{new Integer(cluster_id)};
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)TResCluster.class.getName(), (String)"cleanupCluster");
                }
                throw new GeneralException(MessageLog.getMessage((String)"SRV0906E", (Object[])args));
            }
            finally {
                LockManager.unLock((short)0, (String)"GLOBAL", (String)"DELETE");
            }
        }
        boolean traceResult = status;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResCluster.class.getName(), (String)"cleanupCluster", (boolean)traceResult);
        }
        return traceResult;
    }

    public int cleanupClusters() throws GeneralException {
        NameList all;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResCluster.class.getName(), (String)"cleanupClusters", (String)"");
        }
        int clustersRemoved = 0;
        NameList n = all = this.selectNames(null);
        while (n != null) {
            if (this.cleanupCluster(n.nlID)) {
                ++clustersRemoved;
            }
            n = n.nlNext;
        }
        int traceResult = clustersRemoved;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResCluster.class.getName(), (String)"cleanupClusters", (int)traceResult);
        }
        return traceResult;
    }

    private boolean lockCluster(String cluster) {
        return LockManager.lock((short)0, (String)CLUSTER_LOCK, (String)cluster, (byte)1, (boolean)true);
    }

    private void unlockCluster(String cluster) {
        if (cluster != null) {
            LockManager.unLock((short)0, (String)CLUSTER_LOCK, (String)cluster);
        }
    }
}

