/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.TimeZone;
import org.eclipse.aperi.Nas.common.NasFiler;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.StorageException;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.identity.HardwareID;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.table.TComputer;
import org.eclipse.aperi.repository.table.TResVendorModel;
import org.eclipse.aperi.server.AgentLessManagedNode;
import org.eclipse.aperi.server.AgentManager;
import org.eclipse.aperi.server.Server;

public class TResComputer
extends RepositoryAccessor {
    private static final String SELECT_ID = "select computer_id from t_res_host where";
    private static final String SELECT_SS_ID = "select subsystem_id from t_res_storage_subsystem where";
    private static final String BY_NAME = " host_name = ?";
    private static final String BY_SS_NAME = " name = ?";
    private static final String BY_NETWORK_NAME = " network_name = ? and domain_name = ?";
    private static final String SELECT_COMPUTER_ID = "select computer_id from t_res_host where host_url = ?";
    private static final String SELECT_NAME = "select host_name from t_res_host where computer_id = ?";
    private static final String SELECT_LOCAL_HOSTNAME = "select case when user_provided_name is not null  and user_provided_name <> ''  then user_provided_name else display_name end display_name from t_res_storage_subsystem  where subsystem_id = ?";
    private static final String SELECT_NETWORK_HOSTNAME = "select network_name, domain_name from t_res_host where computer_id = ?";
    private static final String SELECT_NODE_HOSTED_NAME = "select host_name from t_stat_computer s, t_res_host c where c.computer_id = s.computer_id and c.computer_id = (select node_hosted_id from t_stat_computer where computer_id = ?)";
    private static final String SELECT_DEPENDENTS = "select c.host_name, c.computer_id, a.exclude from t_res_host c, t_res_attribute a where a.attribute_id = ? and a.resource_id = c.computer_id order by 1 desc";
    private static final String SELECT_BY_ID = "select host_name, network_name, host_url, ip_address, vendor_id, os_type from t_res_host where computer_id = ?";
    private static final String SELECT_BY_SS_ID = "select name, case when user_provided_name is not null  and user_provided_name <> ''  then user_provided_name else display_name end display_name, ip_address, vendor_id, os_type, name_format from t_res_storage_subsystem where subsystem_id = ?";
    private static final String SELECT_BY_LIBRARY_ID = "select name, display_name from t_res_tape_library where tape_library_id = ?";
    private static final String AGENT_JOIN = "select c.computer_id from t_res_host c, t_res_agent a where upper(c.host_name) = ? and a.computer_id = c.computer_id";
    private static final String SELECT_AGENTLESS_COMPUTERS = "select computer_id, os_type, host_name, host_url, network_name, domain_name from t_res_host where computer_id not in (select computer_id from t_res_agent)";
    private static final String SELECT_IP_ADDRESS = "select ip_address from t_res_host where computer_id = ?";
    private static final String SELECT_SS = "select os_type from t_res_storage_subsystem where subsystem_id = ? ";
    private static final String SELECT_TAPE = "select name from t_res_tape_library where tape_library_id = ? ";
    private TResVendorModel vmAccessor = null;

    public TResComputer(Connection dbc) {
        super(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResComputer.class.getName(), (String)"TResComputer", (String)"dbc");
        }
        this.tableName = "t_res_host";
        this.vmAccessor = new TResVendorModel(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResComputer.class.getName(), (String)"TResComputer");
        }
    }

    public void prepSelectName() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResComputer.class.getName(), (String)"prepSelectName", (String)"");
        }
        this.selectStmt = this.prepareStmt(SELECT_NAME);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResComputer.class.getName(), (String)"prepSelectName");
        }
    }

    public void prepSelectLocalHostname() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResComputer.class.getName(), (String)"prepSelectLocalHostname", (String)"");
        }
        this.selectStmt = this.prepareStmt(SELECT_LOCAL_HOSTNAME);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResComputer.class.getName(), (String)"prepSelectLocalHostname");
        }
    }

    public String fetchName(int computerID, boolean failFriendly) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResComputer.class.getName(), (String)"fetchName", (String)"computerID, failFriendly");
        }
        String result = null;
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setInt(this.selectStmt, computerID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            if (this.nextResult()) {
                this.stmtPhase = 1;
                this.colIndex = 1;
                result = this.getString(this.resultSet);
            } else if (failFriendly) {
                result = "? (" + Integer.toString(computerID) + ')';
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResComputer.class.getName(), (String)"fetchName", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        this.closeResultSet();
        String traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResComputer.class.getName(), (String)"fetchName", traceResult);
        }
        return traceResult;
    }

    public String fetchName(int computerID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResComputer.class.getName(), (String)"fetchName", (String)"computerID");
        }
        String traceResult = this.fetchName(computerID, true);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResComputer.class.getName(), (String)"fetchName", (Object)traceResult);
        }
        return traceResult;
    }

    public NameList queryDependents(int attributeID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResComputer.class.getName(), (String)"queryDependents", (String)"attributeID");
        }
        NameList head = null;
        this.selectStmt = this.prepareStmt(SELECT_DEPENDENTS);
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, attributeID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.nextResult()) {
                NameList element = new NameList();
                this.colIndex = 1;
                element.nlName = this.getString(this.resultSet);
                element.nlID = this.getInt(this.resultSet);
                if (this.getBoolean(this.resultSet)) {
                    element.nlState = 1;
                }
                element.nlInfo = 1;
                element.nlNext = head;
                head = element;
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResComputer.class.getName(), (String)"queryDependents", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        this.closeSelect();
        NameList traceResult = head;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResComputer.class.getName(), (String)"queryDependents", traceResult);
        }
        return traceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNetworkHostname(int computerID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResComputer.class.getName(), (String)"getNetworkHostname", (String)"computerID");
        }
        String hname = null;
        String dname = null;
        String result = null;
        this.selectStmt = this.prepareStmt(SELECT_NETWORK_HOSTNAME);
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setInt(this.selectStmt, computerID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            if (this.nextResult()) {
                this.stmtPhase = 1;
                this.colIndex = 1;
                hname = this.getString(this.resultSet);
                dname = this.getString(this.resultSet);
                if (!Util.isEmpty((String)hname)) {
                    result = hname;
                    if (!Util.isEmpty((String)dname)) {
                        result = result + "." + dname;
                    }
                }
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResComputer.class.getName(), (String)"getNetworkHostname", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        finally {
            this.closeSelect();
            this.closeResultSet();
        }
        String traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResComputer.class.getName(), (String)"getNetworkHostname", traceResult);
        }
        return traceResult;
    }

    private void setVirtualServerDomainName(TComputer computer, int parentCompID) {
        AgentManager agentMgr;
        String parentHostAddress;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResComputer.class.getName(), (String)"setVirtualServerDomainName", (String)"computer, parentCompID");
        }
        if ((parentHostAddress = (agentMgr = Server.getAgentManager()).getAgentHostAddress(parentCompID)) != null) {
            if (TResComputer.isIPAddress(parentHostAddress)) {
                int index;
                if (computer.ipAddress != null && (index = computer.ipAddress.indexOf(46)) > 0) {
                    computer.networkName = computer.ipAddress.substring(0, index);
                    computer.domainName = computer.ipAddress.substring(index + 1);
                }
            } else {
                int index = parentHostAddress.indexOf(46);
                computer.domainName = index < 0 ? null : parentHostAddress.substring(index + 1);
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResComputer.class.getName(), (String)"setVirtualServerDomainName");
        }
    }

    private static boolean isIPAddress(String ip) {
        boolean traceResult;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResComputer.class.getName(), (String)"isIPAddress", (String)"ip");
        }
        int octetCount = 0;
        int index = TResComputer.testOctet(ip, 0);
        while (index > 0) {
            ++octetCount;
            index = TResComputer.testOctet(ip, index);
        }
        boolean bl = traceResult = octetCount == 4;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResComputer.class.getName(), (String)"isIPAddress", (boolean)traceResult);
        }
        return traceResult;
    }

    private static int testOctet(String s, int start) {
        char piece;
        boolean zeroIsInvalid;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResComputer.class.getName(), (String)"testOctet", (String)"s, start");
        }
        int value = 0;
        int firstDigit = 32;
        boolean bl = zeroIsInvalid = start == 0;
        while (start < s.length() && (piece = s.charAt(start++)) != '.') {
            if (!Character.isDigit(piece)) {
                int traceResult = -1;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)TResComputer.class.getName(), (String)"testOctet", (int)traceResult);
                }
                return traceResult;
            }
            if (firstDigit == 32) {
                firstDigit = piece;
            }
            value *= 10;
            if ((value += piece - 48) <= 255) continue;
            int traceResult = -1;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TResComputer.class.getName(), (String)"testOctet", (int)traceResult);
            }
            return traceResult;
        }
        if (value == 0) {
            if (zeroIsInvalid || firstDigit == 32) {
                start = -1;
            }
        } else if (firstDigit == 48) {
            start = -1;
        }
        int traceResult = start;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResComputer.class.getName(), (String)"testOctet", (int)traceResult);
        }
        return traceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getIPAddress(int computerID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResComputer.class.getName(), (String)"getIPAddress", (String)"computerID");
        }
        String ip = null;
        this.selectStmt = this.prepareStmt(SELECT_IP_ADDRESS);
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setInt(this.selectStmt, computerID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            if (this.nextResult()) {
                this.stmtPhase = 1;
                this.colIndex = 1;
                ip = this.getString(this.resultSet);
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResComputer.class.getName(), (String)"getIPAddress", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        finally {
            this.closeSelect();
            this.closeResultSet();
        }
        String traceResult = ip;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResComputer.class.getName(), (String)"getIPAddress", traceResult);
        }
        return traceResult;
    }

    public NameList[] agentNameToComputerID(NameList[] agents) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResComputer.class.getName(), (String)"agentNameToComputerID", (String)"agents");
        }
        if (agents != null) {
            this.selectStmt = this.prepareStmt(AGENT_JOIN);
            int i = agents.length;
            while (i-- > 0) {
                NameList agent = agents[i];
                if (agent == null || agent.nlID != 0 || agent.nlName == null) continue;
                agent.nlID = this.getnlName(agent.nlName);
            }
        }
        this.closeSelect();
        NameList[] traceResult = agents;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResComputer.class.getName(), (String)"agentNameToComputerID", (Object)traceResult);
        }
        return traceResult;
    }

    public int getnlName(String nlName) throws GeneralException {
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setString(this.selectStmt, nlName.toUpperCase());
            this.resultSet = this.selectStmt.executeQuery();
            if (this.nextResult()) {
                this.stmtPhase = 1;
                this.colIndex = 1;
                return this.getInt(this.resultSet);
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResComputer.class.getName(), (String)"agentNameToComputerID", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        this.colIndex = 1;
        int pos = nlName.indexOf(46);
        if (pos == -1) {
            return 0;
        }
        try {
            String MynlName = nlName.substring(0, pos);
            this.setString(this.selectStmt, MynlName.toUpperCase());
            this.resultSet = this.selectStmt.executeQuery();
            if (this.nextResult()) {
                this.stmtPhase = 1;
                this.colIndex = 1;
                return this.getInt(this.resultSet);
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResComputer.class.getName(), (String)"agentNameToComputerID", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        return 0;
    }

    public void prepGetNasFiler() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResComputer.class.getName(), (String)"prepGetNasFiler", (String)"");
        }
        this.selectStmt = this.prepareStmt(SELECT_BY_ID);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResComputer.class.getName(), (String)"prepGetNasFiler");
        }
    }

    public void prepGetSS() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResComputer.class.getName(), (String)"prepGetSS", (String)"");
        }
        this.selectStmt = this.prepareStmt(SELECT_BY_SS_ID);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResComputer.class.getName(), (String)"prepGetSS");
        }
    }

    public void prepGetTape() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResComputer.class.getName(), (String)"prepGetTape", (String)"");
        }
        this.selectStmt = this.prepareStmt(SELECT_BY_LIBRARY_ID);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResComputer.class.getName(), (String)"prepGetTape");
        }
    }

    public NasFiler getNasFiler(int computerID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResComputer.class.getName(), (String)"getNasFiler", (String)"computerID");
        }
        this.execQueryByID(computerID);
        NasFiler filer = null;
        try {
            if (this.resultSet.next()) {
                this.colIndex = 1;
                filer = new NasFiler();
                filer.nfName = this.getString(this.resultSet);
                filer.nfNetworkName = this.getString(this.resultSet);
                filer.nfAlias = this.getString(this.resultSet);
                filer.nfIPAddress = this.getString(this.resultSet);
                this.vmAccessor = new TResVendorModel(this.dbc);
                filer.nfManufacturer = this.vmAccessor.getVendorName(this.getShort(this.resultSet));
                filer.nfOSType = this.getShort(this.resultSet);
                filer.nfComputerID = computerID;
            }
            this.resultSet.close();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResComputer.class.getName(), (String)"getNasFiler", (Throwable)e);
            }
            this.stmtType = 0;
            this.stmtPhase = 1;
            this.sqlError(e);
        }
        NasFiler traceResult = filer;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResComputer.class.getName(), (String)"getNasFiler", (Object)traceResult);
        }
        return traceResult;
    }

    public NasFiler getSS(int subsystemID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResComputer.class.getName(), (String)"getSS", (String)"subsystemID");
        }
        this.execQueryByID(subsystemID);
        NasFiler filer = null;
        try {
            if (this.resultSet.next()) {
                this.colIndex = 1;
                filer = new NasFiler();
                filer.nfName = this.getString(this.resultSet);
                filer.nfAlias = this.getString(this.resultSet);
                filer.nfIPAddress = this.getString(this.resultSet);
                this.vmAccessor = new TResVendorModel(this.dbc);
                filer.nfManufacturer = this.vmAccessor.getVendorName(this.getShort(this.resultSet));
                filer.nfOSType = this.getShort(this.resultSet);
                filer.nfNameFormat = this.getShort(this.resultSet);
                filer.nfComputerID = subsystemID;
            }
            this.resultSet.close();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResComputer.class.getName(), (String)"getNasFiler", (Throwable)e);
            }
            this.stmtType = 0;
            this.stmtPhase = 1;
            this.sqlError(e);
        }
        NasFiler traceResult = filer;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResComputer.class.getName(), (String)"getNasFiler", (Object)traceResult);
        }
        return traceResult;
    }

    public NasFiler getTape(int libraryID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResComputer.class.getName(), (String)"getTape", (String)"libraryID");
        }
        this.execQueryByID(libraryID);
        NasFiler filer = null;
        try {
            if (this.resultSet.next()) {
                this.colIndex = 1;
                filer = new NasFiler();
                filer.nfName = this.getString(this.resultSet);
                filer.nfAlias = this.getString(this.resultSet);
                filer.nfIPAddress = null;
                filer.nfManufacturer = null;
                filer.nfOSType = (short)26;
                filer.nfComputerID = libraryID;
            }
            this.resultSet.close();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResComputer.class.getName(), (String)"getNasFiler", (Throwable)e);
            }
            this.stmtType = 0;
            this.stmtPhase = 1;
            this.sqlError(e);
        }
        NasFiler traceResult = filer;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResComputer.class.getName(), (String)"getNasFiler", (Object)traceResult);
        }
        return traceResult;
    }

    public void fillNodeMap(Map nodeMap) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResComputer.class.getName(), (String)"fillNodeMap", (String)"nodeMap");
        }
        nodeMap.clear();
        this.staticStmt = this.createStatement();
        try {
            this.stmtPhase = 3;
            this.resultSet = this.staticStmt.executeQuery(SELECT_AGENTLESS_COMPUTERS);
            while (this.nextResult()) {
                this.getPhase();
                AgentLessManagedNode node = new AgentLessManagedNode(this.getInt(this.resultSet), this.getShort(this.resultSet), this.getString(this.resultSet), this.getString(this.resultSet), this.getString(this.resultSet), this.getString(this.resultSet));
                nodeMap.put(node, node);
            }
            this.closeStaticStmt();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResComputer.class.getName(), (String)"fillNodeMap", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResComputer.class.getName(), (String)"fillNodeMap");
        }
    }

    public void deleteByID(int computerID, boolean commit) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResComputer.class.getName(), (String)"deleteByID", (String)"computerID, commit");
        }
        try {
            this.deleteStmt = this.prepareStmt("delete from t_res_host where computer_id = ?");
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.deleteStmt, computerID);
            this.executeUpdate(this.deleteStmt);
            if (commit) {
                this.dbc.commit();
            }
            this.closeDelete();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResComputer.class.getName(), (String)"deleteByID", (Throwable)e);
            }
            this.stmtType = 3;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResComputer.class.getName(), (String)"deleteByID");
        }
    }

    public void getIDs(NasFiler filerList) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResComputer.class.getName(), (String)"getIDs", (String)"filerList");
        }
        int insertCount = this.selectIDs(filerList);
        if (filerList != null) {
            this.updateFilers(filerList);
        }
        if (insertCount > 0) {
            try {
                HardwareID hwID = new HardwareID(null, null, null, 8);
                TComputer computer = new TComputer();
                computer.hwID = hwID;
                computer.timezoneID = TimeZone.getDefault().getID();
                int id = StorageRepositoryAccessor.getIdentifier(1, insertCount, this.dbc);
                NasFiler filer = filerList;
                while (filer != null) {
                    if (filer.nfComputerID == -1) {
                        filer.nfNewFiler = true;
                        filer.nfComputerID = id++;
                        computer.tsName = filer.nfName;
                        computer.ipAddress = filer.nfIPAddress;
                        computer.networkName = filer.nfNetworkName;
                        if (Constants.isCimomManaged((short)filer.nfComputer.cmpOSType) || Constants.isUnmanagedOS((short)filer.nfComputer.cmpOSType)) {
                            computer.domainName = filer.nfDomain.domName;
                        }
                        hwID.manufacturer = filer.nfManufacturer;
                        hwID.hostName = filer.nfComputer.cmpOSType == 26 ? filer.nfComputer.cmpModel : (Util.isEmpty((String)filer.nfAlias) ? filer.nfName : filer.nfAlias);
                        hwID.hardwareID = String.valueOf(filer.nfComputerID).getBytes();
                        hwID.osType = filer.nfComputer.cmpOSType;
                        if (Constants.isVirtualServer((int)hwID.osType)) {
                            this.setVirtualServerDomainName(computer, filer.nfParentComputerID);
                            filer.nfComputer.cmpNewVS = true;
                        }
                        if (Constants.isCimomManaged((short)filer.nfComputer.cmpOSType)) {
                            computer.prepareInsertSS(this.dbc);
                            computer.insertSS(this.dbc);
                        } else {
                            computer.prepareInsert(this.dbc);
                            computer.insertComputer(this.dbc, filer.nfComputerID);
                        }
                    }
                    filer = filer.nfNext;
                }
                computer.closeInsert();
            }
            catch (SQLException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)TResComputer.class.getName(), (String)"getIDs", (Throwable)e);
                }
                this.stmtType = 1;
                this.sqlError(e);
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResComputer.class.getName(), (String)"getIDs");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFilers(NasFiler filerList) throws GeneralException {
        block17: {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)TResComputer.class.getName(), (String)"updateFilers", (String)"filerList");
            }
            TComputer comp = new TComputer();
            TComputer repoComputer = new TComputer();
            AgentManager agentMgr = Server.getAgentManager();
            GeneralException head = null;
            boolean needUpdate = false;
            try {
                NasFiler filer = filerList;
                while (filer != null) {
                    block18: {
                        block20: {
                            boolean isCIMOMManaged;
                            block19: {
                                if (filer.nfComputerID == -1 || Constants.isUnmanagedOS((short)filer.nfComputer.cmpOSType)) break block18;
                                boolean isVirtualServer = Constants.isVirtualServer((int)filer.nfComputer.cmpOSType);
                                isCIMOMManaged = Constants.isCimomManaged((short)filer.nfComputer.cmpOSType);
                                if (!isVirtualServer && !isCIMOMManaged || (repoComputer = isCIMOMManaged ? TComputer.getSS(filer.nfComputerID, this.dbc) : TComputer.getComputer(null, null, filer.nfComputerID, null, this.dbc)) == null) break block18;
                                if (!isVirtualServer) break block19;
                                comp.computerID = filer.nfComputerID;
                                comp.guid = repoComputer.guid;
                                comp.hwID = repoComputer.hwID;
                                comp.ipAddress = filer.nfIPAddress;
                                comp.networkName = filer.nfNetworkName;
                                this.setVirtualServerDomainName(comp, filer.nfParentComputerID);
                                comp.productState = repoComputer.productState;
                                comp.timezoneID = TimeZone.getDefault().getID();
                                comp.tsName = repoComputer.tsName;
                                if (comp.equalsRepositoryComputer(repoComputer)) break block18;
                                needUpdate = true;
                                break block20;
                            }
                            if (!isCIMOMManaged) break block20;
                            if (filer.nfDomain != null && Util.stringsEqual((String)repoComputer.domainName, (String)filer.nfDomain.domName)) break block18;
                            needUpdate = true;
                            comp = repoComputer;
                            comp.domainName = filer.nfDomain.domName;
                        }
                        if (needUpdate) {
                            needUpdate = false;
                            comp.updateComputer(repoComputer, this.dbc);
                            agentMgr.updateAgentLessManagedNode(comp);
                        }
                    }
                    filer = filer.nfNext;
                }
            }
            catch (SQLException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)TResComputer.class.getName(), (String)"updateFilers", (Throwable)e);
                }
                this.stmtType = 2;
                try {
                    this.sqlError(e);
                }
                catch (GeneralException ge) {
                    if (head == null) {
                        head = ge;
                    }
                    head.addException((StorageException)ge);
                }
            }
            finally {
                if (head == null) break block17;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)TResComputer.class.getName(), (String)"updateFilers");
                }
                throw head;
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResComputer.class.getName(), (String)"updateFilers");
        }
    }

    public int selectIDs(NasFiler filerList) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResComputer.class.getName(), (String)"selectIDs", (String)"filerList");
        }
        int notFoundCount = 0;
        try {
            NasFiler filer = filerList;
            while (filer != null) {
                if (Constants.isVirtualServer((int)filer.nfOSType)) {
                    filer.nfNewFiler = false;
                }
                this.selectStmt = Constants.isDiskArray((short)filer.nfOSType) ? this.prepareStmt("select subsystem_id from t_res_storage_subsystem where name = ?") : this.prepareStmt("select computer_id from t_res_host where host_name = ?");
                this.setPhase();
                this.setString(this.selectStmt, filer.nfName);
                this.stmtPhase = 3;
                this.resultSet = this.selectStmt.executeQuery();
                if (this.nextResult()) {
                    this.getPhase();
                    filer.nfComputerID = this.getInt(this.resultSet);
                } else {
                    filer.nfComputerID = -1;
                    ++notFoundCount;
                }
                this.resultSet.close();
                filer = filer.nfNext;
            }
            this.closeSelect();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResComputer.class.getName(), (String)"selectIDs", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        int traceResult = notFoundCount;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResComputer.class.getName(), (String)"selectIDs", (int)traceResult);
        }
        return traceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int selectID(String localHostName) throws StorageException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResComputer.class.getName(), (String)"selectID", (String)"localHostName");
        }
        int returnVal = -1;
        try {
            this.selectStmt = this.prepareStmt(SELECT_COMPUTER_ID);
            this.setPhase();
            this.setString(this.selectStmt, localHostName);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.getPhase();
            if (this.nextResult()) {
                returnVal = this.getInt(this.resultSet);
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResComputer.class.getName(), (String)"selectID", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        finally {
            this.closeResultSet();
            this.closeSelect();
        }
        int traceResult = returnVal;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResComputer.class.getName(), (String)"selectID", (int)traceResult);
        }
        return traceResult;
    }

    public int selectCID(String trellisoftName) throws GeneralException {
        return this.selectCID(trellisoftName, null);
    }

    public int selectCID(String name1, String name2) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResComputer.class.getName(), (String)"selectCID", (String)"name1, name2");
        }
        int returnVal = -1;
        try {
            String whereClause = name2 == null ? BY_NAME : BY_NETWORK_NAME;
            this.selectStmt = this.prepareStmt(SELECT_ID + whereClause);
            this.setPhase();
            this.setString(this.selectStmt, name1);
            if (name2 != null) {
                this.setString(this.selectStmt, name2);
            }
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.getPhase();
            if (this.nextResult()) {
                returnVal = this.getInt(this.resultSet);
            }
            this.resultSet.close();
            this.closeSelect();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResComputer.class.getName(), (String)"selectCID", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResComputer.class.getName(), (String)"selectCID", (int)returnVal);
        }
        return returnVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVSNodeName(int computerId) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResComputer.class.getName(), (String)"getVSNodeName", (String)"computer_id");
        }
        String nodeName = null;
        try {
            this.selectStmt = this.prepareStmt(SELECT_NODE_HOSTED_NAME);
            this.setPhase();
            this.setInt(this.selectStmt, computerId);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.getPhase();
            if (this.nextResult()) {
                nodeName = this.getString(this.resultSet);
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResComputer.class.getName(), (String)"getVSNodeName", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        finally {
            this.closeSelect();
            this.closeResultSet();
        }
        String traceResult = nodeName;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResComputer.class.getName(), (String)"getVSNodeName", traceResult);
        }
        return traceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getStorageSubsystemType(int id) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResComputer.class.getName(), (String)"getStorageSubsystemType", (String)"id");
        }
        this.selectStmt = this.prepareStmt(SELECT_SS);
        short traceResult = -1;
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, id);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            if (this.nextResult()) {
                this.colIndex = 1;
                traceResult = this.getShort(this.resultSet);
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResComputer.class.getName(), (String)"isStorageSubsystem", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        finally {
            this.closeResultSet();
            this.closeSelect();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResComputer.class.getName(), (String)"isStorageSubsystem", (short)traceResult);
        }
        return traceResult;
    }

    public boolean isStorageSubsystem(int id) throws GeneralException {
        return this.getStorageSubsystemType(id) > -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTapeLibrary(int id) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResComputer.class.getName(), (String)"isTapeLibrary", (String)"id");
        }
        boolean isTape = false;
        StringBuffer buf = new StringBuffer(500);
        buf.append(SELECT_TAPE);
        this.selectStmt = this.prepareStmt(buf.toString());
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, id);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            if (this.nextResult()) {
                isTape = true;
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResComputer.class.getName(), (String)"isTapeLibrary", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        finally {
            this.closeResultSet();
            this.closeSelect();
        }
        boolean traceResult = isTape;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResComputer.class.getName(), (String)"isTapeLibrary", (boolean)traceResult);
        }
        return traceResult;
    }
}

