/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import org.eclipse.aperi.TStorm.common.Device;
import org.eclipse.aperi.TStorm.common.Disk;
import org.eclipse.aperi.TStorm.common.Share;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.table.TAlertLog;
import org.eclipse.aperi.repository.table.TResComputer;
import org.eclipse.aperi.repository.table.TResVendorModel;
import org.eclipse.aperi.repository.table.TStatDisk;
import org.eclipse.aperi.repository.table.TStatDiskHist;

public class TResDevice
extends StorageRepositoryAccessor {
    private TResVendorModel vmAccessor = null;
    private Timestamp tsMan = new Timestamp(0L);
    private Timestamp tsCurr = new Timestamp(0L);
    private TStatDisk dskAccessor;
    private long currentTime;
    protected PreparedStatement insertNetAppStmt;
    protected PreparedStatement updateNetAppStmt;
    private static final String GET_DEVICE_IDS = "select physical_volume_id from t_res_physical_volume where vendor_id = ? and serial_number = ? and device_id = ? ";
    private static final String GET_PV_ID = "select physical_volume_id from t_res_physical_volume where  serial_number = ? ";
    private static final String GET_OLD_STYLE_DEVID = "select physical_volume_id from t_res_physical_volume where  physical_volume_id = ? and DEVICE_ID like '%NETWORK APPLIANCE%'";
    private static final String GET_NEW_STYLE_PV = "select * from t_res_physical_volume where serial_number = ?";
    private static final String UPDATE_NETAPP_DEVICE = "update t_res_physical_volume set serial_number = ?, display_name = ?, subsystem_serial_number = ? where physical_volume_id = ?";
    private static final String INSERT_NETAPP_DEVICE = "insert into t_res_physical_volume (physical_volume_id, vendor_id, serial_number, model_id, manufacture_date, firmware_rev, device_type, use_count, multi_port, flags, removable_medium, unsupported_model, discovered_time, storage_system_type, subsystem_id, device_id, SYSTEM_NAMES_ID, subsystem_serial_number, name, display_name) values (?,?,?,?,?,?,?,0,?,?,?,?,?,?,-1,?, -1, ?, ?, ?)";
    private static final String GET_DEVICE = "select device_type, physical_volume_id, vendor_id, serial_number, model_id, name, manufacture_date, firmware_rev, use_count, multi_port, flags, removable_medium, unsupported_model, discovered_time, storage_system_type, subsystem_serial_number from t_res_physical_volume";
    private static final String GET_DEVICE_BY_COMPUTER = "select device_type, physical_volume_id, vendor_id, serial_number, model_id, d.name,  manufacture_date, firmware_rev, use_count, multi_port, flags, removable_medium, unsupported_model, discovered_time, storage_system_type, subsystem_serial_number from t_res_physical_volume d, t_res_share s where s.computer_id = ? and s.resource_type = 10 and s.resource_id = d.physical_volume_id";
    private static final String INSERT_DEVICE = "insert into t_res_physical_volume (physical_volume_id, vendor_id, serial_number, model_id, manufacture_date, firmware_rev, device_type, use_count, multi_port, flags, removable_medium, unsupported_model, discovered_time, storage_system_type, subsystem_id, device_id, SYSTEM_NAMES_ID, subsystem_serial_number, name) values (?,?,?,?,?,?,?,0,?,?,?,?,?,?,-1,?, -1, ?, ?)";
    private static final String BUMP_DEV_USE_COUNT = "update t_res_physical_volume set use_count = use_count + ? where physical_volume_id = ?";
    private static final String UPDATE_SPARE_DISK = "update t_res_physical_volume set flags = ? where physical_volume_id = ?";
    private static final String NULL_FLAGS = "update t_res_physical_volume set flags = NULL where physical_volume_id = ?";
    private static final String EXTRACT_FLAGS = "select flags from t_res_physical_volume where physical_volume_id = ?";
    private static final String DELETE_DEVICE = "delete from t_res_physical_volume where physical_volume_id = ?";
    private static final String SELECT_SS_DISK = " select physical_volume_id from t_res_physical_volume where physical_volume_id = ?  and subsystem_id <> -1 ";
    private static final String SELECT_SVC_MDISK = " select storage_extent_id from t_res_storage_extent where storage_extent_id = ?";
    private static final String SELECT_SS_TYPE_FOR_DISK = " select ss.os_type from t_res_storage_subsystem ss, t_res_physical_volume pv   where ss.subsystem_id = pv.subsystem_id and pv.physical_volume_id = ?";
    private static final String GET_SVC_MDISK_INFO = "select se.storage_extent_id, ss.vendor_id, se.serial_number, ss.model_id, se.element_name from t_res_storage_extent se, t_res_storage_subsystem ss where se.subsystem_id = ss.subsystem_id and";

    public TResDevice(Connection dbc) {
        super(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResDevice.class.getName(), (String)"TResDevice", (String)"dbc");
        }
        try {
            this.currentTime = SQLUtil.getTimestamp(dbc).getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResDevice.class.getName(), (String)"TResDevice", (Throwable)e);
            }
            return;
        }
        this.dskAccessor = new TStatDisk(dbc);
        this.tableName = "t_res_physical_volume";
        this.vmAccessor = new TResVendorModel(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResDevice.class.getName(), (String)"TResDevice");
        }
    }

    public void prepGetDevByID(boolean SVCMDisk) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResDevice.class.getName(), (String)"prepGetDevByID", (String)"SVCMDisk");
        }
        String selectSql = null;
        selectSql = SVCMDisk ? "select se.storage_extent_id, ss.vendor_id, se.serial_number, ss.model_id, se.element_name from t_res_storage_extent se, t_res_storage_subsystem ss where se.subsystem_id = ss.subsystem_id and storage_extent_id = ?" : "select device_type, physical_volume_id, vendor_id, serial_number, model_id, name, manufacture_date, firmware_rev, use_count, multi_port, flags, removable_medium, unsupported_model, discovered_time, storage_system_type, subsystem_serial_number from t_res_physical_volume where physical_volume_id = ?";
        this.selectStmt = this.prepareStmt(selectSql);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResDevice.class.getName(), (String)"prepGetDevByID", (Object)"SVCMDisk");
        }
    }

    public Device getDevByID(int devID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResDevice.class.getName(), (String)"getDevByID", (String)"devID");
        }
        boolean isMDisk = this.isSVCMDisk(devID);
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, devID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            Device localDev = this.getDevice(isMDisk);
            this.closeResultSet();
            Device traceResult = localDev;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TResDevice.class.getName(), (String)"getDevByID", (Object)traceResult);
            }
            return traceResult;
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResDevice.class.getName(), (String)"getDevByID", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
            Device traceResult = null;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TResDevice.class.getName(), (String)"getDevByID", traceResult);
            }
            return traceResult;
        }
    }

    public Device getDevByCmp(int computerID, short devType) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResDevice.class.getName(), (String)"getDevByCmp", (String)"computerID, devType");
        }
        Device devList = null;
        String devTypeCondition = devType != -1 ? " and device_type = " + devType : null;
        String selectSql = GET_DEVICE_BY_COMPUTER + devTypeCondition;
        this.selectStmt = this.prepareStmt(selectSql);
        try {
            Device dev;
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, computerID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            while ((dev = this.getDevice(false)) != null) {
                dev.devNext = devList;
                devList = dev;
            }
            this.closeSelect();
            TStatDisk diskAccessor = new TStatDisk(this.dbc);
            Device traceResult = diskAccessor.getDiskByID(devList);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TResDevice.class.getName(), (String)"getDevByCmp", (Object)traceResult);
            }
            return traceResult;
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResDevice.class.getName(), (String)"getDevByCmp", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
            Device traceResult = null;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TResDevice.class.getName(), (String)"getDevByCmp", traceResult);
            }
            return traceResult;
        }
    }

    private Device getDevice(boolean isSVCMdisk) throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResDevice.class.getName(), (String)"getDevice", (String)"");
        }
        if (!this.nextResult()) {
            Device traceResult = null;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TResDevice.class.getName(), (String)"getDevice", traceResult);
            }
            return traceResult;
        }
        this.stmtPhase = 1;
        this.colIndex = 1;
        Object dev = null;
        if (!isSVCMdisk) {
            short devType = this.getShort(this.resultSet);
            dev = Device.isFixedDisk((short)devType) ? new Disk() : new Device();
            dev.devType = devType;
        } else {
            dev = new Disk();
        }
        dev.devID = this.getInt(this.resultSet);
        dev.devManufacturer = this.vmAccessor.getVendorName(this.getShort(this.resultSet));
        dev.devSerialNumber = this.getString(this.resultSet);
        dev.devModel = this.vmAccessor.getModelName(this.getShort(this.resultSet));
        dev.devName = this.getString(this.resultSet);
        if (!isSVCMdisk) {
            dev.devManufactureDate = this.getTimestamp(this.resultSet);
            dev.devFirmwareRev = this.getString(this.resultSet);
            dev.devUseCount = this.getShort(this.resultSet);
            dev.devMultiPort = this.getBoolean(this.resultSet);
            dev.devFlags = this.getShort(this.resultSet);
            dev.devRemovableMedium = this.getBoolean(this.resultSet);
            dev.devUnsupportedModel = this.getBoolean(this.resultSet);
            dev.devDiscoveredTime = this.getTimestamp(this.resultSet);
            dev.devStorageSystemType = this.getShort(this.resultSet);
            dev.devSubsystemSerialNumber = this.getString(this.resultSet);
        }
        Disk traceResult = dev;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResDevice.class.getName(), (String)"getDevice", (Object)traceResult);
        }
        return traceResult;
    }

    public void saveDevices(Device devList) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResDevice.class.getName(), (String)"saveDevices", (String)"devList");
        }
        if (devList == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TResDevice.class.getName(), (String)"saveDevices");
            }
            return;
        }
        Device dev = null;
        int identifierCount = 0;
        int identifier = 0;
        try {
            this.stmtType = 0;
            this.selectStmt = this.prepareStmt(GET_DEVICE_IDS);
            dev = devList;
            while (dev != null) {
                if (!this.fetchID(dev)) {
                    ++identifierCount;
                }
                dev = dev.devNext;
            }
            if (identifierCount > 0) {
                identifier = TResDevice.getIdentifier(1, identifierCount, this.dbc);
                this.insertStmt = this.prepareStmt(INSERT_DEVICE);
            }
            this.dskAccessor.prepSave();
            dev = devList;
            while (dev != null) {
                if (dev.devID == -1) {
                    dev.devFlags = (short)(dev.devFlags | 4);
                    dev.devID = identifier++;
                    this.insertDev(dev);
                }
                if (dev.isFixedDisk()) {
                    this.dskAccessor.saveDisk((Disk)dev);
                }
                this.dbc.commit();
                dev = dev.devNext;
            }
            this.closeSelect();
            this.closeInsert();
            this.closeUpdate();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResDevice.class.getName(), (String)"saveDevices", (Throwable)e);
            }
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResDevice.class.getName(), (String)"saveDevices");
        }
    }

    public void saveNetAppDevices(Device devList, String SS_SerialNumber) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResDevice.class.getName(), (String)"saveNetappDevices", (String)"devList");
        }
        if (devList == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TResDevice.class.getName(), (String)"saveNetAppDevices");
            }
            return;
        }
        Device dev = null;
        int identifierCount = 0;
        int identifier = 0;
        try {
            dev = devList;
            while (dev != null) {
                if (!this.fetchNetAppID(dev, SS_SerialNumber)) {
                    ++identifierCount;
                }
                dev = dev.devNext;
            }
            if (identifierCount > 0) {
                identifier = TResDevice.getIdentifier(1, identifierCount, this.dbc);
                this.insertNetAppStmt = this.prepareStmt(INSERT_NETAPP_DEVICE);
            }
            this.dskAccessor.prepSave();
            dev = devList;
            while (dev != null) {
                if (dev.devID == -1) {
                    dev.devFlags = (short)(dev.devFlags | 4);
                    dev.devID = identifier++;
                    this.insertNetAppDev(dev, SS_SerialNumber);
                } else {
                    this.updateNetAppDev(dev, SS_SerialNumber);
                }
                if (dev.isFixedDisk()) {
                    this.dskAccessor.saveDisk((Disk)dev);
                }
                this.dbc.commit();
                dev = dev.devNext;
            }
            this.closeSelect();
            this.closeInsert();
            this.closeUpdate();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResDevice.class.getName(), (String)"saveNetAppDevices", (Throwable)e);
            }
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResDevice.class.getName(), (String)"saveNetAppDevices");
        }
    }

    private boolean fetchNetAppID(Device dev, String SS_SerialNumber) throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResDevice.class.getName(), (String)"fetchNetAppID", (String)"dev");
        }
        this.stmtType = 0;
        this.selectStmt = this.prepareStmt(GET_DEVICE_IDS);
        this.stmtPhase = 0;
        this.colIndex = 1;
        this.setDeviceKey(this.selectStmt, dev);
        this.setString(this.selectStmt, dev.devSerialNumber + ":" + dev.devManufacturer);
        this.stmtPhase = 3;
        this.resultSet = this.selectStmt.executeQuery();
        this.stmtPhase = 1;
        boolean result = this.nextResult();
        if (result) {
            this.colIndex = 1;
            dev.devID = this.getInt(this.resultSet);
            this.closeResultSet();
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TResDevice.class.getName(), (String)"fetchNetAppID", (boolean)result);
            }
            return result;
        }
        this.closeResultSet();
        this.stmtPhase = 0;
        this.colIndex = 1;
        this.selectStmt = this.prepareStmt(GET_NEW_STYLE_PV);
        String new_serial_no = this.prep_new_serialno(dev, SS_SerialNumber);
        this.setString(this.selectStmt, new_serial_no);
        this.stmtPhase = 3;
        this.resultSet = this.selectStmt.executeQuery();
        this.stmtPhase = 1;
        result = this.nextResult();
        if (result) {
            this.colIndex = 1;
            dev.devID = this.getInt(this.resultSet);
            this.closeResultSet();
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TResDevice.class.getName(), (String)"fetchNetAppID", (boolean)result);
            }
            return result;
        }
        dev.devID = -1;
        this.closeResultSet();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResDevice.class.getName(), (String)"fetchNetAppID", (boolean)result);
        }
        return result;
    }

    private void setNewDeviceKey(PreparedStatement stmt, Device dev, String SS_SerialNumber) throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResDevice.class.getName(), (String)"setNewDeviceKey", (String)"stmt, dev");
        }
        short vendor_id = this.vmAccessor.getVendorID(dev.devManufacturer);
        this.setShort(stmt, vendor_id);
        this.setString(stmt, this.prep_new_serialno(dev, SS_SerialNumber));
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResDevice.class.getName(), (String)"setNewDeviceKey");
        }
    }

    private void insertNetAppDev(Device dev, String SS_SerialNumber) throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResDevice.class.getName(), (String)"insertNetAppDev", (String)"dev, SS_SerialNumber");
        }
        this.stmtType = 1;
        this.stmtPhase = 0;
        this.colIndex = 1;
        this.setInt(this.insertNetAppStmt, dev.devID);
        this.setNewDeviceKey(this.insertNetAppStmt, dev, SS_SerialNumber);
        short model_id = this.vmAccessor.getModelID(dev.devModel);
        this.setInt(this.insertNetAppStmt, model_id);
        this.setTimestamp(this.insertNetAppStmt, dev.devManufactureDate, this.tsMan);
        if (dev.devFirmwareRev == null) {
            dev.devFirmwareRev = " ";
        }
        this.setString(this.insertNetAppStmt, dev.devFirmwareRev);
        this.setShort(this.insertNetAppStmt, dev.devType);
        this.setBoolean(this.insertNetAppStmt, dev.devMultiPort);
        this.setShort(this.insertNetAppStmt, dev.devFlags);
        this.setBoolean(this.insertNetAppStmt, dev.devRemovableMedium);
        this.setBoolean(this.insertNetAppStmt, dev.devUnsupportedModel);
        this.setTimestamp(this.insertNetAppStmt, this.currentTime, this.tsCurr);
        this.setShort(this.insertNetAppStmt, dev.devStorageSystemType);
        this.setString(this.insertNetAppStmt, this.prep_new_deviceID(dev, SS_SerialNumber));
        if (SS_SerialNumber == null || SS_SerialNumber == "") {
            this.setString(this.insertNetAppStmt, " ");
        } else {
            this.setString(this.insertNetAppStmt, SS_SerialNumber);
        }
        if (dev.devName == null) {
            dev.devName = " ";
        }
        this.setString(this.insertNetAppStmt, dev.devName);
        this.setString(this.insertNetAppStmt, this.prep_device_str(dev));
        this.executeUpdate(this.insertNetAppStmt);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResDevice.class.getName(), (String)"insertNetAppDev", (Object)"dev, SS_SerialNumber");
        }
    }

    private void updateNetAppDev(Device dev, String SS_SerialNumber) throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResDevice.class.getName(), (String)"updateDev", (String)"dev, SS_SerialNumber");
        }
        PreparedStatement updateNetAppStmt = null;
        updateNetAppStmt = this.prepareStmt(UPDATE_NETAPP_DEVICE);
        this.stmtType = 2;
        this.stmtPhase = 0;
        this.colIndex = 1;
        this.setString(updateNetAppStmt, this.prep_new_serialno(dev, SS_SerialNumber));
        this.setString(updateNetAppStmt, this.prep_device_str(dev));
        if (SS_SerialNumber == null || SS_SerialNumber == "") {
            this.setString(updateNetAppStmt, " ");
        } else {
            this.setString(updateNetAppStmt, SS_SerialNumber);
        }
        this.setInt(updateNetAppStmt, dev.devID);
        this.executeUpdate(updateNetAppStmt);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResDevice.class.getName(), (String)"updateDev", (Object)"dev, SS_SerialNumber");
        }
    }

    private String prep_new_deviceID(Device dev, String SS_SerialNumber) throws GeneralException {
        String device_str = this.prep_device_str(dev);
        if (SS_SerialNumber != null && SS_SerialNumber != "" && device_str != null) {
            return "ONTAP:" + SS_SerialNumber + ":" + device_str;
        }
        return device_str;
    }

    private String prep_new_serialno(Device dev, String SS_SerialNumber) throws GeneralException {
        String device_str = this.prep_device_str(dev);
        if (SS_SerialNumber != null && device_str != null) {
            return SS_SerialNumber + "/" + device_str + ":" + dev.devManufacturer;
        }
        GeneralException e = new GeneralException("node or device are null");
        throw e;
    }

    private String prep_device_str(Device dev) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResDevice.class.getName(), (String)"prep_device_str", (String)"dev");
        }
        int end = 0;
        end = dev.devControllers.daPath.indexOf(":");
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResDevice.class.getName(), (String)"prep_device_str");
        }
        if (end != -1) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TResDevice.class.getName(), (String)"prep_device_str");
            }
            return dev.devControllers.daPath.substring(5, end) + "." + dev.devControllers.daTarget;
        }
        int index = dev.devSerialNumber.indexOf("/");
        String localDevSerialNumber = dev.devSerialNumber;
        if (index > 1) {
            dev.devSubsystemSerialNumber = dev.devSerialNumber.substring(0, index);
            localDevSerialNumber = dev.devSerialNumber.substring(index + 1);
        }
        return localDevSerialNumber;
    }

    public void prepBumpUseCount() throws GeneralException {
        this.updateStmt = this.prepareStmt(BUMP_DEV_USE_COUNT);
    }

    public void bumpUseCount(Device dev, int value) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResDevice.class.getName(), (String)"bumpUseCount", (String)"dev, value");
        }
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setShort(this.updateStmt, (short)value);
            this.setInt(this.updateStmt, dev.devID);
            this.executeUpdate(this.updateStmt);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResDevice.class.getName(), (String)"bumpUseCount", (Throwable)e);
            }
            this.stmtType = 2;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResDevice.class.getName(), (String)"bumpUseCount");
        }
    }

    private boolean fetchID(Device dev) throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResDevice.class.getName(), (String)"fetchID", (String)"dev");
        }
        this.stmtPhase = 0;
        this.colIndex = 1;
        this.setDeviceKey(this.selectStmt, dev);
        this.setString(this.selectStmt, dev.devSerialNumber + ":" + dev.devManufacturer);
        this.stmtPhase = 3;
        this.resultSet = this.selectStmt.executeQuery();
        this.stmtPhase = 1;
        boolean result = this.nextResult();
        if (result) {
            this.colIndex = 1;
            dev.devID = this.getInt(this.resultSet);
        } else {
            dev.devID = -1;
        }
        this.closeResultSet();
        boolean traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResDevice.class.getName(), (String)"fetchID", (boolean)traceResult);
        }
        return traceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getStorageSubsystemTypeForDisk(int disk_id) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResDevice.class.getName(), (String)"getStorageSubsystemTypeForDisk", (String)"disk_id");
        }
        short ssType = -1;
        Statement ssTypeStatement = null;
        ResultSet rs = null;
        try {
            short s = ssType = this.isSVCMDisk(disk_id) ? (short)21 : ssType;
            if (ssType != 21) {
                ssTypeStatement = this.dbc.prepareStatement(SELECT_SS_TYPE_FOR_DISK);
                ssTypeStatement.setInt(1, disk_id);
                rs = ssTypeStatement.executeQuery();
                if (rs.next()) {
                    ssType = rs.getShort(1);
                }
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResComputer.class.getName(), (String)"getStorageSubsystemTypeForDisk", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        finally {
            try {
                if (ssTypeStatement != null) {
                    ssTypeStatement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sqle) {}
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResComputer.class.getName(), (String)"getStorageSubsystemTypeForDisk", (short)ssType);
        }
        return ssType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStorageSubsystemDisk(int id) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResDevice.class.getName(), (String)"isStorageSubsystemDisk", (String)"id");
        }
        this.selectStmt = this.prepareStmt(SELECT_SS_DISK);
        int result = -1;
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, id);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            if (this.nextResult()) {
                this.colIndex = 1;
                result = this.getInt(this.resultSet);
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResComputer.class.getName(), (String)"isStorageSubsystemDisk", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        finally {
            this.closeResultSet();
            this.closeSelect();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResComputer.class.getName(), (String)"isStorageSubsystemDisk", (int)result);
        }
        return result > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSVCMDisk(int id) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResDevice.class.getName(), (String)"isSVCMDisk", (String)"id");
        }
        PreparedStatement svcMDiskStatement = null;
        ResultSet svcMDiskResultSet = null;
        int result = -1;
        try {
            svcMDiskStatement = this.dbc.prepareStatement(SELECT_SVC_MDISK);
            svcMDiskStatement.setInt(1, id);
            svcMDiskResultSet = svcMDiskStatement.executeQuery();
            if (svcMDiskResultSet.next()) {
                result = svcMDiskResultSet.getInt(1);
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResComputer.class.getName(), (String)"isSVCMDisk", (Throwable)e);
            }
            this.sqlError(e);
        }
        finally {
            try {
                if (svcMDiskStatement != null) {
                    svcMDiskStatement.close();
                }
                if (svcMDiskResultSet != null) {
                    svcMDiskResultSet.close();
                }
            }
            catch (SQLException sqle) {}
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResComputer.class.getName(), (String)"isSVCMDisk", (int)result);
        }
        return result > 0;
    }

    private void insertDev(Device dev) throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResDevice.class.getName(), (String)"insertDev", (String)"dev");
        }
        this.stmtType = 1;
        this.stmtPhase = 0;
        this.colIndex = 1;
        this.setInt(this.insertStmt, dev.devID);
        this.setDeviceKey(this.insertStmt, dev);
        short model_id = this.vmAccessor.getModelID(dev.devModel);
        this.setInt(this.insertStmt, model_id);
        this.setTimestamp(this.insertStmt, dev.devManufactureDate, this.tsMan);
        if (dev.devFirmwareRev == null) {
            dev.devFirmwareRev = " ";
        }
        this.setString(this.insertStmt, dev.devFirmwareRev);
        this.setShort(this.insertStmt, dev.devType);
        this.setBoolean(this.insertStmt, dev.devMultiPort);
        this.setShort(this.insertStmt, dev.devFlags);
        this.setBoolean(this.insertStmt, dev.devRemovableMedium);
        this.setBoolean(this.insertStmt, dev.devUnsupportedModel);
        this.setTimestamp(this.insertStmt, this.currentTime, this.tsCurr);
        this.setShort(this.insertStmt, dev.devStorageSystemType);
        this.setString(this.insertStmt, dev.devSerialNumber + ":" + dev.devManufacturer);
        this.setString(this.insertStmt, dev.devSubsystemSerialNumber);
        if (dev.devName == null) {
            dev.devName = " ";
        }
        this.setString(this.insertStmt, dev.devName);
        this.executeUpdate(this.insertStmt);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResDevice.class.getName(), (String)"insertDev");
        }
    }

    private void setDeviceKey(PreparedStatement stmt, Device dev) throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResDevice.class.getName(), (String)"setDeviceKey", (String)"stmt, dev");
        }
        short vendor_id = this.vmAccessor.getVendorID(dev.devManufacturer);
        this.setShort(stmt, vendor_id);
        int index = dev.devSerialNumber.indexOf("/");
        String localDevSerialNumber = dev.devSerialNumber;
        if (index > 1) {
            dev.devSubsystemSerialNumber = dev.devSerialNumber.substring(0, index);
            localDevSerialNumber = dev.devSerialNumber.substring(index + 1);
        }
        this.setString(stmt, localDevSerialNumber);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResDevice.class.getName(), (String)"setDeviceKey");
        }
    }

    public void deleteDevices(Device devList) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResDevice.class.getName(), (String)"deleteDevices", (String)"devList");
        }
        TStatDiskHist histAccessor = new TStatDiskHist(this.dbc);
        histAccessor.deleteHist(devList);
        TAlertLog alertAccessor = new TAlertLog(this.dbc);
        try {
            this.deleteStmt = this.prepareStmt(DELETE_DEVICE);
            this.dskAccessor.prepDelete();
            Device dev = devList;
            while (dev != null) {
                if (dev.isFixedDisk()) {
                    this.dskAccessor.deleteDisk(dev);
                    alertAccessor.deleteByDisk(dev.devID);
                }
                this.deleteDev(dev);
                dev = dev.devNext;
            }
            this.closeDelete();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResDevice.class.getName(), (String)"deleteDevices", (Throwable)e);
            }
            this.stmtType = 3;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResDevice.class.getName(), (String)"deleteDevices");
        }
    }

    private void deleteDev(Device dev) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResDevice.class.getName(), (String)"deleteDev", (String)"dev");
        }
        this.stmtPhase = 0;
        this.colIndex = 1;
        this.setInt(this.deleteStmt, dev.devID);
        this.executeUpdate(this.deleteStmt);
        this.dbc.commit();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResDevice.class.getName(), (String)"deleteDev");
        }
    }

    public static String getGeneratedSerialNumber(Disk disk, Share share) {
        if (disk.devSerialNumber == null) {
            disk.devSerialNumber = Constants.hasSSDiskSerialNumber((short)share.shResourceType) ? share.shPath : share.shPath + "-" + share.shComputerName;
        }
        return disk.devSerialNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPVID(String serialNum) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResDevice.class.getName(), (String)"getPVID", (String)"serialNum");
        }
        PreparedStatement selectStmt = null;
        ResultSet rs = null;
        int pvID = 0;
        try {
            selectStmt = this.prepareStmt(GET_PV_ID);
            selectStmt.setString(1, serialNum);
            rs = selectStmt.executeQuery();
            if (rs.next()) {
                pvID = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResComputer.class.getName(), (String)"getPVID", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        finally {
            try {
                if (selectStmt != null) {
                    selectStmt.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sqle) {}
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResComputer.class.getName(), (String)"getPVID", (int)pvID);
        }
        return pvID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSpare(int diskID, boolean clearFlags) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResDevice.class.getName(), (String)"setSpare", (String)"diskID");
        }
        PreparedStatement selectStmt = null;
        Statement updateStmt = null;
        ResultSet rs = null;
        short diskFlags = 0;
        try {
            selectStmt = this.prepareStmt(EXTRACT_FLAGS);
            selectStmt.setInt(1, diskID);
            rs = selectStmt.executeQuery();
            if (rs.next()) {
                diskFlags = rs.getShort(1);
                diskFlags = (short)(diskFlags | 8);
                updateStmt = clearFlags ? this.prepareStmt(NULL_FLAGS) : this.prepareStmt(UPDATE_SPARE_DISK);
                this.stmtPhase = 0;
                this.colIndex = 1;
                if (!clearFlags) {
                    this.setShort((PreparedStatement)updateStmt, diskFlags);
                }
                this.setInt((PreparedStatement)updateStmt, diskID);
                this.executeUpdate((PreparedStatement)updateStmt);
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResComputer.class.getName(), (String)"setSpare", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        finally {
            try {
                if (selectStmt != null) {
                    selectStmt.close();
                }
                if (updateStmt != null) {
                    updateStmt.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sqle) {}
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResComputer.class.getName(), (String)"setSpare", (int)diskID);
        }
    }

    public void closeInsert() throws GeneralException {
        super.closeInsert();
        this.dskAccessor.closeSave();
    }

    public void closeDelete() throws GeneralException {
        super.closeDelete();
        this.dskAccessor.closeDelete();
    }
}

