/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.aperi.TStorm.common.EntityWWPN;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.table.TResLogicalDisk;

public class TResEntityWWPN
extends StorageRepositoryAccessor {
    private static final String INSERT = "insert into t_res_entity_wwpn (entity_id, entity_type, wwpn, swwpn) values (?,?,?,?)";
    private static final String DELETE_BY_ENTITY_ID = "delete from t_res_entity_wwpn where entity_id = ?";
    private static final String DELETE_BY_ENTITY_ID_AND_WWPN = "delete from t_res_entity_wwpn where entity_id = ? and wwpn = ?";
    private static final String DELETE_BY_ENTITY_ID_AND_TYPE = "delete from t_res_entity_wwpn where entity_id = ? and entity_type = ?";
    private static final String SELECT = "select entity_type, swwpn from t_res_entity_wwpn where entity_id = ?";
    private static final String SELECT_BY_ENTITY_ID = "select entity_id, entity_type, wwpn, swwpn from t_res_entity_wwpn where entity_id = ?";
    private static final String SELECT_ENTITY_ID_BY_WWPN = "select entity_id from t_res_entity_wwpn where entity_type = ? and swwpn = ?";

    public TResEntityWWPN(Connection dbc) {
        super(dbc);
        this.tableName = "t_res_entity_wwpn";
    }

    public void deleteByEntity_ID(int entityID) throws GeneralException {
        block4: {
            String delete = DELETE_BY_ENTITY_ID;
            this.deleteStmt = this.prepareStmt(delete);
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)TResEntityWWPN.class.getName(), (String)"deleteByEntity_ID", (String)"entityID");
            }
            try {
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setInt(this.deleteStmt, entityID);
                this.stmtPhase = 3;
                this.executeUpdate(this.deleteStmt);
            }
            catch (SQLException e) {
                this.stmtType = 3;
                this.sqlError(e);
                if (!TraceLogger.enableTrace) break block4;
                TraceLogger.exception((String)TResEntityWWPN.class.getName(), (String)"deleteByEntity_ID", (Throwable)e);
            }
        }
        this.commit();
        this.closeDelete();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResEntityWWPN.class.getName(), (String)"deleteByEntity_ID");
        }
    }

    public void insert(int entityID, byte entity_type, String wwpn) throws GeneralException {
        block6: {
            long work_wwpn = 0L;
            String news = wwpn != null && wwpn.length() > 32 ? new String(wwpn.substring(32)) : new String(wwpn);
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)TResLogicalDisk.class.getName(), (String)"insert", (String)"entityID, entity_type, wwpn");
            }
            try {
                work_wwpn = Long.parseLong(wwpn, 16);
            }
            catch (NumberFormatException e) {
                this.stmtType = 1;
            }
            try {
                this.insertStmt = this.prepareStmt(INSERT);
                this.setPhase();
                this.setInt(this.insertStmt, entityID);
                this.setByte(this.insertStmt, entity_type);
                this.setLong(this.insertStmt, work_wwpn);
                this.setString(this.insertStmt, news);
                this.executeUpdate(this.insertStmt);
            }
            catch (SQLException e) {
                this.stmtType = 1;
                this.sqlError(e);
                if (!TraceLogger.enableTrace) break block6;
                TraceLogger.exception((String)TResEntityWWPN.class.getName(), (String)"insert", (Throwable)e);
            }
        }
        this.closeInsert();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResEntityWWPN.class.getName(), (String)"insert");
        }
    }

    public EntityWWPN getEntityWWPNs(int entityID) throws GeneralException {
        EntityWWPN wwpnList = null;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResLogicalDisk.class.getName(), (String)"getEntityWWPNs", (String)"entityID");
        }
        try {
            this.selectStmt = this.prepareStmt(SELECT);
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, entityID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.nextResult()) {
                EntityWWPN wwpn = new EntityWWPN();
                wwpn.entityID = entityID;
                this.fetchEntityWWPN(wwpn, this.resultSet);
                wwpn.entityWWPNNext = wwpnList;
                wwpnList = wwpn;
            }
            this.closeResultSet();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResEntityWWPN.class.getName(), (String)"getEntityWWPNs", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        this.closeSelect();
        EntityWWPN traceResult = wwpnList;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResEntityWWPN.class.getName(), (String)"getEntityWWPNs", traceResult);
        }
        return traceResult;
    }

    public int fetchEntityWWPN(EntityWWPN wwpn, ResultSet rs) throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResLogicalDisk.class.getName(), (String)"fetchEntityWWPN", (String)"wwpn, rs");
        }
        this.colIndex = 1;
        wwpn.entity_type = this.getByte(rs);
        wwpn.sWWPN = this.getString(rs);
        int traceResult = this.colIndex;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResLogicalDisk.class.getName(), (String)"fetchEntityWWPN", (int)traceResult);
        }
        return traceResult;
    }

    public int getEntityIdByWWPN(byte entity_type, String swwpn) throws GeneralException {
        String news = swwpn != null && swwpn.length() > 32 ? new String(swwpn.substring(32)) : new String(swwpn);
        Object wwpnList = null;
        int entityID = -1;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResLogicalDisk.class.getName(), (String)"getEntityIdByWWPN", (String)"entityID");
        }
        try {
            this.selectStmt = this.prepareStmt(SELECT_ENTITY_ID_BY_WWPN);
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setByte(this.selectStmt, entity_type);
            this.setString(this.selectStmt, news);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.nextResult()) {
                this.colIndex = 1;
                entityID = this.getInt(this.resultSet);
            }
            this.closeResultSet();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResEntityWWPN.class.getName(), (String)"getEntityIdByWWPN", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        this.closeSelect();
        int traceResult = entityID;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResEntityWWPN.class.getName(), (String)"getEntityIdByWWPN", (int)traceResult);
        }
        return traceResult;
    }
}

