/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.aperi.TStorm.common.Controller;
import org.eclipse.aperi.TStorm.common.ExtAccess;
import org.eclipse.aperi.TStorm.common.Rank;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;

public class TResExtCtrlr
extends StorageRepositoryAccessor {
    private static final String FETCH = "select storext_id, controller_id from t_res_ext_ctrlr";
    private static final String BY_CONTROLLER = " where controller_id = ?";
    private static final String INSERT = "insert into t_res_ext_ctrlr (storext_id, controller_id) values (?,?)";
    private static final String DELETE_BY_CTRLR = "delete from t_res_ext_ctrlr where controller_id = ?";
    private static final String DELETE_BY_RANK = "delete from t_res_ext_ctrlr where storext_id = ?";
    private static final String DELETE_BY_KEY = "delete from t_res_ext_ctrlr where storext_id = ? and controller_id = ?";

    public TResExtCtrlr(Connection dbc) {
        super(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResExtCtrlr.class.getName(), (String)"TResExtCtrlr", (String)"dbc");
        }
        this.tableName = "t_res_ext_ctrlr";
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResExtCtrlr.class.getName(), (String)"TResExtCtrlr");
        }
    }

    public void prepSelectByCtlr() throws GeneralException {
        this.selectStmt = this.prepareStmt("select storext_id, controller_id from t_res_ext_ctrlr where controller_id = ?");
    }

    public ExtAccess getExtAccess(int id) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResExtCtrlr.class.getName(), (String)"getExtAccess", (String)"id");
        }
        ExtAccess eaList = null;
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, id);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.nextResult()) {
                this.colIndex = 1;
                ExtAccess ea = new ExtAccess();
                ea.eaRankID = this.getInt(this.resultSet);
                ea.eaControllerID = this.getInt(this.resultSet);
                ea.eaNextExtent = eaList;
                eaList = ea;
            }
            this.closeResultSet();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResExtCtrlr.class.getName(), (String)"getExtAccess", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        ExtAccess traceResult = eaList;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResExtCtrlr.class.getName(), (String)"getExtAccess", traceResult);
        }
        return traceResult;
    }

    public void deleteExtAccess(ExtAccess eaList) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResExtCtrlr.class.getName(), (String)"deleteExtAccess", (String)"eaList");
        }
        try {
            this.deleteStmt = this.prepareStmt(DELETE_BY_KEY);
            ExtAccess ea = eaList;
            while (ea != null) {
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setInt(this.deleteStmt, ea.eaRankID);
                this.setInt(this.deleteStmt, ea.eaControllerID);
                this.executeUpdate(this.deleteStmt);
                this.dbc.commit();
                ea = ea.eaNextExtent;
            }
            this.closeDelete();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResExtCtrlr.class.getName(), (String)"deleteExtAccess", (Throwable)e);
            }
            this.stmtType = 3;
            this.deleteError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResExtCtrlr.class.getName(), (String)"deleteExtAccess");
        }
    }

    public void deleteExtCtrlr(Controller ctlrList) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResExtCtrlr.class.getName(), (String)"deleteExtCtrlr", (String)"ctlrList");
        }
        try {
            this.deleteStmt = this.prepareStmt(DELETE_BY_CTRLR);
            Controller ctlr = ctlrList;
            while (ctlr != null) {
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setInt(this.deleteStmt, ctlr.ctlrID);
                this.executeUpdate(this.deleteStmt);
                this.dbc.commit();
                ctlr = ctlr.ctlrNext;
            }
            this.closeDelete();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResExtCtrlr.class.getName(), (String)"deleteExtCtrlr", (Throwable)e);
            }
            this.stmtType = 3;
            this.deleteError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResExtCtrlr.class.getName(), (String)"deleteExtCtrlr");
        }
    }

    public void deleteExtCtrlr(Rank rankList) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResExtCtrlr.class.getName(), (String)"deleteExtCtrlr", (String)"rankList");
        }
        try {
            this.deleteStmt = this.prepareStmt(DELETE_BY_RANK);
            Rank rank = rankList;
            while (rank != null) {
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setInt(this.deleteStmt, rank.rankID);
                this.executeUpdate(this.deleteStmt);
                this.dbc.commit();
                rank = rank.rankNext;
            }
            this.closeDelete();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResExtCtrlr.class.getName(), (String)"deleteExtCtrlr", (Throwable)e);
            }
            this.stmtType = 3;
            this.deleteError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResExtCtrlr.class.getName(), (String)"deleteExtCtrlr");
        }
    }

    public void prepInsert() throws GeneralException {
        this.insertStmt = this.prepareStmt(INSERT);
    }

    public void insertExtCtrlr(ExtAccess eaList) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResExtCtrlr.class.getName(), (String)"insertExtCtrlr", (String)"eaList");
        }
        boolean identifierCount = false;
        try {
            this.insertStmt = this.prepareStmt(INSERT);
            ExtAccess ea = eaList;
            while (ea != null) {
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setInt(this.insertStmt, ea.eaRankID);
                this.setInt(this.insertStmt, ea.eaControllerID);
                this.executeUpdate(this.insertStmt);
                this.dbc.commit();
                ea = ea.eaNextExtent;
            }
            this.closeInsert();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResExtCtrlr.class.getName(), (String)"insertExtCtrlr", (Throwable)e);
            }
            this.stmtType = 1;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResExtCtrlr.class.getName(), (String)"insertExtCtrlr");
        }
    }
}

