/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import org.eclipse.aperi.Nas.common.NasFiler;
import org.eclipse.aperi.TStorm.common.Filesystem;
import org.eclipse.aperi.TStorm.common.FsNameList;
import org.eclipse.aperi.TStorm.common.NasFilesystem;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.backend.LockManager;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Packer;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.NameListQueryable;
import org.eclipse.aperi.repository.QueryBySchedule;
import org.eclipse.aperi.repository.ResourceFilter;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.ScheduleQueryable;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.table.TAlertLog;
import org.eclipse.aperi.repository.table.TGroup2Res;
import org.eclipse.aperi.repository.table.TResAttr;
import org.eclipse.aperi.repository.table.TResComputer;
import org.eclipse.aperi.repository.table.TResPwd;
import org.eclipse.aperi.repository.table.TStatComputer;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.AgentManager;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.guireq.ResourceAttribute;
import org.eclipse.aperi.xmsg.LocalizableException;

public class TResFS
extends StorageRepositoryAccessor
implements NameListQueryable,
ScheduleQueryable {
    private Timestamp tsScan = new Timestamp(0L);
    private Timestamp tsCurr = new Timestamp(0L);
    public static final String[] dependentTables = new String[]{"t_stat_user", "t_stat_group", "t_stat_file_type", "t_stat_file", "t_stat_large_dir", "t_stat_time_dist", "t_stat_time_hist", "t_stat_summary", "t_stat_user_hist", "t_stat_group_hist", "t_stat_ftype_hist", "t_stat_space_hist", "t_stat_size_dist", "t_stat_directory", "t_stat_scan_spoor", "t_stat_fs_hist", "t_res_filesystem"};
    public static final int TABLES_WITH_STAT_ID = 13;
    private QueryBySchedule queryBySchedule;
    private long currentTime;
    PreparedStatement updateUseCountStmt;
    public static final String ID_COLUMN_NAME = "filesystem_id";
    private static final String SELECT = "select filesystem_id, mount_point, computer_id, group_id, log_disk_id, logical_disk_id, filesystem_type, use_count, physical_size, capacity, used_space, free_space, maxfiles, used_inodes, free_inodes, last_scan_time, scanning_comp_id, export_name, discovered_time from t_res_filesystem where ";
    private static final String BY_ID = "filesystem_id = ?";
    private static final String BY_LOGICAL_DISK = "logical_disk_id = ?";
    private static final String BY_COMPUTER = "computer_id = ?";
    private static final String SELECT_BY_MOUNT_POINT = "select f.computer_id, f.filesystem_id, f.group_id, f.logical_disk_id, f.use_count, f.capacity from t_res_filesystem f, t_res_share s where s.computer_id = ? and s.resource_type = 3 and s.resource_id = f.filesystem_id and f.mount_point = ? order by f.use_count";
    private static final String SELECT_AGENT_GROUP_FS = "select distinct f.filesystem_id, a.exclude, f.mount_point, f.computer_id, f.group_id, f.log_disk_id, f.logical_disk_id, f.filesystem_type, f.use_count, f.physical_size, f.capacity, f.used_space, f.free_space, f.maxfiles, f.used_inodes, f.free_inodes, f.last_scan_time, scanning_comp_id, export_name from t_res_filesystem f, t_res_attribute a, t_stat_computer c where a.attribute_id = ? and f.scanning_comp_id = ? and c.computer_id = f.computer_id and (f.filesystem_id = a.resource_id or f.group_id = a.resource_id or a.resource_id = c.computer_id or a.resource_id = c.group_id or a.resource_id = c.cluster_id or a.resource_type = " + Short.toString((short)13) + ") order by 1, 2 desc";
    private static final String SELECT_ID_BY_GROUP = "select filesystem_id from t_res_filesystem where group_id = ?";
    private static final String SELECT_ID_BY_COMPUTER = "select filesystem_id from t_res_filesystem where computer_id = ?";
    private static final String SELECT_NAMES = "select computer_id, mount_point, filesystem_id from t_res_filesystem";
    private static final String SELECT_EXTENDABLE = "select f.computer_id, f.mount_point, f.filesystem_id, f.capacity, f.free_space from t_res_filesystem f, t_res_logical_disk l, t_res_volgroup v where f.filesystem_type in (8,6) and f.logical_disk_id = l.logical_disk_id and l.volgroup_id = v.volgroup_id and v.volgroup_type in (0,1 ) order by 1 desc, 2 desc";
    private static final String IS_EXTENSIBLE = "select f.computer_id  from t_res_filesystem f, t_res_logical_disk l, t_res_volgroup v, t_res_host c where f.filesystem_type in (8,6) and (f.logical_disk_id = l.logical_disk_id) and (c.computer_id = f.computer_id) and l.volgroup_id = v.volgroup_id and v.volgroup_type in (0,1 ) and (c.host_url = ?) and (f.mount_point = ?)";
    private static final String SELECT_VISIBLE_NAMES = "select s.computer_id, f.mount_point, f.filesystem_id from t_res_filesystem f, t_res_share s where s.computer_id = ? and s.resource_type = 3 and s.resource_id = f.filesystem_id order by f.mount_point";
    private static final String JOIN_1 = "select f.computer_id, f.mount_point, f.filesystem_id, a.exclude from t_res_filesystem f, t_res_attribute a where a.attribute_id = ? and f.filesystem_id = a.resource_id";
    private static final String JOIN_1_ORDER_BY = " order by 1, 2";
    private static final String JOIN_2_PT_I = ", f.filesystem_id, a.exclude from t_res_filesystem f, t_res_attribute a, t_stat_computer c where f.computer_id = c.computer_id and a.attribute_id = ? and ";
    private static final String JOIN_2_PT_II;
    private static final String JOIN_3_PT_I = "select distinct a.attribute_id, f.filesystem_id, a.exclude from t_res_filesystem f, t_res_attribute a, t_stat_computer c where c.computer_id = f.computer_id and a.attribute_type = ?";
    private static final String JOIN_3_PT_II;
    public static final String SELECT_PARENT_IDS = "select distinct f.filesystem_id, gr.group_id from t_res_filesystem f, t_view_group2res gr where gr.res_type = 3 and f.filesystem_id = gr.resource_id union  select f.filesystem_id, f.computer_id from t_res_filesystem f union  select f.filesystem_id, c.domain_id from t_res_filesystem f, t_stat_computer c where f.computer_id = c.computer_id union select distinct f.filesystem_id, gr.group_id from t_res_filesystem f, t_view_group2res gr where f.computer_id = gr.resource_id order by 1";
    private static final String INSERT = "insert into t_res_filesystem (filesystem_type, physical_size, capacity, used_space, free_space, maxfiles, used_inodes, free_inodes, last_scan_time, mount_point, computer_id, filesystem_id, logical_disk_id, log_disk_id, group_id, use_count, discovered_time, file_count, directory_count, scanning_comp_id, export_name) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String SCAN_UPDATE = "update t_res_filesystem set filesystem_type = ?, physical_size = ?, capacity = ?, used_space = ?, free_space = ?, maxfiles = ?, used_inodes = ?, free_inodes = ?, last_scan_time = ?, file_count = ?, directory_count = ? where filesystem_id = ?";
    private static final String PROBE_UPDATE = "update t_res_filesystem set filesystem_type = ?, physical_size = ?, capacity = ?, used_space = ?, free_space = ?, maxfiles = ?, used_inodes = ?, free_inodes = ?, log_disk_id = ?, mount_point = ?";
    private static final String WHERE_FSID = " where filesystem_id = ?";
    private static final String UPDATE_USE_COUNT = "update t_res_filesystem set use_count = ? where filesystem_id = ?";
    private static final String UPDATE_LOGICAL_DISK = "update t_res_filesystem set logical_disk_id = ? where filesystem_id = ?";
    private static final String UPDATE_SCAN_COMPUTER = "update t_res_filesystem set computer_id = ?, scanning_comp_id = ? where filesystem_id = ?";
    private static final String RESET_SCAN_COMPUTER = "update t_res_filesystem set scanning_comp_id = 0 where scanning_comp_id = ? and computer_id <> scanning_comp_id";
    private static final String RESET_DISCOVERY_SCAN_COMPUTER = "update t_found_filesystem set scanning_comp_id = 0 where scanning_comp_id = ?";
    private static final String RESET_NAS_SCAN_COMPUTER = "update t_found_filesystem set scanning_comp_id = 0 where computer_id = ?";
    private static final String DELETE_BY_FS = "delete from t_res_filesystem where filesystem_id = ?";
    private static final String IN_FS_GROUP = " in (select resource_id from t_view_group2res where res_indicator in (1,2, 5) group_id = ";
    private static final String SELECT_NAS_FILESYSTEMS = "select computer_id, filesystem_id, mount_point, scanning_comp_id, export_name from t_res_filesystem where computer_id <> scanning_comp_id";
    private static final String UPDATE_SCANNING_AGENT = "update t_res_filesystem set scanning_comp_id = ? where filesystem_id = ?";
    private static final String SELECT_SCANNING_COMPID = "select scanning_comp_id from t_res_filesystem where filesystem_id = ?";

    public TResFS(Connection dbc) {
        super(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"TResFS", (String)"dbc");
        }
        try {
            this.currentTime = SQLUtil.getTimestamp(dbc).getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResFS.class.getName(), (String)"TResFS", (Throwable)e);
            }
            return;
        }
        this.tableName = "t_res_filesystem";
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"TResFS");
        }
    }

    public Filesystem getAgentScanFS(int computerID, int scheduleID, Response response) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"getAgentScanFS", (String)"computerID, scheduleID, response");
        }
        Filesystem fsList = null;
        Filesystem prev = null;
        int lastFilesystemID = -1;
        try {
            this.selectStmt = this.dbc.prepareStatement(SELECT_AGENT_GROUP_FS);
            this.colIndex = 1;
            this.setInt(this.selectStmt, scheduleID);
            this.setInt(this.selectStmt, computerID);
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.nextResult()) {
                this.colIndex = 1;
                int filesystemID = this.getInt(this.resultSet);
                if (filesystemID == lastFilesystemID) continue;
                lastFilesystemID = filesystemID;
                if (this.getBoolean(this.resultSet)) continue;
                Filesystem fs = new Filesystem();
                fs.fsID = filesystemID;
                this.fetchFS(fs, 3);
                if (prev != null) {
                    prev.fsNext = fs;
                } else {
                    fsList = fs;
                }
                prev = fs;
            }
            this.closeSelect();
            Filesystem traceResult = fsList = this.getNasFilers(computerID, fsList, response);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TResFS.class.getName(), (String)"getAgentScanFS", (Object)traceResult);
            }
            return traceResult;
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResFS.class.getName(), (String)"getAgentScanFS", (Throwable)e);
            }
            this.cleanup();
            Object[] args = new Object[]{String.valueOf(scheduleID)};
            String errorMsg = SQLUtil.getSQLExceptionMsg("STS0009E", e, args);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TResFS.class.getName(), (String)"getAgentScanFS");
            }
            throw new GeneralException(errorMsg);
        }
    }

    private void fetchFS(Filesystem fs, int startingColumn) throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"fetchFS", (String)"fs, startingColumn");
        }
        this.stmtPhase = 1;
        this.colIndex = startingColumn;
        if (startingColumn == 1) {
            fs.fsID = this.getInt(this.resultSet);
        }
        fs.fsMountPoint = this.getString(this.resultSet);
        fs.fsComputerID = this.getInt(this.resultSet);
        fs.fsGroupID = this.getInt(this.resultSet);
        fs.fsLogDiskID = this.getInt(this.resultSet);
        fs.fsLogicalDiskID = this.getInt(this.resultSet);
        fs.fsType = this.getShort(this.resultSet);
        fs.fsUseCount = this.getShort(this.resultSet);
        fs.fsPhysicalSize = this.getLong(this.resultSet);
        fs.fsCapacity = this.getLong(this.resultSet);
        fs.fsUsedSpace = this.getLong(this.resultSet);
        fs.fsFreeSpace = this.getLong(this.resultSet);
        fs.fsMaxFiles = this.getInt(this.resultSet);
        fs.fsUsedInodes = this.getInt(this.resultSet);
        fs.fsFreeInodes = this.getInt(this.resultSet);
        fs.fsScanTime = this.getTimestamp(this.resultSet);
        fs.fsScanningCompID = this.getInt(this.resultSet);
        fs.fsExportName = this.getString(this.resultSet);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"fetchFS");
        }
    }

    public Filesystem getNasFilers(int computerID, Filesystem fsList, Response response) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"getNasFilers", (String)"computerID, fsList, response");
        }
        HashMap<MutableInteger, NasFiler> nasMap = new HashMap<MutableInteger, NasFiler>();
        MutableInteger hashKey = new MutableInteger();
        TResComputer compAccessor = new TResComputer(this.dbc);
        compAccessor.prepGetNasFiler();
        Filesystem fs = fsList;
        while (fs != null) {
            block9: {
                NasFiler filer;
                block10: {
                    if (fs.fsComputerID == fs.fsScanningCompID) break block9;
                    hashKey.value = fs.fsComputerID;
                    filer = (NasFiler)nasMap.get(hashKey);
                    if (filer != null) break block10;
                    filer = compAccessor.getNasFiler(fs.fsComputerID);
                    if (filer == null) break block9;
                    nasMap.put(new MutableInteger(fs.fsComputerID), filer);
                }
                fs.fsNasFiler = filer;
            }
            fs = fs.fsNext;
        }
        compAccessor.closeSelect();
        if (nasMap.isEmpty()) {
            Filesystem traceResult = fsList;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TResFS.class.getName(), (String)"getNasFilers", (Object)traceResult);
            }
            return traceResult;
        }
        compAccessor = null;
        AgentManager.AgentAddress agent = Server.agentMgr.get(computerID);
        if (agent == null || Constants.isWindows((short)agent.osType)) {
            TResPwd pwdAccessor = new TResPwd(this.dbc);
            pwdAccessor.getFilerLogins(nasMap.values().iterator());
        }
        Filesystem traceResult = fsList;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"getNasFilers", (Object)traceResult);
        }
        return traceResult;
    }

    private Filesystem pruneNasFilesystems(Filesystem fsList) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"pruneNasFilesystems", (String)"fsList");
        }
        Filesystem prevFs = null;
        Filesystem currFs = fsList;
        while (currFs != null) {
            NasFiler filer = currFs.fsNasFiler;
            if (filer != null && !filer.nfManufacturer.equals("NOVELL")) {
                if (prevFs == null) {
                    fsList = currFs.fsNext;
                } else {
                    prevFs.fsNext = currFs.fsNext;
                }
            } else {
                prevFs = currFs;
            }
            currFs = currFs.fsNext;
        }
        Filesystem traceResult = fsList;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"pruneNasFilesystems", (Object)traceResult);
        }
        return traceResult;
    }

    public Filesystem getByComputerID(int computerID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"getByComputerID", (String)"computerID");
        }
        Filesystem fsList = null;
        this.selectStmt = this.prepareStmt("select filesystem_id, mount_point, computer_id, group_id, log_disk_id, logical_disk_id, filesystem_type, use_count, physical_size, capacity, used_space, free_space, maxfiles, used_inodes, free_inodes, last_scan_time, scanning_comp_id, export_name, discovered_time from t_res_filesystem where computer_id = ?");
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, computerID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            while (this.nextResult()) {
                Filesystem fs = new Filesystem();
                this.fetchFS(fs, 1);
                fs.fsNext = fsList;
                fsList = fs;
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResFS.class.getName(), (String)"getByComputerID", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        Filesystem traceResult = fsList;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"getByComputerID", traceResult);
        }
        return traceResult;
    }

    public void prepSelectByID() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"prepSelectByID", (String)"");
        }
        this.selectStmt = this.prepareStmt("select filesystem_id, mount_point, computer_id, group_id, log_disk_id, logical_disk_id, filesystem_type, use_count, physical_size, capacity, used_space, free_space, maxfiles, used_inodes, free_inodes, last_scan_time, scanning_comp_id, export_name, discovered_time from t_res_filesystem where filesystem_id = ?");
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"prepSelectByID");
        }
    }

    public Filesystem getByID(int fsID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"getByID", (String)"fsID");
        }
        Filesystem traceResult = this.singletonSelectByID(fsID);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"getByID", (Object)traceResult);
        }
        return traceResult;
    }

    private Filesystem singletonSelectByID(int identifier) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"singletonSelectByID", (String)"identifier");
        }
        Filesystem fs = null;
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, identifier);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            if (this.nextResult()) {
                fs = new Filesystem();
                this.fetchFS(fs, 1);
                fs.fsDiscoveredTime = this.getTimestamp(this.resultSet);
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResFS.class.getName(), (String)"singletonSelectByID", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        Filesystem traceResult = fs;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"singletonSelectByID", traceResult);
        }
        return traceResult;
    }

    public void prepSelectByLogicalDisk() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"prepSelectByLogicalDisk", (String)"");
        }
        this.selectStmt = this.prepareStmt("select filesystem_id, mount_point, computer_id, group_id, log_disk_id, logical_disk_id, filesystem_type, use_count, physical_size, capacity, used_space, free_space, maxfiles, used_inodes, free_inodes, last_scan_time, scanning_comp_id, export_name, discovered_time from t_res_filesystem where logical_disk_id = ?");
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"prepSelectByLogicalDisk");
        }
    }

    public Filesystem getByLogicalDisk(int lDiskID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"getByLogicalDisk", (String)"lDiskID");
        }
        Filesystem traceResult = this.singletonSelectByID(lDiskID);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"getByLogicalDisk", (Object)traceResult);
        }
        return traceResult;
    }

    public void prepSelectByMountPoint() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"prepSelectByMountPoint", (String)"");
        }
        this.selectStmt = this.prepareStmt(SELECT_BY_MOUNT_POINT);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"prepSelectByMountPoint");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getByMountPoint(Filesystem fs) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"getByMountPoint", (String)"fs");
        }
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, fs.fsComputerID);
            this.setString(this.selectStmt, fs.fsMountPoint);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            if (!this.nextResult()) {
                boolean traceResult = false;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)TResFS.class.getName(), (String)"getByMountPoint", (boolean)traceResult);
                }
                boolean bl = traceResult;
                return bl;
            }
            this.stmtPhase = 1;
            this.colIndex = 1;
            fs.fsComputerID = this.getInt(this.resultSet);
            fs.fsID = this.getInt(this.resultSet);
            fs.fsGroupID = this.getInt(this.resultSet);
            fs.fsLogicalDiskID = this.getInt(this.resultSet);
            fs.fsUseCount = this.getShort(this.resultSet);
            fs.fsCapacity = this.getLong(this.resultSet);
            boolean traceResult = true;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TResFS.class.getName(), (String)"getByMountPoint", (boolean)traceResult);
            }
            boolean bl = traceResult;
            return bl;
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResFS.class.getName(), (String)"getByMountPoint", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        finally {
            this.closeResultSet();
        }
        boolean traceResult = false;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"getByMountPoint", (boolean)traceResult);
        }
        return traceResult;
    }

    public void prepSelectIDByGroup() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"prepSelectIDByGroup", (String)"");
        }
        this.selectStmt = this.prepareStmt(SELECT_ID_BY_GROUP);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"prepSelectIDByGroup");
        }
    }

    public void prepSelectIDByComputer() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"prepSelectIDByComputer", (String)"");
        }
        this.selectStmt = this.prepareStmt(SELECT_ID_BY_COMPUTER);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"prepSelectIDByComputer");
        }
    }

    public NameList selectVisibleNames(int computerID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"selectVisibleNames", (String)"computerID");
        }
        NameList traceResult = this.nameListQuery(SELECT_VISIBLE_NAMES, computerID, false, null);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"selectVisibleNames", (Object)traceResult);
        }
        return traceResult;
    }

    private NameList nameListQuery(String sqlText, int ID, boolean hasExclude, ResourceFilter filter) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"nameListQuery", (String)"sqlText, ID, hasExclude, filter");
        }
        NameList head = null;
        NameList prev = null;
        this.selectStmt = this.prepareStmt(sqlText);
        try {
            if (ID != -1) {
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setInt(this.selectStmt, ID);
            }
            NameList fetchBuffer = new NameList();
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.nextResult()) {
                this.colIndex = 1;
                fetchBuffer.nlID2 = this.getInt(this.resultSet);
                fetchBuffer.nlName = this.getString(this.resultSet);
                fetchBuffer.nlID = this.getInt(this.resultSet);
                if (hasExclude && this.getBoolean(this.resultSet)) {
                    fetchBuffer.nlState = 1;
                }
                fetchBuffer.nlInfo = (short)3;
                if (filter != null && !filter.accept(fetchBuffer)) continue;
                NameList element = (NameList)fetchBuffer.clone();
                if (prev == null) {
                    head = element;
                } else {
                    prev.nlNext = element;
                }
                prev = element;
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResFS.class.getName(), (String)"nameListQuery", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        this.closeSelect();
        NameList traceResult = head;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"nameListQuery", traceResult);
        }
        return traceResult;
    }

    public NameList selectNames(GuiListReq requestData) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"selectNames", (String)"requestData");
        }
        StringBuffer buffer = new StringBuffer(128);
        String orderBy = " order by computer_id, mount_point";
        int groupID = requestData.groupID;
        int computerID = requestData.computerID;
        buffer.append(SELECT_NAMES);
        if (groupID != -1) {
            buffer.append(" where group_id = ?");
        } else if (computerID > 0) {
            buffer.append(" where computer_id = ?");
            groupID = computerID;
        }
        ResourceFilter filter = null;
        buffer.append(orderBy);
        NameList traceResult = this.nameListQuery(buffer.toString(), groupID, false, filter);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"selectNames", (Object)traceResult);
        }
        return traceResult;
    }

    public NameList queryDependents(int parentID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"queryDependents", (String)"parentID");
        }
        NameList traceResult = this.nameListQuery("select f.computer_id, f.mount_point, f.filesystem_id, a.exclude from t_res_filesystem f, t_res_attribute a where a.attribute_id = ? and f.filesystem_id = a.resource_id order by 1, 2", parentID, true, null);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"queryDependents", (Object)traceResult);
        }
        return traceResult;
    }

    public NameList queryDependents(int computerID, int parentID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"queryDependents", (String)"computerID, parentID");
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(JOIN_1);
        buffer.append(" and computer_id = ");
        buffer.append(computerID);
        buffer.append(JOIN_1_ORDER_BY);
        NameList traceResult = this.nameListQuery(buffer.toString(), parentID, false, null);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"queryDependents", (Object)traceResult);
        }
        return traceResult;
    }

    public FsNameList queryExtendable() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"queryExtendable", (String)"");
        }
        FsNameList list = null;
        int prevComputerID = -1;
        boolean extendable = false;
        AgentManager am = Server.getAgentManager();
        this.selectStmt = this.prepareStmt(SELECT_EXTENDABLE);
        try {
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.nextResult()) {
                this.colIndex = 1;
                int computerID = this.getInt(this.resultSet);
                if (computerID != prevComputerID) {
                    prevComputerID = computerID;
                    extendable = this.isOsExtendable(am.getAgentOsType(computerID));
                }
                if (!extendable) continue;
                FsNameList fetchBuffer = new FsNameList();
                fetchBuffer.nlID2 = computerID;
                fetchBuffer.nlName = this.getString(this.resultSet);
                fetchBuffer.nlID = this.getInt(this.resultSet);
                fetchBuffer.fsCapacity = this.getLong(this.resultSet);
                fetchBuffer.fsFreespace = this.getLong(this.resultSet);
                fetchBuffer.nlNext = list;
                list = fetchBuffer;
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResFS.class.getName(), (String)"queryExtendable", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        this.closeSelect();
        FsNameList traceResult = list;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"queryExtendable", traceResult);
        }
        return traceResult;
    }

    private boolean isOsExtendable(short osType) {
        boolean traceResult;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"isOsExtendable", (String)"osType");
        }
        boolean bl = traceResult = osType == 2 || osType == 6;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"isOsExtendable", (boolean)traceResult);
        }
        return traceResult;
    }

    public void initQueryBySchedule(int scheduleID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"initQueryBySchedule", (String)"scheduleID");
        }
        this.initQueryBySchedule(scheduleID, true);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"initQueryBySchedule");
        }
    }

    public void initQueryBySchedule(int scheduleID, boolean scanningCompID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"initQueryBySchedule", (String)"scheduleID, scanningCompID");
        }
        StringBuffer select = new StringBuffer(256);
        String computerIDColumn = scanningCompID ? "f.scanning_comp_id" : "f.computer_id";
        select.append("select distinct ");
        select.append(computerIDColumn);
        select.append(JOIN_2_PT_I);
        select.append(computerIDColumn);
        select.append(" > 0");
        select.append(JOIN_2_PT_II);
        this.queryBySchedule = new QueryBySchedule(this);
        this.queryBySchedule.init(select.toString(), scheduleID);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"initQueryBySchedule");
        }
    }

    public void initQueryByAttrType(short attributeType) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"initQueryByAttrType", (String)"attributeType");
        }
        this.initQueryByAttrType(attributeType, null, null);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"initQueryByAttrType");
        }
    }

    public void initQueryByAttrType(short attributeType, Filesystem fsList) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"initQueryByAttrType", (String)"attributeType, fsList");
        }
        this.initQueryByAttrType(attributeType, fsList, null);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"initQueryByAttrType");
        }
    }

    public void initQueryByAttrType(short attributeType, Filesystem fsList, ResourceFilter filter) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"initQueryByAttrType", (String)"attributeType, fsList, filter");
        }
        StringBuffer buf = new StringBuffer(500);
        buf.append(JOIN_3_PT_I);
        if (fsList != null) {
            buf.append(" and f.filesystem_id in (");
            while (fsList != null) {
                buf.append(Integer.toString(fsList.fsID));
                buf.append(',');
                fsList = fsList.fsNext;
            }
            buf.setCharAt(buf.length() - 1, ')');
        }
        buf.append(JOIN_3_PT_II);
        this.selectStmt = this.prepareStmt(buf.toString());
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setShort(this.selectStmt, attributeType);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResFS.class.getName(), (String)"initQueryByAttrType", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        this.stmtPhase = 1;
        this.queryBySchedule = new QueryBySchedule(this, filter);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"initQueryByAttrType");
        }
    }

    public boolean fetchQueryBySchedule(NameList element) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"fetchQueryBySchedule", (String)"element");
        }
        boolean traceResult = this.queryBySchedule.fetch(element);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"fetchQueryBySchedule", (boolean)traceResult);
        }
        return traceResult;
    }

    public void prepSelectParentIDs(String sqlText) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"prepSelectParentIDs", (String)"sqlText");
        }
        this.prepSelectForParentIDs(sqlText);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"prepSelectParentIDs");
        }
    }

    public int[] prepSelectCompGroupIDs(String sqlText) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"prepSelectCompGroupIDs", (String)"sqlText");
        }
        this.prepSelectForParentIDs(sqlText);
        int[] traceResult = new int[2];
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"prepSelectCompGroupIDs", (Object)traceResult);
        }
        return traceResult;
    }

    private void prepSelectForParentIDs(String sqlText) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"prepSelectForParentIDs", (String)"sqlText");
        }
        this.selectStmt = this.prepareStmt(sqlText);
        try {
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResFS.class.getName(), (String)"prepSelectForParentIDs", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        this.stmtPhase = 1;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"prepSelectForParentIDs");
        }
    }

    public boolean selectParentIDs(int[] fetchBuffer) throws GeneralException {
        boolean status;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"selectParentIDs", (String)"fetchBuffer");
        }
        if (status = this.nextResult()) {
            try {
                this.colIndex = 1;
                for (int i = 0; i < fetchBuffer.length; ++i) {
                    fetchBuffer[i] = this.getInt(this.resultSet);
                }
            }
            catch (SQLException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)TResFS.class.getName(), (String)"selectParentIDs", (Throwable)e);
                }
                this.stmtType = 0;
                this.sqlError(e);
            }
        }
        boolean traceResult = status;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"selectParentIDs", (boolean)traceResult);
        }
        return traceResult;
    }

    public void prepInsert() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"prepInsert", (String)"");
        }
        this.insertStmt = this.prepareStmt(INSERT);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"prepInsert");
        }
    }

    public void insert(Filesystem fs) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"insert", (String)"fs");
        }
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setStatistics(this.insertStmt, fs);
            this.setTimestamp(this.insertStmt, fs);
            this.setString(this.insertStmt, fs.fsMountPoint);
            this.setInt(this.insertStmt, fs.fsComputerID);
            this.setInt(this.insertStmt, fs.fsID);
            this.setInt(this.insertStmt, fs.fsLogicalDiskID);
            this.setInt(this.insertStmt, fs.fsLogDiskID);
            this.setInt(this.insertStmt, fs.fsGroupID);
            this.setInt(this.insertStmt, fs.fsUseCount);
            this.setTimestamp(this.insertStmt, this.currentTime, this.tsCurr);
            this.setInt(this.insertStmt, -1);
            this.setInt(this.insertStmt, -1);
            this.setInt(this.insertStmt, fs.fsScanningCompID);
            this.setString(this.insertStmt, fs.fsExportName);
            this.executeUpdate(this.insertStmt);
            TGroup2Res grp2ResAccessor = new TGroup2Res(this.dbc);
            grp2ResAccessor.insertNewResources(fs.fsID, fs.fsGroupID, fs.fsMountPoint, false);
            grp2ResAccessor = null;
            this.dbc.commit();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResFS.class.getName(), (String)"insert", (Throwable)e);
            }
            this.stmtType = 1;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"insert");
        }
    }

    private void setStatistics(PreparedStatement stmt, Filesystem fs) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"setStatistics", (String)"stmt, fs");
        }
        this.setShort(stmt, fs.fsType);
        if (fs.fsType == 18 || fs.fsType == 19) {
            fs.fsPhysicalSize = -1L;
            fs.fsCapacity = -1L;
            fs.fsUsedSpace = -1L;
            fs.fsFreeSpace = -1L;
            fs.fsMaxFiles = -1;
            fs.fsUsedInodes = -1;
            fs.fsFreeInodes = -1;
        }
        this.setLong(stmt, fs.fsPhysicalSize);
        this.setLong(stmt, fs.fsCapacity);
        this.setLong(stmt, fs.fsUsedSpace);
        this.setLong(stmt, fs.fsFreeSpace);
        this.setInt(stmt, fs.fsMaxFiles);
        this.setInt(stmt, fs.fsUsedInodes);
        this.setInt(stmt, fs.fsFreeInodes);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"setStatistics");
        }
    }

    private void setTimestamp(PreparedStatement stmt, Filesystem fs) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"setTimestamp", (String)"stmt, fs");
        }
        this.setTimestamp(stmt, fs.fsScanTime, this.tsScan);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"setTimestamp");
        }
    }

    public void prepScanUpdate() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"prepScanUpdate", (String)"");
        }
        this.updateStmt = this.prepareStmt(SCAN_UPDATE);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"prepScanUpdate");
        }
    }

    public void scanUpdate(Filesystem fs) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"scanUpdate", (String)"fs");
        }
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setStatistics(this.updateStmt, fs);
            this.setTimestamp(this.updateStmt, fs);
            this.setInt(this.updateStmt, fs.fsFileCount);
            this.setInt(this.updateStmt, fs.fsDirectoryCount);
            this.setInt(this.updateStmt, fs.fsID);
            this.executeUpdate(this.updateStmt);
            this.dbc.commit();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResFS.class.getName(), (String)"scanUpdate", (Throwable)e);
            }
            this.stmtType = 2;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"scanUpdate");
        }
    }

    public void prepProbeUpdate(boolean setExportName) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"prepProbeUpdate", (String)"setExportName");
        }
        StringBuffer buffer = new StringBuffer(128);
        buffer.append(PROBE_UPDATE);
        if (setExportName) {
            buffer.append(", export_name = ?");
        }
        buffer.append(WHERE_FSID);
        this.updateStmt = this.prepareStmt(buffer.toString());
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"prepProbeUpdate");
        }
    }

    public boolean probeUpdate(Filesystem fs) throws GeneralException {
        boolean traceResult;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"probeUpdate", (String)"fs");
        }
        int rowsUpdated = 0;
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setStatistics(this.updateStmt, fs);
            this.setInt(this.updateStmt, fs.fsLogDiskID);
            this.setString(this.updateStmt, fs.fsMountPoint);
            if (fs.fsExportName != null) {
                this.setString(this.updateStmt, fs.fsExportName);
            }
            this.setInt(this.updateStmt, fs.fsID);
            rowsUpdated = this.executeUpdate(this.updateStmt);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResFS.class.getName(), (String)"probeUpdate", (Throwable)e);
            }
            this.stmtType = 2;
            this.sqlError(e);
        }
        boolean bl = traceResult = rowsUpdated > 0;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"probeUpdate", (boolean)traceResult);
        }
        return traceResult;
    }

    public void prepUpdateUseCount() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"prepUpdateUseCount", (String)"");
        }
        this.updateUseCountStmt = this.prepareStmt(UPDATE_USE_COUNT);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"prepUpdateUseCount");
        }
    }

    public void updateUseCount(Filesystem fs) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"updateUseCount", (String)"fs");
        }
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setShort(this.updateUseCountStmt, fs.fsUseCount);
            this.setInt(this.updateUseCountStmt, fs.fsID);
            this.executeUpdate(this.updateUseCountStmt);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResFS.class.getName(), (String)"updateUseCount", (Throwable)e);
            }
            this.stmtType = 2;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"updateUseCount");
        }
    }

    public void prepUpdateLogicalDisk() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"prepUpdateLogicalDisk", (String)"");
        }
        this.updateStmt = this.prepareStmt(UPDATE_LOGICAL_DISK);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"prepUpdateLogicalDisk");
        }
    }

    public void updateLogicalDisk(Filesystem fs) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"updateLogicalDisk", (String)"fs");
        }
        this.updateIdentifier(fs, new int[]{fs.fsLogicalDiskID});
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"updateLogicalDisk");
        }
    }

    private void updateIdentifier(Filesystem fs, int[] newIdentifiers) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"updateIdentifier", (String)"fs, newIdentifiers");
        }
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            for (int i = 0; i < newIdentifiers.length; ++i) {
                this.setInt(this.updateStmt, newIdentifiers[0]);
            }
            if (fs != null) {
                this.setInt(this.updateStmt, fs.fsID);
            }
            this.executeUpdate(this.updateStmt);
            this.dbc.commit();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResFS.class.getName(), (String)"updateIdentifier", (Throwable)e);
            }
            this.stmtType = 2;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"updateIdentifier");
        }
    }

    public void prepUpdateScanComputer() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"prepUpdateScanComputer", (String)"");
        }
        this.updateStmt = this.prepareStmt(UPDATE_SCAN_COMPUTER);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"prepUpdateScanComputer");
        }
    }

    public void updateScanComputer(Filesystem fs) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"updateScanComputer", (String)"fs");
        }
        this.updateIdentifier(fs, new int[]{fs.fsComputerID, fs.fsComputerID});
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"updateScanComputer");
        }
    }

    public void resetScanComputer(int computerID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"resetScanComputer", (String)"computerID");
        }
        int[] args = new int[]{computerID};
        this.updateStmt = this.prepareStmt(RESET_SCAN_COMPUTER);
        this.updateIdentifier(null, args);
        this.closeUpdate();
        this.updateStmt = this.prepareStmt(RESET_DISCOVERY_SCAN_COMPUTER);
        this.updateIdentifier(null, args);
        this.closeUpdate();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"resetScanComputer");
        }
    }

    public void resetNasScanComputer(int computerID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"resetNasScanComputer", (String)"computerID");
        }
        int[] args = new int[]{computerID};
        this.updateStmt = this.prepareStmt(RESET_NAS_SCAN_COMPUTER);
        this.updateIdentifier(null, args);
        this.closeUpdate();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"resetNasScanComputer");
        }
    }

    public void updateScanComputer(int hostCID, int scanCID, int filesystemID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"updateScanComputer", (String)"hostCID, scanCID, filesystemID");
        }
        try {
            this.setPhase();
            this.setInt(this.updateStmt, hostCID);
            this.setInt(this.updateStmt, scanCID);
            this.setInt(this.updateStmt, filesystemID);
            this.executeUpdate(this.updateStmt);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResFS.class.getName(), (String)"updateScanComputer", (Throwable)e);
            }
            this.stmtType = 2;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"updateScanComputer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFS(Filesystem fsList, boolean removeAll) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"deleteFS", (String)"fsList, removeAll");
        }
        StringBuffer buf = new StringBuffer();
        buf.append(" WHERE filesystem_id IN (");
        boolean notFirst = false;
        Filesystem fs = fsList;
        while (fs != null) {
            if (notFirst) {
                buf.append(',');
            }
            notFirst = true;
            buf.append(Integer.toString(fs.fsID));
            fs = fs.fsNext;
        }
        buf.append(')');
        LockManager.lock((short)0, (String)"GLOBAL", (String)"DELETE", (byte)2, (boolean)true);
        try {
            if (removeAll) {
                TAlertLog alertDeleter = new TAlertLog(this.dbc);
                fs = fsList;
                while (fs != null) {
                    alertDeleter.deleteByFilesystem(fs.fsID);
                    fs = fs.fsNext;
                }
                TResAttr attrAccessor = new TResAttr(this.dbc);
                ResourceAttribute res = new ResourceAttribute();
                attrAccessor.prepDelete();
                fs = fsList;
                while (fs != null) {
                    res.raResourceID = fs.fsID;
                    res.raResourceType = (short)3;
                    attrAccessor.delete(res);
                    fs = fs.fsNext;
                }
                attrAccessor.closeDelete();
                attrAccessor = null;
            }
            int numberTables = dependentTables.length;
            if (!removeAll) {
                numberTables -= 2;
            }
            TGroup2Res grp2ResAccessor = new TGroup2Res(this.dbc);
            fs = fsList;
            while (fs != null) {
                grp2ResAccessor.deleteResource(fs.fsID, false);
                fs = fs.fsNext;
            }
            grp2ResAccessor.commit();
            grp2ResAccessor = null;
        }
        finally {
            LockManager.unLock((short)0, (String)"GLOBAL", (String)"DELETE");
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"deleteFS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeUpdate() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"closeUpdate", (String)"");
        }
        super.closeUpdate();
        if (this.updateUseCountStmt != null) {
            try {
                this.closeStmt(this.updateUseCountStmt, STMT_TYPE[2]);
            }
            finally {
                this.updateUseCountStmt = null;
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"closeUpdate");
        }
    }

    public static void appendInClause(StringBuffer buffer, String fsColName, String groupColName, GuiReportReq grr, boolean appendAnd) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"appendInClause", (String)"buffer, fsColName, groupColName, grr, appendAnd");
        }
        if (grr.idSubtype == 11) {
            if (appendAnd) {
                buffer.append(" and");
            }
            if (groupColName == null) {
                buffer.append(' ');
                buffer.append(fsColName);
                buffer.append(IN_FS_GROUP);
                buffer.append(grr.grrID1);
                buffer.append(')');
            } else {
                buffer.append(' ');
                buffer.append(groupColName);
                buffer.append(" = ");
                buffer.append(grr.grrID1);
            }
        } else {
            SQLUtil.appendInClause(buffer, fsColName, grr.selectedResources, grr.isResourceInList, appendAnd);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"appendInClause");
        }
    }

    public void prepUpdateScanAgent() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"prepUpdateScanAgent", (String)"");
        }
        this.updateStmt = this.prepareStmt(UPDATE_SCANNING_AGENT);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"prepUpdateScanAgent");
        }
    }

    public void updateScanningAgent(NasFilesystem fsList) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"updateScanningAgent", (String)"fsList");
        }
        try {
            NasFilesystem nfs = fsList;
            while (nfs != null) {
                this.setPhase();
                this.setInt(this.updateStmt, nfs.nflAgentID);
                this.setInt(this.updateStmt, nfs.nflFsID);
                this.executeUpdate(this.updateStmt);
                nfs = nfs.nflNext;
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResFS.class.getName(), (String)"updateScanningAgent", (Throwable)e);
            }
            this.stmtType = 2;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"updateScanningAgent");
        }
    }

    public NasFilesystem[] getNasFilesystems() throws GeneralException {
        NasFilesystem node;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"getNasFilesystems", (String)"");
        }
        NasFilesystem head = null;
        NasFilesystem prev = null;
        try {
            this.staticStmt = this.createStatement();
            this.resultSet = this.staticStmt.executeQuery(SELECT_NAS_FILESYSTEMS);
            this.stmtPhase = 1;
            while (this.nextResult()) {
                node = new NasFilesystem();
                this.colIndex = 1;
                node.nflComputerID = this.getInt(this.resultSet);
                node.nflFsID = this.getInt(this.resultSet);
                node.nflFsName = this.getString(this.resultSet);
                node.nflAgentID = this.getInt(this.resultSet);
                String exportName = this.getString(this.resultSet);
                node.nflSeenFromWindows = !Util.isEmpty((String)exportName);
                if (prev != null) {
                    prev.nflNext = node;
                } else {
                    head = node;
                }
                prev = node;
            }
            this.closeStaticStmt();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResFS.class.getName(), (String)"getNasFilesystems", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        NameList computer = new TStatComputer(this.dbc).selectComputersAndDomains();
        while (computer != null) {
            node = head;
            while (node != null) {
                if (node.nflComputerID == computer.nlID) {
                    node.nflDomainName = computer.nlName;
                }
                node = node.nflNext;
            }
            computer = computer.nlNext;
        }
        NasFilesystem[] traceResult = (NasFilesystem[])Packer.pack(head);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"getNasFilesystems", (Object)traceResult);
        }
        return traceResult;
    }

    public void prepSelectScanningCompID() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"prepSelectScanningCompID", (String)"");
        }
        this.selectStmt = this.prepareStmt(SELECT_SCANNING_COMPID);
        this.stmtType = 0;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"prepSelectScanningCompID");
        }
    }

    public int selectScanningCompID(int filesystemID) throws GeneralException, LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"selectScanningCompID", (String)"filesystemID");
        }
        int result = -1;
        boolean rowFound = false;
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setInt(this.selectStmt, filesystemID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            if (this.nextResult()) {
                this.stmtPhase = 1;
                this.colIndex = 1;
                result = this.getInt(this.resultSet);
                rowFound = true;
            }
            this.closeResultSet();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResFS.class.getName(), (String)"selectScanningCompID", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        if (!rowFound) {
            Object[] args = new Object[]{"Filesystem", new Integer(filesystemID)};
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TResFS.class.getName(), (String)"selectScanningCompID");
            }
            throw new LocalizableException("STS0092E", args);
        }
        int traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"selectScanningCompID", (int)traceResult);
        }
        return traceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExtensible(String host, String fs) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFS.class.getName(), (String)"isExtensible", (String)"host, fs");
        }
        boolean isExtensible = false;
        try {
            this.selectStmt = this.prepareStmt(IS_EXTENSIBLE);
            this.setPhase();
            this.setString(this.selectStmt, host);
            this.setString(this.selectStmt, fs);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            if (this.nextResult()) {
                isExtensible = true;
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResFS.class.getName(), (String)"isExtensible", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        finally {
            this.closeResultSet();
            this.closeSelect();
        }
        boolean traceResult = isExtensible;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFS.class.getName(), (String)"isExtensible", (boolean)traceResult);
        }
        return traceResult;
    }

    static {
        JOIN_3_PT_II = JOIN_2_PT_II = " and ((a.resource_type = " + Short.toString((short)3) + "  and f.filesystem_id = a.resource_id) or" + " (a.resource_type = " + Short.toString((short)2) + "  and f.group_id = a.resource_id) or " + " (a.resource_type = " + Short.toString((short)1) + "  and f.computer_id = a.resource_id) or" + " (a.resource_type = " + Short.toString((short)0) + "  and c.group_id = a.resource_id) or" + " (a.resource_type = " + Short.toString((short)99) + "  and a.resource_id = c.cluster_id)  or a.resource_type = " + Short.toString((short)13) + ") order by 1, 2, 3 desc";
    }
}

