/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.SQLException;
import java.util.Hashtable;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.objects.Attribute;
import org.eclipse.aperi.infrastructure.database.objects.Fabric;
import org.eclipse.aperi.infrastructure.database.sql.SqlAttributeFabric;
import org.eclipse.aperi.infrastructure.database.tables.TResFabricTable;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.NameListQueryable;
import org.eclipse.aperi.xmsg.MessageLog;

public class TResFabric
implements NameListQueryable {
    public static String FABRIC_NAMES = "SELECT CASE WHEN (Fabric.DISPLAY_NAME <> '' AND Fabric.DISPLAY_NAME is not null) THEN Fabric.DISPLAY_NAME WHEN (Fabric.SAN_WWN <> '' AND Fabric.SAN_WWN is not null) THEN RTRIM(Fabric.SAN_WWN) ELSE RTRIM(Fabric.FABRIC_WWN)END AS LABEL, FABRIC_ID FROM T_RES_FABRIC Fabric";
    public static String FabricByScheduleID = " SELECT DISTINCT fab.fabric_id, attr.exclude, fab.fabric_wwn  FROM \tt_res_attribute  attr, t_res_fabric fab  WHERE  attr.attribute_id= ? AND  (attr.resource_id = fab.fabric_id or   attr.resource_id = fab.group_id  or  attr.resource_type = 115)";

    private DBConnection getConnection() throws GeneralException {
        DBConnection dbConn;
        block6: {
            dbConn = null;
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)TResFabric.class.getName(), (String)"getConnection", (String)"");
            }
            try {
                DBConnPoolDataSource ds = DBConnPoolDataSource.getInstance();
                dbConn = (DBConnection)ds.getPooledConnection();
            }
            catch (SQLException sqlEx) {
                MessageLog.logException((String)"STS0920E", (Exception)sqlEx);
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)TResFabric.class.getName(), (String)"getConnection", (Object)sqlEx);
                }
                throw new GeneralException(sqlEx.getMessage());
            }
            catch (NullPointerException nullEx) {
                MessageLog.logException((String)"STS0920E", (Exception)nullEx);
                if (!TraceLogger.enableTrace) break block6;
                TraceLogger.exit((String)TResFabric.class.getName(), (String)"getConnection", (Object)nullEx);
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFabric.class.getName(), (String)"getConnection");
        }
        return dbConn;
    }

    public NameList getFabricList() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFabric.class.getName(), (String)"getFabricList", (String)"");
        }
        DBConnection connection = this.getConnection();
        DBResultSet rs = null;
        NameList list = null;
        try {
            rs = ComplexQuery.sqlQuery((DBConnection)connection, (String)FABRIC_NAMES, null);
            NameList item = new NameList();
            if (rs != null) {
                while (rs.next()) {
                    item = new NameList();
                    item.nlName = rs.getString(1);
                    item.nlID = rs.getInt(2);
                    item.nlInfo = (short)114;
                    item.nlNext = list;
                    list = item;
                }
            }
        }
        catch (SQLException eDB) {
            MessageLog.logException((String)"STS0922E", (Exception)eDB);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TResFabric.class.getName(), (String)"getFabricList", (Object)eDB);
            }
            throw new GeneralException(eDB.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.getStatement().close();
                }
                if (connection != null) {
                    connection.commit();
                    connection.close();
                }
            }
            catch (SQLException sqlEx) {
                MessageLog.logException((String)"STS0921E", (Exception)sqlEx);
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)TResFabric.class.getName(), (String)"getFabricList", (Object)sqlEx);
                }
                throw new GeneralException(sqlEx.getMessage());
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFabric.class.getName(), (String)"getFabricList", list);
        }
        return list;
    }

    public NameList getFabricTiedTo(int scheduleID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFabric.class.getName(), (String)"getFabricTiedTo", (String)"");
        }
        DBConnection connection = null;
        DBResultSet rs = null;
        Object list = null;
        NameList head = null;
        try {
            connection = this.getConnection();
            Hashtable<ColumnInfo, String> whereClasue = new Hashtable<ColumnInfo, String>();
            whereClasue.put(Attribute.getColumnInfo((String)"ATTRIBUTE_ID"), Integer.toString(scheduleID));
            rs = ComplexQuery.sqlQuery((DBConnection)connection, (String)FabricByScheduleID, whereClasue);
            NameList item = null;
            while (rs.next()) {
                int fabricID = rs.getInt(1);
                boolean excluded = rs.getBoolean(2);
                String wwnName = rs.getString(3);
                if (excluded) continue;
                item = new NameList();
                item.nlID = fabricID;
                item.nlName = wwnName;
                item.nlInfo = (short)114;
                item.nlID2 = 0;
                item.nlNext = head;
                head = item;
            }
        }
        catch (SQLException eDB) {
            MessageLog.logException((String)"STS0923E", (Exception)eDB);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TResFabric.class.getName(), (String)"getFabricTiedTo", (Object)eDB);
            }
            throw new GeneralException(eDB.toString());
        }
        finally {
            try {
                if (rs != null) {
                    rs.getStatement().close();
                }
                if (connection != null) {
                    connection.commit();
                    connection.close();
                }
            }
            catch (SQLException e) {
                throw new GeneralException(e.toString());
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFabric.class.getName(), (String)"getFabricTiedTo", (Object)"");
        }
        return head;
    }

    public NameList selectNames(GuiListReq req) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFabric.class.getName(), (String)"selectNames", (String)"req");
        }
        DBConnection connection = null;
        Fabric.FabricCursor cursor = null;
        Hashtable<ColumnInfo, String> htWhereClause = new Hashtable<ColumnInfo, String>();
        NameList list = null;
        try {
            Fabric fab = null;
            NameList item = null;
            String sanWWN = null;
            connection = this.getConnection();
            htWhereClause.put(TResFabricTable.getColumnInfo((String)"GROUP_ID"), Integer.toString(req.groupID));
            cursor = Fabric.getCursor((DBConnection)connection, htWhereClause, null);
            while (cursor.next()) {
                fab = cursor.getAttributes();
                item = new NameList();
                item.nlName = fab.getFabricWwn();
                item.nlID = fab.getFabricId();
                item.nlInfo = (short)114;
                item.nlName2 = fab.getDisplayName();
                sanWWN = fab.getSanWwn();
                item.nlNext = list;
                list = item;
            }
        }
        catch (SQLException eDB) {
            MessageLog.logException((String)"STS0924E", (Exception)eDB);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TResFabric.class.getName(), (String)"selectNames", (Object)eDB);
            }
            throw new GeneralException(eDB.getMessage());
        }
        finally {
            try {
                if (cursor != null) {
                    cursor.close();
                }
                if (connection != null) {
                    connection.commit();
                    connection.close();
                }
            }
            catch (SQLException sqlEx) {
                MessageLog.logException((String)"STS0921E", (Exception)sqlEx);
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)TResFabric.class.getName(), (String)"selectNames", (Object)sqlEx);
                }
                throw new GeneralException(sqlEx.getMessage());
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFabric.class.getName(), (String)"selectNames", list);
        }
        return list;
    }

    public NameList queryDependents(int attributeID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResFabric.class.getName(), (String)"queryDependents", (String)"attributeID");
        }
        DBConnection connection = null;
        NameList list = null;
        DBResultSet dbr = null;
        NameList item = null;
        Hashtable<ColumnInfo, String> parms = new Hashtable<ColumnInfo, String>();
        parms.put(Attribute.getColumnInfo((String)"ATTRIBUTE_ID"), Integer.toString(attributeID));
        try {
            connection = this.getConnection();
            dbr = SqlAttributeFabric.sqlQuery((DBConnection)connection, (int)SqlAttributeFabric.allFabricDependentsQueryIndex, parms);
            while (dbr.next()) {
                item = new NameList();
                item.nlID = dbr.getInt(1);
                item.nlName = dbr.getString(2);
                if (dbr.getBoolean(3)) {
                    item.nlState = 1;
                }
                item.nlInfo = (short)114;
                item.nlNext = list;
                list = item;
            }
        }
        catch (SQLException eDB) {
            MessageLog.logException((String)"STS0925E", (Exception)eDB);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TResFabric.class.getName(), (String)"queryDependents");
            }
            throw new GeneralException(eDB.getMessage());
        }
        finally {
            try {
                if (dbr != null) {
                    dbr.getStatement().close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sqlEx) {
                MessageLog.logException((String)"STS0921E", (Exception)sqlEx);
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)TResFabric.class.getName(), (String)"queryDependants", (Object)sqlEx);
                }
                throw new GeneralException(sqlEx.getMessage());
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResFabric.class.getName(), (String)"queryDependents", list);
        }
        return list;
    }
}

