/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.SQLException;
import java.util.Hashtable;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBPreparedStatement;
import org.eclipse.aperi.infrastructure.database.objects.IpAddresses;
import org.eclipse.aperi.infrastructure.database.tables.TResIpAddressesTable;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.NameListQueryable;
import org.eclipse.aperi.repository.table.TResFabric;
import org.eclipse.aperi.xmsg.MessageLog;

public class TResIpAddresses
implements NameListQueryable {
    public NameList getIPAddressList(int type) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResIpAddresses.class.getName(), (String)"getIPAddressList", (String)"type");
        }
        DBConnection connection = null;
        try {
            DBConnPoolDataSource ds = DBConnPoolDataSource.getInstance();
            connection = (DBConnection)ds.getPooledConnection();
        }
        catch (SQLException eDB) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TResIpAddresses.class.getName(), (String)"TResIpAddresses");
            }
            MessageLog.logException((String)"STS0920E", (Exception)eDB);
            throw new GeneralException(eDB.getMessage());
        }
        IpAddresses.IpAddressesCursor cursor = null;
        Hashtable<ColumnInfo, String> htWhereClause = new Hashtable<ColumnInfo, String>();
        NameList list = null;
        IpAddresses ip = null;
        NameList item = null;
        try {
            htWhereClause.put(TResIpAddressesTable.getColumnInfo((String)"OBJECT_TYPE"), Integer.toString(type));
            cursor = IpAddresses.getCursor((DBConnection)connection, htWhereClause, null);
            while (cursor.next()) {
                ip = cursor.getAttributes();
                item = new NameList();
                item.nlName = ip.getIpAddress();
                item.nlID = ip.getObjectId();
                item.nlInfo = (short)114;
                item.nlNext = list;
                list = item;
            }
        }
        catch (SQLException eDB) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TResIpAddresses.class.getName(), (String)"getIPAddressList");
            }
            MessageLog.logException((String)"STS0926E", (Exception)eDB, (Object)new Integer(type));
            throw new GeneralException(eDB.getMessage());
        }
        try {
            cursor.close();
            connection.close();
        }
        catch (SQLException eDB) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TResIpAddresses.class.getName(), (String)"selectNames");
            }
            MessageLog.logException((String)"STS0921E", (Exception)eDB);
            throw new GeneralException(eDB.getMessage());
        }
        return list;
    }

    public NameList selectNames(GuiListReq req) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResIpAddresses.class.getName(), (String)"selectNames", (String)"req");
        }
        DBConnection connection = null;
        try {
            DBConnPoolDataSource ds = DBConnPoolDataSource.getInstance();
            connection = (DBConnection)ds.getPooledConnection();
        }
        catch (SQLException eDB) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TResIpAddresses.class.getName(), (String)"selectNames");
            }
            MessageLog.logException((String)"STS0920E", (Exception)eDB);
            throw new GeneralException(eDB.getMessage());
        }
        IpAddresses.IpAddressesCursor cursor = null;
        Hashtable<ColumnInfo, String> htWhereClause = new Hashtable<ColumnInfo, String>();
        NameList list = null;
        IpAddresses ip = null;
        NameList item = null;
        try {
            htWhereClause.put(TResIpAddressesTable.getColumnInfo((String)"OBJECT_TYPE"), Integer.toString(req.listRequested));
            cursor = IpAddresses.getCursor((DBConnection)connection, htWhereClause, null);
            while (cursor.next()) {
                ip = cursor.getAttributes();
                item = new NameList();
                item.nlName = ip.getIpAddress();
                item.nlID = ip.getObjectId();
                item.nlNext = list;
                list = item;
            }
        }
        catch (SQLException eDB) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TResIpAddresses.class.getName(), (String)"selectNames");
            }
            MessageLog.logException((String)"STS0926E", (Exception)eDB, (Object)new Integer(req.listRequested));
            throw new GeneralException(eDB.getMessage());
        }
        try {
            cursor.close();
            connection.close();
        }
        catch (SQLException eDB) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TResIpAddresses.class.getName(), (String)"selectNames");
            }
            MessageLog.logException((String)"STS0921E", (Exception)eDB);
            throw new GeneralException(eDB.getMessage());
        }
        return list;
    }

    public boolean update(NameList manualDaData, int type) throws GeneralException {
        DBConnection connection = null;
        DBPreparedStatement pStmt = null;
        boolean status = false;
        boolean roleID = false;
        GeneralException ex = null;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResIpAddresses.class.getName(), (String)"update");
        }
        try {
            DBConnPoolDataSource ds = DBConnPoolDataSource.getInstance();
            connection = (DBConnection)ds.getPooledConnection();
            IpAddresses dbHelper = new IpAddresses();
            NameList curr = manualDaData;
            String delStr = "delete from t_res_ip_addresses where object_type = ?";
            pStmt = connection.prepareStatement(delStr);
            pStmt.setShort(1, (short)type);
            pStmt.executeUpdate();
            while (curr != null) {
                dbHelper.setObjectId(curr.getID());
                dbHelper.setObjectType((short)type);
                dbHelper.setIpAddress(curr.nlName);
                if (!dbHelper.insert(connection)) {
                    ex = new GeneralException("STS0927E");
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit((String)TResIpAddresses.class.getName(), (String)"update", (Object)((Object)ex));
                    }
                    throw ex;
                }
                curr = curr.nlNext;
            }
            connection.commit();
            status = true;
        }
        catch (SQLException eDB) {
            try {
                if (connection != null) {
                    connection.rollback();
                }
            }
            catch (SQLException ex1) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)TResIpAddresses.class.getName(), (String)"update");
                }
                MessageLog.logException((String)"STS0928E", (Exception)ex1);
            }
            throw new GeneralException(eDB.getMessage());
        }
        catch (NullPointerException dbEx) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TResIpAddresses.class.getName(), (String)"update");
            }
            MessageLog.logException((String)"STS0928E", (Exception)dbEx);
            ex = new GeneralException("STS0928E");
            throw ex;
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sqlEx) {
                MessageLog.logException((String)"STS0921E", (Exception)sqlEx);
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)TResFabric.class.getName(), (String)"update", (Object)sqlEx);
                }
                throw new GeneralException(sqlEx.getMessage());
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResIpAddresses.class.getName(), (String)"update");
        }
        return status;
    }
}

