/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.common.CreateHeader;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.LinkedInteger;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.ScheduleHeader;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.CreatorNameListProxy;
import org.eclipse.aperi.repository.CreatorNameQueryable;
import org.eclipse.aperi.repository.EditableObjectProxy;
import org.eclipse.aperi.repository.RepositoryAccessor;

public class TSchedule
extends RepositoryAccessor
implements CreatorNameQueryable {
    public static String ID_COLUMN_NAME = "schedule_id";
    private static final String COLUMNS = "enabled,          schedule_type,    start_year,     start_month, start_day,        start_hour,       start_minute,   repeat_type, interval_type,    interval_number,  run_sunday,     run_monday,  run_tuesday,      run_wednesday,    run_thursday,   run_friday,  run_saturday,     timezone_type,    global_type,    timezone,    arguments,        alert_id,         job_type_id,    high_run_number, computer_id,      job_type";
    private static final String SELECT_BY_ID = "select creator, name, job_type_id from t_schedule where schedule_id = ?";
    private static final String SELECT_BY_JOB_TYPE = "select schedule_id from t_schedule where job_type_id = ";

    public TSchedule(Connection dbc) {
        super(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TSchedule.class.getName(), (String)"TSchedule", (String)"dbc");
        }
        this.tableName = "t_schedule";
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TSchedule.class.getName(), (String)"TSchedule");
        }
    }

    public void retrieve(ScheduleHeader schedule, String jobType) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TSchedule.class.getName(), (String)"retrieve", (String)"schedule, jobType");
        }
        EditableObjectProxy proxy = new EditableObjectProxy(this, (CreateHeader)schedule, jobType);
        proxy.initSelect(COLUMNS);
        try {
            schedule.enabled = this.getBoolean(this.resultSet);
            schedule.scheduleType = this.getByte(this.resultSet);
            schedule.startYear = this.getShort(this.resultSet);
            schedule.startMonth = this.getShort(this.resultSet);
            schedule.startDay = this.getShort(this.resultSet);
            schedule.startHour = this.getShort(this.resultSet);
            schedule.startMinute = this.getShort(this.resultSet);
            schedule.repeatType = this.getByte(this.resultSet);
            schedule.intervalType = this.getByte(this.resultSet);
            schedule.intervalNumber = this.getShort(this.resultSet);
            schedule.runSunday = this.getByte(this.resultSet);
            schedule.runMonday = this.getByte(this.resultSet);
            schedule.runTuesday = this.getByte(this.resultSet);
            schedule.runWednesday = this.getByte(this.resultSet);
            schedule.runThursday = this.getByte(this.resultSet);
            schedule.runFriday = this.getByte(this.resultSet);
            schedule.runSaturday = this.getByte(this.resultSet);
            schedule.timezoneType = this.getByte(this.resultSet);
            schedule.globalType = this.getByte(this.resultSet);
            schedule.timezone = this.getString(this.resultSet);
            schedule.arguments = this.getString(this.resultSet);
            schedule.alertID = this.getInt(this.resultSet);
            schedule.jobType = this.getShort(this.resultSet);
            schedule.highRunNumber = this.getInt(this.resultSet);
            schedule.computerID = this.getInt(this.resultSet);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TSchedule.class.getName(), (String)"retrieve", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        this.closeSelect();
        int length = schedule.timezone.length();
        if (length == 0 || length == 1 && schedule.timezone.charAt(0) == ' ') {
            schedule.timezone = null;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TSchedule.class.getName(), (String)"retrieve");
        }
    }

    public void deleteByID(int scheduleID, String jobType) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TSchedule.class.getName(), (String)"deleteByID", (String)"scheduleID, jobType");
        }
        this.deleteByID(scheduleID, jobType, false);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TSchedule.class.getName(), (String)"deleteByID");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteByID(int scheduleID, String jobType, boolean deleteHistory) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TSchedule.class.getName(), (String)"deleteByID", (String)"scheduleID, jobType, deleteHistory");
        }
        EditableObjectProxy proxy = new EditableObjectProxy(this, null, jobType);
        if (deleteHistory) {
            try {
                this.tableName = "t_run_jobs";
                proxy.deleteByID(scheduleID, this.getIDColumnName());
                this.tableName = "t_runs";
                proxy.deleteByID(scheduleID, this.getIDColumnName());
            }
            finally {
                this.tableName = "t_schedule";
            }
        }
        proxy.deleteByID(scheduleID, this.getIDColumnName());
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TSchedule.class.getName(), (String)"deleteByID");
        }
    }

    public void insert(ScheduleHeader schedule, String jobType) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TSchedule.class.getName(), (String)"insert", (String)"schedule, jobType");
        }
        EditableObjectProxy proxy = new EditableObjectProxy(this, (CreateHeader)schedule, jobType);
        proxy.initInsert(COLUMNS);
        try {
            this.setBoolean(this.insertStmt, schedule.enabled);
            this.setByte(this.insertStmt, schedule.scheduleType);
            this.setShort(this.insertStmt, schedule.startYear);
            this.setShort(this.insertStmt, schedule.startMonth);
            this.setShort(this.insertStmt, schedule.startDay);
            this.setShort(this.insertStmt, schedule.startHour);
            this.setShort(this.insertStmt, schedule.startMinute);
            this.setByte(this.insertStmt, schedule.repeatType);
            this.setByte(this.insertStmt, schedule.intervalType);
            this.setShort(this.insertStmt, schedule.intervalNumber);
            this.setByte(this.insertStmt, schedule.runSunday);
            this.setByte(this.insertStmt, schedule.runMonday);
            this.setByte(this.insertStmt, schedule.runTuesday);
            this.setByte(this.insertStmt, schedule.runWednesday);
            this.setByte(this.insertStmt, schedule.runThursday);
            this.setByte(this.insertStmt, schedule.runFriday);
            this.setByte(this.insertStmt, schedule.runSaturday);
            this.setByte(this.insertStmt, schedule.timezoneType);
            this.setByte(this.insertStmt, schedule.globalType);
            this.setString(this.insertStmt, schedule.timezone);
            this.setString(this.insertStmt, schedule.arguments);
            this.setInt(this.insertStmt, schedule.alertID);
            this.setShort(this.insertStmt, schedule.jobType);
            this.setInt(this.insertStmt, schedule.highRunNumber);
            this.setInt(this.insertStmt, schedule.computerID);
            this.setString(this.insertStmt, "-");
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TSchedule.class.getName(), (String)"insert", (Throwable)e);
            }
            this.sqlError(e);
        }
        proxy.finishInsert();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TSchedule.class.getName(), (String)"insert");
        }
    }

    public NameList selectNames(GuiListReq requestData) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TSchedule.class.getName(), (String)"selectNames", (String)"requestData");
        }
        CreatorNameListProxy proxy = new CreatorNameListProxy(this, requestData);
        NameList traceResult = proxy.select();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TSchedule.class.getName(), (String)"selectNames", (Object)traceResult);
        }
        return traceResult;
    }

    public String getIDColumnName() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TSchedule.class.getName(), (String)"getIDColumnName", (String)"");
        }
        String traceResult = ID_COLUMN_NAME;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TSchedule.class.getName(), (String)"getIDColumnName", (Object)traceResult);
        }
        return traceResult;
    }

    public void appendWhereClause(GuiListReq requestData, StringBuffer buf) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TSchedule.class.getName(), (String)"appendWhereClause", (String)"requestData, buf");
        }
        buf.append(" WHERE job_type_id = ");
        buf.append(requestData.listRequested);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TSchedule.class.getName(), (String)"appendWhereClause");
        }
    }

    public void addQualifiers(GuiListReq requestData, NameList element) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TSchedule.class.getName(), (String)"addQualifiers", (String)"requestData, element");
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TSchedule.class.getName(), (String)"addQualifiers");
        }
    }

    public void prepareSelectByID() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TSchedule.class.getName(), (String)"prepareSelectByID", (String)"");
        }
        this.selectStmt = this.prepareStmt(SELECT_BY_ID);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TSchedule.class.getName(), (String)"prepareSelectByID");
        }
    }

    public void selectByID(int scheduleID, NameList obj) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TSchedule.class.getName(), (String)"selectByID", (String)"scheduleID, obj");
        }
        obj.nlName = null;
        obj.nlInfo = (short)-1;
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setInt(this.selectStmt, scheduleID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            if (this.nextResult()) {
                this.stmtPhase = 1;
                this.colIndex = 1;
                StringBuffer buf = new StringBuffer(100);
                buf.append(this.getString(this.resultSet));
                buf.append('.');
                buf.append(this.getString(this.resultSet));
                obj.nlName = buf.toString();
                obj.nlInfo = this.getShort(this.resultSet);
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TSchedule.class.getName(), (String)"selectByID", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        this.closeResultSet();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TSchedule.class.getName(), (String)"selectByID");
        }
    }

    public void commitInsert() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TSchedule.class.getName(), (String)"commitInsert", (String)"");
        }
        this.commit();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TSchedule.class.getName(), (String)"commitInsert");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedInteger getSchedulesByJobType(short jobType) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)this.getClass().getName(), (String)"getSchedulesByJobType", (String)"jobType");
        }
        LinkedInteger schedule_ids = null;
        try {
            this.staticStmt = this.createStatement();
            this.resultSet = this.staticStmt.executeQuery(SELECT_BY_JOB_TYPE + jobType);
            while (this.nextResult()) {
                this.getPhase();
                LinkedInteger node = new LinkedInteger();
                node.value = this.getInt(this.resultSet);
                node.next = schedule_ids;
                schedule_ids = node;
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)this.getClass().getName(), (String)"getSchedulesForProduct", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        finally {
            try {
                this.resultSet.close();
            }
            catch (SQLException sQLException) {}
            this.closeStaticStmt();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)this.getClass().getName(), (String)"getSchedulesByJobType", schedule_ids);
        }
        return schedule_ids;
    }
}

