/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;

public class TSnmpCommunity
extends RepositoryAccessor {
    private static final String SELECT = "select community_id, snmp_community from t_snmp_community";
    private static final String INSERT = "insert into t_snmp_community (community_id, snmp_community) values (?,?)";
    private static final String DELETE = "delete from t_snmp_community where community_id = ?";

    public TSnmpCommunity(Connection dbc) {
        super(dbc);
        this.tableName = "t_snmp_community";
    }

    public NameList getCommunities() throws GeneralException {
        NameList listHead = null;
        this.selectStmt = this.prepareStmt(SELECT);
        try {
            this.resultSet = this.selectStmt.executeQuery();
            while (this.nextResult()) {
                NameList node = new NameList();
                this.getPhase();
                node.nlID = this.getInt(this.resultSet);
                node.nlName = this.getString(this.resultSet);
                node.nlNext = listHead;
                listHead = node;
            }
            this.closeResultSet();
        }
        catch (SQLException e) {
            this.stmtType = 0;
            this.sqlError(e);
        }
        this.closeSelect();
        return listHead;
    }

    public void insert(NameList rows, boolean doCommit) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TSnmpCommunity.class.getName(), (String)"insert", (String)"rows, doCommit");
        }
        int i = 0;
        NameList row = rows;
        while (row != null) {
            ++i;
            row = row.nlNext;
        }
        i = StorageRepositoryAccessor.getIdentifier(1, i, this.dbc);
        this.insertStmt = this.prepareStmt(INSERT);
        row = rows;
        while (row != null) {
            row.nlID = i++;
            this.stmtPhase = 0;
            this.colIndex = 1;
            try {
                this.setInt(this.insertStmt, row.nlID);
                this.setString(this.insertStmt, row.nlName);
                this.executeUpdate(this.insertStmt);
            }
            catch (SQLException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)TSnmpCommunity.class.getName(), (String)"insert", (Throwable)e);
                }
                this.stmtType = 1;
                this.sqlError(e);
            }
            row = row.nlNext;
        }
        if (doCommit) {
            this.commit();
        }
        this.closeInsert();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TSnmpCommunity.class.getName(), (String)"insert");
        }
    }

    public void delete(Iterator iterator) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TSnmpCommunity.class.getName(), (String)"delete", (String)"iterator");
        }
        this.deleteStmt = this.prepareStmt(DELETE);
        while (iterator.hasNext()) {
            NameList row = (NameList)iterator.next();
            this.stmtPhase = 0;
            this.colIndex = 1;
            try {
                this.setInt(this.deleteStmt, row.nlID);
                this.executeUpdate(this.deleteStmt);
            }
            catch (SQLException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)TSnmpCommunity.class.getName(), (String)"delete", (Throwable)e);
                }
                this.stmtType = 3;
                this.sqlError(e);
            }
        }
        this.commit();
        this.closeDelete();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TSnmpCommunity.class.getName(), (String)"delete");
        }
    }
}

