/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.GregorianCalendar;
import org.eclipse.aperi.TStorm.common.PingHist;
import org.eclipse.aperi.TStorm.common.Settings;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.table.TStormSettings;

public class TStatPingHist
extends StorageRepositoryAccessor {
    private Timestamp tsStart = new Timestamp(0L);
    private Timestamp tsEnd = new Timestamp(0L);
    Settings settings;
    PingHist accumulator;
    GregorianCalendar calendar;
    Date currentTime;
    private static final String SELECT_UNIQUE_ACCUMULATOR = "select computer_id, statistic_type, monitor_start, monitor_end, transmitted, received, damaged, min_transit_time, max_transit_time, avg_transit_time from t_stat_ping_hist where computer_id = ? and statistic_type = ?";
    private static final String SELECT_ACCUMULATOR = "select computer_id, statistic_type, monitor_start, monitor_end, transmitted, received, damaged, min_transit_time, max_transit_time, avg_transit_time from t_stat_ping_hist where statistic_type = ?";
    private static final String INSERT = "insert into t_stat_ping_hist (computer_id, statistic_type, monitor_start, monitor_end, transmitted, received, damaged, min_transit_time, max_transit_time, avg_transit_time) values (?,?,?,?,?,?,?,?,?,?)";
    private static final String UPDATE_ACCUMULATOR = "update t_stat_ping_hist set monitor_start = ?, monitor_end = ?, transmitted = ?, received = ?, damaged = ?, min_transit_time = ?, max_transit_time = ?, avg_transit_time = ? where computer_id = ? and statistic_type = ?";
    private static final String AGE_OFF_HIST = "delete from t_stat_ping_hist where monitor_end < ? and computer_id = ? and statistic_type = ?";

    public TStatPingHist(Connection dbc) {
        super(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatPingHist.class.getName(), (String)"TStatPingHist", (String)"dbc");
        }
        this.tableName = "t_stat_ping_hist";
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatPingHist.class.getName(), (String)"TStatPingHist");
        }
    }

    public void prepSave() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatPingHist.class.getName(), (String)"prepSave", (String)"");
        }
        if (this.accumulator == null) {
            this.accumulator = new PingHist();
        }
        if (this.calendar == null) {
            this.calendar = new GregorianCalendar();
            this.currentTime = new Date();
        }
        TStormSettings seAccessor = new TStormSettings(this.dbc);
        this.settings = seAccessor.getSettings();
        seAccessor.closeSelect();
        this.insertStmt = this.prepareStmt(INSERT);
        this.updateStmt = this.prepareStmt(UPDATE_ACCUMULATOR);
        this.selectStmt = this.prepareStmt(SELECT_UNIQUE_ACCUMULATOR);
        this.deleteStmt = this.prepareStmt(AGE_OFF_HIST);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatPingHist.class.getName(), (String)"prepSave");
        }
    }

    public void closeSave() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatPingHist.class.getName(), (String)"closeSave", (String)"");
        }
        this.closeInsert();
        this.closeUpdate();
        this.closeSelect();
        this.closeDelete();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatPingHist.class.getName(), (String)"closeSave");
        }
    }

    public void save(PingHist pingHist) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatPingHist.class.getName(), (String)"save", (String)"pingHist");
        }
        if (pingHist.pngTransmitted > 0) {
            if (this.settings.sePingDailyHist > 0) {
                pingHist.pngStatisticType = 0;
                long totalTransitTime = pingHist.pngAvgTransitTime;
                if (pingHist.pngReceived > 0) {
                    pingHist.pngAvgTransitTime /= (long)pingHist.pngReceived;
                }
                this.insert(pingHist);
                pingHist.pngAvgTransitTime = totalTransitTime;
            }
            if (this.settings.sePingWeeklyHist > 0) {
                pingHist.pngStatisticType = (byte)3;
                this.updateAccumulator(pingHist);
            }
            if (this.settings.sePingMonthlyHist > 0) {
                pingHist.pngStatisticType = (byte)4;
                this.updateAccumulator(pingHist);
            }
            this.commit();
        }
        this.ageHist(pingHist);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatPingHist.class.getName(), (String)"save");
        }
    }

    public void insert(PingHist pingHist) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatPingHist.class.getName(), (String)"insert", (String)"pingHist");
        }
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setKey(pingHist, this.insertStmt);
            this.setStats(pingHist, this.insertStmt);
            this.executeUpdate(this.insertStmt);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatPingHist.class.getName(), (String)"insert", (Throwable)e);
            }
            this.stmtType = 1;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatPingHist.class.getName(), (String)"insert");
        }
    }

    private void setStats(PingHist pingHist, PreparedStatement stmt) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatPingHist.class.getName(), (String)"setStats", (String)"pingHist, stmt");
        }
        this.setTimestamp(stmt, pingHist.pngMonitorStart, this.tsStart);
        this.setTimestamp(stmt, pingHist.pngMonitorEnd, this.tsEnd);
        this.setInt(stmt, pingHist.pngTransmitted);
        this.setInt(stmt, pingHist.pngReceived);
        this.setInt(stmt, pingHist.pngDamaged);
        this.setInt(stmt, pingHist.pngMinTransitTime);
        this.setInt(stmt, pingHist.pngMaxTransitTime);
        this.setLong(stmt, pingHist.pngAvgTransitTime);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatPingHist.class.getName(), (String)"setStats");
        }
    }

    private void updateAccumulator(PingHist pingHist) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatPingHist.class.getName(), (String)"updateAccumulator", (String)"pingHist");
        }
        boolean gotAccumulator = false;
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setKey(pingHist, this.selectStmt);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            gotAccumulator = this.fetch(this.accumulator);
            this.closeResultSet(this.resultSet);
            if (gotAccumulator) {
                this.accumulator.pngTransmitted += pingHist.pngTransmitted;
                this.accumulator.pngReceived += pingHist.pngReceived;
                this.accumulator.pngDamaged += pingHist.pngDamaged;
                this.accumulator.pngAvgTransitTime += pingHist.pngAvgTransitTime;
                if (this.accumulator.pngMinTransitTime > pingHist.pngMinTransitTime) {
                    this.accumulator.pngMinTransitTime = pingHist.pngMinTransitTime;
                }
                if (this.accumulator.pngMaxTransitTime < pingHist.pngMaxTransitTime) {
                    this.accumulator.pngMaxTransitTime = pingHist.pngMaxTransitTime;
                }
                if (this.accumulator.pngMonitorStart <= 86400000L) {
                    this.accumulator.pngMonitorStart = pingHist.pngMonitorStart;
                }
                this.accumulator.pngMonitorEnd = pingHist.pngMonitorEnd;
                this.update(this.accumulator);
            } else {
                this.insert(pingHist);
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatPingHist.class.getName(), (String)"updateAccumulator", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatPingHist.class.getName(), (String)"updateAccumulator");
        }
    }

    private void setKey(PingHist pingHist, PreparedStatement stmt) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatPingHist.class.getName(), (String)"setKey", (String)"pingHist, stmt");
        }
        this.setInt(stmt, pingHist.pngComputerID);
        this.setByte(stmt, pingHist.pngStatisticType);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatPingHist.class.getName(), (String)"setKey");
        }
    }

    public void update(PingHist accumulator) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatPingHist.class.getName(), (String)"update", (String)"accumulator");
        }
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setStats(accumulator, this.updateStmt);
            this.setKey(accumulator, this.updateStmt);
            this.executeUpdate(this.updateStmt);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatPingHist.class.getName(), (String)"update", (Throwable)e);
            }
            this.stmtType = 2;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatPingHist.class.getName(), (String)"update");
        }
    }

    public boolean fetch(PingHist pingHist) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatPingHist.class.getName(), (String)"fetch", (String)"pingHist");
        }
        try {
            if (this.nextResult(this.resultSet)) {
                this.stmtPhase = 1;
                this.colIndex = 1;
                pingHist.pngComputerID = this.getInt(this.resultSet);
                pingHist.pngStatisticType = this.getByte(this.resultSet);
                pingHist.pngMonitorStart = this.getTimestamp(this.resultSet);
                pingHist.pngMonitorEnd = this.getTimestamp(this.resultSet);
                pingHist.pngTransmitted = this.getInt(this.resultSet);
                pingHist.pngReceived = this.getInt(this.resultSet);
                pingHist.pngDamaged = this.getInt(this.resultSet);
                pingHist.pngMinTransitTime = this.getInt(this.resultSet);
                pingHist.pngMaxTransitTime = this.getInt(this.resultSet);
                pingHist.pngAvgTransitTime = this.getLong(this.resultSet);
                boolean traceResult = true;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)TStatPingHist.class.getName(), (String)"fetch", (boolean)traceResult);
                }
                return traceResult;
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatPingHist.class.getName(), (String)"fetch", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        boolean traceResult = false;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatPingHist.class.getName(), (String)"fetch", (boolean)traceResult);
        }
        return traceResult;
    }

    private void ageHist(PingHist pingHist) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatPingHist.class.getName(), (String)"ageHist", (String)"pingHist");
        }
        this.currentTime.setTime(pingHist.pngMonitorEnd);
        try {
            if (this.settings.sePingDailyHist != 0) {
                pingHist.pngStatisticType = 0;
                this.ageOff(pingHist, this.settings.sePingDailyHist, 5);
            }
            if (this.settings.sePingWeeklyHist != 0) {
                pingHist.pngStatisticType = 1;
                this.ageOff(pingHist, this.settings.sePingWeeklyHist * 7, 5);
            }
            if (this.settings.sePingMonthlyHist != 0) {
                pingHist.pngStatisticType = (byte)2;
                this.ageOff(pingHist, this.settings.sePingMonthlyHist, 2);
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatPingHist.class.getName(), (String)"ageHist", (Throwable)e);
            }
            this.stmtType = 3;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatPingHist.class.getName(), (String)"ageHist");
        }
    }

    private void ageOff(PingHist pingHist, int retention, int calendarUnit) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatPingHist.class.getName(), (String)"ageOff", (String)"pingHist, retention, calendarUnit");
        }
        this.stmtPhase = 0;
        this.colIndex = 1;
        this.calendar.setTime(this.currentTime);
        this.calendar.add(calendarUnit, -retention);
        this.setTimestamp(this.deleteStmt, this.calendar.getTime().getTime());
        this.setKey(pingHist, this.deleteStmt);
        this.executeUpdate(this.deleteStmt);
        this.dbc.commit();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatPingHist.class.getName(), (String)"ageOff");
        }
    }

    public void prepAverages(byte statisticType) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatPingHist.class.getName(), (String)"prepAverages", (String)"statisticType");
        }
        this.insertStmt = this.prepareStmt(INSERT);
        this.updateStmt = this.prepareStmt(UPDATE_ACCUMULATOR);
        this.selectStmt = this.prepareStmt(SELECT_ACCUMULATOR);
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setByte(this.selectStmt, statisticType);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatPingHist.class.getName(), (String)"prepAverages", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatPingHist.class.getName(), (String)"prepAverages");
        }
    }

    public void closeAverages() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatPingHist.class.getName(), (String)"closeAverages", (String)"");
        }
        this.closeInsert();
        this.closeUpdate();
        this.closeSelect();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatPingHist.class.getName(), (String)"closeAverages");
        }
    }
}

