/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server;

import java.net.Socket;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TimeZone;
import org.eclipse.aperi.agent.req.AgentRequestData;
import org.eclipse.aperi.agent.req.RunReq;
import org.eclipse.aperi.agent.req.RunScriptReq;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.LinkedInteger;
import org.eclipse.aperi.common.SoftwareVersion;
import org.eclipse.aperi.connector.ConnectorClient;
import org.eclipse.aperi.jobs.JobRun;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.table.TAgent;
import org.eclipse.aperi.repository.table.TComputer;
import org.eclipse.aperi.repository.table.TResComputer;
import org.eclipse.aperi.repository.table.TResShare;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.SocketTransceiver;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.AgentLessManagedNode;
import org.eclipse.aperi.server.ComputerHashTable;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.xmsg.MessageLog;

public class AgentManager {
    private static final int HASH_TABLE_SIZE = 53;
    private static final String UNKNOWN_COMPUTER = MessageLog.getMessageNoID((String)"SRV0121E");
    private ComputerHashTable agentTable;
    private Map<String, TimeZone> timezoneTable = new HashMap<String, TimeZone>();
    private Map<AgentLessManagedNode, AgentLessManagedNode> nasComputerMap = new HashMap<AgentLessManagedNode, AgentLessManagedNode>();
    private AgentLessManagedNode key = new AgentLessManagedNode();

    protected AgentManager() {
        this.agentTable = new ComputerHashTable(53);
    }

    protected boolean init() {
        Connection dbConnection = Server.getConnection();
        if (dbConnection == null) {
            return this.initError(dbConnection);
        }
        TAgent buffer = new TAgent();
        Iterator i = TAgent.getManagedAgents(buffer, dbConnection);
        if (i == null) {
            return this.initError(dbConnection);
        }
        StringBuffer hostAddress = new StringBuffer(200);
        while (i.hasNext()) {
            try {
                i.next();
            }
            catch (NoSuchElementException e) {
                return this.initError(dbConnection);
            }
            hostAddress.setLength(0);
            hostAddress.append(buffer.computer.networkName);
            if (!SQLUtil.isNullString(buffer.computer.domainName)) {
                hostAddress.append('.');
                hostAddress.append(buffer.computer.domainName);
            }
            short cpuArchitecture = buffer.computer.hwID.cpuArchitecture;
            AgentAddress agent = new AgentAddress(buffer.computer.computerID, hostAddress.toString(), buffer.port, buffer.state, buffer.timestamp, buffer.computer.tsName, buffer.computer.hwID.osType, cpuArchitecture, buffer.productVersions, buffer.featureSet);
            agent.timezone = this.getTimezone(buffer.computer.timezoneID);
            this.agentTable.add(agent);
        }
        Server.returnConnection(dbConnection);
        return true;
    }

    private boolean initError(Connection dbConnection) {
        MessageLog.logMessage((String)"SRV0037E");
        Server.returnConnection(dbConnection);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean register(TAgent agentInfo, Response response, SoftwareVersion[] installedProducts, String newLogDir) {
        TAgent repoAgent;
        TComputer agentComputer = agentInfo.computer;
        String address = agentComputer.networkName == null ? agentComputer.ipAddress : (agentComputer.domainName == null ? agentComputer.networkName : agentComputer.networkName + "." + agentComputer.domainName);
        Connection dbConnection = Server.getConnection();
        if (dbConnection == null) {
            Server.setResponseError(response, "SRV0042E", agentComputer.tsName, new Integer(agentInfo.port));
            return false;
        }
        try {
            repoAgent = TAgent.getAgent(Server.getServerID(), agentComputer, dbConnection);
        }
        catch (SQLException e) {
            Server.returnConnection(dbConnection);
            Server.setResponseError(response, "SRV0042E", agentComputer.tsName, new Integer(agentInfo.port));
            return false;
        }
        Server.returnConnection(dbConnection);
        AgentAddress agent = null;
        if (repoAgent != null && (agent = this.get(repoAgent.computer.computerID)) == null) {
            MessageLog.logMessage((String)"SRV0137W", (Object)agentComputer.tsName, (Object)Integer.toString(agentComputer.computerID));
        }
        if (agent == null) {
            agent = new AgentAddress(-1, address, agentInfo.port, 1, agentInfo.timestamp, agentComputer.tsName, agentComputer.hwID.osType, agentComputer.hwID.cpuArchitecture, agentInfo.productVersions, agentInfo.featureSet);
            agent.timezone = this.getTimezoneSynchronized(agentComputer.timezoneID);
        }
        AgentAddress agentAddress = agent;
        synchronized (agentAddress) {
            agentInfo.state = 1;
            if (!agentInfo.registerAgent(repoAgent, newLogDir)) {
                Server.setResponseError(response, "SRV0042E", agentComputer.tsName, new Integer(agentInfo.port));
                return false;
            }
            if (agent.computerID == -1) {
                agent.computerID = agentComputer.computerID;
                agent.state = agentInfo.state;
                this.agentTable.add(agent);
                if (agentComputer.wasAgentLess) {
                    this.removeAgentLessManagedNode(agentComputer.computerID);
                }
            } else {
                this.update(agent, agentInfo, address, agentInfo.state);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean update(AgentAddress agent, TAgent tAgent, String hostAddress, byte state) {
        AgentAddress agentAddress = agent;
        synchronized (agentAddress) {
            TComputer computer = tAgent.computer;
            agent.hostAddress = hostAddress;
            agent.listenerPort = tAgent.port;
            agent.state = state;
            if (state == 1) {
                agent.consecutiveErrors = 0;
            }
            agent.timestamp = tAgent.timestamp;
            agent.tsName = computer.tsName;
            agent.osType = computer.hwID.osType;
            agent.softwareVersion = AgentManager.encodeSoftwareVersion(tAgent.productVersions);
            agent.featureSet = tAgent.featureSet;
            if (!agent.timezone.getID().equals(computer.timezoneID)) {
                agent.timezone = this.getTimezoneSynchronized(computer.timezoneID);
            }
        }
        return true;
    }

    private static int encodeSoftwareVersion(byte[] productVersions) {
        int softwareVersion = 0;
        if (productVersions != null && productVersions.length >= 2) {
            softwareVersion = SoftwareVersion.encode((int)productVersions[0], (int)productVersions[1], (int)productVersions[2]);
        }
        return softwareVersion;
    }

    private boolean updateRepository(AgentAddress agent, boolean logErrors) {
        int status;
        Connection dbConnection = Server.getConnection();
        if (dbConnection == null) {
            status = 16;
        } else {
            try {
                agent.timestamp = SQLUtil.getTimestamp(dbConnection).getTime();
            }
            catch (Exception e) {
                int status2;
                e.printStackTrace();
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)Iterate.class.getName(), (String)"updateRepository", (Throwable)e);
                }
                return (status2 = 16) == 16;
            }
            status = TAgent.updateAgent(agent.computerID, Server.getServerID(), agent.listenerPort, agent.state, agent.timestamp, null, null, null, dbConnection);
            Server.returnConnection(dbConnection);
        }
        if (status == 16 && logErrors) {
            MessageLog.logMessage((String)"SRV0043E", (Object)agent.hostAddress, (Object)new Integer(agent.listenerPort));
        }
        return status != 16;
    }

    public boolean setState(int computerID, byte state) {
        Response r = Response.getResponse((short)0, null);
        boolean status = this.setState(computerID, state, r);
        if (r.errorMessage != null) {
            Server.getLogWriter().println(r.errorMessage);
        }
        r.returnResponse();
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setState(int computerID, byte state, Response response) {
        AgentAddress agent = this.get(computerID);
        if (agent == null) {
            Server.setResponseError(response, "SRV0040E", new Integer(computerID));
            return false;
        }
        boolean status = true;
        AgentAddress agentAddress = agent;
        synchronized (agentAddress) {
            if (!(agent.state == state || state == 0 && agent.state == 3 || agent.state == 2 && state != 1)) {
                agent.state = state;
                if (state == 1) {
                    agent.consecutiveErrors = 0;
                }
                if (!(status = this.updateRepository(agent, false))) {
                    Server.setResponseError(response, "SRV0043E", agent.hostAddress, new Integer(agent.listenerPort));
                }
            }
        }
        return status;
    }

    public TimeZone getAgentTimezone(int computerID) {
        AgentAddress agent = this.get(computerID);
        if (agent == null) {
            MessageLog.logMessage((String)"SRV0040E", (Object)String.valueOf(computerID));
            return null;
        }
        return agent.timezone;
    }

    public String getAgentHostAddress(int computerID) {
        AgentAddress agent = this.get(computerID);
        if (agent == null) {
            MessageLog.logMessage((String)"SRV0040E", (Object)String.valueOf(computerID));
            return null;
        }
        return agent.hostAddress;
    }

    public String getAgentName(int computerID) {
        String name = null;
        AgentAddress agent = this.get(computerID);
        if (agent != null) {
            name = agent.tsName;
        } else {
            name = this.getNasComputerName(computerID);
            if (name == null || name.equalsIgnoreCase(UNKNOWN_COMPUTER)) {
                name = this.getStorageSystemName(computerID);
            }
        }
        if (name == null) {
            name = UNKNOWN_COMPUTER;
        }
        return name;
    }

    public short getAgentOsType(int computerID) {
        AgentAddress agent = this.get(computerID);
        if (agent == null) {
            MessageLog.logMessage((String)"SRV0040E", (Object)String.valueOf(computerID));
            return 0;
        }
        return agent.osType;
    }

    private String getNasComputerName(int computerID) {
        return this.getNasComputer((int)computerID).name;
    }

    private String getStorageSystemName(int computerID) {
        return this.getStorageSystem((int)computerID).name;
    }

    public boolean isNasComputerExpired(int computerID) {
        boolean expired = false;
        AgentAddress agent = this.get(computerID);
        if (agent != null) {
            return expired;
        }
        AgentLessManagedNode node = this.getNasComputer(computerID);
        if (node != null) {
            expired = node.expired;
        }
        return expired;
    }

    public String getHostAddress(int computerID) {
        String hostAddress = null;
        AgentAddress agent = this.get(computerID);
        if (agent != null) {
            hostAddress = agent.hostAddress;
        }
        return hostAddress;
    }

    public short getOsType(int computerID) {
        AgentAddress agent = this.get(computerID);
        if (agent != null) {
            return agent.osType;
        }
        return this.getNasComputer((int)computerID).osType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAgentLessManagedNode(int computerID) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AgentManager.class.getName(), (String)"removeAgentLessManagedNode", (String)"computerID");
        }
        Map<AgentLessManagedNode, AgentLessManagedNode> map = this.nasComputerMap;
        synchronized (map) {
            AgentLessManagedNode node = new AgentLessManagedNode(computerID, UNKNOWN_COMPUTER);
            this.nasComputerMap.remove(node);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AgentManager.class.getName(), (String)"removeAgentLessManagedNode");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAgentLessManagedNode(TComputer comp) {
        Map<AgentLessManagedNode, AgentLessManagedNode> map = this.nasComputerMap;
        synchronized (map) {
            AgentLessManagedNode node = this.getNasComputer(comp.computerID);
            node.setAttributes(comp.hwID.osType, comp.tsName, comp.hwID.hostName, comp.networkName, comp.domainName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AgentLessManagedNode getNasComputer(int computerID) {
        AgentLessManagedNode node;
        Map<AgentLessManagedNode, AgentLessManagedNode> map = this.nasComputerMap;
        synchronized (map) {
            this.key.computerID = computerID;
            node = this.nasComputerMap.get(this.key);
            if (node == null) {
                Connection dbc = Server.getConnection();
                if (dbc == null) {
                    MessageLog.logMessage((String)"SRV0102E", (Object)"AgentManager.getNasComputerName()");
                    return null;
                }
                try {
                    LinkedInteger expired;
                    TResComputer compAccessor = new TResComputer(dbc);
                    compAccessor.fillNodeMap(this.nasComputerMap);
                    TResShare shareAccessor = new TResShare(dbc);
                    LinkedInteger w = expired = shareAccessor.getExpiredVSs();
                    while (w != null) {
                        this.updateExpiration(w.value, true);
                        w = w.next;
                    }
                    node = this.nasComputerMap.get(this.key);
                    if (node == null) {
                        node = new AgentLessManagedNode(computerID, UNKNOWN_COMPUTER);
                        this.nasComputerMap.put(node, node);
                    }
                }
                catch (GeneralException e) {
                    MessageLog.logException((String)"SRV0156E", (Exception)((Object)e), (Object)Integer.toString(computerID));
                }
                finally {
                    Server.returnConnection(dbc);
                }
            }
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AgentLessManagedNode getStorageSystem(int computerID) {
        AgentLessManagedNode node;
        Map<AgentLessManagedNode, AgentLessManagedNode> map = this.nasComputerMap;
        synchronized (map) {
            this.key.computerID = computerID;
            node = this.nasComputerMap.get(this.key);
            if (node == null || node.name.equalsIgnoreCase(UNKNOWN_COMPUTER)) {
                Connection dbc = Server.getConnection();
                if (dbc == null) {
                    MessageLog.logMessage((String)"SRV0102E", (Object)"AgentManager.getNasComputerName()");
                    return null;
                }
                try {
                    TComputer computerSS = new TComputer();
                    computerSS = TComputer.getSS(computerID, dbc);
                    if (computerSS != null && node != null) {
                        this.updateStorageSystem(computerID, computerSS);
                    }
                }
                catch (SQLException e) {
                    MessageLog.logException((String)"SRV0156E", (Exception)e, (Object)Integer.toString(computerID));
                }
                finally {
                    Server.returnConnection(dbc);
                }
            }
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getTransceiver(int computerID, boolean force, RunReq runReq, int socketTimeout) {
        JobRun jobRun = null;
        RunScriptReq runScriptReq = null;
        if (runReq instanceof JobRun) {
            jobRun = (JobRun)runReq;
        } else if (runReq instanceof RunScriptReq) {
            runScriptReq = (RunScriptReq)runReq;
        }
        AgentAddress agent = this.get(computerID);
        if (agent == null) {
            Response resp = Response.getResponse((short)34, null);
            resp.errorMessage = MessageLog.getMessage((String)"SRV0040E", (Object)String.valueOf(computerID));
            MessageLog.getThreadLog().println(resp.errorMessage);
            return resp;
        }
        Socket agentSocket = null;
        Exception exception = null;
        String hostAddress = null;
        int listenerPort = 0;
        short consecutiveErrors = 0;
        boolean autoDisabled = false;
        boolean checkFailed = false;
        boolean upgradeRequired = false;
        boolean upgrading = false;
        boolean getSocket = false;
        AgentAddress agentAddress = agent;
        synchronized (agentAddress) {
            hostAddress = agent.hostAddress;
            listenerPort = agent.listenerPort;
            if (agent.state == 1 || force) {
                getSocket = true;
                consecutiveErrors = agent.consecutiveErrors;
            }
        }
        if (getSocket) {
            try {
                agentSocket = AgentManager.connectToAgent(hostAddress, listenerPort);
            }
            catch (Exception e) {
                exception = e;
            }
            if (exception != null || consecutiveErrors != 0) {
                AgentAddress e = agent;
                synchronized (e) {
                    if (exception == null) {
                        agent.consecutiveErrors = 0;
                    } else {
                        agent.bumpConnectionError();
                        if (Server.agentErrorLimit > 0 && agent.consecutiveErrors >= Server.agentErrorLimit && agent.state == 1) {
                            this.setState(computerID, (byte)0);
                            autoDisabled = true;
                        }
                    }
                }
            }
        }
        if (agentSocket == null) {
            Response resp = Response.getResponse((short)12, null);
            if (upgradeRequired) {
                if (upgrading) {
                    resp.status = (short)28;
                    resp.errorMessage = MessageLog.getMessage((String)"SRV0123E", (Object)hostAddress, (Object)String.valueOf(listenerPort));
                } else {
                    resp.status = (short)36;
                    resp.errorMessage = MessageLog.getMessage((String)"SRV0158E", (Object)hostAddress);
                }
            } else if (checkFailed) {
                resp.status = (short)32;
                resp.errorMessage = jobRun != null ? jobRun.getLicenseMessage() : runScriptReq.getLicenseMessage();
            } else if (exception == null) {
                resp.status = (short)36;
                resp.errorMessage = MessageLog.getMessage((String)"SRV0039E", (Object)hostAddress, (Object)String.valueOf(listenerPort));
            } else {
                resp.status = (short)36;
                resp.errorMessage = MessageLog.getMessageWithException((String)"SRV0038E", (Exception)exception, (Object)hostAddress, (Object)String.valueOf(listenerPort));
                if (autoDisabled) {
                    MessageLog.logMessage((String)"SRV0041E", (Object)hostAddress, (Object)String.valueOf(listenerPort));
                }
            }
            MessageLog.getThreadLog().println(resp.errorMessage);
            return resp;
        }
        SocketTransceiver st = socketTimeout > 0 ? SocketTransceiver.getSocketTransceiver((Socket)agentSocket, null, (int)socketTimeout) : SocketTransceiver.getSocketTransceiver((Socket)agentSocket, null);
        return st;
    }

    public Response transmitToAgent(Request request, Object requestData, int computerID, boolean force) {
        return this.transmitToAgent(request, requestData, computerID, force, 0);
    }

    public Response transmitToAgent(Request request, Object requestData, int computerID, boolean force, int socketTimeout) {
        RunReq runReq = null;
        if (request.requestData instanceof JobRun) {
            runReq = (RunReq)request.requestData;
        } else if (request.requestData instanceof RunScriptReq) {
            runReq = (RunReq)request.requestData;
        }
        Object o = this.getTransceiver(computerID, force, runReq, socketTimeout);
        if (o instanceof Response) {
            return (Response)o;
        }
        Transceiver transceiver = (Transceiver)o;
        if (request.requestData instanceof AgentRequestData) {
            AgentRequestData ard = (AgentRequestData)request.requestData;
            ard.setServerToken(Server.getServerToken());
            ard.setServerPort(Server.getListenerPort());
            ard.setComputerID(computerID);
        }
        Response response = transceiver.transmitRequest(request, requestData);
        transceiver.close();
        transceiver.returnTransceiver();
        if (response != null && response.status == 16) {
            this.setState(computerID, (byte)2);
        }
        return response;
    }

    public Iterator listAgents(AgentAddress returnArea) {
        return new Iterate(returnArea);
    }

    public Iterator listAgents() {
        return new Iterate(null);
    }

    public void delete(int computerID) {
        this.agentTable.delete(computerID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AgentAddress getAgent(int computerID) {
        AgentAddress returnAgent = null;
        AgentAddress agent = (AgentAddress)this.agentTable.get(computerID);
        if (agent != null) {
            returnAgent = new AgentAddress();
            AgentAddress agentAddress = agent;
            synchronized (agentAddress) {
                agent.copyInto(returnAgent);
            }
        }
        return returnAgent;
    }

    public AgentAddress get(int computerID) {
        return (AgentAddress)this.agentTable.get(computerID);
    }

    private TimeZone getTimezone(String timezoneID) {
        TimeZone timezone = this.timezoneTable.get(timezoneID);
        if (timezone != null) {
            return timezone;
        }
        timezone = TimeZone.getTimeZone(timezoneID);
        if (timezone.getID().indexOf("Custom") != -1) {
            timezone.setID(timezone.getDisplayName(timezone.useDaylightTime(), 0));
        }
        this.timezoneTable.put(timezoneID, timezone);
        return timezone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TimeZone getTimezoneSynchronized(String timezoneID) {
        Map<String, TimeZone> map = this.timezoneTable;
        synchronized (map) {
            return this.getTimezone(timezoneID);
        }
    }

    private void updateExpiration(int cmpID, boolean pExpired) {
        AgentLessManagedNode node = this.getNasComputer(cmpID);
        node.updateExpiredFlag(pExpired);
    }

    private void updateStorageSystem(int cmpID, TComputer computer) {
        AgentLessManagedNode node = this.getNasComputer(cmpID);
        node.name = computer.hwID.hostName;
        node.osType = computer.hwID.osType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateExpirationOfAgentLessManagedNode(int cmpID, boolean pExpired) {
        Map<AgentLessManagedNode, AgentLessManagedNode> map = this.nasComputerMap;
        synchronized (map) {
            this.updateExpiration(cmpID, pExpired);
        }
    }

    public static Socket connectToAgent(String hostAddress, int listenerPort) throws Exception {
        return ConnectorClient.getSocket((String)hostAddress, (int)listenerPort, (String)"org.eclipse.aperi.agent.svp.SocketHandler");
    }

    private class Iterate
    implements Iterator {
        AgentAddress returnArea;
        Iterator iterator;

        Iterate(AgentAddress returnArea) {
            this.iterator = AgentManager.this.agentTable.getIterator();
            this.returnArea = returnArea;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() throws NoSuchElementException {
            AgentAddress agent = (AgentAddress)this.iterator.next();
            if (this.returnArea == null) {
                return agent;
            }
            agent.copyInto(this.returnArea);
            return this.returnArea;
        }

        public void remove() throws UnsupportedOperationException, IllegalStateException {
            throw new UnsupportedOperationException();
        }
    }

    public static class AgentAddress
    extends ComputerHashTable.HashedComputer {
        public int listenerPort;
        public short connectionErrors;
        public short consecutiveErrors;
        public byte state;
        public String hostAddress;
        public long timestamp;
        public TimeZone timezone;
        public short osType;
        public short cpuArchitecture;
        public String tsName;
        public byte upgradeRequired;
        public byte mustBeUpgraded;
        public int softwareVersion;
        public int featureSet;

        public AgentAddress(int computerID, String hostAddress, int port, byte state, long timestamp, String tsName, short osType, short cpuArchitecture, byte[] productVersions, int featureSet) {
            this.computerID = computerID;
            this.listenerPort = port;
            this.hostAddress = hostAddress;
            this.state = state;
            this.timestamp = timestamp;
            this.tsName = tsName;
            this.osType = osType;
            this.cpuArchitecture = cpuArchitecture;
            this.softwareVersion = AgentManager.encodeSoftwareVersion(productVersions);
            this.featureSet = featureSet;
        }

        public AgentAddress() {
            this(-1, null, -1, 0, 0L, null, -1, -1, null, 0);
        }

        public synchronized void copyInto(AgentAddress copy) {
            copy.computerID = this.computerID;
            copy.listenerPort = this.listenerPort;
            copy.connectionErrors = this.connectionErrors;
            copy.consecutiveErrors = this.consecutiveErrors;
            copy.state = this.state;
            copy.hostAddress = this.hostAddress;
            copy.timestamp = this.timestamp;
            copy.timezone = this.timezone;
            copy.tsName = this.tsName;
            copy.osType = this.osType;
            copy.cpuArchitecture = this.cpuArchitecture;
            copy.upgradeRequired = this.upgradeRequired;
            copy.mustBeUpgraded = this.mustBeUpgraded;
            copy.softwareVersion = this.softwareVersion;
            copy.featureSet = this.featureSet;
        }

        public void bumpConnectionError() {
            this.connectionErrors = (short)(this.connectionErrors + 1);
            this.consecutiveErrors = (short)(this.consecutiveErrors + 1);
        }
    }
}

