/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.StreamTokenizer;
import java.util.Properties;
import org.eclipse.aperi.identity.HardwareID;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.Transform;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;

public class ConfigParser {
    private final String CONTROLLER_SECTION = "controller";
    private final String REPOSITORY_SECTION = "repository";
    private final String LOGGING_SECTION = "logging";
    private final String HARDWARE_SECTION = "hardware";
    public static final String DELETE_DUPCOMPINFO = "delete";
    public static final String KEEP_DUPCOMPINFO = "keep";
    private String configFile;
    private String passwordFile;
    private String currentSection;
    private BufferedReader reader = null;
    private StreamTokenizer tokenizer;
    public String name;
    public String hostAlias;
    public String repositoryDriver;
    public String repositoryURL;
    public HardwareID hardwareID;
    public int connectionPoolSize = 5;
    public int listenerPort = 3123;
    public int agentErrorLimit = 0;
    public int messagesPerLog = 1000000;
    public int logsKept = 5;
    public short maxConnections = (short)200;
    public short routerThreads = 1;
    public short serviceThreads = (short)2;
    public String adminGroup = null;
    public boolean commEncrypted = false;
    public String dupCompInfo = "";
    public Properties repositoryProperties = new Properties();
    public boolean multipleMaintenance = false;

    public ConfigParser(String configFile, String passwordFile) {
        this.configFile = configFile;
        this.passwordFile = passwordFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parse() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ConfigParser.class.getName(), (String)"parse", (String)"");
        }
        boolean success = false;
        try {
            this.initializeTokenizer();
            this.tokenize();
            success = true;
        }
        catch (Exception e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)ConfigParser.class.getName(), (String)"parse", (Throwable)e);
            }
            MessageLog.logException((String)"SRV0004E", (Exception)e, (Object)this.configFile);
        }
        finally {
            block16: {
                if (this.reader != null) {
                    try {
                        this.reader.close();
                    }
                    catch (Exception e) {
                        if (!TraceLogger.enableTrace) break block16;
                        TraceLogger.exception((String)ConfigParser.class.getName(), (String)"parse", (Throwable)e);
                    }
                }
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ConfigParser.class.getName(), (String)"parse", (boolean)success);
        }
        return success;
    }

    private void initializeTokenizer() throws Exception {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ConfigParser.class.getName(), (String)"initializeTokenizer", (String)"");
        }
        this.reader = new BufferedReader(new FileReader(this.configFile));
        this.tokenizer = new StreamTokenizer(this.reader);
        this.tokenizer.resetSyntax();
        this.tokenizer.wordChars(97, 122);
        this.tokenizer.wordChars(65, 90);
        this.tokenizer.wordChars(48, 57);
        this.tokenizer.wordChars(47, 47);
        this.tokenizer.wordChars(92, 92);
        this.tokenizer.wordChars(46, 46);
        this.tokenizer.wordChars(95, 95);
        this.tokenizer.whitespaceChars(0, 32);
        this.tokenizer.commentChar(35);
        this.tokenizer.quoteChar(34);
        this.tokenizer.quoteChar(39);
        this.tokenizer.eolIsSignificant(false);
        this.tokenizer.slashStarComments(false);
        this.tokenizer.slashSlashComments(false);
        this.tokenizer.lowerCaseMode(false);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ConfigParser.class.getName(), (String)"initializeTokenizer");
        }
    }

    private void tokenize() throws Exception {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ConfigParser.class.getName(), (String)"tokenize", (String)"");
        }
        while (this.nextToken(false, 91) != -1) {
            this.nextToken(true, -3);
            String sectionName = this.tokenizer.sval;
            this.nextToken(true, 93);
            if (sectionName.equalsIgnoreCase("controller")) {
                this.currentSection = "controller";
                this.controllerSection();
                continue;
            }
            if (sectionName.equalsIgnoreCase("logging")) {
                this.currentSection = "logging";
                this.loggingSection();
                continue;
            }
            if (sectionName.equalsIgnoreCase("repository")) {
                this.currentSection = "repository";
                this.repositorySection();
                continue;
            }
            if (sectionName.equalsIgnoreCase("hardware")) {
                this.currentSection = "hardware";
                this.hardwareSection();
                continue;
            }
            this.throwException("SRV0010E", sectionName, null);
        }
        if (this.repositoryDriver == null || this.repositoryDriver.length() == 0) {
            this.throwException("SRV0003E", "repository", "driver");
        }
        if (this.repositoryURL == null || this.repositoryURL.length() == 0) {
            this.throwException("SRV0003E", "repository", "url");
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ConfigParser.class.getName(), (String)"tokenize");
        }
    }

    private int nextToken(boolean tokenRequired, int expectedTokenType) throws Exception {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ConfigParser.class.getName(), (String)"nextToken", (String)"tokenRequired, expectedTokenType");
        }
        if (this.tokenizer.ttype != -1) {
            this.tokenizer.nextToken();
        }
        if (this.tokenizer.ttype == -1) {
            if (tokenRequired) {
                this.throwException("SRV0007E", null, null);
            }
        } else {
            if (this.tokenizer.ttype == 34 || this.tokenizer.ttype == 39) {
                this.tokenizer.ttype = -3;
            }
            if (expectedTokenType != 0 && expectedTokenType != this.tokenizer.ttype) {
                this.throwException("SRV0006E", this.tokenizer.toString(), null);
            }
        }
        int traceResult = this.tokenizer.ttype;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ConfigParser.class.getName(), (String)"nextToken", (int)traceResult);
        }
        return traceResult;
    }

    private void controllerSection() throws Exception {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ConfigParser.class.getName(), (String)"controllerSection", (String)"");
        }
        String[] keyValuePair = new String[2];
        while (this.getKeyValuePair(keyValuePair)) {
            if (keyValuePair[0].equalsIgnoreCase("name")) {
                this.name = keyValuePair[1];
                continue;
            }
            if (keyValuePair[0].equalsIgnoreCase("hostalias")) {
                this.hostAlias = keyValuePair[1];
                if (this.hostAlias == null) continue;
                this.hostAlias = this.hostAlias.toLowerCase();
                continue;
            }
            if (keyValuePair[0].equalsIgnoreCase("port")) {
                this.listenerPort = this.stringToInt(keyValuePair);
                if (this.listenerPort >= 1) continue;
                this.throwException("SRV0008E", "controller", "port");
                continue;
            }
            if (keyValuePair[0].equalsIgnoreCase("maxconnections")) {
                this.maxConnections = (short)this.stringToInt(keyValuePair);
                if (this.maxConnections >= 20) continue;
                this.throwException("SRV0008E", "controller", "maxConnections");
                continue;
            }
            if (keyValuePair[0].equalsIgnoreCase("routerthreads")) {
                this.routerThreads = (short)this.stringToInt(keyValuePair);
                if (this.routerThreads >= 1) continue;
                this.throwException("SRV0008E", "controller", "routerThreads");
                continue;
            }
            if (keyValuePair[0].equalsIgnoreCase("servicethreads")) {
                this.serviceThreads = (short)this.stringToInt(keyValuePair);
                if (this.serviceThreads >= 1) continue;
                this.throwException("SRV0008E", "controller", "serviceThreads");
                continue;
            }
            if (keyValuePair[0].equalsIgnoreCase("agenterrorlimit")) {
                this.agentErrorLimit = this.stringToInt(keyValuePair);
                continue;
            }
            if (keyValuePair[0].equalsIgnoreCase("admingroup")) {
                this.adminGroup = keyValuePair[1];
                continue;
            }
            if (keyValuePair[0].equalsIgnoreCase("commencrypted")) {
                this.commEncrypted = this.stringToInt(keyValuePair) == 1;
                continue;
            }
            if (keyValuePair[0].equalsIgnoreCase("dupCompInfo")) {
                this.dupCompInfo = keyValuePair[1];
                continue;
            }
            if (keyValuePair[0].equalsIgnoreCase("multiplemaintenance")) {
                this.multipleMaintenance = true;
                continue;
            }
            this.throwException("SRV0009E", "controller", keyValuePair[0]);
        }
        if (this.name == null || this.name.length() == 0) {
            this.throwException("SRV0003E", "controller", "name");
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ConfigParser.class.getName(), (String)"controllerSection");
        }
    }

    private void loggingSection() throws Exception {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ConfigParser.class.getName(), (String)"loggingSection", (String)"");
        }
        String[] keyValuePair = new String[2];
        while (this.getKeyValuePair(keyValuePair)) {
            if (keyValuePair[0].equalsIgnoreCase("logskept")) {
                this.logsKept = this.stringToInt(keyValuePair);
                continue;
            }
            if (keyValuePair[0].equalsIgnoreCase("messagesperlog")) {
                this.messagesPerLog = this.stringToInt(keyValuePair);
                continue;
            }
            this.throwException("SRV0009E", "logging", keyValuePair[0]);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ConfigParser.class.getName(), (String)"loggingSection");
        }
    }

    private void repositorySection() throws Exception {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ConfigParser.class.getName(), (String)"repositorySection", (String)"");
        }
        String[] keyValuePair = new String[2];
        while (this.getKeyValuePair(keyValuePair)) {
            if (keyValuePair[0].equalsIgnoreCase("driver")) {
                this.repositoryDriver = keyValuePair[1];
                continue;
            }
            if (keyValuePair[0].equalsIgnoreCase("url")) {
                this.repositoryURL = keyValuePair[1];
                continue;
            }
            if (keyValuePair[0].equalsIgnoreCase("connectionpool")) {
                this.connectionPoolSize = this.stringToInt(keyValuePair);
                this.repositoryProperties.put(keyValuePair[0], keyValuePair[1]);
                if (this.connectionPoolSize >= 0) continue;
                this.throwException("SRV0008E", "repository", "connectionPool");
                continue;
            }
            this.repositoryProperties.put(keyValuePair[0], keyValuePair[1]);
        }
        if (this.passwordFile != null) {
            String password = Transform.getTransformed((String)this.passwordFile);
            if (password == null) {
                this.throwException("SRV0067E", this.passwordFile, null);
            }
            this.repositoryProperties.put("password", password);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ConfigParser.class.getName(), (String)"repositorySection");
        }
    }

    private void hardwareSection() throws Exception {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ConfigParser.class.getName(), (String)"hardwareSection", (String)"");
        }
        String identifier = null;
        String manufacturer = null;
        String[] keyValuePair = new String[2];
        while (this.getKeyValuePair(keyValuePair)) {
            if (keyValuePair[0].equalsIgnoreCase("manufacturer")) {
                manufacturer = keyValuePair[1];
                continue;
            }
            if (keyValuePair[0].equalsIgnoreCase("hardwareid")) {
                identifier = keyValuePair[1];
                continue;
            }
            this.throwException("SRV0009E", "hardware", keyValuePair[0]);
        }
        if (manufacturer == null || manufacturer.length() == 0) {
            this.throwException("SRV0003E", "hardware", "manufacturer");
        }
        if (identifier == null || identifier.length() == 0) {
            this.throwException("SRV0003E", "hardware", "hardwareid");
        }
        try {
            this.hardwareID = new HardwareID(identifier.getBytes(), manufacturer);
        }
        catch (LocalizableException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)ConfigParser.class.getName(), (String)"hardwareSection", (Throwable)e);
            }
            e.print();
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ConfigParser.class.getName(), (String)"hardwareSection");
            }
            throw new Exception();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ConfigParser.class.getName(), (String)"hardwareSection");
        }
    }

    private boolean getKeyValuePair(String[] keyValuePair) throws Exception {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ConfigParser.class.getName(), (String)"getKeyValuePair", (String)"keyValuePair");
        }
        if (this.nextToken(false, 0) == -1) {
            boolean traceResult = false;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ConfigParser.class.getName(), (String)"getKeyValuePair", (boolean)traceResult);
            }
            return traceResult;
        }
        if (this.tokenizer.ttype == 91) {
            this.tokenizer.pushBack();
            boolean traceResult = false;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ConfigParser.class.getName(), (String)"getKeyValuePair", (boolean)traceResult);
            }
            return traceResult;
        }
        if (this.tokenizer.ttype != -3) {
            this.throwException("SRV0006E", this.tokenizer.toString(), null);
        }
        keyValuePair[0] = this.tokenizer.sval.toLowerCase();
        this.nextToken(true, 61);
        this.nextToken(true, -3);
        keyValuePair[1] = this.tokenizer.sval;
        boolean traceResult = true;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ConfigParser.class.getName(), (String)"getKeyValuePair", (boolean)traceResult);
        }
        return traceResult;
    }

    private int stringToInt(String[] keyValuePair) throws Exception {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ConfigParser.class.getName(), (String)"stringToInt", (String)"keyValuePair");
        }
        try {
            int traceResult = Integer.parseInt(keyValuePair[1]);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ConfigParser.class.getName(), (String)"stringToInt", (int)traceResult);
            }
            return traceResult;
        }
        catch (NumberFormatException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)ConfigParser.class.getName(), (String)"stringToInt", (Throwable)e);
            }
            this.throwException("SRV0008E", this.currentSection, keyValuePair[0]);
            int traceResult = -1;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ConfigParser.class.getName(), (String)"stringToInt", (int)traceResult);
            }
            return traceResult;
        }
    }

    private void throwException(String msgId, String parm1, String parm2) throws Exception {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ConfigParser.class.getName(), (String)"throwException", (String)"msgId, parm1, parm2");
        }
        Object[] args = new Object[]{parm1, parm2};
        String msg = MessageLog.getMessage((String)msgId, (Object[])args);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ConfigParser.class.getName(), (String)"throwException");
        }
        throw new Exception(msg.substring("                         ".length()));
    }
}

