/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import org.eclipse.aperi.backend.SaferServerSocket;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.server.ClientSocket;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ServiceQueue;
import org.eclipse.aperi.xmsg.MessageLog;

class Listener
extends Thread {
    ServiceQueue queue;
    PrintWriter logWriter = MessageLog.getThreadLog();

    protected Listener(ThreadGroup serverThreadGroup) {
        super(serverThreadGroup, "Listener");
        this.queue = Server.routerQueue;
        this.setDaemon(true);
        this.start();
    }

    public void run() {
        block6: {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)Listener.class.getName(), (String)"run", (String)"");
            }
            SaferServerSocket listenerSocket = null;
            MessageLog.setThreadLog((PrintWriter)this.logWriter);
            try {
                listenerSocket = new SaferServerSocket(Server.getListenerPort());
                Server.listenerSocket = listenerSocket;
                MessageLog.logMessage((String)"SRV0029I");
                while (Server.terminate == 0) {
                    Socket socket = listenerSocket.accept();
                    ClientSocket clientSocket = ClientSocket.getClientSocket(socket);
                    Server.bumpConnectionCount(1);
                    this.queue.add(clientSocket, false);
                }
            }
            catch (IOException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)Listener.class.getName(), (String)"run", (Throwable)e);
                }
                if (Server.terminate != 0) break block6;
                String msg = listenerSocket == null ? "SRV0027E" : "SRV0028E";
                MessageLog.logException((String)msg, (Exception)e, (Object)new Integer(Server.getListenerPort()));
                if (!TraceLogger.enableTrace) break block6;
                TraceLogger.exit((String)Listener.class.getName(), (String)"run");
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Listener.class.getName(), (String)"run");
        }
    }
}

