/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server;

import java.io.PrintWriter;
import java.util.Date;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.server.Alerter;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ServerThreadGroup;
import org.eclipse.aperi.xmsg.CurtailedWriter;
import org.eclipse.aperi.xmsg.MessageLog;

public class SvpThreadGroup
extends ThreadGroup {
    private static final String CLASSNAME = SvpThreadGroup.class.getName();
    private String[] services;

    public SvpThreadGroup(String groupName, String[] services) {
        super(groupName);
        this.services = services;
    }

    public void uncaughtException(Thread t, Throwable e) {
        String methodName = "uncaughtException";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"uncaughtException", (String)"t, e");
        }
        String serviceName = RequestTypeManager.getInternalName((String)this.services[0]);
        MessageLog.setThreadLog((PrintWriter)Server.getLogWriter());
        MessageLog.logMessage((String)"SRV0068E", (Object)(serviceName != null ? serviceName : "Request code " + this.services[0] + " (name unknown)"));
        if (e instanceof OutOfMemoryError) {
            ServerThreadGroup.fatalError(e);
        } else {
            e.printStackTrace();
            for (int i = this.services.length - 1; i >= 0; --i) {
                Server.serviceMgr.stopService(this.services[i], (byte)2);
            }
            Object[] args = new Object[]{String.valueOf(this.services[0]), ((CurtailedWriter)Server.getLogWriter()).getCurrentFileName(), Server.getHomeDirectory(), new Date()};
            Alerter.shutdownNotification("SRV0183M", "SRV0184M", args);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"uncaughtException");
        }
    }
}

