/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server;

import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.jobs.JobRun;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.VMJobResults;
import org.eclipse.aperi.server.handler.scheduler.JobHndlr;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;

public class VMTransceiver
extends Transceiver {
    private boolean isClosed;
    private boolean resultAvailable;
    private boolean dataAvailable;
    private boolean jobDataAvailable;
    private Object data;
    private Response result;

    public void returnTransceiver() {
    }

    public synchronized Response transmitRequest(Request request, Object requestData) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)VMTransceiver.class.getName(), (String)"transmitRequest", (String)"request, requestData");
        }
        if (!Server.serviceMgr.routeRequest(request, this)) {
            Response traceResult = null;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)VMTransceiver.class.getName(), (String)"transmitRequest", traceResult);
            }
            return traceResult;
        }
        if ((request.typeCode.equals("org.eclipse.aperi.server.svp.AgentSvp") && request.subType.equals("org.eclipse.aperi.server.handler.scheduler.JobHndlr.Agent") || request.typeCode.equals("org.eclipse.aperi.server.svp.CimomSvp") && request.subType.equals("org.eclipse.aperi.server.handler.scheduler.JobHndlr.CIMOM")) && !this.sendJobReceivedResponse(request)) {
            Response traceResult = null;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)VMTransceiver.class.getName(), (String)"transmitRequest", traceResult);
            }
            return traceResult;
        }
        int phase = requestData == null ? 0 : 1;
        Response response = this.getResponse(request, phase);
        if (requestData == null || response == null || response.status > 4) {
            Response traceResult = response;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)VMTransceiver.class.getName(), (String)"transmitRequest", (Object)traceResult);
            }
            return traceResult;
        }
        try {
            this.data = requestData;
            this.dataAvailable = true;
            this.checkClosed();
            ((Object)((Object)this)).notify();
        }
        catch (LocalizableException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)VMTransceiver.class.getName(), (String)"transmitRequest", (Throwable)e);
            }
            MessageLog.logMessage((String)"SRV0069E", (Object)RequestTypeManager.getInternalName((String)request.typeCode));
            e.print();
            this.logTransmitExplanation(request, 2);
            Response traceResult = null;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)VMTransceiver.class.getName(), (String)"transmitRequest", traceResult);
            }
            return traceResult;
        }
        Response traceResult = this.getResponse(request, 2);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)VMTransceiver.class.getName(), (String)"transmitRequest", (Object)traceResult);
        }
        return traceResult;
    }

    public synchronized boolean transmitResponse(Request request, Response response) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)VMTransceiver.class.getName(), (String)"transmitResponse", (String)"request, response");
        }
        if (response.status != 0) {
            this.logResponse(request, response);
        }
        try {
            this.checkResponseToSend(request, response);
            this.result = response;
            this.resultAvailable = true;
            this.checkClosed();
            ((Object)((Object)this)).notify();
        }
        catch (LocalizableException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)VMTransceiver.class.getName(), (String)"transmitResponse", (Throwable)e);
            }
            MessageLog.logMessage((String)"SRV0071E");
            e.print();
            boolean traceResult = false;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)VMTransceiver.class.getName(), (String)"transmitResponse", (boolean)traceResult);
            }
            return traceResult;
        }
        boolean traceResult = true;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)VMTransceiver.class.getName(), (String)"transmitResponse", (boolean)traceResult);
        }
        return traceResult;
    }

    public synchronized Request receiveRequest() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)VMTransceiver.class.getName(), (String)"receiveRequest", (String)"");
        }
        MessageLog.logMessage((String)"SRV0072E");
        Request traceResult = null;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)VMTransceiver.class.getName(), (String)"receiveRequest", traceResult);
        }
        return traceResult;
    }

    public synchronized Object receiveData(Request request) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)VMTransceiver.class.getName(), (String)"receiveData", (String)"request");
        }
        try {
            this.checkTwoPhase(request);
            while (!this.dataAvailable) {
                try {
                    ((Object)((Object)this)).wait();
                }
                catch (InterruptedException e) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.exception((String)VMTransceiver.class.getName(), (String)"receiveData", (Throwable)e);
                }
            }
            this.checkClosed();
        }
        catch (LocalizableException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)VMTransceiver.class.getName(), (String)"receiveData", (Throwable)e);
            }
            MessageLog.logMessage((String)"SRV0073E");
            e.print();
            this.data = null;
        }
        Object o = this.data;
        this.data = null;
        this.dataAvailable = false;
        if (o == null) {
            MessageLog.logMessage((String)"GEN7070I", (Object)request.toString());
        }
        Object traceResult = o;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)VMTransceiver.class.getName(), (String)"receiveData", (Object)traceResult);
        }
        return traceResult;
    }

    public synchronized boolean close() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)VMTransceiver.class.getName(), (String)"close", (String)"");
        }
        if (!this.isClosed) {
            this.isClosed = true;
            this.resultAvailable = true;
            this.dataAvailable = true;
            this.jobDataAvailable = true;
            ((Object)((Object)this)).notify();
            boolean traceResult = true;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)VMTransceiver.class.getName(), (String)"close", (boolean)traceResult);
            }
            return traceResult;
        }
        boolean traceResult = false;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)VMTransceiver.class.getName(), (String)"close", (boolean)traceResult);
        }
        return traceResult;
    }

    private Response getResponse(Request request, int phase) {
        block12: {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)VMTransceiver.class.getName(), (String)"getResponse", (String)"request, phase");
            }
            while (!this.resultAvailable) {
                try {
                    ((Object)((Object)this)).wait();
                }
                catch (InterruptedException e) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.exception((String)VMTransceiver.class.getName(), (String)"getResponse", (Throwable)e);
                }
            }
            this.resultAvailable = false;
            try {
                if (this.result == null) {
                    MessageLog.logMessage((String)"SRV0075E", (Object)RequestTypeManager.getInternalName((String)request.typeCode));
                    this.logTransmitExplanation(request, phase);
                    this.checkClosed();
                    Response traceResult = null;
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit((String)VMTransceiver.class.getName(), (String)"getResponse", traceResult);
                    }
                    return traceResult;
                }
                if (this.result.status != 0) {
                    MessageLog.logMessage((String)"SRV0074I", (Object)RequestTypeManager.getInternalName((String)request.typeCode));
                    this.logReceivedResponse(this.result);
                    this.logTransmitExplanation(request, phase);
                }
                if (this.result.status <= 4) {
                    this.checkReceivedResponse(request, phase, this.result);
                }
            }
            catch (LocalizableException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)VMTransceiver.class.getName(), (String)"getResponse", (Throwable)e);
                }
                e.print();
                if (this.result == null) break block12;
                this.result.status = (short)12;
            }
        }
        Response response = this.result;
        this.result = null;
        Response traceResult = response;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)VMTransceiver.class.getName(), (String)"getResponse", (Object)traceResult);
        }
        return traceResult;
    }

    public synchronized VMJobResults getJobData(Request request) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)VMTransceiver.class.getName(), (String)"getJobData", (String)"request");
        }
        while (!this.jobDataAvailable) {
            try {
                ((Object)((Object)this)).wait();
            }
            catch (InterruptedException e) {
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.exception((String)VMTransceiver.class.getName(), (String)"getJobData", (Throwable)e);
            }
        }
        VMJobResults jobData = null;
        Response response = new Response(0, null);
        if (RequestChecker.isDesiredType(VMJobResults.class, (Request)request, (Response)response)) {
            jobData = (VMJobResults)request.requestData;
        } else {
            MessageLog.getThreadLog().println(response.getErrorMessage());
            try {
                this.checkClosed();
            }
            catch (LocalizableException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)VMTransceiver.class.getName(), (String)"getJobData", (Throwable)e);
                }
                e.print();
            }
        }
        VMJobResults traceResult = jobData;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)VMTransceiver.class.getName(), (String)"getJobData", (Object)traceResult);
        }
        return traceResult;
    }

    private void checkClosed() throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)VMTransceiver.class.getName(), (String)"checkClosed", (String)"");
        }
        if (this.isClosed) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)VMTransceiver.class.getName(), (String)"checkClosed");
            }
            throw new LocalizableException("SRV0070E", null);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)VMTransceiver.class.getName(), (String)"checkClosed");
        }
    }

    private void logTransmitExplanation(Request request, int phase) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)VMTransceiver.class.getName(), (String)"logTransmitExplanation", (String)"request, phase");
        }
        if (phase == 0) {
            MessageLog.logMessage((String)"GEN7071I", (Object)request.toString());
        } else {
            MessageLog.logMessage((String)"GEN7072I", (Object)request.toString(), (Object)new Integer(phase));
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)VMTransceiver.class.getName(), (String)"logTransmitExplanation");
        }
    }

    private boolean sendJobReceivedResponse(Request request) {
        Response response;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)VMTransceiver.class.getName(), (String)"sendJobReceivedResponse", (String)"request");
        }
        if (!RequestChecker.isDesiredType(JobRun.class, (Request)request, (Response)(response = Response.getResponse((short)0, null)))) {
            boolean traceResult = this.transmitResponse(request, response);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)VMTransceiver.class.getName(), (String)"sendJobReceivedResponse", (boolean)traceResult);
            }
            return traceResult;
        }
        JobRun jobRun = (JobRun)request.requestData;
        VMJobResults jobResults = new VMJobResults(jobRun);
        this.jobDataAvailable = this.transmitResponse(request, response);
        if (this.jobDataAvailable) {
            if (JobHndlr.jobNeedsLogFile(jobRun)) {
                response.responseData = jobResults.createJobLog();
                jobResults.logMessage("STS0306I", null);
                jobResults.closeJobLog();
            }
            request.requestData = jobResults;
            JobHndlr.addToJobTable(jobRun);
        }
        boolean traceResult = this.jobDataAvailable;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)VMTransceiver.class.getName(), (String)"sendJobReceivedResponse", (boolean)traceResult);
        }
        return traceResult;
    }
}

