/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.alert;

import java.sql.Connection;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.table.TAlertDefinition;
import org.eclipse.aperi.server.AgentManager;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.alert.StormAlerter;
import org.eclipse.aperi.server.jobs.Ping;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.NestableException;

public class PingAlerter
extends StormAlerter {
    AgentManager agentMgr = Server.getAgentManager();
    Ping.PingStats statsList;
    int alertID;

    public PingAlerter(Connection dbc, Ping.PingStats statsList, int alertID) {
        super(dbc, -1);
        this.statsList = statsList;
        this.alertID = alertID;
    }

    public void alert() throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)PingAlerter.class.getName(), (String)"alert", (String)"");
        }
        try {
            TAlertDefinition alertAccessor = new TAlertDefinition(this.dbc);
            alertAccessor.prepSelectByID(false, true);
            this.alertDef = alertAccessor.getByID(this.alertID);
            alertAccessor.closeSelect();
            if (this.alertDef == null) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)PingAlerter.class.getName(), (String)"alert");
                }
                return;
            }
        }
        catch (GeneralException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)PingAlerter.class.getName(), (String)"alert", (Throwable)e);
            }
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)PingAlerter.class.getName(), (String)"alert");
            }
            throw new NestableException("STS0053W", null, (Exception)((Object)e));
        }
        Ping.PingStats stats = this.statsList;
        while (stats != null) {
            if (stats.unreachableCount > this.alertDef.aldThresholdValue) {
                this.initParms();
                this.setHostName(stats.computerID);
                this.alertParms[1] = this.hostName;
                this.setParmFromMsg(11, "STS0054I");
                this.setNumParm(2, this.alertDef.aldThresholdValue, (String)null);
                this.setNumParm(3, stats.unreachableCount, (String)null);
                this.setParmFromMsg(10, "ALR1077W");
                this.genAlert(stats.computerID, (short)1, 16, stats.unreachableCount, -1);
                stats.alertExists = true;
            } else if (stats.alertExists) {
                this.setComputer(stats.computerID);
                this.clearAlert(stats.computerID, (short)1);
                stats.alertExists = false;
            }
            stats = stats.next;
        }
        this.close();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)PingAlerter.class.getName(), (String)"alert");
        }
    }
}

