/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.agent;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.aperi.Nas.common.NasFiler;
import org.eclipse.aperi.TStorm.common.Domain;
import org.eclipse.aperi.TStorm.common.Settings;
import org.eclipse.aperi.TStorm.server.agentreq.DiscoveryData;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.LinkedInteger;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.infrastructure.database.CurrentTime;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.FilerSaver;
import org.eclipse.aperi.repository.UnmanagedSaver;
import org.eclipse.aperi.repository.table.TResDomain;
import org.eclipse.aperi.repository.table.TResLdapTree;
import org.eclipse.aperi.repository.table.TResPwd;
import org.eclipse.aperi.repository.table.TResShare;
import org.eclipse.aperi.repository.table.TSnmpCommunity;
import org.eclipse.aperi.repository.table.TStormSettings;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.Alerter;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThrowAway;
import org.eclipse.aperi.server.alert.StormAlerter;
import org.eclipse.aperi.server.svp.AgentSvp;
import org.eclipse.aperi.xmsg.MessageLog;

public class DiscoveryHndlr
implements RequestHandler,
ThrowAway {
    public static final String RESOURCE_TYPE = "CIMOMDISCOVERY";
    private static final long CLEANUP_TIME = 0x6DDD00L;
    private static long lastCleanup;
    private static Map runMap;
    private static final int[][] varBindOIDs;
    private static final String NAS_CONFIG_FILE;
    private Connection dbc;
    private Response response;
    private boolean updateScheduler;
    private int[] lockedTrees;
    private long discoveryTime;
    private TResShare shareAccessor;

    private static synchronized void setNoComputerDiscovery(DiscoveryData data, long now) {
        long cleanupTime;
        NameList domain;
        RunAnchor key;
        RunAnchor anchor2;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)DiscoveryHndlr.class.getName(), (String)"setNoComputerDiscovery", (String)"data, now");
        }
        if ((anchor2 = (RunAnchor)((Object)runMap.get((Object)(key = new RunAnchor(data.dfRunNumber))))) != null) {
            domain = anchor2.domains;
            while (domain != null && !data.dfNoNetworkDiscovery) {
                if (domain.nlName.equalsIgnoreCase(data.dfDomain)) {
                    data.dfNoNetworkDiscovery = true;
                    continue;
                }
                domain = domain.nlNext;
            }
        } else {
            anchor2 = key;
            runMap.put(anchor2, anchor2);
        }
        anchor2.lastRequest = now;
        if (!data.dfNoNetworkDiscovery) {
            domain = new NameList();
            domain.nlName = data.dfDomain;
            domain.nlNext = anchor2.domains;
            anchor2.domains = domain;
            String agentName = Server.agentMgr.getAgentName(data.dfComputerID.computerID);
            String runNumber = Integer.toString(data.dfRunNumber);
            Object[] parms = new String[]{runNumber, agentName, data.dfDomain};
            MessageLog.logMessage((String)"STS0180I", (Object[])parms);
        }
        if (lastCleanup < (cleanupTime = now - 0x6DDD00L)) {
            LinkedInteger head = null;
            for (RunAnchor anchor2 : runMap.keySet()) {
                if (anchor2.lastRequest >= cleanupTime) continue;
                anchor2.next = head;
                head = anchor2;
            }
            while (head != null) {
                runMap.remove(head);
                head = head.next;
            }
            lastCleanup = now;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)DiscoveryHndlr.class.getName(), (String)"setNoComputerDiscovery");
        }
    }

    private static void close(Reader reader) {
        block5: {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)DiscoveryHndlr.class.getName(), (String)"close", (String)"reader");
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ignored) {
                    if (!TraceLogger.enableTrace) break block5;
                    TraceLogger.exception((String)DiscoveryHndlr.class.getName(), (String)"close", (Throwable)ignored);
                }
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)DiscoveryHndlr.class.getName(), (String)"close");
        }
    }

    public Response handle(Request request, Transceiver transceiver) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)DiscoveryHndlr.class.getName(), (String)"handle", (String)"request, transceiver");
        }
        this.response = Response.getResponse((short)0, null);
        DiscoveryData data = null;
        if (request.requestData != null) {
            if (!RequestChecker.isDesiredType(DiscoveryData.class, (Request)request, (Response)this.response)) {
                Response traceResult = this.response;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)DiscoveryHndlr.class.getName(), (String)"handle", (Object)traceResult);
                }
                return traceResult;
            }
            data = (DiscoveryData)request.requestData;
        }
        this.dbc = Server.getConnection();
        if (this.dbc == null) {
            Server.setResponseError(this.response, "GEN0050E");
            Response traceResult = this.response;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)DiscoveryHndlr.class.getName(), (String)"handle", (Object)traceResult);
            }
            return traceResult;
        }
        try {
            if (data != null) {
                this.setDiscoveryData(data);
            } else {
                this.saveDiscoveryData(request, transceiver);
            }
        }
        catch (GeneralException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)DiscoveryHndlr.class.getName(), (String)"handle", (Throwable)e);
            }
            Server.setResponseError(this.response, (Exception)((Object)e));
        }
        Server.returnConnection(this.dbc);
        Response traceResult = this.response;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)DiscoveryHndlr.class.getName(), (String)"handle", (Object)traceResult);
        }
        return traceResult;
    }

    private void setDiscoveryData(DiscoveryData data) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)DiscoveryHndlr.class.getName(), (String)"setDiscoveryData", (String)"data");
        }
        try {
            this.discoveryTime = CurrentTime.getTimestamp().getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)RunAnchor.class.getName(), (String)"setDiscoveryData", (Throwable)e);
            }
            return;
        }
        TResLdapTree treeAccessor = new TResLdapTree(this.dbc);
        data.dfLdapTree = treeAccessor.getTrees(data.dfComputerID.computerID);
        treeAccessor = null;
        if (!data.dfNetwareOnlyDiscovery) {
            data.dfNoNetworkDiscovery = false;
        }
        if (data.dfDomain != null && data.dfRunNumber > 0 && !data.dfNetwareOnlyDiscovery) {
            DiscoveryHndlr.setNoComputerDiscovery(data, this.discoveryTime);
        }
        if (data.dfDomain != null) {
            TResPwd pwdAccessor = new TResPwd(this.dbc);
            data.dfNasFiler = pwdAccessor.getDomainVisibleFilers(data.dfDomain);
            String[] defaultLogin = pwdAccessor.getDefaultLogin();
            pwdAccessor = null;
            if (defaultLogin != null) {
                data.dfDefaultNasLogin = defaultLogin[0];
                data.dfDefaultNasPwd = defaultLogin[1];
            }
        }
        data.dfNasVendor = DiscoveryHndlr.getNasConfigFile();
        TSnmpCommunity snmpAccessor = new TSnmpCommunity(this.dbc);
        data.dfCommunity = snmpAccessor.getCommunities();
        data.dfIncludeNonRoot = AgentSvp.saveNonRootExports;
        TStormSettings settingsAccessor = new TStormSettings(this.dbc);
        Settings settings = settingsAccessor.getSettings();
        data.dfExcludeWorkstations = settings.seNoWkstaDiscovery;
        data.pack();
        this.response.responseData = data;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)DiscoveryHndlr.class.getName(), (String)"setDiscoveryData");
        }
    }

    public static String[] getNasConfigFile() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)DiscoveryHndlr.class.getName(), (String)"getNasConfigFile", (String)"");
        }
        String[] nasVendors = null;
        File file = new File(NAS_CONFIG_FILE);
        if (file.exists()) {
            FileReader fReader = null;
            BufferedReader bReader = null;
            try {
                String line;
                fReader = new FileReader(file);
                bReader = new BufferedReader(fReader);
                ArrayList<String> vendorList = new ArrayList<String>();
                while ((line = bReader.readLine()) != null) {
                    vendorList.add(line);
                }
                nasVendors = new String[vendorList.size()];
                vendorList.toArray(nasVendors);
                DiscoveryHndlr.close(fReader);
                DiscoveryHndlr.close(bReader);
            }
            catch (IOException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)DiscoveryHndlr.class.getName(), (String)"getNasConfigFile", (Throwable)e);
                }
                DiscoveryHndlr.close(fReader);
                DiscoveryHndlr.close(bReader);
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)DiscoveryHndlr.class.getName(), (String)"getNasConfigFile");
                }
                throw new GeneralException(MessageLog.getMessage((String)"GEN0133E", (Object)NAS_CONFIG_FILE));
            }
        }
        String[] traceResult = nasVendors;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)DiscoveryHndlr.class.getName(), (String)"getNasConfigFile", traceResult);
        }
        return traceResult;
    }

    private void saveDiscoveryData(Request request, Transceiver transceiver) throws GeneralException {
        boolean didNetworkDiscovery;
        Response phase1Response;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)DiscoveryHndlr.class.getName(), (String)"saveDiscoveryData", (String)"request, transceiver");
        }
        if (!transceiver.transmitResponse(request, phase1Response = Response.getResponse((short)0, null, (byte)0))) {
            phase1Response.returnResponse();
            this.response = null;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)DiscoveryHndlr.class.getName(), (String)"saveDiscoveryData");
            }
            return;
        }
        phase1Response.returnResponse();
        request.requestData = (Serializable)transceiver.receiveData(request);
        if (!RequestChecker.isDesiredType(DiscoveryData.class, (Request)request, (Response)this.response)) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)DiscoveryHndlr.class.getName(), (String)"saveDiscoveryData");
            }
            return;
        }
        DiscoveryData data = (DiscoveryData)request.requestData;
        data.unpack();
        NasFiler diskArrayHead = null;
        NasFiler lastFiler = null;
        NasFiler nf = data.dfNasFiler;
        while (nf != null) {
            NasFiler next = nf.nfNext;
            if (!Constants.isDiskArray((short)nf.nfOSType)) {
                lastFiler = nf;
            } else {
                nf.nfNext = diskArrayHead;
                diskArrayHead = nf;
                if (lastFiler != null) {
                    lastFiler.nfNext = next;
                } else {
                    data.dfNasFiler = next;
                }
            }
            nf = next;
        }
        boolean bl = didNetworkDiscovery = !data.dfNoNetworkDiscovery;
        if (didNetworkDiscovery || data.dfNasFiler != null) {
            short shareOwnerType;
            String shareOwnerName;
            int filerShareID;
            if (data.dfDomain == null || data.dfNasFiler != null && data.dfNasFiler.nfOSType == 23) {
                filerShareID = data.dfComputerID.computerID;
                shareOwnerName = Server.agentMgr.getAgentName(filerShareID);
                shareOwnerType = 1;
            } else {
                if (didNetworkDiscovery) {
                    Domain dom = new Domain();
                    dom.domName = data.dfDomain;
                    TResDomain domAccessor = new TResDomain(this.dbc);
                    domAccessor.getIDs(dom);
                    filerShareID = dom.domID;
                    shareOwnerName = dom.domName;
                } else {
                    filerShareID = -1;
                    shareOwnerName = "ICKYGUY";
                }
                shareOwnerType = 25;
            }
            FilerSaver filerSaver = new FilerSaver(this.dbc, filerShareID, shareOwnerType, !data.dfFirstDiscovery, null, shareOwnerName);
            filerSaver.saveDiscoveryData(data.dfNasFiler);
        }
        if (data.dfDomain != null && didNetworkDiscovery) {
            UnmanagedSaver unmanagedSaver = new UnmanagedSaver(this.dbc);
            unmanagedSaver.save(data.dfDomain, data.dfManageable);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)DiscoveryHndlr.class.getName(), (String)"saveDiscoveryData");
        }
    }

    static {
        block2: {
            NAS_CONFIG_FILE = "configuration" + File.separator + "nas.config";
            runMap = new HashMap();
            try {
                lastCleanup = CurrentTime.getTimestamp().getTime();
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!TraceLogger.enableTrace) break block2;
                TraceLogger.exception((String)RunAnchor.class.getName(), (String)"static_initializer", (Throwable)e);
            }
        }
        varBindOIDs = new int[2][];
        DiscoveryHndlr.varBindOIDs[0] = StormAlerter.COMPUTER_OID;
        DiscoveryHndlr.varBindOIDs[1] = Alerter.ALERT_TYPE_OID;
    }

    private static class RunAnchor
    extends LinkedInteger {
        public long lastRequest;
        public NameList domains;

        public RunAnchor(int runNumber) {
            super(runNumber);
        }
    }
}

