/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import org.eclipse.aperi.TStorm.server.guireq.DeviceRequest;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.connector.ConnectorClient;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.IConfigService;
import org.eclipse.aperi.sanmgmt.middleware.data.Status;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.IDeviceServiceManager;
import org.eclipse.aperi.server.DeviceServerManager;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.handler.DeviceRequestHndlr;
import org.eclipse.aperi.server.req.DeviceServerStatusResp;

public class DeviceServerStatusHndlr
extends DeviceRequestHndlr {
    private static Hashtable<String, String> keyNameToType = new Hashtable();

    public byte getIconStatus(Status s) {
        switch (s.getRunStatus()) {
            case 8: {
                return 1;
            }
        }
        return 2;
    }

    public int deviceAPI(DeviceRequest request, Response response) {
        String methodName = "deviceAPI";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)DeviceServerStatusHndlr.class.getName(), (String)"deviceAPI", (String)"request, response");
        }
        DeviceServerStatusResp status = new DeviceServerStatusResp();
        response.responseData = status;
        DeviceServerManager dsm = Server.getDeviceServerManager();
        org.eclipse.aperi.infrastructure.database.objects.Server deviceServer = dsm.getDeviceServer();
        if (this.handleUnexpectedError(deviceServer, methodName, "deviceServer", response)) {
            return 12;
        }
        DeviceRequestHndlr.initDeviceServerComm(request);
        IDeviceServiceManager proxy = (IDeviceServiceManager)ConnectorClient.getService((String)request.deviceServerHost, (int)request.deviceServerPort, IDeviceServiceManager.class, (String)"DeviceServiceManager");
        if (this.handleUnexpectedError(proxy, methodName, "IDeviceServiceManager proxy", response)) {
            return 12;
        }
        String[] services = null;
        if (TraceLogger.enableTrace) {
            TraceLogger.traceMessage((int)1, (String)this.getClass().getName(), (String)"deviceAPI", (String)"beginning call to proxy.getListOfServices();");
        }
        try {
            services = proxy.getListOfServices();
            if (TraceLogger.enableTrace) {
                TraceLogger.traceMessage((int)1, (String)this.getClass().getName(), (String)"deviceAPI", (String)"ending call to proxy.getListOfServices()");
            }
        }
        catch (UndeclaredThrowableException ute) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)DeviceServerStatusHndlr.class.getName(), (String)"deviceAPI", (Throwable)ute);
            }
            response.status = (short)12;
            response.errorMessage = Util.getString((String)"GUI8208E");
            return 12;
        }
        if (this.handleUnexpectedError(services, methodName, "services", response)) {
            return 12;
        }
        this.loadServerInfo(proxy, status, deviceServer, request);
        if (!this.isUnexpectedlyNull(services, methodName, "services array")) {
            this.loadServicesInfo(proxy, status, deviceServer, request, services);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)DeviceServerStatusHndlr.class.getName(), (String)methodName, (short)response.status);
        }
        return response.status;
    }

    public void loadServicesInfo(IDeviceServiceManager proxy, DeviceServerStatusResp status, org.eclipse.aperi.infrastructure.database.objects.Server deviceServer, DeviceRequest request, String[] services) {
        String methodName = "loadServicesInfo";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)DeviceServerStatusHndlr.class.getName(), (String)methodName, (String)"request, response");
        }
        for (int i = 0; i < services.length; ++i) {
            HashMap properties = null;
            String nameKey = services[i];
            if (this.isUnexpectedlyNull(services[i], methodName, "nameKey = services[i]") || DeviceServerStatusResp.NonserverService.isManager((String)nameKey)) continue;
            try {
                properties = proxy.getServiceProperties(nameKey, Locale.getDefault());
            }
            catch (UndeclaredThrowableException ute) {
                this.handleNoProperties(nameKey, status);
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.exception((String)DeviceServerStatusHndlr.class.getName(), (String)"deviceAPI", (Throwable)ute);
                continue;
            }
            if (this.isUnexpectedlyNull(properties, methodName, "properties")) {
                this.handleNoProperties(nameKey, status);
                continue;
            }
            Object objUiName = properties.get("Name");
            String uiName = this.isUnexpectedlyNull(objUiName, methodName, "Name") ? nameKey : (String)objUiName;
            String ID = (String)properties.get("ID");
            String uniqueType = this.isUnexpectedlyNull(ID, methodName, "ID") ? this.getType(nameKey) : this.getType(ID);
            DeviceServerStatusResp.NonserverService r = null;
            Status s = (Status)properties.get("RunStatus");
            if (this.isUnexpectedlyNull(s, methodName, "Status s")) {
                s = new Status();
            }
            r = new DeviceServerStatusResp.NonserverService(uiName, "org.eclipse.aperi.server.svp.GuiSvp", uniqueType, this.getIconStatus(s), (String)properties.get("Description"), (String)properties.get("Version"), (String)properties.get("Status"), (String)properties.get("Available"), (String)properties.get("DeployedStatus"));
            status.addService(r);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)DeviceServerStatusHndlr.class.getName(), (String)methodName);
        }
    }

    private void handleNoProperties(String nameKey, DeviceServerStatusResp status) {
        Status s = new Status(2, 2);
        String uiName = nameKey;
        String uniqueType = this.getType(nameKey);
        status.addService(new DeviceServerStatusResp.NonserverService(uiName, "org.eclipse.aperi.server.svp.GuiSvp", uniqueType, 2, "", "", s.getLocalizedStatusAsText(Locale.getDefault()), "", ""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadServerInfo(IDeviceServiceManager proxy, DeviceServerStatusResp status, org.eclipse.aperi.infrastructure.database.objects.Server deviceServer, DeviceRequest request) {
        block52: {
            methodName = "loadServerInfo";
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)DeviceServerStatusHndlr.class.getName(), (String)methodName, (String)"status, deviceServer, request");
            }
            status.setRequestType("org.eclipse.aperi.server.svp.GuiSvp");
            status.setUniqueRequestType("org.eclipse.aperi.DeviceServer");
            status.setState((byte)1);
            status.setServerName(deviceServer.getServerName());
            status.setPort(deviceServer.getPortNumber());
            status.setVMSize(proxy.getVMSize());
            status.setStartTime(proxy.getStartupTime());
            status.setElapsedTime(proxy.getElapseTime());
            cs = (IConfigService)ConnectorClient.getService((String)request.deviceServerHost, (int)request.deviceServerPort, IConfigService.class, (String)"ConfigService");
            url = "";
            driver = "";
            poolCount = "";
            if (!this.isUnexpectedlyNull(cs, methodName, "IConfigService cs (a proxy)") && !this.isUnexpectedlyNull(p = cs.getProperties("database"), methodName, "cs.getProperties(IConfigService.DB_GROUP)")) {
                url = p.getProperty("tivoli.sanmgmt.jdbc.dbURL");
                driver = p.getProperty("tivoli.sanmgmt.jdbc.dbDriver");
                poolCount = p.getProperty("tivoli.sanmgmt.jdbc.conpool.max");
            }
            status.setJdbcUrl(url);
            status.setJdbcDriver(driver);
            status.setDbPoolCount(poolCount);
            rs = null;
            rs1 = null;
            connection = null;
            try {
                block54: {
                    block53: {
                        ds = DBConnPoolDataSource.getInstance();
                        if (!this.isUnexpectedlyNull(ds, methodName, "DBConnPoolDataSource.getInstance()")) break block53;
                        if (TraceLogger.enableTrace) {
                            TraceLogger.exit((String)DeviceServerStatusHndlr.class.getName(), (String)methodName);
                        }
                        var17_15 = null;
                        ** GOTO lbl112
                    }
                    connection = (DBConnection)ds.getPooledConnection();
                    if (!this.isUnexpectedlyNull(connection, methodName, "(DBConnection) ds.getPooledConnection()")) break block54;
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit((String)DeviceServerStatusHndlr.class.getName(), (String)methodName);
                    }
                    ** GOTO lbl136
                }
                devAgentQuery = "select count (DEVICE_AGENT_ID) from t_res_device_agent";
                rs = ComplexQuery.sqlQuery((DBConnection)connection, (String)devAgentQuery, null);
                if (!this.isUnexpectedlyNull(rs, methodName, "ComplexQuery.sqlQuery(connection, devAgentQuery, null)")) {
                    while (rs.next()) {
                        status.setTotalAgents(rs.getInt(1));
                    }
                }
                devAgentInactiveQuery = "select count (DEVICE_AGENT_ID) from t_res_device_agent where status != 'ac'";
                rs1 = ComplexQuery.sqlQuery((DBConnection)connection, (String)devAgentInactiveQuery, null);
                if (!this.isUnexpectedlyNull(rs, methodName, "ComplexQuery.sqlQuery(connection, devAgentInactiveQuery, null)")) {
                    while (rs.next()) {
                        status.setInactiveAgents(rs.getInt(1));
                    }
                }
                ** GOTO lbl161
            }
            catch (Exception e) {
                block43: {
                    block42: {
                        if (TraceLogger.enableTrace) {
                            TraceLogger.exception((String)DeviceServerStatusHndlr.class.getName(), (String)methodName, (Throwable)e);
                        }
                        var17_18 = null;
                        try {
                            if (rs != null) {
                                rs.getStatement().close();
                            }
                        }
                        catch (Exception e1) {
                            if (!TraceLogger.enableTrace) break block42;
                            TraceLogger.exception((String)DeviceServerStatusHndlr.class.getName(), (String)methodName, (Throwable)e1);
                        }
                    }
                    try {
                        if (rs1 != null) {
                            rs1.getStatement().close();
                        }
                    }
                    catch (Exception e1) {
                        if (!TraceLogger.enableTrace) break block43;
                        TraceLogger.exception((String)DeviceServerStatusHndlr.class.getName(), (String)methodName, (Throwable)e1);
                    }
                }
                try {
                    if (connection == null) return;
                    connection.close();
                    return;
                }
                catch (Exception e2) {
                    if (TraceLogger.enableTrace == false) return;
                    TraceLogger.exception((String)DeviceServerStatusHndlr.class.getName(), (String)methodName, (Throwable)e2);
                }
                return;
            }
            {
                block51: {
                    block50: {
                        block49: {
                            block48: {
                                block47: {
                                    block46: {
                                        catch (Throwable var16_27) {
                                            block45: {
                                                block44: {
                                                    var17_19 = null;
                                                    ** try [egrp 2[TRYBLOCK] [8 : 432->448)] { 
lbl89:
                                                    // 1 sources

                                                    if (rs != null) {
                                                        rs.getStatement().close();
                                                    }
                                                    break block44;
lbl92:
                                                    // 1 sources

                                                    catch (Exception e1) {
                                                        if (!TraceLogger.enableTrace) break block44;
                                                        TraceLogger.exception((String)DeviceServerStatusHndlr.class.getName(), (String)methodName, (Throwable)e1);
                                                    }
                                                }
                                                ** try [egrp 3[TRYBLOCK] [9 : 469->485)] { 
lbl97:
                                                // 1 sources

                                                if (rs1 != null) {
                                                    rs1.getStatement().close();
                                                }
                                                break block45;
lbl100:
                                                // 1 sources

                                                catch (Exception e1) {
                                                    if (!TraceLogger.enableTrace) break block45;
                                                    TraceLogger.exception((String)DeviceServerStatusHndlr.class.getName(), (String)methodName, (Throwable)e1);
                                                }
                                            }
                                            ** try [egrp 4[TRYBLOCK] [10 : 506->519)] { 
lbl105:
                                            // 1 sources

                                            if (connection == null) throw var16_27;
                                            connection.close();
                                            throw var16_27;
lbl108:
                                            // 1 sources

                                            catch (Exception e2) {
                                                if (TraceLogger.enableTrace == false) throw var16_27;
                                                TraceLogger.exception((String)DeviceServerStatusHndlr.class.getName(), (String)methodName, (Throwable)e2);
                                            }
                                            throw var16_27;
                                        }
lbl112:
                                        // 1 sources

                                        ** try [egrp 2[TRYBLOCK] [8 : 432->448)] { 
lbl113:
                                        // 1 sources

                                        if (rs != null) {
                                            rs.getStatement().close();
                                        }
                                        break block46;
lbl116:
                                        // 1 sources

                                        catch (Exception e1) {
                                            if (!TraceLogger.enableTrace) break block46;
                                            TraceLogger.exception((String)DeviceServerStatusHndlr.class.getName(), (String)methodName, (Throwable)e1);
                                        }
                                    }
                                    ** try [egrp 3[TRYBLOCK] [9 : 469->485)] { 
lbl121:
                                    // 1 sources

                                    if (rs1 != null) {
                                        rs1.getStatement().close();
                                    }
                                    break block47;
lbl124:
                                    // 1 sources

                                    catch (Exception e1) {
                                        if (!TraceLogger.enableTrace) break block47;
                                        TraceLogger.exception((String)DeviceServerStatusHndlr.class.getName(), (String)methodName, (Throwable)e1);
                                    }
                                }
                                ** try [egrp 4[TRYBLOCK] [10 : 506->519)] { 
lbl129:
                                // 1 sources

                                if (connection == null) return;
                                connection.close();
                                return;
lbl132:
                                // 1 sources

                                catch (Exception e2) {
                                    if (TraceLogger.enableTrace == false) return;
                                    TraceLogger.exception((String)DeviceServerStatusHndlr.class.getName(), (String)methodName, (Throwable)e2);
                                }
                                return;
lbl136:
                                // 1 sources

                                var17_16 = null;
                                ** try [egrp 2[TRYBLOCK] [8 : 432->448)] { 
lbl138:
                                // 1 sources

                                if (rs != null) {
                                    rs.getStatement().close();
                                }
                                break block48;
lbl141:
                                // 1 sources

                                catch (Exception e1) {
                                    if (!TraceLogger.enableTrace) break block48;
                                    TraceLogger.exception((String)DeviceServerStatusHndlr.class.getName(), (String)methodName, (Throwable)e1);
                                }
                            }
                            ** try [egrp 3[TRYBLOCK] [9 : 469->485)] { 
lbl146:
                            // 1 sources

                            if (rs1 != null) {
                                rs1.getStatement().close();
                            }
                            break block49;
lbl149:
                            // 1 sources

                            catch (Exception e1) {
                                if (!TraceLogger.enableTrace) break block49;
                                TraceLogger.exception((String)DeviceServerStatusHndlr.class.getName(), (String)methodName, (Throwable)e1);
                            }
                        }
                        ** try [egrp 4[TRYBLOCK] [10 : 506->519)] { 
lbl154:
                        // 1 sources

                        if (connection == null) return;
                        connection.close();
                        return;
lbl157:
                        // 1 sources

                        catch (Exception e2) {
                            if (TraceLogger.enableTrace == false) return;
                            TraceLogger.exception((String)DeviceServerStatusHndlr.class.getName(), (String)methodName, (Throwable)e2);
                        }
                        return;
lbl161:
                        // 1 sources

                        var17_17 = null;
                        ** try [egrp 2[TRYBLOCK] [8 : 432->448)] { 
lbl163:
                        // 1 sources

                        if (rs != null) {
                            rs.getStatement().close();
                        }
                        break block50;
lbl166:
                        // 1 sources

                        catch (Exception e1) {
                            if (!TraceLogger.enableTrace) break block50;
                            TraceLogger.exception((String)DeviceServerStatusHndlr.class.getName(), (String)methodName, (Throwable)e1);
                        }
                    }
                    ** try [egrp 3[TRYBLOCK] [9 : 469->485)] { 
lbl171:
                    // 1 sources

                    if (rs1 != null) {
                        rs1.getStatement().close();
                    }
                    break block51;
lbl174:
                    // 1 sources

                    catch (Exception e1) {
                        if (!TraceLogger.enableTrace) break block51;
                        TraceLogger.exception((String)DeviceServerStatusHndlr.class.getName(), (String)methodName, (Throwable)e1);
                    }
                }
                ** try [egrp 4[TRYBLOCK] [10 : 506->519)] { 
lbl179:
                // 1 sources

                if (connection != null) {
                    connection.close();
                }
lbl183:
                // 1 sources

                catch (Exception e2) {}
                if (!TraceLogger.enableTrace) break block52;
                TraceLogger.exception((String)DeviceServerStatusHndlr.class.getName(), (String)methodName, (Throwable)e2);
            }
        }
        if (TraceLogger.enableTrace == false) return;
        TraceLogger.exit((String)DeviceServerStatusHndlr.class.getName(), (String)methodName);
    }

    private boolean isUnexpectedlyNull(Object o, String method, String variable) {
        if (o != null) {
            return false;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.traceMessage((int)1, (String)this.getClass().getName(), (String)method, (String)("this variable was unexpectedly null - [" + variable + "]"));
        }
        return true;
    }

    private boolean handleUnexpectedError(Object o, String method, String variable, Response r) {
        if (this.isUnexpectedlyNull(o, method, variable)) {
            r.status = (short)12;
            r.errorMessage = Util.getString((String)"GUI8208E");
            return true;
        }
        return false;
    }

    private String getType(String keyName) {
        if (keyNameToType.containsKey(keyName)) {
            return keyNameToType.get(keyName);
        }
        return "org.eclipse.aperi.DeviceServer.Unknown";
    }

    static {
        keyNameToType.put("DiskManagerService", "org.eclipse.aperi.DeviceServer.DiskManagerService");
        keyNameToType.put("SANHostMgr", "org.eclipse.aperi.DeviceServer.SANHostManager");
        keyNameToType.put("SANEventCorrelatorFactory", "org.eclipse.aperi.DeviceServer.SANEventCorrelatorFactory");
        keyNameToType.put("SNMPAgentManager", "org.eclipse.aperi.DeviceServer.SNMPAgentManager");
        keyNameToType.put("ControlService", "org.eclipse.aperi.DeviceServer.ControlService");
        keyNameToType.put("Log", "org.eclipse.aperi.DeviceServer.Log");
        keyNameToType.put("ConfigService", "org.eclipse.aperi.DeviceServer.ConfigService");
        keyNameToType.put("DiscoverService", "org.eclipse.aperi.DeviceServer.DiscoverService");
        keyNameToType.put("FabricManagerService", "org.eclipse.aperi.DeviceServer.FabricManagerService");
        keyNameToType.put("MessagingService", "org.eclipse.aperi.DeviceServer.MessagingService");
        keyNameToType.put("DeviceServiceManager", "org.eclipse.aperi.DeviceServer.DeviceServiceManager");
        keyNameToType.put("TapeManagerService", "org.eclipse.aperi.DeviceServer.TapeManager");
        keyNameToType.put("DiskMonitorService", "org.eclipse.aperi.DeviceServer.DiskMonitor");
    }
}

