/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui;

import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.util.HashMap;
import org.eclipse.aperi.TStorm.common.GroupDefinition;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.backend.LockManager;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.CreateHeader;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.constants.metadata.ResourceTypeManager;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.NameListQueryable;
import org.eclipse.aperi.repository.RaceConditionChecker;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.table.TGroup;
import org.eclipse.aperi.repository.table.TGroup2Mask;
import org.eclipse.aperi.repository.table.TGroup2Res;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.scheduler.ScheduleQueue;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThrowAway;
import org.eclipse.aperi.xmsg.MessageLog;

public class GroupDefHndlr
implements RequestHandler,
ThrowAway {
    private static final String RESOURCE_TYPE = "GROUP";
    public static short MONITORING_GROUP = 1;
    public static short REPORTING_GROUP = (short)2;
    private GroupDefinition requestData;
    private Response response;
    private Connection dbc;
    private String objectType;

    private NameList getCurrentMembers() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)GroupDefHndlr.class.getName(), (String)"getCurrentMembers", (String)"");
        }
        NameList groupCurMembers = null;
        if (GroupDefHndlr.whichGroup(this.requestData.groupType) == MONITORING_GROUP) {
            GuiListReq req = new GuiListReq();
            req.groupID = this.requestData.ID;
            NameListQueryable accessor = this.getAccessor(ResourceTypeManager.getGroupAcessor((short)this.requestData.groupType), this.dbc);
            if (this.requestData.groupType == 0) {
                req.includeUnmanaged = true;
            }
            req.listRequested = this.requestData.groupType + 1;
            groupCurMembers = accessor.selectNames(req);
        } else {
            TGroup2Res g2rAccessor = new TGroup2Res(this.dbc);
            groupCurMembers = g2rAccessor.getMembers(this.requestData.ID, this.requestData.groupType);
        }
        NameList traceResult = groupCurMembers;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GroupDefHndlr.class.getName(), (String)"getCurrentMembers", (Object)traceResult);
        }
        return traceResult;
    }

    private NameList getCurrentMasks() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)GroupDefHndlr.class.getName(), (String)"getCurrentMasks", (String)"");
        }
        TGroup2Mask g2m = new TGroup2Mask(this.dbc);
        NameList traceResult = g2m.retrieveMasksByGID(this.requestData.ID);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GroupDefHndlr.class.getName(), (String)"getCurrentMasks", (Object)traceResult);
        }
        return traceResult;
    }

    private void retrieve(String subtype) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)GroupDefHndlr.class.getName(), (String)"retrieve", (String)"subtype");
        }
        TGroup parentAccessor = new TGroup(this.dbc);
        parentAccessor.retrieve((CreateHeader)this.requestData, this.objectType);
        parentAccessor = null;
        if (subtype.equals("org.eclipse.aperi.server.handler.gui.GroupDefHndlr.Information")) {
            TGroup2Res g2rAccessor = new TGroup2Res(this.dbc);
            this.requestData.members = g2rAccessor.getFSforComputer(this.requestData.members, this.requestData.ID, this.requestData.groupType);
        } else {
            this.requestData.members = this.getCurrentMembers();
            if ((GroupDefHndlr.whichGroup(this.requestData.groupType) == REPORTING_GROUP || this.requestData.groupType == 98) && this.requestData.groupType != 99) {
                this.requestData.maskList = this.getCurrentMasks();
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GroupDefHndlr.class.getName(), (String)"retrieve");
        }
    }

    private void save() throws GeneralException {
        String action;
        String s;
        NameList nl;
        MutableInteger key;
        boolean rowExists;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)GroupDefHndlr.class.getName(), (String)"save", (String)"");
        }
        String checkerWarning = null;
        NameList members = null;
        NameList tailAdd = null;
        NameList tailRemove = null;
        NameList masks = null;
        if (this.requestData.ID <= 0) {
            this.requestData.ID = StorageRepositoryAccessor.getIdentifier(1, 1, this.dbc);
            rowExists = false;
        } else {
            RaceConditionChecker checker = new RaceConditionChecker(this.dbc, "t_group", "group_id", (CreateHeader)this.requestData, this.objectType);
            checker.check();
            checkerWarning = checker.message;
            rowExists = !checker.wasDeleted;
            checker = null;
            if (rowExists) {
                members = this.getCurrentMembers();
                if (GroupDefHndlr.whichGroup(this.requestData.groupType) == REPORTING_GROUP) {
                    masks = this.getCurrentMasks();
                }
            }
        }
        NameList reqMembers = this.requestData.members;
        HashMap<MutableInteger, NameList> map = new HashMap<MutableInteger, NameList>();
        while (members != null) {
            key = new MutableInteger(members.nlID);
            map.put(key, members);
            members = members.nlNext;
        }
        NameList toAdd = null;
        key = new MutableInteger();
        members = reqMembers;
        while (members != null) {
            key.value = members.nlID;
            if (map.remove(key) == null) {
                NameList element = (NameList)members.clone();
                element.nlNext = toAdd;
                toAdd = element;
                if (toAdd.nlNext == null) {
                    tailAdd = toAdd;
                }
            }
            members = members.nlNext;
        }
        for (NameList element : map.values()) {
            element.nlNext = members;
            members = element;
            if (members.nlNext != null) continue;
            tailRemove = members;
        }
        map = null;
        NameList nl1 = nl = toAdd;
        while (nl1 != null) {
            int count = 0;
            while (nl != null) {
                if (nl1.nlID == nl.nlID) {
                    ++count;
                }
                nl = nl.nlNext;
            }
            if (count > 1) {
                String s2 = MessageLog.getMessage((String)"SRV0162E");
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)GroupDefHndlr.class.getName(), (String)"save");
                }
                throw new GeneralException(s2);
            }
            nl1 = nl1.nlNext;
        }
        NameList mask = null;
        NameList toAddmasks = null;
        NameList toRemovemasks = null;
        NameList toRetainmasks = null;
        map = new HashMap();
        mask = masks;
        while (mask != null) {
            s = mask.nlName;
            key = new MutableInteger(s.hashCode());
            map.put(key, mask);
            mask = mask.nlNext;
        }
        key = new MutableInteger();
        mask = this.requestData.maskList;
        while (mask != null) {
            NameList element;
            s = mask.nlName;
            key = new MutableInteger(s.hashCode());
            if (map.remove(key) == null) {
                element = (NameList)mask.clone();
                element.nlNext = toAddmasks;
                toAddmasks = element;
            } else {
                element = (NameList)mask.clone();
                element.nlNext = toRetainmasks;
                toRetainmasks = element;
            }
            mask = mask.nlNext;
        }
        for (NameList element : map.values()) {
            element.nlNext = toRemovemasks;
            toRemovemasks = element;
        }
        map = null;
        TGroup accessor = new TGroup(this.dbc);
        if (rowExists) {
            accessor.deleteByID(this.requestData.ID, this.objectType);
        }
        accessor.insert((CreateHeader)this.requestData, this.requestData.groupType, this.objectType);
        if (GroupDefHndlr.whichGroup(this.requestData.groupType) == MONITORING_GROUP) {
            if (members != null) {
                accessor.setGroup(ResourceTypeManager.getGroupTable((short)this.requestData.groupType), ResourceTypeManager.getGroupIdColumn((short)this.requestData.groupType), ResourceTypeManager.getDefaultGroup((short)this.requestData.groupType), members);
            }
            if (toAdd != null) {
                accessor.setGroup(ResourceTypeManager.getGroupTable((short)this.requestData.groupType), ResourceTypeManager.getGroupIdColumn((short)this.requestData.groupType), this.requestData.ID, toAdd);
            }
            if (this.requestData.groupType == 77 || this.requestData.groupType == 113 || this.requestData.groupType == 133) {
                accessor.commit();
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)GroupDefHndlr.class.getName(), (String)"save");
                }
                return;
            }
        }
        String string = action = rowExists ? "Modify group" : "Create group";
        if (TraceLogger.enableAudit) {
            TraceLogger.auditMessage((String)GroupDefHndlr.class.getName(), (String)"save()", (String)("\n Username=" + this.requestData.creator + " " + action + ".  Group name='" + this.requestData.getName() + "'"));
        }
        TGroup2Mask g2m = new TGroup2Mask(this.dbc);
        g2m.handleInsertDelete(this.requestData.ID, toAddmasks, toRemovemasks, false);
        if (toAddmasks != null) {
            if (toAdd != null) {
                tailAdd.nlNext = this.resolveMaskMembers(toRetainmasks, toAddmasks);
            } else {
                toAdd = this.resolveMaskMembers(toRetainmasks, toAddmasks);
            }
        }
        if (toRemovemasks != null) {
            if (members != null) {
                tailRemove.nlNext = this.resolveMaskMembers(toRetainmasks, toRemovemasks);
            } else {
                members = this.resolveMaskMembers(toRetainmasks, toRemovemasks);
            }
        }
        try {
            TGroup2Res r_accessor = new TGroup2Res(this.dbc);
            r_accessor.addRemoveResources(this.requestData.ID, this.requestData.groupType, toAdd, members, true);
        }
        catch (GeneralException ge) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)GroupDefHndlr.class.getName(), (String)"save", (Throwable)ge);
            }
            if (!rowExists) {
                accessor.deleteByID(this.requestData.ID, this.objectType);
            }
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)GroupDefHndlr.class.getName(), (String)"save");
            }
            throw ge;
        }
        accessor.commit();
        if (this.requestData.groupType == 0 || this.requestData.groupType == 2) {
            ScheduleQueue.routine.rebuild();
        }
        if (checkerWarning != null) {
            this.response.status = (short)4;
            this.response.errorMessage = checkerWarning;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GroupDefHndlr.class.getName(), (String)"save");
        }
    }

    private NameList resolveMaskMembers(NameList currMasks, NameList newMasks) throws GeneralException {
        MutableInteger key;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)GroupDefHndlr.class.getName(), (String)"resolveMaskMembers", (String)"currMasks, newMasks");
        }
        NameList currMembers = null;
        NameList newMembers = null;
        NameList members = null;
        TGroup2Mask gm = new TGroup2Mask(this.dbc);
        currMembers = gm.getResourcesForList(currMasks);
        newMembers = gm.getResourcesForList(newMasks);
        HashMap<MutableInteger, NameList> map = new HashMap<MutableInteger, NameList>();
        while (newMembers != null) {
            key = new MutableInteger(newMembers.nlID);
            map.put(key, newMembers);
            newMembers = newMembers.nlNext;
        }
        key = new MutableInteger();
        members = currMembers;
        while (members != null) {
            key.value = members.nlID;
            map.remove(key);
            members = members.nlNext;
        }
        members = null;
        for (NameList element : map.values()) {
            element.nlNext = members;
            members = element;
        }
        map = null;
        NameList traceResult = members;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GroupDefHndlr.class.getName(), (String)"resolveMaskMembers", (Object)traceResult);
        }
        return traceResult;
    }

    public static String translateGroup(short groupType, Response response) {
        String label;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)GroupDefHndlr.class.getName(), (String)"translateIndex", (String)"groupType, response");
        }
        if ((label = ResourceTypeManager.getGroupLabel((short)groupType)) == null) {
            Server.setResponseError(response, "STS0105E", new Object[]{groupType});
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GroupDefHndlr.class.getName(), (String)"translateIndex", (Object)label);
        }
        return label;
    }

    public static short whichGroup(short grpType) {
        short grp = 0;
        if (grpType == 2 || grpType == 0 || grpType == 77 || grpType == 113 || grpType == 133) {
            grp = MONITORING_GROUP;
        } else if (grpType == 89 || grpType == 90 || grpType == 99) {
            grp = REPORTING_GROUP;
        }
        return grp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createGroupWithMembers(GroupDefinition def, String groupName) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)GroupDefHndlr.class.getName(), (String)"createGroupWithMembers", (String)"def, groupName");
        }
        this.requestData = def;
        String resourceName = Integer.toString(this.requestData.ID);
        LockManager.lock((short)0, (String)RESOURCE_TYPE, (String)resourceName, (byte)1, (boolean)true);
        this.dbc = Server.getConnection();
        try {
            TGroup accessor = new TGroup(this.dbc);
            accessor.insert((CreateHeader)this.requestData, this.requestData.groupType, groupName);
            TGroup2Res r_accessor = new TGroup2Res(this.dbc);
            r_accessor.addRemoveResources(this.requestData.ID, this.requestData.groupType, this.requestData.members, null, true);
            accessor.commit();
        }
        catch (GeneralException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)GroupDefHndlr.class.getName(), (String)"createGroupWithMembers", (Throwable)e);
            }
        }
        finally {
            if (resourceName != null) {
                LockManager.unLock((short)0, (String)RESOURCE_TYPE, (String)resourceName);
            }
            Server.returnConnection(this.dbc);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GroupDefHndlr.class.getName(), (String)"createGroupWithMembers");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response handle(Request request, Transceiver transceiver) {
        String resourceName;
        boolean forRetrieve;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)GroupDefHndlr.class.getName(), (String)"handle", (String)"request, transceiver");
        }
        this.response = Response.getResponse((short)0, null);
        if (!RequestChecker.isDesiredType(GroupDefinition.class, (Request)request, (Response)this.response)) {
            Response traceResult = this.response;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)GroupDefHndlr.class.getName(), (String)"handle", (Object)traceResult);
            }
            return traceResult;
        }
        this.requestData = (GroupDefinition)request.requestData;
        this.objectType = GroupDefHndlr.translateGroup(this.requestData.groupType, this.response);
        if (this.objectType == null) {
            Response traceResult = this.response;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)GroupDefHndlr.class.getName(), (String)"handle", (Object)traceResult);
            }
            return traceResult;
        }
        this.dbc = Server.getConnection();
        if (request.subType.equals("org.eclipse.aperi.server.handler.gui.GroupDefHndlr.Information")) {
            forRetrieve = true;
        } else {
            boolean bl = forRetrieve = this.requestData.members == null && this.requestData.maskList == null && this.requestData.ID > 0;
        }
        if (this.requestData.ID <= 0) {
            resourceName = null;
        } else {
            resourceName = Integer.toString(this.requestData.ID);
            byte lockType = forRetrieve ? (byte)2 : 1;
            LockManager.lock((short)0, (String)RESOURCE_TYPE, (String)resourceName, (byte)lockType, (boolean)true);
        }
        try {
            if (forRetrieve) {
                this.retrieve(request.subType);
            } else {
                this.save();
            }
            this.response.responseData = this.requestData;
        }
        catch (GeneralException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)GroupDefHndlr.class.getName(), (String)"handle", (Throwable)e);
            }
            if (this.response.status <= 4) {
                this.response.status = (short)12;
            }
            this.response.errorMessage = e.getMessage();
        }
        finally {
            if (resourceName != null) {
                LockManager.unLock((short)0, (String)RESOURCE_TYPE, (String)resourceName);
            }
            Server.returnConnection(this.dbc);
        }
        Response traceResult = this.response;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GroupDefHndlr.class.getName(), (String)"handle", (Object)traceResult);
        }
        return traceResult;
    }

    private NameListQueryable getAccessor(Class accessorClass, Connection connection) throws GeneralException {
        try {
            Constructor<?> connectionConstructor = null;
            Constructor<?>[] constructors = accessorClass.getConstructors();
            for (int i = 0; i < constructors.length; ++i) {
                Constructor<?> c = constructors[i];
                Class<?>[] parameterTypes = c.getParameterTypes();
                if (parameterTypes.length != 1 || !parameterTypes[0].equals(Connection.class)) continue;
                connectionConstructor = c;
                break;
            }
            if (connectionConstructor != null) {
                return (NameListQueryable)connectionConstructor.newInstance(connection);
            }
            return (NameListQueryable)accessorClass.newInstance();
        }
        catch (Exception e) {
            GeneralException ge = new GeneralException();
            ge.initCause((Throwable)e);
            throw ge;
        }
    }
}

