/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui;

import java.io.Serializable;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.aperi.Nas.common.NasFiler;
import org.eclipse.aperi.San.common.Lun;
import org.eclipse.aperi.TStorm.common.Chunk;
import org.eclipse.aperi.TStorm.common.ChunkCollection;
import org.eclipse.aperi.TStorm.common.Cluster;
import org.eclipse.aperi.TStorm.common.Computer;
import org.eclipse.aperi.TStorm.common.DevAccess;
import org.eclipse.aperi.TStorm.common.Device;
import org.eclipse.aperi.TStorm.common.Disk;
import org.eclipse.aperi.TStorm.common.DiskHistory;
import org.eclipse.aperi.TStorm.common.Domain;
import org.eclipse.aperi.TStorm.common.Filesystem;
import org.eclipse.aperi.TStorm.common.LdapTree;
import org.eclipse.aperi.TStorm.common.LogicalDisk;
import org.eclipse.aperi.TStorm.common.Share;
import org.eclipse.aperi.TStorm.common.VolGroup;
import org.eclipse.aperi.TStorm.server.guireq.GuiInfoReq;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.Packable;
import org.eclipse.aperi.common.Packer;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.table.TGroup;
import org.eclipse.aperi.repository.table.TResChunk;
import org.eclipse.aperi.repository.table.TResChunkCollection;
import org.eclipse.aperi.repository.table.TResCluster;
import org.eclipse.aperi.repository.table.TResComputer;
import org.eclipse.aperi.repository.table.TResDevAccess;
import org.eclipse.aperi.repository.table.TResDevice;
import org.eclipse.aperi.repository.table.TResDiskArray;
import org.eclipse.aperi.repository.table.TResDomain;
import org.eclipse.aperi.repository.table.TResFS;
import org.eclipse.aperi.repository.table.TResLogicalDisk;
import org.eclipse.aperi.repository.table.TResShare;
import org.eclipse.aperi.repository.table.TResVolGroup;
import org.eclipse.aperi.repository.table.TStatComputer;
import org.eclipse.aperi.repository.table.TStatDisk;
import org.eclipse.aperi.repository.table.TStatDiskHist;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThreadSafe;
import org.eclipse.aperi.server.handler.agent.BatchReportHndlr;

public class GuiInfoHndlr
implements RequestHandler,
ThreadSafe {
    public Response handle(Request request, Transceiver transceiver) {
        Response response;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)GuiInfoHndlr.class.getName(), (String)"handle", (String)"request, transceiver");
        }
        if (!RequestChecker.isDesiredType(GuiInfoReq.class, (Request)request, (Response)(response = Response.getResponse((short)0, null)))) {
            Response traceResult = response;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)GuiInfoHndlr.class.getName(), (String)"handle", (Object)traceResult);
            }
            return traceResult;
        }
        GuiInfoReq gir = (GuiInfoReq)request.requestData;
        Connection dbc = Server.getConnection();
        if (dbc == null) {
            Server.setResponseError(response, "GEN0050E");
            Response traceResult = response;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)GuiInfoHndlr.class.getName(), (String)"handle", (Object)traceResult);
            }
            return traceResult;
        }
        switch (gir.objectType) {
            case 1: {
                boolean all = gir.objectID == -2;
                boolean forInstall = !all && gir.computerID == -1;
                try {
                    TStatComputer accessorC = new TStatComputer(dbc);
                    Computer c = new Computer();
                    c.cmpID = gir.objectID;
                    if (accessorC.getGuiComputerStats(c)) {
                        response.responseData = c;
                        if (all) {
                            response.responseData = (Serializable)BatchReportHndlr.packComps(c);
                        }
                        if (all || forInstall) break;
                        c.cmpDomain = new Domain();
                        c.cmpDomain.domID = c.cmpDomainID;
                        new TResDomain(dbc).getName(c.cmpDomain);
                        c.cmpGroup = new TGroup(dbc).selectByID(c.cmpGroupID);
                        break;
                    }
                    if (forInstall) break;
                    Server.setResponseError(response, "STS0092E", "Computer", new Integer(gir.objectID));
                }
                catch (GeneralException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)GuiInfoHndlr.class.getName(), (String)"handle", (Throwable)e);
                    }
                    Server.setResponseError(response, (Exception)((Object)e));
                }
                break;
            }
            case 2: {
                try {
                    TResDevice devAccessor = new TResDevice(dbc);
                    boolean isStorageSubsystemDisk = devAccessor.isStorageSubsystemDisk(gir.objectID);
                    boolean isSVCMdisk = devAccessor.isSVCMDisk(gir.objectID);
                    DevAccess da = null;
                    Disk disk = null;
                    if (!isStorageSubsystemDisk && !isSVCMdisk) {
                        TResDevAccess accessorDA = new TResDevAccess(dbc);
                        accessorDA.prepSelectByDevice();
                        da = accessorDA.getDevAccess(gir.objectID);
                        accessorDA.closeSelect();
                    } else {
                        da = new DevAccess();
                    }
                    if (da != null) {
                        da.daNextDevice = null;
                        response.responseData = da;
                        TResDevice accessorD = new TResDevice(dbc);
                        accessorD.prepGetDevByID(isSVCMdisk);
                        da.daDevice = accessorD.getDevByID(gir.objectID);
                        accessorD.closeSelect();
                        if (da.daDevice == null) {
                            Server.setResponseError(response, "STS0092E", "Device", new Integer(gir.objectID));
                        } else if (da.daDevice instanceof Disk) {
                            if (!isStorageSubsystemDisk) {
                                TStatDisk accessorDSK = new TStatDisk(dbc);
                                accessorDSK.getLogicalDiskID((Disk)da.daDevice);
                                accessorDSK = null;
                            }
                            TResChunk accessorCHK = new TResChunk(dbc);
                            accessorCHK.prepSelectByDiskID();
                            disk = (Disk)da.daDevice;
                            disk.dskChunk = accessorCHK.getChunksByDiskID(gir.objectID);
                            disk.dskPackedChunks = Chunk.packByCollection((Chunk)disk.dskChunk);
                            accessorCHK.closeSelect();
                        }
                    } else {
                        Server.setResponseError(response, "STS0092E", "Dev Access", new Integer(gir.objectID));
                    }
                    if (disk == null) break;
                    Share share = new Share();
                    TStatDisk diskAccessor = new TStatDisk(dbc);
                    share = diskAccessor.selectHostPaths(disk.devID, isStorageSubsystemDisk, isSVCMdisk);
                    if (isStorageSubsystemDisk || isSVCMdisk) {
                        da.daPath = share.shPath;
                        da.daDevice.devSerialNumber = TResDevice.getGeneratedSerialNumber((Disk)da.daDevice, share);
                    }
                    disk.dskHostPaths = (Share[])Packer.pack((Packable)share);
                }
                catch (GeneralException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)GuiInfoHndlr.class.getName(), (String)"handle", (Throwable)e);
                    }
                    Server.setResponseError(response, (Exception)((Object)e));
                }
                break;
            }
            case 3: {
                try {
                    TStatDisk accessorDSK = new TStatDisk(dbc);
                    Disk dsk = new Disk();
                    dsk.devID = gir.objectID;
                    dsk.devType = 0;
                    dsk.devNext = null;
                    dsk = (Disk)accessorDSK.getDiskByID((Device)dsk);
                    if (dsk != null) {
                        response.responseData = dsk;
                        TStatDiskHist accessorDKH = new TStatDiskHist(dbc);
                        accessorDKH.prepFetchMostRecentByDiskID();
                        dsk.dskHistory = accessorDKH.fetchByDiskID(gir.objectID);
                        accessorDKH.closeSelect();
                        if (dsk.dskHistory != null) break;
                        Server.setResponseError(response, "STS0092E", "Latest Disk History", new Integer(gir.objectID));
                        break;
                    }
                    Server.setResponseError(response, "STS0092E", "Disk", new Integer(gir.objectID));
                }
                catch (GeneralException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)GuiInfoHndlr.class.getName(), (String)"handle", (Throwable)e);
                    }
                    Server.setResponseError(response, (Exception)((Object)e));
                }
                break;
            }
            case 4: {
                try {
                    TStatDiskHist accessorDKH = new TStatDiskHist(dbc);
                    accessorDKH.prepFetchAllByDiskID();
                    DiskHistory dkh = accessorDKH.fetchByDiskID(gir.objectID);
                    accessorDKH.closeSelect();
                    if (dkh != null) {
                        response.responseData = (DiskHistory[])Packer.pack((Packable)dkh);
                        break;
                    }
                    Server.setResponseError(response, "STS0092E", "Disk History", new Integer(gir.objectID));
                }
                catch (GeneralException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)GuiInfoHndlr.class.getName(), (String)"handle", (Throwable)e);
                    }
                    Server.setResponseError(response, (Exception)((Object)e));
                }
                break;
            }
            case 5: {
                try {
                    LogicalDisk ld = new LogicalDisk();
                    ld.ldID = gir.objectID;
                    if (this.getLogicalDisk(ld, dbc, response, gir.computerID)) {
                        Share share = new Share();
                        response.responseData = share;
                        share.shResource = ld;
                        share.shComputerID = gir.computerID;
                        share.shResourceID = gir.objectID;
                        TResFS accessorFS = new TResFS(dbc);
                        accessorFS.prepSelectByLogicalDisk();
                        Filesystem fs = accessorFS.getByLogicalDisk(gir.objectID);
                        accessorFS.closeSelect();
                        ld.ldFilesystem = fs != null && fs.fsComputerID == gir.computerID ? fs : null;
                        TResShare accessorSH = new TResShare(dbc);
                        accessorSH.prepGetUniqueShare();
                        accessorSH.getUniqueShare(share);
                        ld.ldPath = share.shPath;
                        accessorSH.closeSelect();
                        break;
                    }
                    Server.setResponseError(response, "STS0092E", "Logical Disk", new Integer(gir.objectID));
                }
                catch (GeneralException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)GuiInfoHndlr.class.getName(), (String)"handle", (Throwable)e);
                    }
                    Server.setResponseError(response, (Exception)((Object)e));
                }
                break;
            }
            case 18: {
                this.getLunInfo(gir.objectID, dbc, response);
                break;
            }
            case 7: {
                try {
                    TResFS accessorFS = new TResFS(dbc);
                    accessorFS.prepSelectByID();
                    Filesystem fs = accessorFS.getByID(gir.objectID);
                    accessorFS.closeSelect();
                    if (fs != null) {
                        Share sh = new Share();
                        sh.shResource = fs;
                        sh.shComputerID = fs.fsComputerID;
                        sh.shResourceID = fs.fsID;
                        sh.shScanTime = 0L;
                        sh.shRemovedTime = 0L;
                        TResShare accessorSH = new TResShare(dbc);
                        accessorSH.prepGetUniqueShare();
                        accessorSH.getUniqueShare(sh);
                        accessorSH.closeSelect();
                        response.responseData = sh;
                        break;
                    }
                    Server.setResponseError(response, "STS0092E", "Filesystem", new Integer(gir.objectID));
                }
                catch (GeneralException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)GuiInfoHndlr.class.getName(), (String)"handle", (Throwable)e);
                    }
                    Server.setResponseError(response, (Exception)((Object)e));
                }
                break;
            }
            case 19: {
                try {
                    TResDiskArray accessor = new TResDiskArray(dbc);
                    NasFiler filerList = accessor.getDiskArrays(gir.objectID);
                    GuiInfoHndlr.selectGroupNames(dbc, filerList);
                    response.responseData = (Serializable)Packer.pack((Packable)filerList);
                }
                catch (GeneralException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)GuiInfoHndlr.class.getName(), (String)"handle", (Throwable)e);
                    }
                    Server.setResponseError(response, (Exception)((Object)e));
                }
                break;
            }
            case 21: {
                try {
                    TResVolGroup accessor = new TResVolGroup(dbc);
                    VolGroup vg = accessor.getVolGroupByID(gir.objectID, gir.computerID);
                    response.responseData = vg;
                }
                catch (GeneralException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)GuiInfoHndlr.class.getName(), (String)"handle", (Throwable)e);
                    }
                    Server.setResponseError(response, (Exception)((Object)e));
                }
                break;
            }
            case 20: {
                try {
                    LogicalDisk ld = new LogicalDisk();
                    ld.ldID = gir.objectID;
                    if (this.getLogicalDisk(ld, dbc, response, gir.computerID)) {
                        response.responseData = ld;
                        break;
                    }
                    Server.setResponseError(response, "STS0092E", "Logical Unit", new Integer(gir.objectID));
                }
                catch (GeneralException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)GuiInfoHndlr.class.getName(), (String)"handle", (Throwable)e);
                    }
                    Server.setResponseError(response, (Exception)((Object)e));
                }
                break;
            }
            case 22: {
                try {
                    TResCluster accessorC = new TResCluster(dbc);
                    Cluster c = accessorC.getClusterByID(gir.objectID);
                    response.responseData = c;
                    break;
                }
                catch (GeneralException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)GuiInfoHndlr.class.getName(), (String)"handle", (Throwable)e);
                    }
                    Server.setResponseError(response, (Exception)((Object)e));
                }
            }
        }
        Server.returnConnection(dbc);
        Response traceResult = response;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GuiInfoHndlr.class.getName(), (String)"handle", (Object)traceResult);
        }
        return traceResult;
    }

    private static void selectGroupNames(Connection dbc, NasFiler filerList) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)GuiInfoHndlr.class.getName(), (String)"selectGroupNames", (String)"dbc, filerList");
        }
        TGroup accessor = new TGroup(dbc);
        accessor.prepSelectNameByID();
        while (filerList != null) {
            LdapTree structure = new LdapTree();
            structure.setLtName(accessor.fetchNameByID(filerList.nfComputer.cmpGroupID));
            filerList.nfLdapTree = structure;
            filerList = filerList.nfNext;
        }
        accessor.closeSelect();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GuiInfoHndlr.class.getName(), (String)"selectGroupNames");
        }
    }

    private boolean getLogicalDisk(LogicalDisk ld, Connection dbc, Response response, int computerID) throws GeneralException {
        boolean isSVCMDisk;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)GuiInfoHndlr.class.getName(), (String)"getLogicalDisk", (String)"ld, dbc, response");
        }
        TResLogicalDisk accessorLD = new TResLogicalDisk(dbc);
        TResComputer cmpAccessor = new TResComputer(dbc);
        int ssType = -1;
        boolean isStorageSystem = false;
        ssType = computerID > 0 ? (int)cmpAccessor.getStorageSubsystemType(computerID) : (int)accessorLD.getSSTypeForLogicalDisk(ld.ldID);
        isStorageSystem = ssType > -1;
        boolean bl = isSVCMDisk = ssType == 21;
        if (isStorageSystem) {
            accessorLD.prepSelectBySVID();
        } else {
            accessorLD.prepSelectByID();
        }
        boolean status = accessorLD.getLogicalDisk(ld, isStorageSystem);
        if (status) {
            ChunkCollection ccList;
            if (isStorageSystem) {
                Share paths = accessorLD.selectHostPaths(ld);
                ld.ldHostPaths = (Share[])Packer.pack((Packable)paths);
            }
            TResChunkCollection accessorCC = new TResChunkCollection(dbc);
            accessorCC.prepSelectByLogicalDisk();
            ld.ldCollectionList = ccList = accessorCC.getCollections(ld);
            TResChunk accessorCHK = new TResChunk(dbc);
            accessorCHK.prepSelectByCollection();
            TResDevAccess accessorDA = new TResDevAccess(dbc);
            accessorDA.prepSelectByDevice();
            TResDevice accessorDV = new TResDevice(dbc);
            accessorDV.prepGetDevByID(isSVCMDisk);
            TResShare accessorSH = new TResShare(dbc);
            accessorSH.prepGetUniqueShare();
            HashMap diskMap = new HashMap();
            this.getChunkInfo(ccList, accessorDV, accessorDA, accessorCHK, diskMap);
            if (ld.ldMirrorCount > 0) {
                accessorLD.getMirrors(ld, isStorageSystem);
                byte count = 0;
                LogicalDisk ldm = ld.ldNextMirror;
                Share share = new Share();
                share.shComputerID = computerID;
                while (ldm != null) {
                    ++count;
                    ldm.ldCollectionList = ccList = accessorCC.getCollections(ldm);
                    this.getChunkInfo(ccList, accessorDV, accessorDA, accessorCHK, diskMap);
                    share.shResourceID = ldm.ldID;
                    share.shPath = null;
                    accessorSH.getUniqueShare(share);
                    ldm.ldPath = share.shPath;
                    ldm = ldm.ldNextMirror;
                }
                accessorLD.closeSelect();
                if (count != ld.ldMirrorCount) {
                    Server.setResponseWarning(response, "STS0091W", new Integer(ld.ldID));
                }
            }
            ld.pack();
            accessorLD.closeSelect();
            accessorDV.closeSelect();
            accessorCC.closeSelect();
            accessorCHK.closeSelect();
            accessorDA.closeSelect();
            accessorSH.closeSelect();
        }
        boolean traceResult = status;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GuiInfoHndlr.class.getName(), (String)"getLogicalDisk", (boolean)traceResult);
        }
        return traceResult;
    }

    private void getChunkInfo(ChunkCollection ccList, TResDevice accessorDV, TResDevAccess accessorDA, TResChunk accessorCHK, Map diskMap) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)GuiInfoHndlr.class.getName(), (String)"getChunkInfo", (String)"ccList, accessorDV, accessorDA, accessorCHK, diskMap");
        }
        MutableInteger key = new MutableInteger();
        DevAccess devAccess = null;
        Disk disk = null;
        while (ccList != null) {
            Chunk chunk;
            ccList.ccChunkList = chunk = accessorCHK.getChunksByCollection(ccList);
            while (chunk != null) {
                key.value = chunk.chkDiskID;
                disk = (Disk)diskMap.get(key);
                if (disk == null) {
                    disk = (Disk)accessorDV.getDevByID(key.value);
                    if (disk == null) {
                        disk = new Disk();
                    }
                    diskMap.put(key, disk);
                    devAccess = accessorDA.getDevAccess(chunk.chkDiskID);
                    disk.devManufacturer = devAccess != null ? devAccess.daPath : disk.devName;
                }
                chunk.chkDisk = disk;
                chunk = chunk.chkNextInCollection;
            }
            ccList = ccList.ccNext;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GuiInfoHndlr.class.getName(), (String)"getChunkInfo");
        }
    }

    private void getLunInfo(int logicalDiskID, Connection dbc, Response response) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)GuiInfoHndlr.class.getName(), (String)"getLunInfo", (String)"logicalDiskID, dbc, response");
        }
        try {
            TResDiskArray accessorDA = new TResDiskArray(dbc);
            Lun lun = accessorDA.getLunByID(logicalDiskID);
            if (lun == null) {
                Server.setResponseError(response, "STS0092E", "LUN", new Integer(logicalDiskID));
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)GuiInfoHndlr.class.getName(), (String)"getLunInfo");
                }
                return;
            }
            LogicalDisk ld = new LogicalDisk();
            ld.ldID = logicalDiskID;
            if (this.getLogicalDisk(ld, dbc, response, -1)) {
                lun.lunLogicalDisk = ld;
                response.responseData = lun;
            } else {
                Server.setResponseError(response, "STS0092E", "Logical Disk", new Integer(logicalDiskID));
            }
        }
        catch (GeneralException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)GuiInfoHndlr.class.getName(), (String)"getLunInfo", (Throwable)e);
            }
            Server.setResponseError(response, (Exception)((Object)e));
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GuiInfoHndlr.class.getName(), (String)"getLunInfo");
        }
    }
}

