/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui;

import java.sql.Connection;
import org.eclipse.aperi.backend.LockManager;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.ScheduleHeader;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.table.TSchedule;
import org.eclipse.aperi.repository.table.TScript;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.scheduler.ScheduleQueue;
import org.eclipse.aperi.server.Alerter;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThrowAway;
import org.eclipse.aperi.server.handler.gui.GuiScriptHndlr;

public class ScriptDeleteHndlr
implements RequestHandler,
ThrowAway {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response handle(Request request, Transceiver transceiver) {
        Response response;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScriptDeleteHndlr.class.getName(), (String)"handle", (String)"request, transceiver");
        }
        if (RequestChecker.isDesiredType(NameList.class, (Request)request, (Response)(response = Response.getResponse((short)0, null)))) {
            NameList requestData = (NameList)request.requestData;
            Connection dbc = Server.getConnection();
            if (dbc == null) {
                response.status = (short)12;
            } else {
                String type = GuiScriptHndlr.SCRIPT_JOB_TYPE_LABEL;
                String resourceType = "SCRIPT";
                String resourceName = Integer.toString(requestData.nlID);
                try {
                    LockManager.lock((short)0, (String)resourceType, (String)resourceName, (byte)1, (boolean)true);
                    TSchedule scheduleAccessor = new TSchedule(dbc);
                    ScheduleHeader row = new ScheduleHeader();
                    row.ID = requestData.nlID;
                    scheduleAccessor.retrieve(row, type);
                    if (row.alertID > 0) {
                        Alerter.deleteAlert(dbc, row.alertID, false);
                    }
                    TScript scriptAccessor = new TScript(dbc);
                    scriptAccessor.delete(requestData.nlID);
                    scheduleAccessor.deleteByID(requestData.nlID, type, true);
                    scheduleAccessor.commit();
                }
                catch (GeneralException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)ScriptDeleteHndlr.class.getName(), (String)"handle", (Throwable)e);
                    }
                    Server.setResponseError(response, (Exception)((Object)e));
                }
                finally {
                    LockManager.unLock((short)0, (String)resourceType, (String)resourceName);
                    Server.returnConnection(dbc);
                }
                ScheduleQueue.routine.addDelete(requestData.nlID);
            }
        }
        Response traceResult = response;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScriptDeleteHndlr.class.getName(), (String)"handle", (Object)traceResult);
        }
        return traceResult;
    }
}

