/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui.disk;

import java.util.Hashtable;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.common.api.SRMRuntimeException;
import org.eclipse.aperi.gui.common.model.GUIRequestData;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.ThrowAway;
import org.eclipse.aperi.server.handler.gui.disk.GUIEntityFactory;

public class SubsystemInfoHandler
implements RequestHandler,
ThrowAway {
    GUIEntityFactory entityFactory = null;

    public Response handle(Request request, Transceiver transceiver) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SubsystemInfoHandler.class.getName(), (String)"handle", (String)"request, transceiver");
        }
        GUIRequestData reqData = (GUIRequestData)request.requestData;
        Response response = Response.getResponse((short)0, null);
        this.entityFactory = GUIEntityFactory.getInstance();
        try {
            if (reqData.getActionId() == 0) {
                this.getAllStorageSubsystems(reqData, response);
            } else if (reqData.getActionId() == 1) {
                this.getSubsystemPorts(reqData, response);
            } else if (reqData.getActionId() == 2) {
                this.getHostPortsBySubsystem(reqData, response);
            } else if (reqData.getActionId() == 3) {
                this.getStoragePoolsBySubsytstem(reqData, response);
            } else if (reqData.getActionId() == 4) {
                this.getIOGroupsBySVC(reqData, response);
            } else if (reqData.getActionId() == 5) {
                this.getMDiskGroupsBySVC(reqData, response);
            } else if (reqData.getActionId() == 6) {
                this.getUnmanagedMDisksBySVC(reqData, response);
            } else if (reqData.getActionId() == 7) {
                this.getSupportedRaidLevels(reqData, response);
            } else if (reqData.getActionId() == 8) {
                this.getMaxVolumes(reqData, response);
            } else if (reqData.getActionId() == 9) {
                this.getAssignedHostPortsBySubsystem(reqData, response);
            } else if (reqData.getActionId() == 10) {
                this.setStorageSubsystemAttributes(reqData, response);
            } else if (reqData.getActionId() == 12) {
                this.getStorageSubsystemCapabilities(reqData, response);
            }
        }
        catch (Exception ex) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)SubsystemInfoHandler.class.getName(), (String)"handle", (Throwable)ex);
            }
            response.status = (short)12;
            if (ex instanceof SRMRuntimeException) {
                response.errorMessage = ((SRMRuntimeException)ex).getLocalizedMessage();
            } else {
                String[] inserts = new String[]{};
                String msg = ex.getMessage();
                if (msg != null) {
                    inserts = new String[]{msg};
                }
                response.errorMessage = new SRMMessage("HWN021503E", inserts).getLocalizedMessage();
            }
            response.responseData = null;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SubsystemInfoHandler.class.getName(), (String)"handle", (Object)response);
        }
        return response;
    }

    private void getAllStorageSubsystems(GUIRequestData reqData, Response response) throws Exception {
        response.responseData = this.entityFactory.getAllStorageSubsystems();
    }

    private void getSubsystemPorts(GUIRequestData reqData, Response response) throws Exception {
        String subsystemId = (String)((Object)reqData.getParameter("subsystem.id"));
        TraceLogger.traceMessage((int)1, (String)SubsystemInfoHandler.class.getName(), (String)"getSubsystemPorts", (String)("subsystemId: " + subsystemId));
        response.responseData = this.entityFactory.getSubsystemPorts(subsystemId);
    }

    private void getHostPortsBySubsystem(GUIRequestData reqData, Response response) throws Exception {
        String subsystemId = (String)((Object)reqData.getParameter("subsystem.id"));
        TraceLogger.traceMessage((int)1, (String)SubsystemInfoHandler.class.getName(), (String)"getHostPortsBySubsystem", (String)("subsystemId: " + subsystemId));
        response.responseData = this.entityFactory.getHostPortsBySubsystem(subsystemId);
    }

    private void getStoragePoolsBySubsytstem(GUIRequestData reqData, Response response) throws Exception {
        String subsystemId = (String)((Object)reqData.getParameter("subsystem.id"));
        TraceLogger.traceMessage((int)1, (String)SubsystemInfoHandler.class.getName(), (String)"getStoragePoolsBySubsytstem", (String)("subsystemId: " + subsystemId));
        response.responseData = this.entityFactory.getStoragePoolsBySubsytstem(subsystemId);
    }

    private void getIOGroupsBySVC(GUIRequestData reqData, Response response) throws Exception {
        String subsystemId = (String)((Object)reqData.getParameter("subsystem.id"));
        TraceLogger.traceMessage((int)1, (String)SubsystemInfoHandler.class.getName(), (String)"getIOGroupsBySVC", (String)("subsystemId: " + subsystemId));
        response.responseData = this.entityFactory.getIOGroupsBySVC(subsystemId);
    }

    private void getMDiskGroupsBySVC(GUIRequestData reqData, Response response) throws Exception {
        String subsystemId = (String)((Object)reqData.getParameter("subsystem.id"));
        TraceLogger.traceMessage((int)1, (String)SubsystemInfoHandler.class.getName(), (String)"getMDiskGroupsBySVC", (String)("subsystemId: " + subsystemId));
        response.responseData = this.entityFactory.getMDiskGroupsBySVC(subsystemId);
    }

    private void getUnmanagedMDisksBySVC(GUIRequestData reqData, Response response) throws Exception {
        String subsystemId = (String)((Object)reqData.getParameter("subsystem.id"));
        TraceLogger.traceMessage((int)1, (String)SubsystemInfoHandler.class.getName(), (String)"getUnmanagedMDisksBySVC", (String)("subsystemId: " + subsystemId));
        response.responseData = this.entityFactory.getUnmanagedMDisksBySVC(subsystemId);
    }

    private void getSupportedRaidLevels(GUIRequestData reqData, Response response) throws Exception {
        String subsystemId = (String)((Object)reqData.getParameter("subsystem.id"));
        TraceLogger.traceMessage((int)1, (String)SubsystemInfoHandler.class.getName(), (String)"getSupportedRaidLevels", (String)("subsystemId: " + subsystemId));
        response.responseData = this.entityFactory.getSupportedRaidLevels(subsystemId);
    }

    private void getMaxVolumes(GUIRequestData reqData, Response response) throws Exception {
        String subsystemId = (String)((Object)reqData.getParameter("subsystem.id"));
        TraceLogger.traceMessage((int)1, (String)SubsystemInfoHandler.class.getName(), (String)"getMaxVolumes", (String)("subsystemId: " + subsystemId));
        response.responseData = new Long(this.entityFactory.getMaxVolumes(subsystemId));
    }

    private void getAssignedHostPortsBySubsystem(GUIRequestData reqData, Response response) throws Exception {
        String subsystemId = (String)((Object)reqData.getParameter("subsystem.id"));
        TraceLogger.traceMessage((int)1, (String)SubsystemInfoHandler.class.getName(), (String)"getAssignedHostPortsBySubsystem", (String)("subsystemId: " + subsystemId));
        response.responseData = this.entityFactory.getAssignedHostPortsBySubsystem(subsystemId);
    }

    private void setStorageSubsystemAttributes(GUIRequestData reqData, Response response) throws Exception {
        String subsystemId = (String)((Object)reqData.getParameter("subsystem.id"));
        TraceLogger.traceMessage((int)1, (String)SubsystemInfoHandler.class.getName(), (String)"setStorageSubsystemAttributes", (String)("subsystemId: " + subsystemId));
        Hashtable attributes = (Hashtable)reqData.getParameter("subsystem.attrs");
        response.responseData = new Integer(this.entityFactory.setStorageSubsystemAttributes(subsystemId, attributes));
    }

    private void getStorageSubsystemCapabilities(GUIRequestData reqData, Response response) throws Exception {
        String subsystemId = (String)((Object)reqData.getParameter("subsystem.id"));
        TraceLogger.traceMessage((int)1, (String)SubsystemInfoHandler.class.getName(), (String)"getHostsBySubsystem", (String)("subsystemId: " + subsystemId));
        response.responseData = this.entityFactory.getCapabilities(subsystemId);
    }
}

