/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui.nas;

import java.sql.Connection;
import org.eclipse.aperi.TStorm.common.LdapTree;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.table.TResLdapTree;
import org.eclipse.aperi.repository.table.TResPwd;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.scheduler.ScheduleQueue;
import org.eclipse.aperi.server.AgentManager;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThrowAway;

public class NasAdminHndlr
implements RequestHandler,
ThrowAway {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response handle(Request request, Transceiver transceiver) {
        Response response;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)NasAdminHndlr.class.getName(), (String)"handle", (String)"request, transceiver");
        }
        if (RequestChecker.isDesiredType(LdapTree.class, (Request)request, (Response)(response = Response.getResponse((short)0, null)))) {
            LdapTree tree = (LdapTree)request.requestData;
            Connection dbc = Server.getConnection();
            if (dbc == null) {
                Server.setResponseError(response, "GEN0050E");
            } else {
                try {
                    TResPwd accessor = new TResPwd(dbc);
                    Request agentReq = new Request();
                    agentReq.typeCode = "org.eclipse.aperi.agent.svp.AgentSvp";
                    agentReq.subType = "org.eclipse.aperi.agent.handler.nas.LoginAdminHandler";
                    agentReq.serviceName = RequestTypeManager.getInternalName((String)agentReq.typeCode);
                    agentReq.userName = request.userName;
                    agentReq.flags = 0;
                    agentReq.requestData = tree;
                    AgentManager am = Server.getAgentManager();
                    Response agentResp = am.transmitToAgent(agentReq, null, tree.ltComputerID, false);
                    if (agentResp == null) {
                        String name = Server.agentMgr.getAgentName(tree.ltComputerID);
                        Server.setResponseError(response, "NAS0003E", name);
                    } else if (agentResp.status > 4) {
                        response = agentResp;
                    } else {
                        new TResLdapTree(dbc).updateGuiID(tree.ltTreeID, tree.ltComputerID);
                        accessor.prepLoginUpdate();
                        accessor.updateLogin(tree.ltTreeID, tree.ltLdapUser, tree.ltPassword);
                        accessor.closeLoginUpdate();
                        ScheduleQueue.routine.rebuild();
                        response.responseData = agentResp.responseData;
                    }
                }
                catch (GeneralException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)NasAdminHndlr.class.getName(), (String)"handle", (Throwable)e);
                    }
                    Server.setResponseError(response, (Exception)((Object)e));
                }
                finally {
                    Server.returnConnection(dbc);
                }
            }
        }
        Response traceResult = response;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)NasAdminHndlr.class.getName(), (String)"handle", (Object)traceResult);
        }
        return traceResult;
    }
}

