/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui.nas;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.aperi.Nas.common.NasFiler;
import org.eclipse.aperi.TStorm.common.Computer;
import org.eclipse.aperi.TStorm.common.Domain;
import org.eclipse.aperi.TStorm.common.NasFilesystem;
import org.eclipse.aperi.TStorm.server.agentreq.ProbeDefResp;
import org.eclipse.aperi.backend.LockManager;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.TSThread;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.table.TFoundFilesystem;
import org.eclipse.aperi.repository.table.TResDomain;
import org.eclipse.aperi.repository.table.TResFS;
import org.eclipse.aperi.repository.table.TStatComputer;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.scheduler.ScheduleQueue;
import org.eclipse.aperi.server.AgentManager;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThrowAway;
import org.eclipse.aperi.server.UninstallAgentDriver;
import org.eclipse.aperi.server.handler.agent.ProbeDefHndlr;
import org.eclipse.aperi.server.handler.gui.GuiListHndlr;
import org.eclipse.aperi.xmsg.MessageLog;

public class NasGuiAgentHndlr
implements RequestHandler,
ThrowAway {
    private HashMap probeMap;
    private MutableInteger probeKey = new MutableInteger();
    private static Class requestDataClass;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response handle(Request request, Transceiver transceiver) {
        Response response;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)NasGuiAgentHndlr.class.getName(), (String)"handle", (String)"request, transceiver");
        }
        if (RequestChecker.isDesiredType((Class)requestDataClass, (Request)request, (Response)(response = Response.getResponse((short)0, null)))) {
            NasFilesystem[] fsArray = (NasFilesystem[])request.requestData;
            Connection dbc = Server.getConnection();
            if (dbc == null) {
                Server.setResponseError(response, "GEN0050E");
            } else {
                try {
                    this.doDeletes(dbc, fsArray);
                    this.save(dbc, fsArray);
                    ScheduleQueue.routine.rebuild();
                    GuiListHndlr.getNasFsList(dbc, response);
                }
                catch (GeneralException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)NasGuiAgentHndlr.class.getName(), (String)"handle", (Throwable)e);
                    }
                    Server.setResponseError(response, (Exception)((Object)e));
                }
                finally {
                    Server.returnConnection(dbc);
                }
            }
        }
        Response traceResult = response;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)NasGuiAgentHndlr.class.getName(), (String)"handle", (Object)traceResult);
        }
        return traceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDeletes(Connection dbc, NasFilesystem[] fsArray) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)NasGuiAgentHndlr.class.getName(), (String)"doDeletes", (String)"dbc, fsArray");
        }
        NasFilesystem deleteList = null;
        for (int i = 0; i < fsArray.length; ++i) {
            NasFilesystem fs = fsArray[i];
            if (!fs.nflDeleteFiler) continue;
            fs.nflNext = deleteList;
            deleteList = fs;
        }
        if (deleteList == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)NasGuiAgentHndlr.class.getName(), (String)"doDeletes");
            }
            return;
        }
        NasFilesystem fs = deleteList;
        while (fs != null) {
            int computerID = fs.nflComputerID;
            try {
                LockManager.lock((short)2, (String)"Computer", (String)Integer.toString(computerID), (byte)1, (boolean)true);
                if (!UninstallAgentDriver.remove(computerID, false, (byte)1, dbc, true)) {
                    String msg = MessageLog.getMessage((String)"STS0165E", (Object)String.valueOf(computerID));
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit((String)NasGuiAgentHndlr.class.getName(), (String)"doDeletes");
                    }
                    throw new GeneralException(msg);
                }
            }
            finally {
                LockManager.unLock((short)2, (String)"Computer", (String)Integer.toString(computerID));
            }
            fs = fs.nflNext;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)NasGuiAgentHndlr.class.getName(), (String)"doDeletes");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(Connection dbc, NasFilesystem[] fsArray) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)NasGuiAgentHndlr.class.getName(), (String)"save", (String)"dbc, fsArray");
        }
        TResFS fsAccessor = new TResFS(dbc);
        TFoundFilesystem ffAccessor = new TFoundFilesystem(dbc);
        TStatComputer compAccessor = new TStatComputer(dbc);
        Computer computer = new Computer();
        computer.cmpGroupID = 4;
        this.getDomains(dbc, fsArray);
        try {
            fsAccessor.prepUpdateScanAgent();
            ffAccessor.prepUpdateScanAgent();
            compAccessor.prepSaveFiler();
            int index = 0;
            while (index < fsArray.length) {
                NasFilesystem fs = fsArray[index];
                computer.cmpID = fs.nflComputerID;
                computer.cmpOSType = fs.nflOsType;
                computer.cmpManufacturer = fs.nflManufacturer;
                computer.cmpDomain = fs.nflDomain;
                NasFilesystem filerFsList = null;
                boolean deleteFiler = false;
                do {
                    fs = fsArray[index];
                    if (fs.nflComputerID != computer.cmpID) break;
                    if (fs.nflDeleteFiler) {
                        deleteFiler = true;
                    }
                    fs.nflNext = filerFsList;
                    filerFsList = fs;
                } while (++index < fsArray.length);
                if (!deleteFiler) {
                    if (compAccessor.saveFiler(computer)) {
                        this.addToProbeMap(filerFsList);
                    }
                    fsAccessor.updateScanningAgent(filerFsList);
                }
                ffAccessor.updateScanningAgent(filerFsList);
                ffAccessor.commit();
            }
        }
        finally {
            fsAccessor.cleanup();
            ffAccessor.cleanup();
            compAccessor.cleanup();
        }
        if (this.probeMap != null) {
            new InitialNasProbe(this.probeMap).start();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)NasGuiAgentHndlr.class.getName(), (String)"save");
        }
    }

    private void getDomains(Connection dbc, NasFilesystem[] fsArray) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)NasGuiAgentHndlr.class.getName(), (String)"getDomains", (String)"dbc, fsArray");
        }
        HashMap<String, Domain> domainMap = new HashMap<String, Domain>();
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < fsArray.length; ++i) {
            NasFilesystem fs = fsArray[i];
            if (fs.nflDomainName == null) continue;
            String domainName = fs.nflDomainName;
            if (fs.nflOsType == 8) {
                domainName = NasFiler.makeDomainName((String)fs.nflDomainName, (String)fs.nflTreeName, (StringBuffer)buffer);
            }
            fs.nflDomain = (Domain)domainMap.get(domainName);
            if (fs.nflDomain != null) continue;
            fs.nflDomain = new Domain();
            fs.nflDomain.domName = domainName;
            domainMap.put(domainName, fs.nflDomain);
        }
        Domain domainList = null;
        for (Domain domain : domainMap.values()) {
            domain.domNext = domainList;
            domainList = domain;
        }
        if (domainList != null) {
            TResDomain domAccessor = new TResDomain(dbc);
            domAccessor.getIDs(domainList);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)NasGuiAgentHndlr.class.getName(), (String)"getDomains");
        }
    }

    private void addToProbeMap(NasFilesystem fsList) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)NasGuiAgentHndlr.class.getName(), (String)"addToProbeMap", (String)"fsList");
        }
        if (this.probeMap == null) {
            this.probeMap = new HashMap();
        }
        int lastAgentID = 0;
        MutableInteger filer = new MutableInteger(fsList.nflComputerID);
        NasFilesystem fs = fsList;
        while (fs != null) {
            if (fs.nflAgentID != lastAgentID) {
                this.probeKey.value = lastAgentID = fs.nflAgentID;
                ProbeDefHndlr.addMap(this.probeKey, filer, this.probeMap);
                if (Constants.supportsFullProbe((short)fs.nflOsType)) break;
            }
            fs = fs.nflNext;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)NasGuiAgentHndlr.class.getName(), (String)"addToProbeMap");
        }
    }

    static {
        NasFilesystem[] array = new NasFilesystem[]{};
        requestDataClass = array.getClass();
    }

    private static class InitialNasProbe
    extends TSThread {
        private HashMap probeMap;

        InitialNasProbe(HashMap probeMap) {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)InitialNasProbe.class.getName(), (String)"InitialNasProbe", (String)"probeMap");
            }
            this.probeMap = probeMap;
            this.setDaemon(true);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)InitialNasProbe.class.getName(), (String)"InitialNasProbe");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Connection dbc;
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)InitialNasProbe.class.getName(), (String)"run", (String)"");
            }
            if ((dbc = Server.getConnection()) == null) {
                Object[] args = new Object[]{"InitialNasProbe"};
                MessageLog.logMessage((String)"SRV0102E", (Object[])args);
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)InitialNasProbe.class.getName(), (String)"run");
                }
                return;
            }
            try {
                ProbeDefResp probeDef = new ProbeDefResp();
                probeDef.pdProbeLocal = false;
                Request request = new Request();
                request.typeCode = "org.eclipse.aperi.agent.svp.AgentSvp";
                request.subType = "org.eclipse.aperi.agent.handler.nas.RunProbeHandler";
                request.serviceName = RequestTypeManager.getInternalName((String)"org.eclipse.aperi.agent.svp.AgentSvp");
                request.requestData = probeDef;
                ProbeDefHndlr.makeArrays(this.probeMap);
                AgentManager agentMgr = Server.getAgentManager();
                Iterator i = this.probeMap.keySet().iterator();
                while (i.hasNext()) {
                    probeDef.pdNasFiler = null;
                    MutableInteger agent = (MutableInteger)i.next();
                    ProbeDefHndlr.addNasFilers(dbc, probeDef, this.probeMap, agent, new Response(0, null));
                    probeDef.pack();
                    Response response = agentMgr.transmitToAgent(request, null, agent.value, false);
                    if (response != null && response.errorMessage == null) continue;
                    String agentName = agentMgr.getAgentName(agent.value);
                    MessageLog.logMessage((String)"STS0167E", (Object)agentName);
                    if (response == null) {
                        MessageLog.logMessage((String)"STS0168E");
                        continue;
                    }
                    MessageLog.getThreadLog().println(response.errorMessage);
                }
            }
            catch (GeneralException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)InitialNasProbe.class.getName(), (String)"run", (Throwable)e);
                }
                MessageLog.logException((String)"STS0169E", (Exception)((Object)e));
            }
            finally {
                Server.returnConnection(dbc);
            }
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)InitialNasProbe.class.getName(), (String)"run");
            }
        }
    }
}

