/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.scheduler;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.aperi.TStorm.server.guireq.DeviceRequest;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.IJobMgmtService;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.scheduler.SchIntervalNode;
import org.eclipse.aperi.scheduler.ScheduleBuild;
import org.eclipse.aperi.scheduler.ScheduleSubmit;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.handler.DeviceRequestHndlr;
import org.eclipse.aperi.server.handler.scheduler.DeviceJobComplete;
import org.eclipse.aperi.server.handler.scheduler.DeviceJobHndlrThread;
import org.eclipse.aperi.server.handler.scheduler.SchDeviceJobDoneHandler;
import org.eclipse.aperi.xmsg.MessageLog;

public abstract class DeviceJobHndlr
extends DeviceRequestHndlr {
    private static Object mutex = new Object();
    private static final String INSERT_RUNS = "insert into t_runs (time_stamp, schedule_id, run_number, number_jobs) values (?,?,?,?)";

    public Response handle(Request request, Transceiver transceiver) {
        DeviceRequest dr = (DeviceRequest)request;
        Response response = new Response(0, null);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)DeviceJobHndlr.class.getName(), (String)"handle", (String)"request, transceiver");
        }
        DeviceJobHndlr.initDeviceServerComm(dr);
        if (!this.submitJob(dr, response, transceiver)) {
            response.status = (short)12;
        }
        Response resp = new Response(0, null);
        resp.status = (short)-99;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)DeviceJobHndlr.class.getName(), (String)"handle", (Object)response);
        }
        return resp;
    }

    private boolean submitJob(DeviceRequest dr, Response response, Transceiver transceiver) {
        boolean status = DeviceJobHndlr.createNewScheduledJob(dr, response);
        if (!status) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)DeviceJobHndlr.class.getName(), (String)"submitJob", (boolean)false);
            }
            return false;
        }
        DeviceJobHndlrThread devJobHndlrT = new DeviceJobHndlrThread((Request)dr, transceiver, this);
        Thread actionThread = new Thread((Runnable)devJobHndlrT, this.getClass().getName());
        actionThread.start();
        return true;
    }

    public static void setDeviceJobID(DeviceRequest dr) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)DeviceJobHndlr.class.getName(), (String)"setDeviceJobID", (String)"dr");
        }
        DeviceJobHndlr.updateTRuns(dr.dataScheduleID, dr.dataScheduleRunNbr, dr.deviceRunNbr, dr.deviceServerID);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)DeviceJobHndlr.class.getName(), (String)"setDeviceJobID");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean updateTSchedule(int SID, int highRun) {
        boolean result = true;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)DeviceJobHndlr.class.getName(), (String)"updateTSchedule", (String)"SID, highRun");
        }
        StringBuffer sqlText = new StringBuffer(75);
        sqlText.append("update t_schedule set high_run_number = ");
        sqlText.append(highRun);
        sqlText.append(" where schedule_id = ");
        sqlText.append(SID);
        Connection dbc = Server.getConnection();
        try {
            Statement sqlStmt = dbc.createStatement();
            sqlStmt.executeUpdate(sqlText.toString());
            sqlStmt.close();
            dbc.commit();
        }
        catch (SQLException e) {
            result = false;
            Object[] args = new Object[]{"update", "t_schedule", "DeviceJobHndlr.updateTSchedule"};
            String msg = SQLUtil.getSQLExceptionMsg("JSS0008E", e, args);
            ScheduleSubmit.logWriter.println(msg);
        }
        finally {
            if (dbc != null) {
                Server.returnConnection(dbc);
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)DeviceJobHndlr.class.getName(), (String)"updateTSchedule", (boolean)result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int completeDeviceJob(IJobMgmtService iJob, AsyncResult tar, String deviceMethod, int SID, int SidRunNbr, int deviceServerID) {
        AsyncResult tarDone = null;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)DeviceJobHndlr.class.getName(), (String)"completeDeviceJob", (String)"tar, deviceMethod, SID, SidRunNbr, deviceServerID");
        }
        if (tar == null) {
            MessageLog.logMessage((String)"SRV0710E", (Object)"AsyncResult");
            if (TraceLogger.enableTrace) {
                TraceLogger.traceMessage((int)1, (String)DeviceJobHndlr.class.getName(), (String)"completeDeviceJob", (String)"AsyncResult is null.");
            }
            return 8;
        }
        int deviceRunNbr = Integer.parseInt(tar.getJobId());
        DeviceJobHndlr.updateTRuns(SID, SidRunNbr, deviceRunNbr, deviceServerID);
        try {
            tarDone = iJob.waitForJobToComplete(tar.getJobId());
            if (tarDone == null) {
                MessageLog.logMessage((String)"SRV0710E", (Object)"waitForJobToComplete()");
                if (TraceLogger.enableTrace) {
                    TraceLogger.traceMessage((int)1, (String)DeviceJobHndlr.class.getName(), (String)"completeDeviceJob", (String)"waitForJobToComplete() returns null.");
                }
                int n = 8;
                return n;
            }
        }
        catch (Exception e) {
            MessageLog.logException((String)"SRV0770E", (Exception)e, (Object)deviceMethod);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)DeviceJobHndlr.class.getName(), (String)"completeDeviceJob", (int)8);
            }
            e.printStackTrace();
            int n = 8;
            return n;
        }
        catch (Throwable e) {
            MessageLog.logException((String)"SRV0770E", (Exception)new Exception(e), (Object)deviceMethod);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)DeviceJobHndlr.class.getName(), (String)"completeDeviceJob", (int)8);
            }
            e.printStackTrace();
            int n = 8;
            return n;
        }
        finally {
            DeviceJobHndlr.updateTRunJobs(SID, SidRunNbr, deviceRunNbr, deviceServerID);
        }
        Exception e = DeviceJobHndlr.getAnyException(tarDone);
        if (e != null) {
            MessageLog.logException((String)"SRV0451E", (Exception)e, (Object)deviceMethod);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)DeviceJobHndlr.class.getName(), (String)"completeDeviceJob", (int)8);
            }
            return 8;
        }
        DeviceJobHndlr.logResults(tarDone);
        int status = tarDone.getRc();
        if (TraceLogger.enableTrace) {
            TraceLogger.traceMessage((int)1, (String)DeviceJobHndlr.class.getName(), (String)"completeDeviceJob", (String)("After waitForJobToComplete() tarDone.getRc() = " + status));
        }
        int rc = 8;
        if (status > 0) {
            rc = 8;
        } else if (status < 0) {
            rc = 4;
        } else if (status == 0) {
            rc = 0;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)DeviceJobHndlr.class.getName(), (String)"completeDeviceJob", (int)rc);
        }
        return rc;
    }

    private static Exception getAnyException(AsyncResult pTarDone) {
        Exception e = null;
        AsyncResult[] mSubJobs = pTarDone.getSubJobResults();
        if (mSubJobs != null) {
            for (int i = 0; i < mSubJobs.length && (e = DeviceJobHndlr.getAnyException(mSubJobs[i])) == null; ++i) {
            }
        }
        if (e == null) {
            return pTarDone.getReturnException();
        }
        return e;
    }

    private static void logResults(AsyncResult tar) {
        AsyncResult[] tarAll;
        PrintWriter pw = MessageLog.getThreadLog();
        String msg = tar.getMessage();
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)DeviceJobHndlr.class.getName(), (String)"logResults", (String)"tar");
        }
        if (msg != null) {
            pw.write(msg);
            pw.write("\n");
        }
        if ((tarAll = tar.getSubJobResults()) != null) {
            for (int x = 0; x < tarAll.length; ++x) {
                msg = tarAll[x].getMessage();
                if (msg == null) continue;
                pw.write(msg);
                pw.write("\n");
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)DeviceJobHndlr.class.getName(), (String)"logResults");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean updateTRuns(int SID, int SidRunNbr, int deviceJobID, int deviceServerID) {
        boolean result = true;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)DeviceJobHndlr.class.getName(), (String)"updateTRuns", (String)"SID, SidRunNbr, deviceJobID");
        }
        StringBuffer sqlText = new StringBuffer(75);
        sqlText.append("update t_runs set device_server_run_id = ");
        sqlText.append(deviceJobID);
        sqlText.append(", device_server_id = ");
        sqlText.append(deviceServerID);
        sqlText.append(" where schedule_id = ");
        sqlText.append(SID);
        sqlText.append(" and run_number = ");
        sqlText.append(SidRunNbr);
        Connection dbc = Server.getConnection();
        try {
            Statement sqlStmt = dbc.createStatement();
            sqlStmt.executeUpdate(sqlText.toString());
            sqlStmt.close();
            dbc.commit();
        }
        catch (SQLException e) {
            result = false;
            Object[] args = new Object[]{"update", "t_runs", "DeviceJobHndlr.updateTRuns"};
            String msg = SQLUtil.getSQLExceptionMsg("JSS0008E", e, args);
            ScheduleSubmit.logWriter.println(msg);
        }
        finally {
            if (dbc != null) {
                Server.returnConnection(dbc);
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)DeviceJobHndlr.class.getName(), (String)"updateTRuns", (boolean)result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean updateTRunJobs(int SID, int SidRunNbr, int deviceJobID, int deviceServerID) {
        boolean result = true;
        StringBuffer sqlText = new StringBuffer(75);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)DeviceJobHndlr.class.getName(), (String)"updateTRunJobs", (String)"SID, SidRunNbr, deviceJobID, deviceServerID");
        }
        sqlText.append("update t_run_jobs set schedule_id = ");
        sqlText.append(SID);
        sqlText.append(", sid_run_number = ");
        sqlText.append(SidRunNbr);
        sqlText.append(", computer_id = ");
        sqlText.append(deviceServerID);
        sqlText.append(" where device_server_run_id = ");
        sqlText.append(deviceJobID);
        Connection dbc = Server.getConnection();
        try {
            Statement sqlStmt = dbc.createStatement();
            sqlStmt.executeUpdate(sqlText.toString());
            sqlStmt.close();
            dbc.commit();
        }
        catch (SQLException e) {
            result = false;
            Object[] args = new Object[]{"update", "t_run_jobs", "DeviceJobHndlr.updateTRunJobs"};
            String msg = SQLUtil.getSQLExceptionMsg("JSS0008E", e, args);
            ScheduleSubmit.logWriter.println(msg);
        }
        finally {
            if (dbc != null) {
                Server.returnConnection(dbc);
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)DeviceJobHndlr.class.getName(), (String)"updateTRunJobs", (boolean)result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean insertRun(DeviceRequest dr) {
        boolean result = true;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)DeviceJobHndlr.class.getName(), (String)"insertRun", (String)"dr");
        }
        Connection dbc = Server.getConnection();
        try {
            PreparedStatement insertStmt = dbc.prepareStatement(INSERT_RUNS);
            insertStmt.setLong(1, SQLUtil.getTimestamp(dbc).getTime());
            insertStmt.setInt(2, dr.dataScheduleID);
            insertStmt.setInt(3, dr.dataScheduleRunNbr);
            insertStmt.setInt(4, 1);
            insertStmt.executeUpdate();
            insertStmt.close();
            dbc.commit();
        }
        catch (SQLException e) {
            result = false;
            Object[] args = new Object[]{"insert", "t_runs", "DeviceJobHndlr.insertRun"};
            String msg = SQLUtil.getSQLExceptionMsg("JSS0008E", e, args);
            ScheduleSubmit.logWriter.println(msg);
        }
        finally {
            if (dbc != null) {
                Server.returnConnection(dbc);
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)DeviceJobHndlr.class.getName(), (String)"insertRun", (boolean)result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForDeviceJob(Response response, int runNbr, IJobMgmtService iJob) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)DeviceJobHndlr.class.getName(), (String)"waitForDeviceJob", (String)"Response, int");
        }
        int rc = 0;
        if (iJob == null) {
            response.errorMessage = MessageLog.getMessage((String)"SRV0451E", (Object)"IJobMgmtService");
            response.status = (short)12;
            rc = 8;
        }
        String runNumber = Integer.toString(runNbr);
        try {
            AsyncResult result = iJob.waitForJobToComplete(runNumber);
            response.status = 0;
            response.responseData = result;
            rc = 0;
        }
        catch (OutOfMemoryError ome) {
            MessageLog.logException((String)"SRV0770E", (Exception)new Exception(ome.getCause()), (Object)"waitForDeviceJob");
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)DeviceJobHndlr.class.getName(), (String)"waitForDeviceJob", (Throwable)ome);
            }
            rc = 8;
            response.errorMessage = MessageLog.getMessageNoID((String)"SRV0770E");
            response.status = (short)12;
        }
        catch (Exception e) {
            MessageLog.logException((String)"SRV0451E", (Exception)e, (Object)"waitForDeviceJob");
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)DeviceJobHndlr.class.getName(), (String)"waitForDeviceJob", (Throwable)e);
            }
            response.errorMessage = MessageLog.getMessage((String)"SRV0703E", (Object)"waitForJobToComplete()");
            response.status = (short)12;
            rc = 8;
        }
        catch (Throwable e) {
            MessageLog.logException((String)"SRV0451E", (Exception)new Exception(e), (Object)"waitForDeviceJob");
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)DeviceJobHndlr.class.getName(), (String)"waitForDeviceJob", (Throwable)e);
            }
            response.errorMessage = MessageLog.getMessage((String)"SRV0703E", (Object)"waitForJobToComplete()");
            response.status = (short)12;
            rc = 8;
        }
        finally {
            DeviceJobHndlr.finishJob(runNbr);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)DeviceJobHndlrThread.class.getName(), (String)"waitForDeviceJob", (int)rc);
            }
        }
    }

    public static void finishJob(int jobID) {
        Request request = new Request();
        DeviceJobComplete djComplete = new DeviceJobComplete();
        djComplete.deviceJobID = jobID;
        request.requestData = djComplete;
        SchDeviceJobDoneHandler jdHandler = new SchDeviceJobDoneHandler();
        jdHandler.handle(request, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createNewScheduledJob(DeviceRequest dr, Response response) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)DeviceJobHndlr.class.getName(), (String)"createNewScheduledJob", (String)"dr, response");
        }
        if (dr.deviceManager == DeviceRequest.DR_DISK) {
            dr.dataScheduleID = 113;
        } else if (dr.deviceManager == DeviceRequest.DR_FABRIC) {
            dr.dataScheduleID = 114;
        } else if (dr.deviceManager == DeviceRequest.DR_PM) {
            dr.dataScheduleID = 115;
        } else if (dr.deviceManager == DeviceRequest.DR_TAPE) {
            dr.dataScheduleID = 116;
        } else if (dr.deviceManager == DeviceRequest.DR_API) {
            dr.dataScheduleID = 117;
        } else {
            response.errorMessage = MessageLog.getMessage((String)"JSS0100E");
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)DeviceJobHndlr.class.getName(), (String)"createNewScheduledJob", (boolean)false);
            }
            return false;
        }
        SchIntervalNode interval = ScheduleBuild.getSchInterval(dr.dataScheduleID);
        if (interval == null) {
            response.errorMessage = MessageLog.getMessage((String)"JSS0101E");
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)DeviceJobHndlr.class.getName(), (String)"createNewScheduledJob", (boolean)false);
            }
            return false;
        }
        Object object = mutex;
        synchronized (object) {
            ++interval.highRunNumber;
            dr.dataScheduleRunNbr = interval.highRunNumber;
            DeviceJobHndlr.updateTSchedule(dr.dataScheduleID, interval.highRunNumber);
        }
        if (!DeviceJobHndlr.insertRun(dr)) {
            response.errorMessage = MessageLog.getMessage((String)"JSS0102E");
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)DeviceJobHndlr.class.getName(), (String)"createNewScheduledJob", (boolean)false);
            }
            return false;
        }
        return true;
    }
}

