/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.scheduler;

import java.lang.reflect.UndeclaredThrowableException;
import org.eclipse.aperi.TStorm.server.guireq.DeviceRequest;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.IJobMgmtService;
import org.eclipse.aperi.common.api.RemoteException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.VMTransceiver;
import org.eclipse.aperi.server.handler.scheduler.DeviceJobComplete;
import org.eclipse.aperi.server.handler.scheduler.SchDeviceJobDoneHandler;
import org.eclipse.aperi.server.handler.scheduler.SchDeviceJobStatusHandler;
import org.eclipse.aperi.xmsg.MessageLog;

class SchDeviceJobStatusHandlerThread
implements Runnable {
    IJobMgmtService iJob = null;
    String runNbr = null;
    Transceiver transceiver = null;
    SchDeviceJobStatusHandler handler = null;
    Response response = null;
    DeviceRequest dr = null;

    public SchDeviceJobStatusHandlerThread(IJobMgmtService iJob, String runNbr, Transceiver transceiver, DeviceRequest dr) {
        this.iJob = iJob;
        this.runNbr = runNbr;
        this.transceiver = transceiver;
        this.dr = dr;
        this.response = new Response(0, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SchDeviceJobStatusHandlerThread.class.getName(), (String)"run", (String)"");
        }
        int rc = 0;
        try {
            AsyncResult result = this.iJob.waitForJobToComplete(this.runNbr);
            this.response.responseData = result;
        }
        catch (RemoteException e) {
            MessageLog.logException((String)"SRV0451E", (Exception)((Object)e), (Object)"waitForDeviceJob");
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)SchDeviceJobStatusHandlerThread.class.getName(), (String)"run", (Throwable)e);
            }
            this.response.errorMessage = MessageLog.getMessage((String)"SRV0703E", (Object)"waitForJobToComplete()");
            this.response.status = (short)12;
            rc = 8;
        }
        catch (UndeclaredThrowableException ute) {
            MessageLog.logException((String)"SRV0451E", (Exception)ute, (Object)"waitForDeviceJob");
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)SchDeviceJobStatusHandlerThread.class.getName(), (String)"run", (Throwable)ute);
            }
            rc = 8;
            this.response.errorMessage = ute.getLocalizedMessage();
            this.response.status = (short)12;
        }
        catch (OutOfMemoryError ome) {
            MessageLog.logException((String)"SRV0770E", (Exception)new Exception(ome.getCause()), (Object)"waitForDeviceJob");
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)SchDeviceJobStatusHandlerThread.class.getName(), (String)"run", (Throwable)ome);
            }
            rc = 8;
            this.response.errorMessage = MessageLog.getMessageNoID((String)"SRV0770E");
            this.response.status = (short)12;
        }
        finally {
            try {
                this.finishJob(new Integer(this.runNbr));
            }
            catch (Exception ignore) {}
            this.ReturnResponse(this.response);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)SchDeviceJobStatusHandlerThread.class.getName(), (String)"run", (int)rc);
            }
        }
    }

    private void finishJob(int jobID) {
        Request request = new Request();
        DeviceJobComplete djComplete = new DeviceJobComplete();
        djComplete.deviceJobID = jobID;
        request.requestData = djComplete;
        SchDeviceJobDoneHandler jdHandler = new SchDeviceJobDoneHandler();
        jdHandler.handle(request, null);
    }

    private void ReturnResponse(Response response) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SchDeviceJobStatusHandlerThread.class.getName(), (String)"ReturnResponse", (String)"Response");
        }
        if (response != null) {
            this.transceiver.transmitResponse((Request)this.dr, response);
            if (!(this.transceiver instanceof VMTransceiver)) {
                response.returnResponse();
            }
        }
        this.transceiver.close();
        this.transceiver.returnTransceiver();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SchDeviceJobStatusHandlerThread.class.getName(), (String)"ReturnResponse", (boolean)true);
        }
    }
}

