/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.scheduler;

import java.io.Serializable;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.StorageException;
import org.eclipse.aperi.jobs.StartedJob;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.scheduler.SchCommon;
import org.eclipse.aperi.scheduler.SchRunNode;
import org.eclipse.aperi.scheduler.ScheduleComplete;
import org.eclipse.aperi.scheduler.ScheduleRunning;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.xmsg.MessageLog;

public class ScheduleHandler
implements RequestHandler {
    ScheduleComplete completeRoutine;
    ScheduleRunning runningRoutine;

    public ScheduleHandler() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleHandler.class.getName(), (String)"ScheduleHandler", (String)"");
        }
        this.completeRoutine = new ScheduleComplete();
        this.runningRoutine = SchCommon.runningRoutine;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleHandler.class.getName(), (String)"ScheduleHandler");
        }
    }

    public Response handle(Request request, Transceiver transceiver) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleHandler.class.getName(), (String)"handle", (String)"request, transceiver");
        }
        Response response = new Response(0, null, 0);
        if (SchCommon.stopped) {
            response.status = (short)24;
            response.setException(new StorageException("SRV0024E", null));
        } else if (!transceiver.transmitResponse(request, response)) {
            response = null;
        } else {
            response = new Response(0, null);
            request.requestData = (Serializable)transceiver.receiveData(request);
            if (!RequestChecker.isDesiredType(StartedJob.class, (Request)request, (Response)response)) {
                MessageLog.logMessage((String)"JSS0022E");
            } else {
                StartedJob startedJob = (StartedJob)request.requestData;
                int runNumber = startedJob.getRunNumber();
                SchRunNode runPtr = this.runningRoutine.getRun(runNumber);
                if (runPtr == null) {
                    SchCommon.buildTask.addRestart(runNumber);
                    runPtr = this.runningRoutine.getRun(runNumber);
                }
                if (runPtr == null) {
                    MessageLog.logMessage((String)"JSS0021E", (Object)Integer.toString(runNumber), (Object)Integer.toString(startedJob.getExitCode()));
                } else {
                    this.completeRoutine.process(runPtr, startedJob);
                }
            }
        }
        Response traceResult = response;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleHandler.class.getName(), (String)"handle", (Object)traceResult);
        }
        return traceResult;
    }
}

