/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.server;

import java.io.Serializable;
import java.sql.Connection;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.table.TAlertLog;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThrowAway;
import org.eclipse.aperi.server.guireq.ExtAlertLog;
import org.eclipse.aperi.xmsg.MessageLog;

public class AlertLogIDHndlr
implements RequestHandler,
ThrowAway {
    private ExtAlertLog requestData;
    private Connection dbc;
    private TAlertLog accessor;

    private void delete() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AlertLogIDHndlr.class.getName(), (String)"delete", (String)"");
        }
        this.accessor.prepLogicalDelete();
        while (this.requestData != null) {
            this.accessor.logicalDelete(this.requestData);
            this.requestData = this.requestData.alnExt;
        }
        this.accessor.closeLogicalDelete();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AlertLogIDHndlr.class.getName(), (String)"delete");
        }
    }

    private void clear() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AlertLogIDHndlr.class.getName(), (String)"clear", (String)"");
        }
        this.accessor.prepDeactivateByID();
        while (this.requestData != null) {
            this.accessor.deactivate(this.requestData.alAlertLogID);
            this.requestData = this.requestData.alnExt;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AlertLogIDHndlr.class.getName(), (String)"clear");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response handle(Request request, Transceiver transceiver) {
        Response response;
        block16: {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)AlertLogIDHndlr.class.getName(), (String)"handle", (String)"request, transceiver");
            }
            response = Response.getResponse((short)0, null);
            Serializable obj = request.requestData;
            if (obj instanceof ExtAlertLog[]) {
                this.requestData = ExtAlertLog.unpack((ExtAlertLog[])((ExtAlertLog[])obj));
            } else {
                if (!RequestChecker.isDesiredType(ExtAlertLog.class, (Request)request, (Response)response)) {
                    Response traceResult = response;
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit((String)AlertLogIDHndlr.class.getName(), (String)"handle", (Object)traceResult);
                    }
                    return traceResult;
                }
                this.requestData = (ExtAlertLog)obj;
            }
            this.dbc = Server.getConnection();
            this.accessor = new TAlertLog(this.dbc);
            try {
                if ("org.eclipse.aperi.server.handler.server.AlertLogIDHndlr.Delete".equals(request.subType)) {
                    this.delete();
                    break block16;
                }
                if ("org.eclipse.aperi.server.handler.server.AlertLogIDHndlr.Clear".equals(request.subType)) {
                    this.clear();
                    break block16;
                }
                if ("org.eclipse.aperi.server.handler.server.AlertLogIDHndlr.Message".equals(request.subType)) {
                    response.responseData = this.accessor.getText(this.requestData.alAlertLogID);
                    break block16;
                }
                String s = MessageLog.getMessage((String)"SRV0101E", null);
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)AlertLogIDHndlr.class.getName(), (String)"handle");
                }
                throw new GeneralException(s);
            }
            catch (GeneralException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)AlertLogIDHndlr.class.getName(), (String)"handle", (Throwable)e);
                }
                Server.setResponseError(response, (Exception)((Object)e));
            }
            finally {
                Server.returnConnection(this.dbc);
            }
        }
        Response traceResult = response;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AlertLogIDHndlr.class.getName(), (String)"handle", (Object)traceResult);
        }
        return traceResult;
    }
}

