/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.server;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.aperi.TStorm.common.Device;
import org.eclipse.aperi.TStorm.common.Domain;
import org.eclipse.aperi.TStorm.common.Filesystem;
import org.eclipse.aperi.TStorm.common.FoundComputer;
import org.eclipse.aperi.TStorm.common.Share;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.StorageException;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.common.dbaccess.FabricDbAccess;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.table.TFoundComputer;
import org.eclipse.aperi.repository.table.TResComputer;
import org.eclipse.aperi.repository.table.TResDevAccess;
import org.eclipse.aperi.repository.table.TResDevice;
import org.eclipse.aperi.repository.table.TResDiskArray;
import org.eclipse.aperi.repository.table.TResDomain;
import org.eclipse.aperi.repository.table.TResFS;
import org.eclipse.aperi.repository.table.TResLdapTree;
import org.eclipse.aperi.server.guireq.ExtAlertLog;
import org.eclipse.aperi.server.handler.server.AlertLogHndlr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlertLogResolver
implements AlertLogHndlr.ProductAlertLogHndlr {
    private Connection dbc;

    @Override
    public void getProductData(AlertLogHndlr handler, Map<Short, ExtAlertLog> map, Connection dbc) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AlertLogResolver.class.getName(), (String)"getProductData", (String)"handler, array, dbc");
        }
        this.dbc = dbc;
        ExtAlertLog records = map.get((short)1);
        if (records != null) {
            this.getDisks(records);
            this.getArraysForDisks(records);
        }
        if ((records = map.get((short)2)) != null) {
            this.getMissingDisks(records);
            this.getArraysForDisks(records);
        }
        if ((records = map.get((short)3)) != null) {
            this.getFilesystems(records);
        }
        if ((records = map.get((short)6)) != null) {
            this.getFoundComputers(records);
        }
        if ((records = map.get((short)14)) != null) {
            this.getDiskArrays(records);
        }
        if ((records = map.get((short)0)) != null) {
            this.getMissingFilers(records);
        }
        if ((records = map.get((short)16)) != null) {
            this.getSwitchLabels(records);
        }
        if ((records = map.get((short)15)) != null) {
            this.getFabricLabels(records);
        }
        if ((records = map.get((short)17)) != null) {
            this.getEndpointLabels(records);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AlertLogResolver.class.getName(), (String)"getProductData");
        }
    }

    private void getMissingDisks(ExtAlertLog records) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AlertLogResolver.class.getName(), (String)"getMissingDisks", (String)"records");
        }
        TResDevice accessor = new TResDevice(this.dbc);
        accessor.prepGetDevByID(false);
        while (records != null) {
            Device device = accessor.getDevByID(records.alResourceID);
            accessor.closeResultSet();
            if (device != null) {
                String serialNumber = Util.isEmpty((String)device.devSubsystemSerialNumber) ? device.devSubsystemSerialNumber + '/' + device.devSerialNumber : device.devSerialNumber;
                records.setAlObjectName(device.devManufacturer + ' ' + device.devModel + ' ' + serialNumber);
            }
            records = records.alnExt;
        }
        accessor.closeSelect();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AlertLogResolver.class.getName(), (String)"getMissingDisks");
        }
    }

    private void getDisks(ExtAlertLog records) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AlertLogResolver.class.getName(), (String)"getDisks", (String)"records");
        }
        TResDevAccess accessor = new TResDevAccess(this.dbc);
        TResComputer cmpAccessor = new TResComputer(this.dbc);
        boolean isSS = cmpAccessor.isStorageSubsystem(records.alComputerID);
        if (!isSS) {
            accessor.prepPathDevCompQuery();
        } else {
            accessor.prepPathDevSSQuery();
        }
        while (records != null) {
            records.setAlObjectName(accessor.getPathByDeviceComputer(records.alResourceID, records.alComputerID));
            records = records.alnExt;
        }
        accessor.closeSelect();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AlertLogResolver.class.getName(), (String)"getDisks");
        }
    }

    private void getArraysForDisks(ExtAlertLog records) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AlertLogResolver.class.getName(), (String)"getArraysForDisks", (String)"records");
        }
        Share share = new Share();
        TResDiskArray accessor = new TResDiskArray(this.dbc);
        accessor.prepFetchByID();
        while (records != null) {
            share.shResourceID = records.alComputerID;
            if (accessor.fetchByID(share)) {
                records.alComputer = share.shPath;
            }
            records = records.alnExt;
        }
        accessor.closeSelect();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AlertLogResolver.class.getName(), (String)"getArraysForDisks");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getDiskArrays(ExtAlertLog records) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AlertLogResolver.class.getName(), (String)"getDiskArrays", (String)"records");
        }
        TResComputer accessor = new TResComputer(this.dbc);
        TResComputer accessor2 = new TResComputer(this.dbc);
        DBConnection dbConnection = null;
        try {
            accessor.prepSelectLocalHostname();
            accessor2.prepSelectName();
            DBConnPoolDataSource ds = DBConnPoolDataSource.getInstance();
            dbConnection = (DBConnection)ds.getPooledConnection();
            dbConnection.setAutoCommit(true);
            while (records != null) {
                records.setAlObjectName(accessor.fetchName(records.alResourceID));
                records.alComputer = "";
                try {
                    new String();
                    DBResultSet res = FabricDbAccess.getComputerDetail((DBConnection)dbConnection, (String)String.valueOf(records.alComputerID));
                    if (res.next()) {
                        records.alComputer = res.getString("LABEL");
                    }
                }
                catch (SQLException e) {
                    // empty catch block
                }
                if (records.alComputer == null || records.alComputer.equals("")) {
                    records.alComputer = this.formatID(records.alComputerID);
                }
                records = records.alnExt;
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)AlertLogResolver.class.getName(), (String)"getDiskArrays", (Throwable)e);
            }
        }
        catch (StorageException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)AlertLogResolver.class.getName(), (String)"getDiskArrays", (Throwable)e);
            }
        }
        finally {
            this.cleanupSelect(accessor);
            this.cleanupSelect(accessor2);
            try {
                if (dbConnection != null) {
                    dbConnection.close();
                }
                dbConnection = null;
            }
            catch (SQLException e2) {}
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AlertLogResolver.class.getName(), (String)"getDiskArrays");
        }
    }

    private void cleanupSelect(RepositoryAccessor accessor) {
        block4: {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)AlertLogResolver.class.getName(), (String)"cleanupSelect", (String)"accessor");
            }
            try {
                accessor.closeSelect();
            }
            catch (GeneralException ignored) {
                if (!TraceLogger.enableTrace) break block4;
                TraceLogger.exception((String)AlertLogResolver.class.getName(), (String)"cleanupSelect", (Throwable)ignored);
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AlertLogResolver.class.getName(), (String)"cleanupSelect");
        }
    }

    private void getDomainNames(List list) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AlertLogResolver.class.getName(), (String)"getDomainNames", (String)"list");
        }
        Domain buffer = new Domain();
        TResDomain accessor = new TResDomain(this.dbc);
        accessor.prepFetchByID();
        for (ExtAlertLog record : list) {
            buffer.domID = record.alResourceID;
            accessor.fetchByID(buffer);
            record.setAlObjectName(buffer.domName);
        }
        accessor.closeSelect();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AlertLogResolver.class.getName(), (String)"getDomainNames");
        }
    }

    private void getComputerNames(List list) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AlertLogResolver.class.getName(), (String)"getComputerNames", (String)"list");
        }
        TResComputer accessor = new TResComputer(this.dbc);
        accessor.prepSelectName();
        for (ExtAlertLog record : list) {
            record.setAlObjectName(accessor.fetchName(record.alResourceID));
        }
        accessor.closeSelect();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AlertLogResolver.class.getName(), (String)"getComputerNames");
        }
    }

    private void getTreeNames(List list) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AlertLogResolver.class.getName(), (String)"getTreeNames", (String)"list");
        }
        TResLdapTree accessor = new TResLdapTree(this.dbc);
        accessor.prepFetchByID();
        for (ExtAlertLog record : list) {
            record.setAlObjectName(accessor.fetchByID(record.alResourceID));
        }
        accessor.closeSelect();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AlertLogResolver.class.getName(), (String)"getTreeNames");
        }
    }

    private void getMissingFilers(ExtAlertLog records) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AlertLogResolver.class.getName(), (String)"getMissingFilers", (String)"records");
        }
        LinkedList<ExtAlertLog> domainList = new LinkedList<ExtAlertLog>();
        LinkedList<ExtAlertLog> computerList = new LinkedList<ExtAlertLog>();
        LinkedList<ExtAlertLog> treeList = new LinkedList<ExtAlertLog>();
        while (records != null) {
            if (records.alAlertCondition == 66) {
                switch (records.alResourceType) {
                    case 25: {
                        domainList.add(records);
                        break;
                    }
                    case 1: {
                        computerList.add(records);
                        break;
                    }
                    case 66: {
                        treeList.add(records);
                    }
                }
            } else if (records.alResourceType == 1) {
                records.alResourceType = (short)-1;
                records.alResourceID = -1;
            }
            records = records.alnExt;
        }
        if (!domainList.isEmpty()) {
            this.getDomainNames(domainList);
        }
        if (!computerList.isEmpty()) {
            this.getComputerNames(computerList);
        }
        if (!treeList.isEmpty()) {
            this.getTreeNames(treeList);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AlertLogResolver.class.getName(), (String)"getMissingFilers");
        }
    }

    private void getFilesystems(ExtAlertLog records) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AlertLogResolver.class.getName(), (String)"getFilesystems", (String)"records");
        }
        TResFS accessor = new TResFS(this.dbc);
        accessor.prepSelectByID();
        while (records != null) {
            Filesystem filesystem = accessor.getByID(records.alResourceID);
            if (filesystem != null) {
                records.setAlObjectName(filesystem.fsMountPoint);
            }
            records = records.alnExt;
        }
        accessor.closeSelect();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AlertLogResolver.class.getName(), (String)"getFilesystems");
        }
    }

    private void getFoundComputers(ExtAlertLog records) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AlertLogResolver.class.getName(), (String)"getFoundComputers", (String)"records");
        }
        FoundComputer fc = new FoundComputer();
        TFoundComputer accessor = new TFoundComputer(this.dbc);
        accessor.prepSelectByID();
        while (records != null) {
            fc.fcID = records.alComputerID;
            accessor.fetchByID(fc);
            records.alComputer = TFoundComputer.canonicalName(fc);
            records = records.alnExt;
        }
        accessor.closeSelect();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AlertLogResolver.class.getName(), (String)"getFoundComputers");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getSwitchLabels(ExtAlertLog records) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AlertLogResolver.class.getName(), (String)"getSwitchLabels", (String)"records");
        }
        DBConnection dbConnection = null;
        try {
            DBConnPoolDataSource ds = DBConnPoolDataSource.getInstance();
            dbConnection = (DBConnection)ds.getPooledConnection();
            dbConnection.setAutoCommit(true);
            TResComputer accessor = new TResComputer(this.dbc);
            accessor.prepSelectName();
            HashMap<String, String> objectLabelMap = new HashMap<String, String>();
            HashMap<String, String> computerIDMap = new HashMap<String, String>();
            TResDiskArray dAaccessor = new TResDiskArray(this.dbc);
            dAaccessor.prepFetchByID();
            while (records != null) {
                String tempID = Integer.toString(records.alResourceID);
                String objectLabel = (String)objectLabelMap.get(tempID);
                if (objectLabel == null) {
                    DBResultSet results = FabricDbAccess.getSwitchDetail((DBConnection)dbConnection, (String)tempID);
                    if (results != null) {
                        if (results.next()) {
                            objectLabelMap.put(tempID, results.getString("LABEL"));
                        } else {
                            objectLabelMap.put(tempID, "");
                        }
                    }
                    objectLabel = (String)objectLabelMap.get(tempID);
                }
                records.setAlObjectName(objectLabel);
                String computerID = (String)computerIDMap.get(Integer.toString(records.alComputerID));
                if (computerID == null) {
                    String tempComputerID = accessor.fetchName(records.alComputerID);
                    if (tempComputerID == null) {
                        tempComputerID = "";
                    }
                    computerIDMap.put(Integer.toString(records.alComputerID), tempComputerID);
                }
                records.alComputer = (String)computerIDMap.get(Integer.toString(records.alComputerID));
                records = records.alnExt;
            }
            dAaccessor.closeSelect();
        }
        catch (Exception e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)AlertLogResolver.class.getName(), (String)"getSwitchLabels", (Throwable)e);
            }
        }
        finally {
            try {
                dbConnection.close();
            }
            catch (Exception exception) {}
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AlertLogResolver.class.getName(), (String)"getSwitchLabels");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getFabricLabels(ExtAlertLog records) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AlertLogResolver.class.getName(), (String)"getFabricLabels", (String)"records");
        }
        DBConnection dbConnection = null;
        try {
            DBConnPoolDataSource ds = DBConnPoolDataSource.getInstance();
            dbConnection = (DBConnection)ds.getPooledConnection();
            dbConnection.setAutoCommit(true);
            TResComputer accessor = new TResComputer(this.dbc);
            accessor.prepSelectName();
            while (records != null) {
                String tempID = Integer.toString(records.alResourceID);
                short resourceType = records.alResourceType;
                if (resourceType == 114) {
                    DBResultSet results = FabricDbAccess.getFabricDetail((DBConnection)dbConnection, (String)tempID);
                    if (results != null && results.next()) {
                        records.setAlObjectName(results.getString("LABEL"));
                    }
                } else if (resourceType == 127) {
                    records.setAlObjectName(FabricDbAccess.getZoneNameForZone((int)records.alResourceID));
                } else if (resourceType == 126) {
                    records.setAlObjectName(FabricDbAccess.getZoneSetNameForZoneSet((int)records.alResourceID));
                }
                records.alComputer = accessor.fetchName(records.alComputerID);
                records = records.alnExt;
            }
            accessor.closeSelect();
        }
        catch (Exception e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)AlertLogResolver.class.getName(), (String)"getFabricLabels", (Throwable)e);
            }
        }
        finally {
            try {
                dbConnection.close();
            }
            catch (Exception exception) {}
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AlertLogResolver.class.getName(), (String)"getFabricLabels");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getEndpointLabels(ExtAlertLog records) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AlertLogResolver.class.getName(), (String)"getEndpointLabels", (String)"records");
        }
        DBConnection dbConnection = null;
        try {
            DBConnPoolDataSource ds = DBConnPoolDataSource.getInstance();
            dbConnection = (DBConnection)ds.getPooledConnection();
            dbConnection.setAutoCommit(true);
            TResComputer accessor = new TResComputer(this.dbc);
            accessor.prepSelectName();
            while (records != null) {
                DBResultSet results;
                String tempID = Integer.toString(records.alResourceID);
                short resourceType = records.alResourceType;
                if (resourceType == 138) {
                    results = FabricDbAccess.getNodeDetail((DBConnection)dbConnection, (String)tempID);
                    if (results != null && results.next()) {
                        records.setAlObjectName(results.getString("LABEL"));
                    }
                } else if (resourceType == 137) {
                    results = FabricDbAccess.getPortDetail((DBConnection)dbConnection, (String)tempID);
                    if (results != null && results.next()) {
                        records.setAlObjectName(results.getString("LABEL"));
                    }
                } else if (resourceType == 139 && (results = FabricDbAccess.getPhyPeDetail((DBConnection)dbConnection, (String)tempID)) != null && results.next()) {
                    records.setAlObjectName(results.getString("LABEL"));
                }
                records.alComputer = accessor.fetchName(records.alComputerID);
                records = records.alnExt;
            }
        }
        catch (Exception e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)AlertLogResolver.class.getName(), (String)"getEndpointLabels", (Throwable)e);
            }
        }
        finally {
            try {
                dbConnection.close();
            }
            catch (Exception exception) {}
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AlertLogResolver.class.getName(), (String)"getEndpointLabels");
        }
    }

    private String formatID(int objectID) {
        return "? (" + Integer.toString(objectID) + ")";
    }
}

