/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.server;

import java.sql.Connection;
import java.util.Iterator;
import org.eclipse.aperi.backend.DaemonLogFileReader;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.dbaccess.FabricDbAccess;
import org.eclipse.aperi.fabric.api.SNMPAgent;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.table.TComputer;
import org.eclipse.aperi.repository.table.TResCluster;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.AgentManager;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThreadSafe;
import org.eclipse.aperi.server.guireq.AgentInfo;
import org.eclipse.aperi.server.guireq.GComputer;
import org.eclipse.aperi.server.handler.gui.fabric.GUIDeviceAccessor;
import org.eclipse.aperi.server.req.GuiInfoReq;
import org.eclipse.aperi.xmsg.MessageLog;

public class GuiHndlr
implements RequestHandler,
ThreadSafe {
    private DaemonLogFileReader logReader = new DaemonLogFileReader(Server.getLogDir());

    public Response handle(Request request, Transceiver transceiver) {
        NameList root;
        Response response;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)GuiHndlr.class.getName(), (String)"handle", (String)"request, transceiver");
        }
        if (!RequestChecker.isDesiredType(GuiInfoReq.class, (Request)request, (Response)(response = Response.getResponse((short)0, null)))) {
            Response traceResult = response;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)GuiHndlr.class.getName(), (String)"handle", (Object)traceResult);
            }
            return traceResult;
        }
        GuiInfoReq requestData = (GuiInfoReq)request.requestData;
        if (requestData.dataRequested == GuiInfoReq.COMPUTER) {
            GComputer g;
            GComputer root2;
            Connection dbc = Server.getConnection();
            if (dbc == null) {
                Server.setResponseError(response, "GEN0050E");
                Response traceResult = response;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)GuiHndlr.class.getName(), (String)"handle", (Object)traceResult);
                }
                return traceResult;
            }
            GComputer prev = root2 = new GComputer();
            TResCluster clusterAccessor = new TResCluster(dbc);
            try {
                TComputer t = TComputer.getComputer(null, null, requestData.dataFor, null, dbc);
                clusterAccessor.prepGetClusterDetailsGC();
                while (t != null) {
                    boolean isStorageSystem;
                    g = new GComputer();
                    g.gcComputerID = t.computerID;
                    g.gcIpAddress = t.ipAddress;
                    g.gcNetworkName = t.networkName;
                    g.gcDomainName = t.domainName;
                    g.gcTimezoneID = t.timezoneID;
                    g.gcOsType = t.hwID.osType;
                    g.gcManufacturer = t.hwID.manufacturer;
                    if (t.hwID.manufacturer.toLowerCase().equals("unknown")) {
                        g.gcManufacturer = MessageLog.getMessageNoID((String)"GEN0183T");
                    }
                    if (!(isStorageSystem = Constants.isDiskArray((short)g.gcOsType))) {
                        g.gcHardwareID = t.hwID.hardwareID;
                        g.gcCPUArchitecture = t.hwID.cpuArchitecture;
                        g.gcTSName = t.tsName;
                        g.gcHostName = t.hwID.hostName;
                    } else {
                        g.gcTSName = t.hwID.hostName;
                        g.gcHostName = t.tsName;
                    }
                    if (Constants.hasClusterSupport((short)g.gcOsType)) {
                        clusterAccessor.getClusterDetailsGC(g);
                    }
                    prev.gcNext = g;
                    prev = g;
                    t = t.next;
                }
                clusterAccessor.closeSelect();
            }
            catch (Exception e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)GuiHndlr.class.getName(), (String)"handle", (Throwable)e);
                }
                response.status = (short)12;
                response.errorMessage = e.getMessage();
                root2.gcNext = null;
            }
            Server.returnConnection(dbc);
            response.responseData = GComputer.packList((GComputer)root2.gcNext);
            root2 = null;
            prev = null;
            g = null;
        } else if (requestData.dataRequested == 2) {
            NameList n;
            NameList prev = root = new NameList();
            Iterator i = Server.agentMgr.listAgents();
            while (i.hasNext()) {
                AgentManager.AgentAddress agent = (AgentManager.AgentAddress)i.next();
                if (agent.computerID <= 0) continue;
                n = new NameList();
                n.nlID = agent.computerID;
                n.nlState = agent.state;
                n.nlState = GuiHndlr.getAgentStateForGui(agent);
                prev.nlNext = n;
                prev = n;
            }
            response.responseData = root.nlNext;
            root = null;
            prev = null;
            n = null;
        } else if (requestData.dataRequested == 8) {
            NameList list = FabricDbAccess.getInbandAgents();
            response.responseData = list;
        } else if (requestData.dataRequested == 7) {
            NameList n;
            NameList prev = root = new NameList();
            SNMPAgent[] list = GUIDeviceAccessor.getSNMPAgents();
            if (list != null) {
                for (int i = 0; i < list.length; ++i) {
                    n = new NameList();
                    n.nlID = 0;
                    n.nlName = list[i].getDnsName();
                    n.nlName2 = list[i].getIpAddress();
                    int state = list[i].getEnabled();
                    n.nlState = state == 1 ? (byte)1 : 0;
                    prev.nlNext = n;
                    prev = n;
                }
            }
            response.responseData = root.nlNext;
            root = null;
            prev = null;
            n = null;
        } else if (requestData.dataRequested == GuiInfoReq.AGENT_DETAIL) {
            AgentInfo ai = null;
            Iterator i = Server.agentMgr.listAgents();
            while (i.hasNext()) {
                AgentManager.AgentAddress agent = (AgentManager.AgentAddress)i.next();
                if (agent.computerID != requestData.dataFor) continue;
                ai = new AgentInfo();
                ai.computerID = agent.computerID;
                ai.listenerPort = agent.listenerPort;
                ai.connectionErrors = agent.connectionErrors;
                ai.consecutiveErrors = agent.consecutiveErrors;
                ai.state = agent.state;
                ai.hostAddress = agent.hostAddress;
                ai.timestamp = agent.timestamp;
                ai.timezone = agent.timezone;
                ai.upgradeRequired = agent.upgradeRequired != 0;
                break;
            }
            response.responseData = ai;
        } else if (requestData.dataRequested == GuiInfoReq.READ_LOG) {
            response.status = (short)12;
            request.requestData = requestData.rlRequest;
            this.logReader.handle(request, response);
            request.requestData = requestData;
        } else if (requestData.dataRequested == GuiInfoReq.SERVER_PRODUCT_VERSION) {
            String VERSION = "5.0.0";
            if (VERSION.equalsIgnoreCase(requestData.productVersion)) {
                response.status = 0;
            } else {
                response.status = (short)97;
                response.errorMessage = MessageLog.getMessage((String)"GEN2020E", (Object)requestData.productVersion, (Object)VERSION);
                response.responseData = VERSION;
            }
        }
        Response traceResult = response;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GuiHndlr.class.getName(), (String)"handle", (Object)traceResult);
        }
        return traceResult;
    }

    protected static Byte getAgentStateForGui(int computerID) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)GuiHndlr.class.getName(), (String)"getAgentStateForGui", (String)"computerID");
        }
        Byte result = null;
        AgentManager.AgentAddress agent = Server.agentMgr.get(computerID);
        if (agent != null) {
            result = new Byte(GuiHndlr.getAgentStateForGui(agent));
        }
        Byte traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GuiHndlr.class.getName(), (String)"getAgentStateForGui", (Object)traceResult);
        }
        return traceResult;
    }

    protected static byte getAgentStateForGui(AgentManager.AgentAddress agent) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)GuiHndlr.class.getName(), (String)"getAgentStateForGui", (String)"agent");
        }
        int state = agent.state;
        if (agent.state == 1) {
            if (agent.consecutiveErrors > 0) {
                state = 4;
            } else if (agent.upgradeRequired > 0) {
                state = 5;
            }
        }
        byte by = state;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GuiHndlr.class.getName(), (String)"getAgentStateForGui", (byte)by);
        }
        return by;
    }
}

