/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.server;

import java.io.Serializable;
import java.util.Iterator;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.AgentManager;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.Service;
import org.eclipse.aperi.server.req.ServerStatusResp;

public class ServerStatusHndlr
implements RequestHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response handle(Request request, Transceiver comm) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ServerStatusHndlr.class.getName(), (String)"handle", (String)"request, comm");
        }
        ServerStatusResp status = new ServerStatusResp();
        Response response = Response.getResponse((short)0, (Serializable)status);
        status.serverName = Server.name;
        status.startTime = Server.startTime;
        long currentTime = System.currentTimeMillis();
        status.upTime = (int)((currentTime - Server.startTime.getTime()) / 1000L);
        status.dbConnections = Server.connectionPool.getConnectionCount();
        status.dbPoolCount = Server.connectionPool.getPoolElementCount();
        status.jdbcURL = Server.repositoryURL;
        status.jdbcDriver = Server.repositoryDriver;
        status.maxConnections = Server.maxConnections;
        status.totalMemory = (int)Runtime.getRuntime().totalMemory();
        status.connectionCount = Server.connectionCount;
        status.listenerPort = Server.getListenerPort();
        status.computerID = Server.serverIdentity.computer.computerID;
        status.osType = Server.serverIdentity.computer.hwID.osType;
        Iterator i = Server.agentMgr.listAgents();
        while (i.hasNext()) {
            AgentManager.AgentAddress agent = (AgentManager.AgentAddress)i.next();
            if (agent.computerID <= 0 || agent.state == 2) continue;
            status.totalAgents = (short)(status.totalAgents + 1);
            if (agent.state == 1) {
                if (agent.upgradeRequired != 0) {
                    status.upgradeNeededAgents = (short)(status.upgradeNeededAgents + 1);
                }
                if (agent.consecutiveErrors > 0) {
                    status.unreachableAgents = (short)(status.unreachableAgents + 1);
                    continue;
                }
                status.onlineAgents = (short)(status.onlineAgents + 1);
                continue;
            }
            if (agent.state == 0) {
                status.offlineAgents = (short)(status.offlineAgents + 1);
                if (agent.upgradeRequired == 0) continue;
                status.upgradeNeededAgents = (short)(status.upgradeNeededAgents + 1);
                continue;
            }
            if (agent.state != 3) continue;
            status.upgradingAgents = (short)(status.upgradingAgents + 1);
        }
        Service[] services = Server.serviceMgr.listServices();
        status.services = new ServerStatusResp.Service[services.length];
        for (int j = 0; j < services.length; ++j) {
            Service s = services[j];
            ServerStatusResp.Service serviceStatus = new ServerStatusResp.Service();
            Service service = s;
            synchronized (service) {
                serviceStatus.serviceName = s.serviceName;
                serviceStatus.requestType = s.requestType;
                serviceStatus.pendingRequests = s.queue.getPending();
                serviceStatus.processedRequests = s.queue.getProcessed();
                serviceStatus.threadsWaiting = s.queue.getWaiting();
                serviceStatus.state = (byte)(s.instance != null ? 1 : 2);
            }
            status.services[j] = serviceStatus;
        }
        Response traceResult = response;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ServerStatusHndlr.class.getName(), (String)"handle", (Object)traceResult);
        }
        return traceResult;
    }
}

