/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.server;

import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.constants.RequestType;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.StateChangeReq;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.Service;
import org.eclipse.aperi.server.ThreadSafe;

public class StateChangeHndlr
implements RequestHandler,
ThreadSafe {
    public Response handle(Request request, Transceiver comm) {
        Response response;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)StateChangeHndlr.class.getName(), (String)"handle", (String)"request, comm");
        }
        if (!RequestChecker.isDesiredType(StateChangeReq.class, (Request)request, (Response)(response = Response.getResponse((short)0, null)))) {
            Response traceResult = response;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)StateChangeHndlr.class.getName(), (String)"handle", (Object)traceResult);
            }
            return traceResult;
        }
        StateChangeReq data = (StateChangeReq)request.requestData;
        if (!RequestType.isValid((String)data.serviceProvider)) {
            Server.setResponseError(response, "SRV0034E", String.valueOf(data.serviceProvider));
            Response traceResult = response;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)StateChangeHndlr.class.getName(), (String)"handle", (Object)traceResult);
            }
            return traceResult;
        }
        Service service = Server.serviceMgr.getService(data.serviceProvider);
        if (service == null) {
            Server.setResponseError(response, "SRV0035E", service.serviceName);
            Response traceResult = response;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)StateChangeHndlr.class.getName(), (String)"handle", (Object)traceResult);
            }
            return traceResult;
        }
        boolean success = data.serviceProvider.equals("org.eclipse.aperi.server.svp.ServerSvp") ? StateChangeHndlr.shutdownServer(data.newState) : (data.newState == 4 ? Server.serviceMgr.startService(service) : Server.serviceMgr.stopService(service, data.newState));
        if (!success) {
            Server.setResponseError(response, "SRV0036E", service.serviceName);
        }
        Response traceResult = response;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)StateChangeHndlr.class.getName(), (String)"handle", (Object)traceResult);
        }
        return traceResult;
    }

    public static boolean shutdownServer(byte newState) {
        return StateChangeHndlr.shutdownServer(newState, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean shutdownServer(byte newState, Throwable throwable) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)StateChangeHndlr.class.getName(), (String)"shutdownServer", (String)"newState");
        }
        Class<Server> clazz = Server.class;
        synchronized (Server.class) {
            if (Server.terminate == 0) {
                Server.fatalError = throwable;
                Server.terminate = newState;
                Server.thread.interrupt();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            boolean traceResult = true;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)StateChangeHndlr.class.getName(), (String)"shutdownServer", (boolean)traceResult);
            }
            return traceResult;
        }
    }
}

