/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.server;

import java.sql.Connection;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.table.TResComputer;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThreadSafe;
import org.eclipse.aperi.server.UninstallAgentDriver;
import org.eclipse.aperi.server.req.UninstallAgentReq;

public class UninstallAgentHndlr
implements RequestHandler,
ThreadSafe {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response handle(Request request, Transceiver comm) {
        Response response;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)UninstallAgentHndlr.class.getName(), (String)"handle", (String)"request, comm");
        }
        if (RequestChecker.isDesiredType(UninstallAgentReq.class, (Request)request, (Response)(response = Response.getResponse((short)0, null)))) {
            UninstallAgentReq data = (UninstallAgentReq)request.requestData;
            if (data.computerID < 0) {
                NameList[] nlArray = new NameList[]{new NameList()};
                nlArray[0].nlName = data.computerName;
                Connection dbc = Server.getConnection();
                TResComputer accessor = new TResComputer(dbc);
                try {
                    nlArray = accessor.agentNameToComputerID(nlArray);
                    data.computerID = nlArray[0].nlID;
                }
                catch (GeneralException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)UninstallAgentHndlr.class.getName(), (String)"handle", (Throwable)e);
                    }
                    Server.setResponseError(response, (Exception)((Object)e));
                    Response traceResult = response;
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit((String)UninstallAgentHndlr.class.getName(), (String)"handle", (Object)traceResult);
                    }
                    Response response2 = traceResult;
                    return response2;
                }
                finally {
                    Server.returnConnection(dbc);
                }
            }
            UninstallAgentDriver driver = new UninstallAgentDriver(data.computerID, data.productCode);
            driver.start();
        }
        Response traceResult = response;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)UninstallAgentHndlr.class.getName(), (String)"handle", (Object)traceResult);
        }
        return traceResult;
    }
}

