/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.jobs;

import java.sql.Connection;
import org.eclipse.aperi.TStorm.server.guireq.DeviceRequest;
import org.eclipse.aperi.backend.LockManager;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.IJobMgmtService;
import org.eclipse.aperi.connector.ConnectorClient;
import org.eclipse.aperi.disk.api.IDiskManagerService;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.interfaces.IDiscover;
import org.eclipse.aperi.jobs.JobRun;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.table.TResIpAddresses;
import org.eclipse.aperi.server.ServerJob;
import org.eclipse.aperi.server.VMJobResults;
import org.eclipse.aperi.server.handler.DeviceRequestHndlr;
import org.eclipse.aperi.server.handler.scheduler.DeviceJobHndlr;
import org.eclipse.aperi.xmsg.MessageLog;

public class CimomDiscover
implements ServerJob {
    public static final String LOCK_RESOURCE_TYPE = "CIMOMDiscovery";
    private Connection dbc;
    private VMJobResults job;
    private JobRun jobRun;
    private boolean scanLocalSubnet;

    public CimomDiscover(Connection dbc) {
        this.initialize(dbc);
    }

    public CimomDiscover() {
    }

    public void initialize(Connection dbc) {
        this.dbc = dbc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(VMJobResults job, String[] parms) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CimomDiscover.class.getName(), (String)"run", (String)"job, parms");
        }
        this.job = job;
        this.jobRun = job.getJobRun();
        MessageLog.logMessage((String)"STS0500I", (Object)this.jobRun.getSchedCreator(), (Object)this.jobRun.getSchedName());
        this.scanLocalSubnet = parms.length <= 0 || !"0".equals(parms[0]);
        String resourceName = LOCK_RESOURCE_TYPE;
        int completionCode = 8;
        boolean haveLock = false;
        try {
            haveLock = LockManager.lock((short)0, (String)LOCK_RESOURCE_TYPE, (String)resourceName, (byte)1, (boolean)false);
            if (!haveLock) {
                MessageLog.logMessage((String)"STS0501W", (Object)this.jobRun.getSchedCreator(), (Object)this.jobRun.getSchedName());
                int n = 8;
                return n;
            }
            completionCode = this.doCimomDiscovery();
        }
        catch (Exception e) {
            MessageLog.logMessage((String)"STS0505E");
            e.printStackTrace(MessageLog.getThreadLog());
        }
        finally {
            if (haveLock) {
                LockManager.unLock((short)0, (String)LOCK_RESOURCE_TYPE, (String)resourceName);
            }
        }
        if (completionCode == 0) {
            MessageLog.logMessage((String)"STS0503I");
        } else if (completionCode < 8) {
            MessageLog.logMessage((String)"STS0504W");
        } else {
            MessageLog.logMessage((String)"STS0504E");
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CimomDiscover.class.getName(), (String)"run", (int)completionCode);
        }
        return completionCode;
    }

    private int doCimomDiscovery() {
        int rc;
        AsyncResult tar;
        String method;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CimomDiscover.class.getName(), (String)"doCimomDiscovery", (String)"");
        }
        boolean slpWarning = false;
        boolean slpError = false;
        DeviceRequest dr = new DeviceRequest();
        DeviceRequestHndlr.initDeviceServerComm(dr);
        IDiskManagerService iDiskMgr = (IDiskManagerService)ConnectorClient.getService((String)dr.deviceServerHost, (int)dr.deviceServerPort, IDiskManagerService.class, (String)"DiskManagerService");
        if (iDiskMgr == null) {
            MessageLog.logMessage((String)"SRV0450E", (Object)IDiskManagerService.class.getName());
            return 8;
        }
        IDiskManagerService iCimom = iDiskMgr;
        IDiskManagerService iJob = iDiskMgr;
        IDiscover iDis = (IDiscover)ConnectorClient.getService((String)dr.deviceServerHost, (int)dr.deviceServerPort, IDiscover.class, (String)"DiscoverService");
        if (iDis == null) {
            MessageLog.logMessage((String)"SRV0450E", (Object)IDiscover.class.getName());
            return 8;
        }
        String[] da_ips = this.fetchDAs();
        String user = this.jobRun.getSchedCreator();
        String schedName = this.jobRun.getSchedName();
        String runNumber = this.jobRun.getFormattedRunNumberSchedID();
        String jobName = this.jobRun.getJobName();
        if (da_ips != null || this.scanLocalSubnet) {
            method = "discoverCIMOMs";
            try {
                tar = (AsyncResult)iDis.invoke(user, schedName, runNumber, jobName, "DiskManagerService", IDiskManagerService.class.getName(), "discoverCIMOMs", new Object[]{da_ips, new Boolean(this.scanLocalSubnet)});
            }
            catch (Exception e1) {
                MessageLog.logException((String)"SRV0451E", (Exception)e1, (Object)method);
                e1.printStackTrace();
                return 8;
            }
            catch (Throwable e1) {
                MessageLog.logException((String)"SRV0451E", (Exception)new Exception(e1), (Object)method);
                e1.printStackTrace();
                return 8;
            }
            rc = DeviceJobHndlr.completeDeviceJob((IJobMgmtService)iJob, tar, method, this.jobRun.getSchedID(), this.jobRun.getSchedRunNumber(), dr.deviceServerID);
            if (rc == 4) {
                slpWarning = true;
                MessageLog.logMessage((String)"SRV0507W");
            } else if (rc == 8) {
                slpError = true;
                MessageLog.logMessage((String)"SRV0508E");
            }
        }
        String[] cimomIDs = null;
        method = "getCIMOMIDs";
        try {
            cimomIDs = iCimom.getCIMOMIDs();
        }
        catch (Exception e1) {
            MessageLog.logException((String)"SRV0451E", (Exception)e1, (Object)method);
            e1.printStackTrace();
            return 8;
        }
        catch (Throwable e1) {
            MessageLog.logException((String)"SRV0451E", (Exception)new Exception(e1), (Object)method);
            e1.printStackTrace();
            return 8;
        }
        if (cimomIDs == null || cimomIDs.length == 0) {
            MessageLog.logMessage((String)"SRV0509W");
            return 4;
        }
        method = "discoverDevicesFromCIMOM";
        try {
            tar = (AsyncResult)iDis.invoke(user, schedName, runNumber, jobName, "DiskManagerService", IDiskManagerService.class.getName(), "discoverDevicesFromCIMOM", new Object[]{cimomIDs});
        }
        catch (Exception e1) {
            MessageLog.logException((String)"SRV0451E", (Exception)e1, (Object)method);
            e1.printStackTrace();
            return 8;
        }
        catch (Throwable e1) {
            MessageLog.logException((String)"SRV0451E", (Exception)new Exception(e1), (Object)method);
            e1.printStackTrace();
            return 8;
        }
        rc = DeviceJobHndlr.completeDeviceJob((IJobMgmtService)iJob, tar, method, this.jobRun.getSchedID(), this.jobRun.getSchedRunNumber(), dr.deviceServerID);
        if (rc < 8 && slpError) {
            rc = 8;
        } else if (rc == 0 && slpWarning) {
            rc = 4;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CimomDiscover.class.getName(), (String)"doCimomDiscovery", (int)rc);
        }
        return rc;
    }

    private String[] fetchDAs() {
        NameList nl;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CimomDiscover.class.getName(), (String)"fetchDAs", (String)"");
        }
        String[] da_ips = null;
        int count = 0;
        TResIpAddresses trip = new TResIpAddresses();
        try {
            String type = DBConstants.getValueFromKey((String)"IP_Address_Type", (String)"SLP Directory agent IP");
            nl = trip.getIPAddressList(Integer.parseInt(type));
        }
        catch (GeneralException e) {
            e.printStackTrace(MessageLog.getThreadLog());
            return null;
        }
        NameList nlWork = nl;
        while (nlWork != null) {
            ++count;
            nlWork = nlWork.nlNext;
        }
        if (count > 0) {
            da_ips = new String[count];
            count = 0;
            nlWork = nl;
            while (nlWork != null) {
                da_ips[count++] = nlWork.nlName;
                nlWork = nlWork.nlNext;
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CimomDiscover.class.getName(), (String)"fetchDAs", (Object)da_ips);
        }
        return da_ips;
    }
}

