/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.jobs;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.aperi.Nas.common.NasFiler;
import org.eclipse.aperi.TStorm.server.agentreq.ProbeDefResp;
import org.eclipse.aperi.TStorm.server.agentreq.ScanDefReq;
import org.eclipse.aperi.TStorm.server.guireq.DeviceRequest;
import org.eclipse.aperi.backend.ProbeLock;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.LinkedInteger;
import org.eclipse.aperi.common.StorageException;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.IJobMgmtService;
import org.eclipse.aperi.connector.ConnectorClient;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.discovery.RemoveMissingProcessor;
import org.eclipse.aperi.disk.api.IDiskManagerService;
import org.eclipse.aperi.interfaces.IDiscover;
import org.eclipse.aperi.jobs.JobRun;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.table.TResChunk;
import org.eclipse.aperi.repository.table.TStatDisk;
import org.eclipse.aperi.repository.table.TStatDiskHist;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ServerJob;
import org.eclipse.aperi.server.VMJobResults;
import org.eclipse.aperi.server.handler.DeviceRequestHndlr;
import org.eclipse.aperi.server.handler.agent.ProbeDefHndlr;
import org.eclipse.aperi.server.handler.scheduler.DeviceJobHndlr;
import org.eclipse.aperi.server.req.ComputerID;
import org.eclipse.aperi.xmsg.MessageLog;

public class ExecProbeSS
implements ServerJob {
    private static final String device_method = "probeStorageSubsystems";
    private Connection dbc;
    private JobRun jobRun;

    public ExecProbeSS(Connection dbc) {
        this.initialize(dbc);
    }

    public ExecProbeSS() {
    }

    public void initialize(Connection dbc) {
        this.dbc = dbc;
    }

    public int run(VMJobResults job, String[] parms) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ExecProbeSS.class.getName(), (String)"run", (String)"job, parms");
        }
        this.jobRun = job.getJobRun();
        int traceResult = this.doProbe(this.jobRun.getSchedID());
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ExecProbeSS.class.getName(), (String)"run", (int)traceResult);
        }
        return traceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doProbe(int scheduleID) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ExecProbeSS.class.getName(), (String)"doProbe", (String)"scheduleID");
        }
        int rc = 0;
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.AgentSvp";
        request.serviceName = RequestTypeManager.getInternalName((String)request.typeCode);
        request.machineName = Server.getServerHostName();
        request.userName = null;
        request.flags = 0;
        Response response = null;
        ScanDefReq requestData = new ScanDefReq();
        requestData.scheduleID = scheduleID;
        requestData.computerID = new ComputerID(Server.getServerComputerID());
        request.requestData = requestData;
        response = ProbeDefHndlr.getEssProbeDef(requestData, this.dbc);
        if (response == null || response.status > 4 || !(response.responseData instanceof ProbeDefResp)) {
            MessageLog.logMessage((String)"GEN0403E");
            int traceResult = 8;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ExecProbeSS.class.getName(), (String)"doProbe", (int)traceResult);
            }
            return traceResult;
        }
        ProbeDefResp def = (ProbeDefResp)response.responseData;
        def.pdProbeLocal = false;
        LinkedInteger locked = ProbeLock.lock((ProbeDefResp)def, null);
        if (locked == null) {
            int traceResult = 8;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ExecProbeSS.class.getName(), (String)"doProbe", (int)traceResult);
            }
            return traceResult;
        }
        try {
            MessageLog.logMessage((String)"GEN0404I");
            rc = this.probeAll(def);
        }
        finally {
            ProbeLock.unlock((LinkedInteger)locked);
        }
        if (rc == 0) {
            MessageLog.logMessage((String)"GEN0401I");
        } else if (rc == 4) {
            MessageLog.logMessage((String)"GEN0402W");
        } else {
            MessageLog.logMessage((String)"GEN0400E");
        }
        int traceResult = rc;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ExecProbeSS.class.getName(), (String)"doProbe", (int)traceResult);
        }
        return traceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int probeAll(ProbeDefResp def) {
        AsyncResult tar;
        int num_filers = 0;
        NasFiler filer = def.pdNasFiler;
        while (filer != null) {
            ++num_filers;
            filer = filer.nfNext;
        }
        String[] ss_ids = new String[num_filers];
        int[] ss_int_temp = new int[num_filers];
        int[] svc_int_temp = new int[num_filers];
        int[] ss_autoIDs = new int[num_filers];
        int i = 0;
        int svcIndex = 0;
        int ssIndex = 0;
        filer = def.pdNasFiler;
        while (filer != null) {
            int index1 = filer.nfName.indexOf(92);
            int index2 = filer.nfName.indexOf(43);
            String newName = filer.nfName;
            if (index1 != -1) {
                newName = filer.nfName.replaceAll("\\\\", "\\\\\\\\");
            }
            if (index2 != -1) {
                newName = filer.nfName.replaceAll("\\+", "\\\\\\+");
            }
            Object[] args = new String[]{newName, Integer.toString(filer.nfNameFormat)};
            MessageLog.logMessage((String)"SAA0022I", (Object[])args);
            ss_ids[i] = newName + "+" + Integer.toString(filer.nfNameFormat);
            if (filer.nfOSType == 21) {
                svc_int_temp[svcIndex] = filer.nfComputerID;
                ++svcIndex;
            } else {
                ss_int_temp[ssIndex] = filer.nfComputerID;
                ++ssIndex;
            }
            ss_autoIDs[i++] = filer.nfComputerID;
            filer = filer.nfNext;
        }
        int[] svc_int = this.trimArray(svc_int_temp, svcIndex);
        int[] ss_int = this.trimArray(ss_int_temp, ssIndex);
        DeviceRequest dr = new DeviceRequest();
        DeviceRequestHndlr.initDeviceServerComm(dr);
        IJobMgmtService iJob = (IJobMgmtService)ConnectorClient.getService((String)dr.deviceServerHost, (int)dr.deviceServerPort, IJobMgmtService.class, (String)"FabricManagerService");
        if (iJob == null) {
            MessageLog.logMessage((String)"SRV0450E", (Object)IJobMgmtService.class.getName());
            return 8;
        }
        IDiscover iDis = (IDiscover)ConnectorClient.getService((String)dr.deviceServerHost, (int)dr.deviceServerPort, IDiscover.class, (String)"DiscoverService");
        if (iDis == null) {
            MessageLog.logMessage((String)"SRV0450E", (Object)IDiscover.class.getName());
            return 8;
        }
        try {
            String user = this.jobRun.getSchedCreator();
            String schedName = this.jobRun.getSchedName();
            String runNumber = this.jobRun.getFormattedRunNumberSchedID();
            String jobName = this.jobRun.getJobName();
            tar = (AsyncResult)iDis.invoke(user, schedName, runNumber, jobName, "DiskManagerService", IDiskManagerService.class.getName(), device_method, new Object[]{ss_ids, new Integer(6)});
        }
        catch (Exception e) {
            MessageLog.logException((String)"SRV0451E", (Exception)e, (Object)device_method);
            e.printStackTrace();
            return 8;
        }
        catch (Throwable t) {
            MessageLog.logException((String)"SRV0451E", (Exception)new Exception(t), (Object)device_method);
            t.printStackTrace();
            return 8;
        }
        int rc = 8;
        try {
            rc = DeviceJobHndlr.completeDeviceJob(iJob, tar, device_method, this.jobRun.getSchedID(), this.jobRun.getSchedRunNumber(), dr.deviceServerID);
        }
        finally {
            this.updateCollectionStatus(ss_autoIDs, this.dbc);
        }
        RemoveMissingProcessor removeMissingProcessor = new RemoveMissingProcessor();
        removeMissingProcessor.performScheduledSubsystemDeletion();
        return this.ssPostProcessing(svc_int, ss_int, rc);
    }

    private int ssPostProcessing(int[] svcIDs, int[] ssIDs, int rc) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ExecProbeSS.class.getName(), (String)"ssPostProcessing", (String)"svcIDs, ssIDs");
        }
        int resultRC = rc;
        try {
            TResChunk chkAccessor = new TResChunk(this.dbc);
            chkAccessor.ssPopulateChunkInfo(ssIDs);
            chkAccessor.svcPopulateChunkInfo(svcIDs);
            TStatDisk statAccessor = new TStatDisk(this.dbc);
            statAccessor.updateSSandSVCDisks(svcIDs, ssIDs);
            statAccessor.insertSSandSVCDisks(svcIDs, ssIDs);
            TStatDiskHist histAccessor = new TStatDiskHist(this.dbc);
            histAccessor.insertSSandSVCDisks(svcIDs, ssIDs);
        }
        catch (GeneralException ge) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)ExecProbeSS.class.getName(), (String)"ssPostProcessing", (Throwable)ge);
            }
            MessageLog.logException((StorageException)((Object)ge));
            resultRC = 8;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ExecProbeSS.class.getName(), (String)"ssPostProcessing", (int)resultRC);
        }
        return resultRC;
    }

    private int[] trimArray(int[] temp, int length) {
        int[] result = new int[length];
        for (int i = 0; i < length; ++i) {
            result[i] = temp[i];
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCollectionStatus(int[] ss_ids, Connection dbc) {
        String selectCollectionID = "select collection_status from   t_res_storage_subsystem where  subsystem_id in (";
        String updateCollectionID = "update t_res_storage_subsystem set    collection_status = ? where  subsystem_id = ?";
        int[] collectionStatus = new int[ss_ids.length];
        Statement stmt = null;
        ResultSet rs = null;
        try {
            int i;
            String ssIDs = new Integer(ss_ids[0]).toString();
            for (i = 1; i < ss_ids.length; ++i) {
                ssIDs = ssIDs + "," + ss_ids[i];
            }
            selectCollectionID = selectCollectionID + ssIDs + ")";
            stmt = dbc.prepareStatement(selectCollectionID);
            rs = stmt.executeQuery();
            i = 0;
            while (rs.next()) {
                collectionStatus[i++] = rs.getInt(1);
            }
            stmt.close();
            stmt = dbc.prepareStatement(updateCollectionID);
            boolean autoCommit = dbc.getAutoCommit();
            dbc.setAutoCommit(false);
            for (i = 0; i < ss_ids.length; ++i) {
                int status = collectionStatus[i] & 0x7F;
                stmt.setInt(1, status);
                stmt.setInt(2, ss_ids[i]);
                stmt.executeUpdate();
            }
            dbc.commit();
            dbc.setAutoCommit(autoCommit);
        }
        catch (SQLException e) {
            try {
                dbc.rollback();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
            e.printStackTrace();
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException ignore) {}
            }
        }
    }
}

