/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.jobs;

import java.sql.Connection;
import org.eclipse.aperi.Nas.common.NasFiler;
import org.eclipse.aperi.TStorm.server.agentreq.ProbeDefResp;
import org.eclipse.aperi.TStorm.server.agentreq.ScanDefReq;
import org.eclipse.aperi.TStorm.server.guireq.DeviceRequest;
import org.eclipse.aperi.backend.ProbeLock;
import org.eclipse.aperi.common.LinkedInteger;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.IJobMgmtService;
import org.eclipse.aperi.connector.ConnectorClient;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.discovery.RemoveMissingProcessor;
import org.eclipse.aperi.interfaces.IDiscover;
import org.eclipse.aperi.jobs.JobRun;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ServerJob;
import org.eclipse.aperi.server.VMJobResults;
import org.eclipse.aperi.server.handler.DeviceRequestHndlr;
import org.eclipse.aperi.server.handler.agent.ProbeDefHndlr;
import org.eclipse.aperi.server.handler.scheduler.DeviceJobHndlr;
import org.eclipse.aperi.server.req.ComputerID;
import org.eclipse.aperi.tape.api.ITapeManagerService;
import org.eclipse.aperi.xmsg.MessageLog;

public class ExecProbeTape
implements ServerJob {
    private static final String DEVICE_METHOD = "probeTapeLibraries";
    private Connection dbc;
    private JobRun jobRun;

    public ExecProbeTape(Connection dbc) {
        this.initialize(dbc);
    }

    public ExecProbeTape() {
    }

    public void initialize(Connection dbc) {
        this.dbc = dbc;
    }

    public int run(VMJobResults job, String[] parms) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ExecProbeTape.class.getName(), (String)"run", (String)"job, parms");
        }
        this.jobRun = job.getJobRun();
        int traceResult = this.doProbe(this.jobRun.getSchedID());
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ExecProbeTape.class.getName(), (String)"run", (int)traceResult);
        }
        return traceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doProbe(int scheduleID) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ExecProbeTape.class.getName(), (String)"doProbe", (String)"scheduleID");
        }
        int rc = 0;
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.AgentSvp";
        request.serviceName = RequestTypeManager.getInternalName((String)request.typeCode);
        request.machineName = Server.getServerHostName();
        request.userName = null;
        request.flags = 0;
        Response response = null;
        ScanDefReq requestData = new ScanDefReq();
        requestData.scheduleID = scheduleID;
        requestData.computerID = new ComputerID(Server.getServerComputerID());
        request.requestData = requestData;
        response = ProbeDefHndlr.getTapeLibraryProbeDef(requestData, this.dbc);
        if (response == null || response.status > 4 || !(response.responseData instanceof ProbeDefResp)) {
            MessageLog.logMessage((String)"GEN0403E");
            int traceResult = 8;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ExecProbeTape.class.getName(), (String)"doProbe", (int)traceResult);
            }
            return traceResult;
        }
        ProbeDefResp def = (ProbeDefResp)response.responseData;
        def.pdProbeLocal = false;
        LinkedInteger locked = ProbeLock.lock((ProbeDefResp)def, null);
        if (locked == null) {
            int traceResult = 8;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ExecProbeTape.class.getName(), (String)"doProbe", (int)traceResult);
            }
            return traceResult;
        }
        try {
            MessageLog.logMessage((String)"GEN0404I");
            rc = this.probeAll(def);
        }
        finally {
            ProbeLock.unlock((LinkedInteger)locked);
        }
        if (rc == 0) {
            MessageLog.logMessage((String)"GEN0401I");
        } else if (rc > 4) {
            MessageLog.logMessage((String)"GEN0400I");
        } else {
            MessageLog.logMessage((String)"GEN0402I");
        }
        int traceResult = rc;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ExecProbeTape.class.getName(), (String)"doProbe", (int)traceResult);
        }
        return traceResult;
    }

    private int probeAll(ProbeDefResp def) {
        AsyncResult tar;
        int num_filers = 0;
        NasFiler filer = def.pdNasFiler;
        while (filer != null) {
            ++num_filers;
            filer = filer.nfNext;
        }
        String[] library_names = new String[num_filers];
        int i = 0;
        filer = def.pdNasFiler;
        while (filer != null) {
            library_names[i++] = filer.nfName;
            filer = filer.nfNext;
        }
        DeviceRequest dr = new DeviceRequest();
        DeviceRequestHndlr.initDeviceServerComm(dr);
        IJobMgmtService iJob = (IJobMgmtService)ConnectorClient.getService((String)dr.deviceServerHost, (int)dr.deviceServerPort, IJobMgmtService.class, (String)"FabricManagerService");
        if (iJob == null) {
            MessageLog.logMessage((String)"SRV0450E", (Object)IJobMgmtService.class.getName());
            return 8;
        }
        IDiscover iDis = (IDiscover)ConnectorClient.getService((String)dr.deviceServerHost, (int)dr.deviceServerPort, IDiscover.class, (String)"DiscoverService");
        if (iDis == null) {
            MessageLog.logMessage((String)"SRV0450E", (Object)IDiscover.class.getName());
            return 8;
        }
        try {
            String user = this.jobRun.getSchedCreator();
            String schedName = this.jobRun.getSchedName();
            String runNumber = this.jobRun.getFormattedRunNumberSchedID();
            String jobName = this.jobRun.getJobName();
            tar = (AsyncResult)iDis.invoke(user, schedName, runNumber, jobName, "TapeManagerService", ITapeManagerService.class.getName(), DEVICE_METHOD, new Object[]{library_names, new Integer(3)});
        }
        catch (Exception e) {
            MessageLog.logException((String)"SRV0451E", (Exception)e, (Object)DEVICE_METHOD);
            e.printStackTrace();
            return 8;
        }
        catch (Throwable e) {
            MessageLog.logException((String)"SRV0451E", (Exception)new Exception(e), (Object)DEVICE_METHOD);
            e.printStackTrace();
            return 8;
        }
        int rc = DeviceJobHndlr.completeDeviceJob(iJob, tar, DEVICE_METHOD, this.jobRun.getSchedID(), this.jobRun.getSchedRunNumber(), dr.deviceServerID);
        RemoveMissingProcessor removeMissingProcessor = new RemoveMissingProcessor();
        removeMissingProcessor.performScheduledTapeDeletion();
        return rc;
    }
}

