/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.jobs;

import java.sql.Connection;
import org.eclipse.aperi.TStorm.common.CompHist;
import org.eclipse.aperi.TStorm.common.DiskHistory;
import org.eclipse.aperi.TStorm.common.PingHist;
import org.eclipse.aperi.TStorm.common.SSummaryHist;
import org.eclipse.aperi.backend.LockManager;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.table.TStatCompHist;
import org.eclipse.aperi.repository.table.TStatDiskHist;
import org.eclipse.aperi.repository.table.TStatPingHist;
import org.eclipse.aperi.xmsg.MessageLog;

public class HistAvgs {
    private Connection dbc;
    private SSummaryHist spAccumulator = new SSummaryHist();
    private SSummaryHist spAverage = new SSummaryHist();
    private DiskHistory dskSnapShot = new DiskHistory();
    private CompHist cmpAccumulator = new CompHist();
    private PingHist pngAccumulator = new PingHist();
    private long timestamp;
    private String requestType;
    private byte accumType;
    private byte statType;
    public static final int WEEKLY_AVERAGE = 0;
    public static final int MONTHLY_AVERAGE = 1;

    public HistAvgs(Connection dbc) {
        this.dbc = dbc;
        try {
            this.timestamp = SQLUtil.getTimestamp(dbc).getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)HistAvgs.class.getName(), (String)"HistAvgs", (Throwable)e);
            }
            return;
        }
    }

    public void average(int avgType) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)HistAvgs.class.getName(), (String)"average", (String)"avgType");
        }
        if (avgType == 0) {
            this.requestType = MessageLog.getMessageNoID((String)"STS0203L");
            this.accumType = (byte)3;
            this.statType = 1;
        } else {
            this.requestType = MessageLog.getMessageNoID((String)"STS0204L");
            this.accumType = (byte)4;
            this.statType = (byte)2;
        }
        MessageLog.logMessage((String)"STS0031I", (Object)this.requestType);
        try {
            LockManager.lock((short)0, (String)"History", (String)"DiskHist", (byte)1, (boolean)true);
            this.genDiskSnapShots();
            LockManager.lock((short)0, (String)"History", (String)"CompHist", (byte)1, (boolean)true);
            this.genCmpAverages();
            LockManager.lock((short)0, (String)"History", (String)"PingHist", (byte)1, (boolean)true);
            this.genPngAverages();
            MessageLog.logMessage((String)"STS0032I", (Object)this.requestType);
        }
        catch (GeneralException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)HistAvgs.class.getName(), (String)"average", (Throwable)e);
            }
            MessageLog.logMessage((String)"STS0030E", (Object)this.requestType);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)HistAvgs.class.getName(), (String)"average");
            }
            throw e;
        }
        finally {
            LockManager.unLock((short)0, (String)"History", (String)"DiskHist");
            LockManager.unLock((short)0, (String)"History", (String)"CompHist");
            LockManager.unLock((short)0, (String)"History", (String)"PingHist");
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)HistAvgs.class.getName(), (String)"average");
        }
    }

    private void genDiskSnapShots() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)HistAvgs.class.getName(), (String)"genDiskSnapShots", (String)"");
        }
        TStatDiskHist dskHistAccessor = new TStatDiskHist(this.dbc);
        dskHistAccessor.prepSnapShots();
        while (dskHistAccessor.fetchMostRecent(this.dskSnapShot)) {
            this.dskSnapShot.dkhType = this.statType;
            this.dskSnapShot.dkhTimestamp = this.timestamp;
            dskHistAccessor.insertHist(this.dskSnapShot);
        }
        dskHistAccessor.closeSnapShots();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)HistAvgs.class.getName(), (String)"genDiskSnapShots");
        }
    }

    private void genCmpAverages() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)HistAvgs.class.getName(), (String)"genCmpAverages", (String)"");
        }
        TStatCompHist cmpHistAccessor = new TStatCompHist(this.dbc);
        cmpHistAccessor.prepAverages(this.accumType);
        this.cmpAccumulator.chStatisticType = this.accumType;
        while (cmpHistAccessor.fetch(this.cmpAccumulator)) {
            if (this.cmpAccumulator.chMonitorStart <= 86400000L) continue;
            this.cmpAccumulator.chStatisticType = this.statType;
            cmpHistAccessor.insert(this.cmpAccumulator);
            this.cmpAccumulator.chMonitorStart = 0L;
            this.cmpAccumulator.chMonitorEnd = 0L;
            this.cmpAccumulator.chDownTime = 0;
            this.cmpAccumulator.chPowerCycles = 0;
            this.cmpAccumulator.chStatisticType = this.accumType;
            cmpHistAccessor.update(this.cmpAccumulator);
            cmpHistAccessor.commit();
        }
        cmpHistAccessor.closeAverages();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)HistAvgs.class.getName(), (String)"genCmpAverages");
        }
    }

    private void genPngAverages() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)HistAvgs.class.getName(), (String)"genPngAverages", (String)"");
        }
        TStatPingHist pngHistAccessor = new TStatPingHist(this.dbc);
        pngHistAccessor.prepAverages(this.accumType);
        this.pngAccumulator.pngStatisticType = this.accumType;
        while (pngHistAccessor.fetch(this.pngAccumulator)) {
            if (this.pngAccumulator.pngMonitorStart <= 86400000L) continue;
            this.pngAccumulator.pngStatisticType = this.statType;
            if (this.pngAccumulator.pngReceived > 0) {
                this.pngAccumulator.pngAvgTransitTime /= (long)this.pngAccumulator.pngReceived;
            }
            pngHistAccessor.insert(this.pngAccumulator);
            this.pngAccumulator.pngMonitorStart = 0L;
            this.pngAccumulator.pngMonitorEnd = 0L;
            this.pngAccumulator.pngTransmitted = 0;
            this.pngAccumulator.pngReceived = 0;
            this.pngAccumulator.pngDamaged = 0;
            this.pngAccumulator.pngMinTransitTime = Integer.MAX_VALUE;
            this.pngAccumulator.pngMaxTransitTime = 0;
            this.pngAccumulator.pngAvgTransitTime = 0L;
            this.pngAccumulator.pngStatisticType = this.accumType;
            pngHistAccessor.update(this.pngAccumulator);
            pngHistAccessor.commit();
        }
        pngHistAccessor.closeAverages();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)HistAvgs.class.getName(), (String)"genPngAverages");
        }
    }
}

