/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.jobs;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.util.HashMap;
import org.eclipse.aperi.TStorm.common.PingHist;
import org.eclipse.aperi.backend.LockManager;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.LinkedInteger;
import org.eclipse.aperi.common.dbaccess.HostAgentPingDbAccess;
import org.eclipse.aperi.jobs.JobRun;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.table.TStatPingHist;
import org.eclipse.aperi.server.AgentLessManagedNode;
import org.eclipse.aperi.server.AgentManager;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ServerJob;
import org.eclipse.aperi.server.VMJobResults;
import org.eclipse.aperi.server.alert.PingAlerter;
import org.eclipse.aperi.server.svp.AgentSvp;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;

public class Ping
implements ServerJob {
    private static HashMap<PingStats, PingStats> statMap = new HashMap();
    private static AgentManager agentMgr = Server.getAgentManager();
    private static long startTime;
    private static final String pingFileName;
    public static final int SUCCESS = 0;
    public static final int PACKET_DAMAGED = 1;
    public static final int UNREACHABLE = 2;
    private static final long[] INTERVAL_UNITS;
    private Connection dbc;
    private long nativeHandle;
    private int transitTime;
    private long saveInterval;
    private int saveIntervalType;
    private int alertID;
    private VMJobResults jobResults;
    private boolean jobLogInitialized;

    public Ping(Connection dbc) {
        this.initialize(dbc);
    }

    public Ping() {
    }

    public void initialize(Connection dbc) {
        this.dbc = dbc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Ping.class.getName(), (String)"init", (String)"");
        }
        Connection dbc = Ping.getConnection();
        try {
            Ping png = new Ping(dbc);
            png.getPingFile();
        }
        finally {
            Server.returnConnection(dbc);
        }
        try {
            startTime = SQLUtil.getTimestamp(dbc).getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)PingStats.class.getName(), (String)"init", (Throwable)e);
            }
            return;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Ping.class.getName(), (String)"init");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void term(byte termOption) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Ping.class.getName(), (String)"term", (String)"termOption");
        }
        Connection dbc = null;
        HashMap<PingStats, PingStats> hashMap = statMap;
        synchronized (hashMap) {
            PingStats statList = null;
            for (PingStats stats : statMap.values()) {
                if (stats.pingInProgress || stats.transmitted <= 0) continue;
                stats.next = statList;
                statList = stats;
            }
            if (termOption == 1) {
                try {
                    dbc = Ping.getConnection();
                    Ping png = new Ping(dbc);
                    png.saveToRepository(statList);
                }
                catch (GeneralException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)Ping.class.getName(), (String)"term", (Throwable)e);
                    }
                    MessageLog.logException((String)"STS0045E", (Exception)((Object)e));
                    termOption = (byte)2;
                }
                finally {
                    if (dbc != null) {
                        Server.returnConnection(dbc);
                    }
                }
            }
            if (termOption == 2) {
                Ping.saveToFile(statList);
            }
            statMap.clear();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Ping.class.getName(), (String)"term");
        }
    }

    public int run(VMJobResults job, String[] parms) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Ping.class.getName(), (String)"run", (String)"job, parms");
        }
        this.jobResults = job;
        JobRun jobRun = job.getJobRun();
        int completionCode = 8;
        try {
            int intervalValue = Integer.parseInt(parms[0]);
            this.saveIntervalType = Integer.parseInt(parms[1]);
            this.saveInterval = (long)(intervalValue + 1) * INTERVAL_UNITS[this.saveIntervalType];
            this.alertID = parms.length > 2 && parms[2] != null ? Integer.parseInt(parms[2]) : -1;
            completionCode = this.ping(jobRun);
        }
        catch (IndexOutOfBoundsException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)Ping.class.getName(), (String)"run", (Throwable)e);
            }
            this.initJobLog();
            MessageLog.logMessage((String)"STS0043E", (Object)jobRun.getSchedCreator(), (Object)jobRun.getSchedName());
        }
        catch (NumberFormatException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)Ping.class.getName(), (String)"run", (Throwable)e);
            }
            this.initJobLog();
            MessageLog.logMessage((String)"STS0043E", (Object)jobRun.getSchedCreator(), (Object)jobRun.getSchedName());
        }
        catch (LocalizableException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)Ping.class.getName(), (String)"run", (Throwable)e);
            }
            this.initJobLog();
            MessageLog.logMessage((String)"STS0044E", (Object)jobRun.getSchedCreator(), (Object)jobRun.getSchedName());
            e.print();
        }
        catch (GeneralException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)Ping.class.getName(), (String)"run", (Throwable)e);
            }
            this.initJobLog();
            MessageLog.logException((String)"STS0044E", (Exception)((Object)e), (Object)jobRun.getSchedCreator(), (Object)jobRun.getSchedName());
        }
        int traceResult = completionCode;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Ping.class.getName(), (String)"run", (int)traceResult);
        }
        return traceResult;
    }

    private void initJobLog() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Ping.class.getName(), (String)"initJobLog", (String)"");
        }
        if (!this.jobLogInitialized) {
            this.jobResults.setJobLog();
            this.jobLogInitialized = true;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Ping.class.getName(), (String)"initJobLog");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int ping(JobRun jobRun) throws LocalizableException, GeneralException {
        PingStats stats;
        int returnCode;
        PingStats statList;
        String scheduleLockName;
        boolean processAlert;
        block40: {
            block39: {
                if (TraceLogger.enableTrace) {
                    TraceLogger.entry((String)Ping.class.getName(), (String)"ping", (String)"jobRun");
                }
                processAlert = false;
                scheduleLockName = null;
                statList = null;
                returnCode = 0;
                scheduleLockName = String.valueOf(jobRun.getSchedID());
                boolean haveLock = LockManager.lock((short)0, (String)"Ping", (String)scheduleLockName, (byte)1, (boolean)false);
                if (haveLock) break block39;
                scheduleLockName = null;
                int traceResult = 0;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)Ping.class.getName(), (String)"ping", (int)traceResult);
                }
                int n = traceResult;
                PingStats stats2 = statList;
                while (stats2 != null) {
                    PingStats next = stats2.next;
                    stats2.pingInProgress = false;
                    stats2 = next;
                }
                if (this.nativeHandle != 0L) {
                    Ping.close(this.nativeHandle);
                }
                if (scheduleLockName != null) {
                    LockManager.unLock((short)0, (String)"Ping", (String)scheduleLockName);
                }
                return n;
            }
            statList = this.buildStatList(jobRun.getComputerList());
            if (statList != null) break block40;
            int traceResult = 0;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Ping.class.getName(), (String)"ping", (int)traceResult);
            }
            int n = traceResult;
            PingStats stats3 = statList;
            while (stats3 != null) {
                PingStats next = stats3.next;
                stats3.pingInProgress = false;
                stats3 = next;
            }
            if (this.nativeHandle != 0L) {
                Ping.close(this.nativeHandle);
            }
            if (scheduleLockName != null) {
                LockManager.unLock((short)0, (String)"Ping", (String)scheduleLockName);
            }
            return n;
        }
        try {
            this.nativeHandle = Ping.open(AgentSvp.pingReceiveTimeout);
            PingStats stats4 = statList;
            while (stats4 != null) {
                String hostAddress = agentMgr.getHostAddress(stats4.computerID);
                AgentLessManagedNode agentLessNode = null;
                if (hostAddress == null && (agentLessNode = agentMgr.getNasComputer(stats4.computerID)) != null && !agentLessNode.expired) {
                    hostAddress = agentLessNode.networkAddress;
                }
                if (hostAddress == null) {
                    if (agentLessNode == null || agentLessNode.osType != 20) {
                        this.initJobLog();
                        MessageLog.logMessage((String)"STS0124E", (Object)Integer.toString(stats4.computerID));
                        returnCode = 8;
                    }
                } else {
                    int status = 2;
                    try {
                        status = this.ping(this.nativeHandle, hostAddress);
                    }
                    catch (LocalizableException e) {
                        if (TraceLogger.enableTrace) {
                            TraceLogger.exception((String)Ping.class.getName(), (String)"ping", (Throwable)e);
                        }
                        this.initJobLog();
                        e.print();
                        returnCode = e.getKey().equals("STS0036E") && returnCode <= 4 ? 4 : 8;
                    }
                    stats4.lastPingStatus = status;
                    stats4.transmitted = (short)(stats4.transmitted + 1);
                    if (status == 2) {
                        stats4.unreachableCount = (short)(stats4.unreachableCount + 1);
                        processAlert = true;
                        if (returnCode < 4) {
                            returnCode = 4;
                        }
                    } else {
                        stats4.unreachableCount = 0;
                        if (stats4.alertExists) {
                            processAlert = true;
                        }
                        if (this.transitTime < stats4.minTransitTime) {
                            stats4.minTransitTime = this.transitTime;
                        }
                        if (this.transitTime > stats4.maxTransitTime) {
                            stats4.maxTransitTime = this.transitTime;
                        }
                        stats4.totalTransitTime += (long)this.transitTime;
                        stats4.received = (short)(stats4.received + 1);
                        if (status == 1) {
                            stats4.damaged = (short)(stats4.damaged + 1);
                        }
                    }
                }
                stats4 = stats4.next;
            }
            this.saveToRepository(statList);
            if (processAlert && this.alertID > 0) {
                try {
                    PingAlerter alerter = new PingAlerter(this.dbc, statList, this.alertID);
                    alerter.alert();
                }
                catch (LocalizableException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)Ping.class.getName(), (String)"ping", (Throwable)e);
                    }
                    this.initJobLog();
                    e.print();
                }
            }
            stats = statList;
        }
        catch (Throwable throwable) {
            PingStats stats5 = statList;
            while (stats5 != null) {
                PingStats next = stats5.next;
                stats5.pingInProgress = false;
                stats5 = next;
            }
            if (this.nativeHandle != 0L) {
                Ping.close(this.nativeHandle);
            }
            if (scheduleLockName != null) {
                LockManager.unLock((short)0, (String)"Ping", (String)scheduleLockName);
            }
            throw throwable;
        }
        while (stats != null) {
            PingStats next = stats.next;
            stats.pingInProgress = false;
            stats = next;
        }
        if (this.nativeHandle != 0L) {
            Ping.close(this.nativeHandle);
        }
        if (scheduleLockName != null) {
            LockManager.unLock((short)0, (String)"Ping", (String)scheduleLockName);
        }
        int traceResult = returnCode;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Ping.class.getName(), (String)"ping", (int)traceResult);
        }
        return traceResult;
    }

    private static native long open(int var0) throws LocalizableException;

    private static native void close(long var0);

    private native int ping(long var1, String var3) throws LocalizableException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PingStats buildStatList(LinkedInteger computerList) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Ping.class.getName(), (String)"buildStatList", (String)"computerList");
        }
        PingStats statList = null;
        PingStats key = new PingStats();
        HashMap<PingStats, PingStats> hashMap = statMap;
        synchronized (hashMap) {
            LinkedInteger computer = computerList;
            while (computer != null) {
                key.computerID = computer.value;
                PingStats stat = statMap.get(key);
                if (stat == null) {
                    stat = new PingStats(computer.value, startTime);
                    statMap.put(stat, stat);
                }
                if (!stat.pingInProgress) {
                    stat.next = statList;
                    statList = stat;
                    stat.pingInProgress = true;
                }
                computer = computer.next;
            }
        }
        PingStats traceResult = statList;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Ping.class.getName(), (String)"buildStatList", traceResult);
        }
        return traceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToRepository(PingStats statList) throws GeneralException {
        PingStats stats;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Ping.class.getName(), (String)"saveToRepository", (String)"statList");
        }
        long currentTime = 0L;
        boolean saveInitialized = false;
        PingHist ph = null;
        TStatPingHist phAccessor = null;
        try {
            currentTime = SQLUtil.getTimestamp(this.dbc).getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)PingStats.class.getName(), (String)"saveToRepository", (Throwable)e);
            }
            return;
        }
        try {
            stats = statList;
            while (stats != null) {
                boolean save;
                if (this.saveIntervalType == 0) {
                    save = (long)stats.transmitted >= this.saveInterval;
                } else {
                    boolean bl = save = currentTime - stats.lastSaveTime >= this.saveInterval;
                }
                if (save) {
                    if (!saveInitialized) {
                        saveInitialized = true;
                        LockManager.lock((short)0, (String)"History", (String)"PingHist", (byte)2, (boolean)true);
                        ph = new PingHist();
                        ph.pngMonitorEnd = currentTime;
                        phAccessor = new TStatPingHist(this.dbc);
                        phAccessor.prepSave();
                    }
                    ph.pngComputerID = stats.computerID;
                    ph.pngTransmitted = stats.transmitted;
                    ph.pngReceived = stats.received;
                    ph.pngDamaged = stats.damaged;
                    ph.pngMinTransitTime = stats.minTransitTime;
                    ph.pngMaxTransitTime = stats.maxTransitTime;
                    ph.pngAvgTransitTime = stats.totalTransitTime;
                    ph.pngMonitorStart = stats.lastSaveTime;
                    stats.lastSaveTime = currentTime;
                    phAccessor.save(ph);
                    stats.resetStats(currentTime);
                }
                stats = stats.next;
            }
            if (saveInitialized) {
                phAccessor.closeSave();
            }
        }
        finally {
            if (saveInitialized) {
                LockManager.unLock((short)0, (String)"History", (String)"PingHist");
            }
        }
        stats = statList;
        while (stats != null) {
            HostAgentPingDbAccess.updateHostStatus((int)stats.computerID, (int)(stats.lastPingStatus > 0 ? stats.lastPingStatus : 1));
            stats = stats.next;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Ping.class.getName(), (String)"saveToRepository");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteComputer(int computerID) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Ping.class.getName(), (String)"deleteComputer", (String)"computerID");
        }
        PingStats key = new PingStats();
        key.computerID = computerID;
        HashMap<PingStats, PingStats> hashMap = statMap;
        synchronized (hashMap) {
            statMap.remove(key);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Ping.class.getName(), (String)"deleteComputer");
        }
    }

    private static void saveToFile(PingStats statList) {
        boolean written;
        block18: {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)Ping.class.getName(), (String)"saveToFile", (String)"statList");
            }
            PingStats[] statArray = Ping.packStats(statList);
            FileOutputStream fStream = null;
            ObjectOutputStream oStream = null;
            written = false;
            try {
                fStream = new FileOutputStream(pingFileName);
            }
            catch (IOException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)Ping.class.getName(), (String)"saveToFile", (Throwable)e);
                }
                MessageLog.logException((String)"STS0046E", (Exception)e, (Object)pingFileName);
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)Ping.class.getName(), (String)"saveToFile");
                }
                return;
            }
            try {
                oStream = new ObjectOutputStream(fStream);
                oStream.writeObject(statArray);
                written = true;
            }
            catch (IOException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)Ping.class.getName(), (String)"saveToFile", (Throwable)e);
                }
                MessageLog.logException((String)"STS0047E", (Exception)e, (Object)pingFileName);
            }
            if (oStream != null) {
                try {
                    oStream.close();
                }
                catch (IOException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)Ping.class.getName(), (String)"saveToFile", (Throwable)e);
                    }
                    if (written) {
                        MessageLog.logException((String)"STS0047E", (Exception)e, (Object)pingFileName);
                        written = false;
                    }
                    break block18;
                }
            }
            if (fStream != null) {
                try {
                    ((OutputStream)fStream).close();
                }
                catch (IOException e) {
                    if (!TraceLogger.enableTrace) break block18;
                    TraceLogger.exception((String)Ping.class.getName(), (String)"saveToFile", (Throwable)e);
                }
            }
        }
        if (!written) {
            File pingFile = new File(pingFileName);
            pingFile.delete();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Ping.class.getName(), (String)"saveToFile");
        }
    }

    private void getPingFile() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Ping.class.getName(), (String)"getPingFile", (String)"");
        }
        FileInputStream fStream = null;
        ObjectInputStream oStream = null;
        File pingFile = new File(pingFileName);
        if (pingFile.canRead()) {
            block27: {
                block26: {
                    try {
                        fStream = new FileInputStream(pingFileName);
                    }
                    catch (FileNotFoundException e) {
                        if (!TraceLogger.enableTrace) break block26;
                        TraceLogger.exception((String)Ping.class.getName(), (String)"getPingFile", (Throwable)e);
                    }
                }
                if (fStream != null) {
                    try {
                        oStream = new ObjectInputStream(fStream);
                    }
                    catch (IOException e) {
                        if (TraceLogger.enableTrace) {
                            TraceLogger.exception((String)Ping.class.getName(), (String)"getPingFile", (Throwable)e);
                        }
                        MessageLog.logException((String)"STS0048W", (Exception)e, (Object)pingFileName);
                        try {
                            ((InputStream)fStream).close();
                        }
                        catch (IOException x) {
                            // empty catch block
                        }
                        if (TraceLogger.enableTrace) {
                            TraceLogger.exit((String)Ping.class.getName(), (String)"getPingFile");
                        }
                        return;
                    }
                }
                try {
                    PingStats[] statArray = (PingStats[])oStream.readObject();
                    if (statArray != null) {
                        this.saveToRepository(Ping.unpackStats(statArray));
                    }
                }
                catch (EOFException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)Ping.class.getName(), (String)"getPingFile", (Throwable)e);
                    }
                }
                catch (ClassNotFoundException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)Ping.class.getName(), (String)"getPingFile", (Throwable)e);
                    }
                    MessageLog.logMessage((String)"STS0048W", (Object)pingFileName);
                    MessageLog.logException((String)"STS0049W", (Exception)e, (Object)pingFileName);
                }
                catch (IOException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)Ping.class.getName(), (String)"getPingFile", (Throwable)e);
                    }
                    MessageLog.logException((String)"STS0048W", (Exception)e, (Object)pingFileName);
                }
                catch (ClassCastException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)Ping.class.getName(), (String)"getPingFile", (Throwable)e);
                    }
                    MessageLog.logMessage((String)"STS0048W", (Object)pingFileName);
                    MessageLog.logException((String)"STS0050W", (Exception)e, (Object)pingFileName);
                }
                catch (GeneralException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)Ping.class.getName(), (String)"getPingFile", (Throwable)e);
                    }
                    MessageLog.logException((String)"STS0051W", (Exception)((Object)e));
                }
                try {
                    oStream.close();
                }
                catch (IOException e) {
                    if (!TraceLogger.enableTrace) break block27;
                    TraceLogger.exception((String)Ping.class.getName(), (String)"getPingFile", (Throwable)e);
                }
            }
            pingFile.delete();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Ping.class.getName(), (String)"getPingFile");
        }
    }

    private static Connection getConnection() throws GeneralException {
        Connection dbc;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Ping.class.getName(), (String)"getConnection", (String)"");
        }
        if ((dbc = Server.getConnection()) == null) {
            MessageLog.logMessage((String)"GEN0050E");
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Ping.class.getName(), (String)"getConnection");
            }
            throw new GeneralException();
        }
        Connection traceResult = dbc;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Ping.class.getName(), (String)"getConnection", (Object)traceResult);
        }
        return traceResult;
    }

    private static PingStats[] packStats(PingStats statList) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Ping.class.getName(), (String)"packStats", (String)"statList");
        }
        int count = 0;
        PingStats stats = statList;
        while (stats != null) {
            ++count;
            stats = stats.next;
        }
        PingStats[] statArray = new PingStats[count];
        PingStats stats2 = statList;
        while (stats2 != null) {
            statArray[--count] = stats2;
            stats2 = stats2.next;
        }
        PingStats[] traceResult = statArray;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Ping.class.getName(), (String)"packStats", (Object)traceResult);
        }
        return traceResult;
    }

    private static PingStats unpackStats(PingStats[] statArray) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Ping.class.getName(), (String)"unpackStats", (String)"statArray");
        }
        PingStats statList = null;
        if (statArray != null) {
            for (int i = 0; i < statArray.length; ++i) {
                PingStats stats = statArray[i];
                stats.next = statList;
                statList = stats;
            }
        }
        PingStats traceResult = statList;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Ping.class.getName(), (String)"unpackStats", traceResult);
        }
        return traceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int pingHostByName(String hostName) {
        long nativeHandle = 0L;
        int status = 2;
        try {
            Ping pong = new Ping();
            nativeHandle = Ping.open(AgentSvp.pingReceiveTimeout);
            status = pong.ping(nativeHandle, hostName);
        }
        catch (LocalizableException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)Ping.class.getName(), (String)"ping", (Throwable)e);
            }
            e.print();
            status = e.getKey().equals("STS0036E") && status <= 4 ? 4 : 8;
        }
        finally {
            if (nativeHandle != 0L) {
                Ping.close(nativeHandle);
            }
        }
        return status;
    }

    static {
        pingFileName = "PING." + Server.getServerName();
        INTERVAL_UNITS = new long[]{1L, 60000L, 3600000L, 86400000L};
    }

    public static class PingStats
    implements Serializable {
        static final long serialVersionUID = 2885925143459169759L;
        public transient PingStats next;
        public int computerID;
        public long totalTransitTime;
        public int minTransitTime = Integer.MAX_VALUE;
        public int maxTransitTime;
        public short transmitted;
        public short received;
        public short damaged;
        public long lastSaveTime;
        public transient short unreachableCount;
        public transient boolean alertExists = true;
        public transient boolean pingInProgress;
        public int lastPingStatus;

        PingStats() {
            this(0, 0L);
        }

        PingStats(int computerID, long lastSaveTime) {
            this.computerID = computerID;
            this.lastSaveTime = lastSaveTime;
        }

        void resetStats(long lastSaveTime) {
            this.lastSaveTime = lastSaveTime;
            this.totalTransitTime = 0L;
            this.minTransitTime = Integer.MAX_VALUE;
            this.maxTransitTime = 0;
            this.transmitted = 0;
            this.received = 0;
            this.damaged = 0;
        }

        public boolean equals(Object o) {
            boolean traceResult;
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)PingStats.class.getName(), (String)"equals", (String)"o");
            }
            PingStats other = (PingStats)o;
            boolean bl = traceResult = this.computerID == other.computerID;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)PingStats.class.getName(), (String)"equals", (boolean)traceResult);
            }
            return traceResult;
        }

        public int hashCode() {
            return this.computerID;
        }
    }
}

