/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.jobs;

import java.sql.Connection;
import org.eclipse.aperi.TStorm.common.FabricDiscoveryOptions;
import org.eclipse.aperi.TStorm.server.guireq.DeviceRequest;
import org.eclipse.aperi.backend.LockManager;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.IJobMgmtService;
import org.eclipse.aperi.connector.ConnectorClient;
import org.eclipse.aperi.fabric.api.IFabricManagerService;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.interfaces.IDiscover;
import org.eclipse.aperi.jobs.JobRun;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.table.TResIpAddresses;
import org.eclipse.aperi.server.ServerJob;
import org.eclipse.aperi.server.VMJobResults;
import org.eclipse.aperi.server.handler.DeviceRequestHndlr;
import org.eclipse.aperi.server.handler.scheduler.DeviceJobHndlr;
import org.eclipse.aperi.xmsg.MessageLog;

public class SnmpDiscover
implements ServerJob {
    public static final String LOCK_RESOURCE_TYPE = "SnmpDiscovery";
    private Connection dbc;
    private VMJobResults job;
    private JobRun jobRun;
    private FabricDiscoveryOptions fdo;
    private final int DISCOVERY_EXECUTED = 8;

    public SnmpDiscover(Connection dbc) {
        this.initialize(dbc);
    }

    public SnmpDiscover() {
    }

    public void initialize(Connection dbc) {
        this.dbc = dbc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(VMJobResults job, String[] parms) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SnmpDiscover.class.getName(), (String)"run", (String)"job, parms");
        }
        this.job = job;
        this.jobRun = job.getJobRun();
        MessageLog.logMessage((String)"SRV0500I", (Object)this.jobRun.getSchedCreator(), (Object)this.jobRun.getSchedName());
        this.fdo = new FabricDiscoveryOptions(parms.length > 0 ? parms[0] : null);
        String resourceName = LOCK_RESOURCE_TYPE;
        int completionCode = 8;
        boolean haveLock = false;
        try {
            haveLock = LockManager.lock((short)0, (String)LOCK_RESOURCE_TYPE, (String)resourceName, (byte)1, (boolean)false);
            if (!haveLock) {
                MessageLog.logMessage((String)"SRV0501W", (Object)this.jobRun.getSchedCreator(), (Object)this.jobRun.getSchedName());
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)SnmpDiscover.class.getName(), (String)"run", (int)8);
                }
                int n = 8;
                return n;
            }
            completionCode = this.doSNMPDiscovery();
        }
        catch (Exception e) {
            MessageLog.logMessage((String)"SRV0506E");
            e.printStackTrace(MessageLog.getThreadLog());
        }
        finally {
            if (haveLock) {
                LockManager.unLock((short)0, (String)LOCK_RESOURCE_TYPE, (String)resourceName);
            }
        }
        if (completionCode == 0) {
            MessageLog.logMessage((String)"SRV0503I");
        } else if (completionCode < 4) {
            MessageLog.logMessage((String)"SRV0504W");
        } else {
            MessageLog.logMessage((String)"SRV0505E");
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SnmpDiscover.class.getName(), (String)"run", (int)completionCode);
        }
        return completionCode;
    }

    private int doSNMPDiscovery() {
        AsyncResult tar;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SnmpDiscover.class.getName(), (String)"doSNMPDiscovery", (String)"");
        }
        DeviceRequest dr = new DeviceRequest();
        DeviceRequestHndlr.initDeviceServerComm(dr);
        IDiscover iDis = (IDiscover)ConnectorClient.getService((String)dr.deviceServerHost, (int)dr.deviceServerPort, IDiscover.class, (String)"DiscoverService");
        if (iDis == null) {
            MessageLog.logMessage((String)"SRV0450E", (Object)IDiscover.class.getName());
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)SnmpDiscover.class.getName(), (String)"doSNMPDiscovery", (int)8);
            }
            return 8;
        }
        IJobMgmtService iJob = (IJobMgmtService)ConnectorClient.getService((String)dr.deviceServerHost, (int)dr.deviceServerPort, IJobMgmtService.class, (String)"FabricManagerService");
        if (iJob == null) {
            MessageLog.logMessage((String)"SRV0450E", (Object)IJobMgmtService.class.getName());
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)SnmpDiscover.class.getName(), (String)"doSNMPDiscovery", (int)8);
            }
            return 8;
        }
        String method = "discoverSNMPAgents";
        String[] base_ips = SnmpDiscover.fetchBaseIPs();
        try {
            String user = this.jobRun.getSchedCreator();
            String jobName = this.jobRun.getSchedName();
            String schedId = this.jobRun.getFormattedRunNumberSchedID();
            String jobDesc = this.jobRun.getJobName();
            tar = (AsyncResult)iDis.invoke(user, jobName, schedId, jobDesc, "FabricManagerService", IFabricManagerService.class.getName(), "discoverSNMPAgents", new Object[]{base_ips, this.fdo.getDefaultCommunity(), this.fdo.getUserName(), this.fdo.getPasword()});
        }
        catch (Exception e) {
            MessageLog.logException((String)"SRV0451E", (Exception)e, (Object)method);
            e.printStackTrace();
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)SnmpDiscover.class.getName(), (String)"doSNMPDiscovery", (int)8);
            }
            return 8;
        }
        catch (Throwable e) {
            MessageLog.logException((String)"SRV0451E", (Exception)new Exception(e), (Object)method);
            e.printStackTrace();
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)SnmpDiscover.class.getName(), (String)"doSNMPDiscovery", (int)8);
            }
            return 8;
        }
        int rc = DeviceJobHndlr.completeDeviceJob(iJob, tar, method, this.jobRun.getSchedID(), this.jobRun.getSchedRunNumber(), dr.deviceServerID);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SnmpDiscover.class.getName(), (String)"doSNMPDiscovery", (int)rc);
        }
        return rc;
    }

    public static String[] fetchBaseIPs() {
        NameList nl;
        String[] base_ips = null;
        int count = 0;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SnmpDiscover.class.getName(), (String)"fetchBaseIPs", (String)"");
        }
        TResIpAddresses trip = new TResIpAddresses();
        try {
            String type = DBConstants.getValueFromKey((String)"IP_Address_Type", (String)"SNMP TRAP IP");
            nl = trip.getIPAddressList(Integer.parseInt(type));
        }
        catch (GeneralException e) {
            e.printStackTrace(MessageLog.getThreadLog());
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)SnmpDiscover.class.getName(), (String)"fetchBaseIPs");
            }
            return null;
        }
        NameList nlWork = nl;
        while (nlWork != null) {
            ++count;
            nlWork = nlWork.nlNext;
        }
        if (count > 0) {
            base_ips = new String[count];
            count = 0;
            nlWork = nl;
            while (nlWork != null) {
                base_ips[count++] = nlWork.nlName;
                nlWork = nlWork.nlNext;
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SnmpDiscover.class.getName(), (String)"fetchBaseIPs", (Object)base_ips);
        }
        return base_ips;
    }
}

