/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.svp;

import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.logging.TraceLoggerFactory;
import org.eclipse.aperi.server.RequestManager;
import org.eclipse.aperi.server.ServiceProvider;
import org.eclipse.aperi.server.ServiceQueue;
import org.eclipse.aperi.server.svp.AgentSvp;
import org.eclipse.aperi.xmsg.MessageLog;

public class GuiSvp
extends ServiceProvider {
    private static final String CLASSNAME = GuiSvp.class.getName();
    private static final int GUI_PENDING_REQUEST_LIMIT = 4;
    public static final String EXTENSION_POINT_ID = "org.eclipse.aperi.server.data.guiHandler";
    private RequestManager rm;

    public String getTypeCode() {
        return "org.eclipse.aperi.server.svp.GuiSvp";
    }

    public void startup(ServiceQueue queue) throws Exception {
        String methodName = "startup";
        TraceLoggerFactory.startLogger((String)"ITSRM.logger.trace.TivoliSRM-GUI", (String)this.getTypeCode());
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"startup", (String)"queue");
        }
        AgentSvp.stormInit();
        this.rm = new RequestManager(EXTENSION_POINT_ID, queue, AgentSvp.threadGroup, "StormGuiRequestHandler", 5, AgentSvp.guiThreadPoolSize, AgentSvp.guiMaxThreads, 4);
        if (!this.rm.initialize()) {
            AgentSvp.stormTerm();
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)CLASSNAME, (String)"startup");
            }
            throw new Exception();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"startup");
        }
    }

    public void shutdown(byte shutdownOption) {
        String methodName = "shutdown";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"shutdown", (String)"shutdown");
        }
        TraceLoggerFactory.stopLogger((String)this.getTypeCode());
        MessageLog.logMessage((String)"STS0002I");
        if (this.rm != null) {
            this.rm.dispose();
            this.rm = null;
        }
        AgentSvp.stormTerm();
    }
}

