/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.util;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.Socket;
import java.util.HashMap;
import org.eclipse.aperi.TStorm.common.GroupDefinition;
import org.eclipse.aperi.TStorm.common.Report;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.CreateHeader;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.SocketTransceiver;
import org.eclipse.aperi.server.ConfigParser;
import org.eclipse.aperi.server.req.ServerStatusResp;
import org.eclipse.aperi.xmsg.MessageLog;

public class Export {
    private static String serverHost;
    private static int serverPort;
    private static String fileName;
    private static Request request;
    private static ObjectOutputStream oStream;
    private static HashMap<MutableInteger, MutableInteger> idMap;
    private static MutableInteger hashKey;
    private static int serverComputerID;
    private static boolean export;
    private static boolean objectsProcessed;

    public static void main(String[] args) throws Exception {
        Export.getArgs(args);
        ConfigParser parser = new ConfigParser("config/server.config", null);
        if (!parser.parse()) {
            System.exit(8);
        }
        serverHost = "localhost";
        serverPort = parser.listenerPort;
        Export.request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        Export.request.serviceName = RequestTypeManager.getInternalName((String)Export.request.typeCode);
        Export.request.flags = (byte)4;
        if (export) {
            Export.exportFile();
        } else {
            Export.importFile();
        }
    }

    private static void getArgs(String[] args) {
        String response;
        if (args.length > 0 && args.length < 2) {
            Export.exitWithMessage("GEN1001I");
        }
        if (args.length == 2) {
            export = args[0].equalsIgnoreCase("-e");
            if (!export && !args[0].equalsIgnoreCase("-i")) {
                Export.exitWithMessage("GEN1001I");
            }
            fileName = args[1];
            return;
        }
        BufferedReader reader = null;
        reader = new BufferedReader(new InputStreamReader(System.in));
        String prompt = MessageLog.getMessageNoID((String)"GEN1020L") + " ";
        while (!(response = Export.getUserInput(reader, prompt, "e")).equalsIgnoreCase("i") && !response.equalsIgnoreCase("e")) {
        }
        export = response.equalsIgnoreCase("e");
        prompt = MessageLog.getMessageNoID((String)"GEN1021L") + " ";
        while ((fileName = Export.getUserInput(reader, prompt, "")).length() == 0) {
        }
        try {
            reader.close();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private static void exitWithMessage(String msgID) {
        System.out.println("");
        MessageLog.logMessage((String)msgID);
        System.exit(8);
    }

    private static String getUserInput(BufferedReader reader, String prompt, String defaultValue) {
        String response = null;
        try {
            System.out.print(prompt);
            System.out.flush();
            response = reader.readLine();
            if (response == null) {
                Export.exitWithMessage("GEN1022I");
            }
            if ((response = response.trim()).length() == 0) {
                response = defaultValue;
            }
        }
        catch (IOException e) {
            MessageLog.getThreadLog().println(e.getMessage());
            Export.exitWithMessage("GEN1023E");
        }
        return response;
    }

    private static void exportFile() {
        try {
            FileOutputStream fStream = new FileOutputStream(fileName);
            oStream = new ObjectOutputStream(fStream);
        }
        catch (IOException e) {
            MessageLog.logException((String)"GEN0131E", (Exception)e, (Object)fileName);
            System.exit(8);
        }
        MessageLog.logMessage((String)"GEN1008I", (Object)fileName);
        Export.exportObjectType((short)0, new GroupExporter(), (CreateHeader)new GroupDefinition(), "org.eclipse.aperi.server.handler.gui.GroupDefHndlr.Definition", "GEN1024I");
        Export.exportObjectType((short)2, new GroupExporter(), (CreateHeader)new GroupDefinition(), "org.eclipse.aperi.server.handler.gui.GroupDefHndlr.Definition", "GEN1025I");
        Export.exportObjectType((short)36, new ReportExporter(), (CreateHeader)new Report(36), "org.eclipse.aperi.server.handler.gui.GuiBatchReportHndlr", "GEN1014I");
        try {
            oStream.close();
        }
        catch (IOException e) {
            MessageLog.logException((String)"GEN1002E", (Exception)e, (Object)fileName);
            System.exit(8);
        }
        if (objectsProcessed) {
            MessageLog.logMessage((String)"GEN1007I");
        } else {
            MessageLog.logMessage((String)"GEN1018I");
        }
    }

    private static void exportObjectType(short objectType, Exporter exporter, CreateHeader header, String subType, String msgID) {
        GuiListReq glr = new GuiListReq();
        glr.listRequested = 10000 + objectType;
        glr.resourceType = (short)-1;
        NameList[] pArray = (NameList[])Export.sendRequest("org.eclipse.aperi.server.handler.gui.GuiListHndlr", (Serializable)glr, true);
        if (pArray != null) {
            for (int i = 0; i < pArray.length; ++i) {
                NameList pName = pArray[i];
                if (pName.nlID <= 299) continue;
                objectsProcessed = true;
                MessageLog.logMessage((String)msgID, (Object)pName.nlName);
                header.ID = pName.nlID;
                CreateHeader expHeader = (CreateHeader)Export.sendRequest(subType, (Serializable)header, true);
                if (expHeader == null) continue;
                exporter.export(expHeader, objectType);
            }
        }
    }

    private static void importFile() {
        boolean warning = false;
        ObjectInputStream oStream = null;
        try {
            FileInputStream fStream = new FileInputStream(fileName);
            oStream = new ObjectInputStream(fStream);
        }
        catch (IOException e) {
            MessageLog.logException((String)"GEN0131E", (Exception)e, (Object)fileName);
            System.exit(8);
        }
        idMap = new HashMap();
        MessageLog.logMessage((String)"GEN1009I", (Object)fileName);
        try {
            while (true) {
                CreateHeader header;
                if (!Export.importObject(header = (CreateHeader)oStream.readObject())) {
                    warning = true;
                }
                objectsProcessed = true;
            }
        }
        catch (EOFException e) {
        }
        catch (IOException e) {
            MessageLog.logException((String)"GEN0133E", (Exception)e, (Object)fileName);
            System.exit(8);
        }
        catch (ClassNotFoundException e) {
            MessageLog.logMessage((String)"GEN0133E", (Object)fileName);
            MessageLog.logException((String)"STS0049W", (Exception)e, (Object)fileName);
            System.exit(8);
        }
        catch (ClassCastException e) {
            MessageLog.logMessage((String)"GEN0133E", (Object)fileName);
            MessageLog.logException((String)"STS0050W", (Exception)e, (Object)fileName);
            System.exit(8);
        }
        try {
            oStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (objectsProcessed) {
            MessageLog.logMessage((String)(warning ? "GEN1010I" : "GEN1011I"));
        } else {
            MessageLog.logMessage((String)"GEN1019I");
        }
    }

    private static boolean importObject(CreateHeader header) {
        MutableInteger oldID = null;
        String subType = null;
        if (header instanceof GroupDefinition) {
            oldID = new MutableInteger(header.ID);
            MessageLog.logMessage((String)"GEN1028I", (Object)header.creator, (Object)header.getName());
            subType = "org.eclipse.aperi.server.handler.gui.GroupDefHndlr.Definition";
        } else if (header instanceof Report) {
            MessageLog.logMessage((String)"GEN1015I", (Object)header.creator, (Object)header.getName());
            subType = "org.eclipse.aperi.server.handler.gui.GuiBatchReportHndlr";
            if (!Export.translateIDs((Report)header)) {
                return false;
            }
        } else {
            MessageLog.logMessage((String)"GEN1012E", (Object)header);
            System.exit(8);
        }
        header.ID = 0;
        CreateHeader newHeader = (CreateHeader)Export.sendRequest(subType, (Serializable)header, false);
        if (newHeader == null) {
            MessageLog.logMessage((String)"GEN1013E", (Object)header.creator, (Object)header.getName());
            oldID = null;
            return false;
        }
        if (oldID != null) {
            idMap.put(oldID, new MutableInteger(newHeader.ID));
        }
        return true;
    }

    private static boolean translateIDs(Report report) {
        MutableInteger newID;
        if (serverComputerID == -1) {
            Export.request.typeCode = "org.eclipse.aperi.server.svp.ServerSvp";
            Export.request.serviceName = RequestTypeManager.getInternalName((String)Export.request.typeCode);
            ServerStatusResp server = (ServerStatusResp)Export.sendRequest("org.eclipse.aperi.server.handler.server.ServerStatusHndlr", null, false);
            if (server == null) {
                MessageLog.logMessage((String)"GEN1017E");
                System.exit(16);
            }
            serverComputerID = server.computerID;
            Export.request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
            Export.request.serviceName = RequestTypeManager.getInternalName((String)Export.request.typeCode);
        }
        report.computerID = serverComputerID;
        GuiReportReq grr = report.batchReport.grr;
        if (grr.profile > 299) {
            Export.hashKey.value = grr.profile;
            newID = idMap.get(hashKey);
            if (newID == null) {
                MessageLog.logMessage((String)"GEN1016E", (Object)report.creator, (Object)report.getName());
                return false;
            }
            grr.profile = newID.value;
        }
        if (Export.isTranslatable(grr.reportSubtype) && grr.selectedResources != null) {
            for (int i = 0; i < grr.selectedResources.length; ++i) {
                Export.hashKey.value = grr.selectedResources[i];
                if (Export.hashKey.value <= 299) continue;
                newID = idMap.get(hashKey);
                if (newID == null) {
                    MessageLog.logMessage((String)"GEN1016E", (Object)report.creator, (Object)report.getName());
                    return false;
                }
                grr.selectedResources[i] = newID.value;
            }
        }
        return true;
    }

    private static boolean isTranslatable(int reportSubtype) {
        return reportSubtype == 6 || reportSubtype == 11 || reportSubtype == 13;
    }

    private static Serializable sendRequest(String subType, Serializable data, boolean exitOnError) {
        Export.request.subType = subType;
        Export.request.flags = (byte)4;
        Export.request.requestData = data;
        Socket socket = null;
        try {
            socket = new Socket(serverHost, serverPort);
        }
        catch (Exception e) {
            MessageLog.logException((String)"AGT0121E", (Exception)e);
            System.exit(8);
        }
        SocketTransceiver t = new SocketTransceiver(socket, serverHost);
        Response response = t.transmitRequest(request, null);
        if (response == null) {
            MessageLog.logMessage((String)"GUI0022M");
            System.exit(8);
        } else if (response.status > 4) {
            if (exitOnError) {
                System.exit(8);
            }
            response.responseData = null;
        }
        return response.responseData;
    }

    private static void exportObject(Serializable object) {
        try {
            oStream.writeObject(object);
        }
        catch (IOException e) {
            MessageLog.logException((String)"GEN0175E", (Exception)e, (Object)fileName);
            System.exit(8);
        }
    }

    static {
        request = new Request();
        hashKey = new MutableInteger();
        serverComputerID = -1;
    }

    private static class ReportExporter
    extends Exporter {
        private ReportExporter() {
        }

        public void export(CreateHeader object, short objectType) {
            Report report = (Report)object;
            GuiReportReq grr = report.batchReport.grr;
            grr.selectedUsers = null;
            grr.isUserInList = true;
            if (!Export.isTranslatable(grr.reportSubtype)) {
                grr.selectedResources = null;
                grr.isResourceInList = true;
            }
            Export.exportObject((Serializable)object);
        }
    }

    private static class GroupExporter
    extends Exporter {
        private GroupExporter() {
        }

        public void export(CreateHeader object, short objectType) {
            GroupDefinition group = (GroupDefinition)object;
            group.members = null;
            group.groupType = objectType;
            Export.exportObject((Serializable)object);
        }
    }

    private static class Exporter {
        private Exporter() {
        }

        public void export(CreateHeader object, short objectType) {
            Export.exportObject((Serializable)object);
        }
    }
}

