/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.util.smtp;

import java.util.Vector;
import org.eclipse.aperi.logging.TraceLogger;

public class Email {
    public String text;
    public String subject;
    protected String from;
    protected String replyTo;
    protected String returnPath;
    protected String defaultDomain;
    protected Vector<String> recipientList;

    public Email(String subject, String text, String from, String replyTo, String returnPath, String defaultDomain, String[] recipientList) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Email.class.getName(), (String)"Email", (String)"subject, text, from, replyTo, returnPath, defaultDomain, recipientList");
        }
        this.subject = subject;
        this.text = text;
        this.from = from;
        this.replyTo = replyTo;
        this.returnPath = returnPath;
        this.defaultDomain = defaultDomain;
        this.recipientList = new Vector();
        if (recipientList != null) {
            for (int i = 0; i < recipientList.length; ++i) {
                this.addRecipient(recipientList[i]);
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Email.class.getName(), (String)"Email");
        }
    }

    public Email(String subject, String text, String from, String replyTo, String returnPath, String defaultDomain) {
        this(subject, text, from, replyTo, returnPath, defaultDomain, null);
    }

    public void addRecipient(String recipient) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Email.class.getName(), (String)"addRecipient", (String)"recipient");
        }
        if (this.defaultDomain != null && recipient.indexOf(64) == -1) {
            recipient = recipient + '@' + this.defaultDomain;
        }
        this.recipientList.addElement(recipient);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Email.class.getName(), (String)"addRecipient");
        }
    }

    public void addEscapeRecipient(String recipient) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Email.class.getName(), (String)"addEscapeRecipient", (String)"recipient");
        }
        recipient = this.parseRecipient(recipient);
        if (this.defaultDomain != null) {
            recipient = recipient + '@' + this.defaultDomain;
        }
        this.recipientList.addElement(recipient);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Email.class.getName(), (String)"addEscapeRecipient");
        }
    }

    private String parseRecipient(String path) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Email.class.getName(), (String)"parseRecipient", (String)"path");
        }
        for (int j = 0; j < path.length(); ++j) {
            if (!this.isSpecial(path.charAt(j))) continue;
            String traceResult = this.escapeRecipient(path, j);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Email.class.getName(), (String)"parseRecipient", (Object)traceResult);
            }
            return traceResult;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Email.class.getName(), (String)"parseRecipient", (Object)path);
        }
        return path;
    }

    private boolean isSpecial(char c) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Email.class.getName(), (String)"isSpecial", (String)"c");
        }
        if (c >= '\u0000' && c <= ' ' || c == '\u007f') {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Email.class.getName(), (String)"isSpecial", (boolean)true);
            }
            return true;
        }
        switch (c) {
            case '\"': 
            case '(': 
            case ')': 
            case ',': 
            case ':': 
            case ';': 
            case '<': 
            case '>': 
            case '@': 
            case '[': 
            case '\\': 
            case ']': {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)Email.class.getName(), (String)"isSpecial", (boolean)true);
                }
                return true;
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Email.class.getName(), (String)"isSpecial", (boolean)false);
        }
        return false;
    }

    private String escapeRecipient(String path, int firstSpecial) {
        int i;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Email.class.getName(), (String)"escapeRecipient", (String)"path, firstSpecial");
        }
        StringBuffer buf = new StringBuffer(128);
        buf.append('\"');
        for (i = 0; i < firstSpecial; ++i) {
            buf.append(path.charAt(i));
        }
        buf.append('\\');
        buf.append(path.charAt(i++));
        while (i < path.length()) {
            if (this.isSpecial(path.charAt(i))) {
                buf.append('\\');
            }
            buf.append(path.charAt(i));
            ++i;
        }
        while (i < path.length()) {
            buf.append(path.charAt(i));
            ++i;
        }
        buf.append('\"');
        String traceResult = buf.toString();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Email.class.getName(), (String)"escapeRecipient", (Object)traceResult);
        }
        return traceResult;
    }
}

