/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.util.snmp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.eclipse.aperi.server.util.snmp.Asn1Value;
import org.eclipse.aperi.server.util.snmp.TrapPdu;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.NestableException;

public class SnmpTransmitter {
    public static final String PUBLIC_COMMUNITY = "public";
    public static final int STANDARD_PORT = 162;
    public static final Asn1Value SNMP_VERSION_1 = new Asn1Value(0);
    private DatagramSocket socket;
    private DatagramPacket packet = null;
    private String community = "public";
    private InetAddress address = null;
    private int port = 162;

    public SnmpTransmitter(String snmpServer, int port, String community) throws LocalizableException {
        this.community = community;
        this.port = port;
        try {
            this.address = InetAddress.getByName(snmpServer);
            this.socket = new DatagramSocket();
        }
        catch (UnknownHostException e) {
            Object[] args = new Object[]{snmpServer};
            throw new NestableException("GEN0115E", args, (Exception)e);
        }
        catch (SocketException e) {
            throw new NestableException("GEN0107E", null, (Exception)e);
        }
    }

    public void setPacket(TrapPdu pdu) throws LocalizableException {
        Asn1Value[] msgContent = new Asn1Value[]{SNMP_VERSION_1, new Asn1Value(this.community), pdu.encode()};
        this.setPacket(new Asn1Value(msgContent));
    }

    public void setPacket(Asn1Value value) throws LocalizableException {
        this.setPacket(value.encode());
    }

    private void setPacket(byte[] data) {
        this.packet = new DatagramPacket(data, data.length, this.address, this.port);
    }

    public void transmit() throws LocalizableException {
        try {
            this.socket.send(this.packet);
        }
        catch (IOException e) {
            throw new NestableException("GEN0108E", null, (Exception)e);
        }
    }

    public void transmit(TrapPdu pdu) throws LocalizableException {
        this.setPacket(pdu);
        this.transmit();
    }

    public void transmit(Asn1Value value) throws LocalizableException {
        this.setPacket(value);
        this.transmit();
    }

    public void close() {
        this.socket.close();
    }
}

