/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp;

import org.eclipse.aperi.snmp.SnmpTrap;
import org.eclipse.aperi.snmp.TrapFilter;

public class BasicTrapFilter
implements TrapFilter {
    public static final int ALL = -1;
    private String source;
    private String enterprise;
    private int genericTrap;
    private int specificTrap;

    public BasicTrapFilter() {
        this.source = null;
        this.enterprise = null;
        this.genericTrap = -1;
        this.specificTrap = -1;
    }

    public BasicTrapFilter(String address, String enterprise, int generic, int specific) {
        this.source = address;
        this.enterprise = enterprise;
        this.genericTrap = generic;
        this.specificTrap = specific;
    }

    public boolean filter(SnmpTrap trap) {
        boolean sourceMatches = false;
        boolean enterpriseMatches = false;
        boolean genericMatches = false;
        boolean specificMatches = false;
        if (this.source != null) {
            if (this.source.equals(trap.agentAddr.toString())) {
                sourceMatches = true;
            }
        } else {
            sourceMatches = true;
        }
        if (this.enterprise != null) {
            if (this.enterprise.equals(trap.enterprise.toString())) {
                enterpriseMatches = true;
            }
        } else {
            enterpriseMatches = true;
        }
        if (this.genericTrap != -1) {
            if (this.genericTrap == trap.genericTrap) {
                genericMatches = true;
            }
        } else {
            genericMatches = true;
        }
        if (this.specificTrap != -1) {
            if (this.specificTrap == trap.genericTrap) {
                specificMatches = true;
            }
        } else {
            specificMatches = true;
        }
        return sourceMatches && enterpriseMatches && genericMatches && specificMatches;
    }
}

