/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp;

import java.net.DatagramPacket;
import org.eclipse.aperi.snmp.SimpleCallback;
import org.eclipse.aperi.snmp.SnmpPDU;
import org.eclipse.aperi.snmp.SnmpSession;
import org.eclipse.aperi.snmp.Snmp_callback;
import org.eclipse.aperi.snmp.utils.Queue;
import org.eclipse.aperi.snmp.utils.Timer;

class PendingResponse {
    protected int retries;
    protected int timeout;
    protected SnmpSession session;
    protected int reqID;
    protected DatagramPacket pack;
    protected Timer timer;
    protected int correlator;
    protected long sendTime;
    protected Queue rspQ;
    protected Object callback;
    protected Object user_data;
    protected boolean isUserPacket;
    protected Object pdu;

    protected PendingResponse(SnmpSession snmpSession, int requestId, int numRetries, int msecTimeout, DatagramPacket packet, int msgCorrelator, boolean isUserPacket, Queue responseQueue, Object callback, Object user_data) {
        this.session = snmpSession;
        this.reqID = requestId;
        this.retries = numRetries;
        this.timeout = msecTimeout;
        this.pack = packet;
        this.correlator = msgCorrelator;
        this.sendTime = System.currentTimeMillis();
        this.rspQ = responseQueue;
        this.callback = callback;
        this.user_data = user_data;
        this.isUserPacket = isUserPacket;
    }

    protected void handleResponse(SnmpPDU pdu) {
        if (pdu.errorStatus == 100) {
            this.session.timeoutReceived();
        } else {
            this.session.dataReceived();
        }
        if (this.rspQ != null) {
            this.rspQ.enqueue(pdu);
        } else {
            try {
                if (this.callback instanceof Snmp_callback) {
                    ((Snmp_callback)this.callback).handle_response(0, pdu, this.session, this.user_data);
                } else {
                    ((SimpleCallback)this.callback).handle_response(pdu, this.user_data);
                }
            }
            catch (Exception e) {
                System.out.println("PendingReponse:Exception in callback:" + e.toString());
                e.printStackTrace();
            }
        }
    }
}

