/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import org.eclipse.aperi.snmp.SnmpV1API;

class SnmpTracer
extends Thread {
    private static DatagramSocket sock = null;
    private static boolean started = false;
    private static boolean running = false;
    private static SnmpTracer inst = null;

    private SnmpTracer() {
    }

    public static synchronized void initialize(int tracePortNumber) throws SocketException {
        if (started) {
            return;
        }
        sock = new DatagramSocket(tracePortNumber);
        inst = new SnmpTracer();
        inst.setDaemon(true);
        inst.start();
        Thread.yield();
    }

    protected static boolean isReady() {
        return started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (sock == null) {
            return;
        }
        this.setName("SnmpTracer");
        byte[] pdu = new byte[10];
        started = true;
        running = true;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            System.out.println("SNMP tracer service is ready.");
        }
        while (running) {
            DatagramPacket recvPdu = new DatagramPacket(pdu, pdu.length);
            try {
                sock.receive(recvPdu);
                byte[] rspPdu = recvPdu.getData();
                if (0 == rspPdu[0]) {
                    SnmpTracer snmpTracer = this;
                    synchronized (snmpTracer) {
                        running = false;
                        sock.close();
                        continue;
                    }
                }
                byte[] realMsg = new byte[recvPdu.getLength()];
                for (int i = 0; i < realMsg.length; ++i) {
                    realMsg[i] = rspPdu[i];
                }
                String msg = new String(realMsg, 0, realMsg.length);
                if (msg.equals("start")) {
                    SnmpV1API.startTrace(System.out);
                    continue;
                }
                if (msg.equals("stop")) {
                    SnmpV1API.stopTrace();
                    continue;
                }
                System.err.println("Do what? - <" + msg + ">, length = " + msg.length());
            }
            catch (IOException e) {
                System.err.println("SnmpTracer::run - error on receive - " + e.toString());
            }
        }
    }

    protected static void terminate() {
        byte[] stopMsg = new byte[]{0};
        if (sock == null) {
            return;
        }
        try {
            DatagramPacket stopPacket = new DatagramPacket(stopMsg, stopMsg.length, InetAddress.getLocalHost(), sock.getLocalPort());
            DatagramSocket stopSocket = new DatagramSocket();
            stopSocket.send(stopPacket);
        }
        catch (Exception e) {
            System.err.println("Error trying to stop tracing: " + e.toString());
        }
        started = false;
        running = false;
    }
}

