/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp;

import java.util.StringTokenizer;
import org.eclipse.aperi.snmp.AbstractSnmpPoller;
import org.eclipse.aperi.snmp.PollingInterval;
import org.eclipse.aperi.snmp.TableHandler;
import org.eclipse.aperi.snmp.TablePollingAction;
import org.eclipse.aperi.snmp.TablePollingFilter;
import org.eclipse.aperi.snmp.TablePollingPreFilter;
import org.eclipse.aperi.snmp.data.OID;

public class TablePoller
extends AbstractSnmpPoller {
    protected boolean changed;
    protected OID[] oids;
    protected int[] index;
    protected TableHandler tableRef;
    protected TablePollingAction action;
    protected TablePollingFilter filter;
    protected TablePollingPreFilter prefilter;
    protected boolean keepOldValues;
    protected int useCount;
    protected int maxRows;
    protected static final int MAX_ROWS = Integer.MAX_VALUE;

    public TablePoller(PollingInterval pollingInterval, String[] columnOids, String startIndex, boolean keepLastObservedValues, TableHandler tableHandler, TablePollingAction pollingAction, TablePollingFilter pollingFilter, TablePollingPreFilter pollingPreFilter) {
        this(pollingInterval, columnOids, startIndex, keepLastObservedValues, tableHandler, pollingAction, pollingFilter, pollingPreFilter, Integer.MAX_VALUE);
    }

    public TablePoller(PollingInterval pollingInterval, String[] columnOids, String startIndex, boolean keepLastObservedValues, TableHandler tableHandler, TablePollingAction pollingAction, TablePollingFilter pollingFilter, TablePollingPreFilter pollingPreFilter, int maximumNumberOfRows) {
        super(pollingInterval);
        this.oids = new OID[columnOids.length];
        for (int i = 0; i < this.oids.length; ++i) {
            this.oids[i] = new OID(columnOids[i]);
        }
        if (startIndex != null) {
            StringTokenizer strtok = new StringTokenizer(startIndex, ".");
            int limit = strtok.countTokens();
            this.index = new int[limit];
            for (int i = 0; i < limit; ++i) {
                this.index[i] = Integer.parseInt(strtok.nextToken());
            }
        }
        this.keepOldValues = keepLastObservedValues;
        this.tableRef = tableHandler;
        this.action = pollingAction;
        this.filter = pollingFilter;
        this.prefilter = pollingPreFilter;
        this.useCount = 1;
        this.maxRows = maximumNumberOfRows;
    }

    public PollingInterval getInterval() {
        return this.interval;
    }

    public void setInterval(PollingInterval newPollingInterval) {
        this.interval = newPollingInterval;
    }

    public TablePollingAction getAction() {
        return this.action;
    }

    public void setAction(TablePollingAction pollingAction) {
        this.action = pollingAction;
    }

    public TablePollingFilter getFilter() {
        return this.filter;
    }

    public void setFilter(TablePollingFilter pollingFilter) {
        this.filter = pollingFilter;
    }

    public TablePollingPreFilter getPreFilter() {
        return this.prefilter;
    }

    public void setPreFilter(TablePollingPreFilter pollingPreFilter) {
        this.prefilter = pollingPreFilter;
    }

    public synchronized void bumpUseCount() {
        ++this.useCount;
    }

    public synchronized int decrUseCount() {
        --this.useCount;
        return this.useCount;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int newMaxRows) {
        if (newMaxRows != this.maxRows) {
            this.changed = true;
        }
        this.maxRows = newMaxRows;
    }
}

