/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp;

import java.io.Serializable;
import java.util.Vector;
import org.eclipse.aperi.snmp.PollingDriver;
import org.eclipse.aperi.snmp.SnmpSession;
import org.eclipse.aperi.snmp.SnmpV1API;
import org.eclipse.aperi.snmp.TablePoller;
import org.eclipse.aperi.snmp.TablePollingInfo;
import org.eclipse.aperi.snmp.WalkThread;
import org.eclipse.aperi.snmp.data.OID;

class TableWalker {
    protected Vector pollers;
    protected Vector rows;
    protected OID tableoid;
    protected OID trustedColumn;
    protected SnmpSession session;
    protected int[] index;
    protected int interval;
    protected boolean polling;
    protected boolean removed;
    protected boolean rescan;
    protected PollingDriver driver;

    public TableWalker(OID tableOID, OID trustedColumnOID, int[] startingIndex, int pollingInterval, PollingDriver pollingDriver, SnmpSession snmpSession) {
        this.tableoid = tableOID;
        this.trustedColumn = trustedColumnOID;
        this.session = snmpSession;
        this.pollers = new Vector();
        this.rows = new Vector();
        this.interval = pollingInterval;
        this.index = startingIndex;
        this.driver = pollingDriver;
        this.polling = false;
        this.removed = false;
        this.rescan = false;
    }

    public void addPoller(TablePollingInfo info) {
        if (this.pollers.size() == 0) {
            WalkThread walker = new WalkThread(this);
            walker.start();
        } else {
            int numVals = ((TablePoller)info.poller).oids.length;
            for (int i = 0; i < this.rows.size(); ++i) {
                OID rowOID = (OID)this.rows.elementAt(i);
                info.newValues.addElement(new Serializable[numVals]);
                info.oldValues.addElement(new Serializable[numVals]);
                if (SnmpV1API.isTracing()) {
                    SnmpV1API.trace("SnmpSession called rowAdded (" + info.cookie + "," + rowOID + ")");
                }
                Object rowCookie = ((TablePoller)info.poller).tableRef.rowAdded(info.cookie, rowOID);
                info.rowCookie.addElement(rowCookie);
            }
        }
        this.pollers.addElement(info);
        this.removed = false;
    }

    public void removePoller(TablePollingInfo info) {
        this.pollers.removeElement(info);
        if (this.pollers.size() == 0) {
            this.removed = true;
            this.driver.tables.removeElement(this);
        }
    }

    public void walkTheTable() {
        if (!this.removed) {
            if (SnmpV1API.isTracing()) {
                SnmpV1API.trace("SnmpSession walkTheTable() called for table " + this.tableoid + " trustedColumn " + this.trustedColumn);
            }
            WalkThread walker = new WalkThread(this);
            walker.start();
        }
    }
}

